/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.core.nio.fs;

import com.intellij.platform.core.nio.fs.CorePosixFilteringFileSystemProvider;
import com.intellij.platform.core.nio.fs.DelegatingFileSystemProvider;
import com.intellij.platform.core.nio.fs.MultiRoutingFileSystem;
import com.intellij.platform.core.nio.fs.MultiRoutingFsPath;
import com.intellij.platform.core.nio.fs.RoutingAwareFileSystemProvider;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.BiFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class MultiRoutingFileSystemProvider
extends DelegatingFileSystemProvider<MultiRoutingFileSystemProvider, MultiRoutingFileSystem> {
    static final boolean ourForceDefaultFs = Objects.equals(System.getProperty("idea.force.default.filesystem"), "true");
    @VisibleForTesting
    public final FileSystemProvider myLocalProvider;
    private final MultiRoutingFileSystem myFileSystem;
    private static final String KEY_ROOT = "KEY_ROOT";
    private static final String KEY_PREFIX = "KEY_PREFIX";
    private static final String KEY_CASE_SENSITIVE = "KEY_CASE_SENSITIVE";
    private static final String KEY_FUNCTION = "KEY_FUNCTION";
    private static final Map<FileSystemProvider, Boolean> ourCanHandleRoutingCache = Collections.synchronizedMap(new WeakHashMap());

    public static void computeBackend(@NotNull FileSystemProvider provider, @NotNull String root, boolean isPrefix, boolean caseSensitive, @NotNull @NotNull BiFunction<@NotNull FileSystemProvider, @Nullable FileSystem, @Nullable FileSystem> function) {
        if (provider == null) {
            MultiRoutingFileSystemProvider.$$$reportNull$$$0(0);
        }
        if (root == null) {
            MultiRoutingFileSystemProvider.$$$reportNull$$$0(1);
        }
        if (function == null) {
            MultiRoutingFileSystemProvider.$$$reportNull$$$0(2);
        }
        if (provider.getClass().getName().equals(MultiRoutingFileSystemProvider.class.getName())) {
            HashMap<String, Object> arguments = new HashMap<String, Object>();
            arguments.put(KEY_ROOT, root);
            arguments.put(KEY_PREFIX, isPrefix);
            arguments.put(KEY_CASE_SENSITIVE, caseSensitive);
            arguments.put(KEY_FUNCTION, function);
            try {
                provider.newFileSystem(URI.create("file:/"), arguments);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        } else {
            throw new IllegalArgumentException(String.format("%s is not an instance of %s", provider, MultiRoutingFileSystemProvider.class));
        }
    }

    public MultiRoutingFileSystemProvider(FileSystemProvider localFSProvider) {
        this.myLocalProvider = ourForceDefaultFs || localFSProvider.getFileSystem(URI.create("file:///")).supportedFileAttributeViews().contains("posix") ? localFSProvider : new CorePosixFilteringFileSystemProvider(localFSProvider);
        this.myFileSystem = new MultiRoutingFileSystem(this, this.myLocalProvider.getFileSystem(URI.create("file:///")));
    }

    @Override
    @NotNull
    protected MultiRoutingFileSystem wrapDelegateFileSystem(@NotNull FileSystem delegateFs) {
        if (delegateFs == null) {
            MultiRoutingFileSystemProvider.$$$reportNull$$$0(3);
        }
        return new MultiRoutingFileSystem(this, delegateFs);
    }

    @Override
    @NotNull
    public MultiRoutingFileSystem newFileSystem(Path path, Map<String, ?> env) {
        MultiRoutingFileSystem multiRoutingFileSystem = this.getFileSystem(path.toUri());
        if (multiRoutingFileSystem == null) {
            MultiRoutingFileSystemProvider.$$$reportNull$$$0(4);
        }
        return multiRoutingFileSystem;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    @Nullable
    public MultiRoutingFileSystem newFileSystem(URI uri, @Nullable Map<String, ?> env) {
        if (env == null) {
            return this.getFileSystem(uri);
        }
        String root = Objects.requireNonNull((String)env.get(KEY_ROOT));
        Boolean isPrefix = Objects.requireNonNull((Boolean)env.get(KEY_PREFIX));
        Boolean caseSensitive = Objects.requireNonNull((Boolean)env.get(KEY_CASE_SENSITIVE));
        @NotNull @Nullable @Nullable BiFunction function = Objects.requireNonNull((BiFunction)env.get(KEY_FUNCTION));
        this.myFileSystem.computeBackend(root, isPrefix, caseSensitive, function);
        return null;
    }

    @Override
    @NotNull
    public MultiRoutingFileSystem getFileSystem(@NotNull URI uri) {
        if (uri == null) {
            MultiRoutingFileSystemProvider.$$$reportNull$$$0(5);
        }
        if (!uri.getScheme().equals("file") || uri.getAuthority() != null && !uri.getAuthority().isEmpty()) {
            throw new UnsupportedOperationException(String.format("Unexpected URI: %s\nThis class is supposed to replace the local file system.", uri));
        }
        MultiRoutingFileSystem multiRoutingFileSystem = this.myFileSystem;
        if (multiRoutingFileSystem == null) {
            MultiRoutingFileSystemProvider.$$$reportNull$$$0(6);
        }
        return multiRoutingFileSystem;
    }

    @Override
    @NotNull
    protected FileSystemProvider getDelegate(@Nullable Path path1, @Nullable Path path2) {
        FileSystemProvider provider2;
        if (ourForceDefaultFs) {
            FileSystemProvider fileSystemProvider = this.myLocalProvider;
            if (fileSystemProvider == null) {
                MultiRoutingFileSystemProvider.$$$reportNull$$$0(7);
            }
            return fileSystemProvider;
        }
        if (path1 == null) {
            if (path2 == null) {
                FileSystemProvider fileSystemProvider = this.myLocalProvider;
                if (fileSystemProvider == null) {
                    MultiRoutingFileSystemProvider.$$$reportNull$$$0(8);
                }
                return fileSystemProvider;
            }
            path1 = path2;
            path2 = null;
        }
        if (!path1.isAbsolute()) {
            path1 = path1.toAbsolutePath();
        }
        FileSystemProvider provider1 = this.myFileSystem.getBackend(path1.getRoot().toString()).provider();
        if (path2 == null) {
            FileSystemProvider fileSystemProvider = provider1;
            if (fileSystemProvider == null) {
                MultiRoutingFileSystemProvider.$$$reportNull$$$0(9);
            }
            return fileSystemProvider;
        }
        if (!path2.isAbsolute()) {
            path2 = path2.toAbsolutePath();
        }
        if (provider1.equals(provider2 = this.myFileSystem.getBackend(path2.getRoot().toString()).provider())) {
            FileSystemProvider fileSystemProvider = provider1;
            if (fileSystemProvider == null) {
                MultiRoutingFileSystemProvider.$$$reportNull$$$0(10);
            }
            return fileSystemProvider;
        }
        if (MultiRoutingFileSystemProvider.canHandleRouting(provider1)) {
            FileSystemProvider fileSystemProvider = provider1;
            if (fileSystemProvider == null) {
                MultiRoutingFileSystemProvider.$$$reportNull$$$0(11);
            }
            return fileSystemProvider;
        }
        if (MultiRoutingFileSystemProvider.canHandleRouting(provider2)) {
            FileSystemProvider fileSystemProvider = provider2;
            if (fileSystemProvider == null) {
                MultiRoutingFileSystemProvider.$$$reportNull$$$0(12);
            }
            return fileSystemProvider;
        }
        throw new IllegalArgumentException(String.format("Provider mismatch: %s != %s", provider1, provider2));
    }

    private static boolean canHandleRouting(FileSystemProvider provider) {
        if (provider instanceof RoutingAwareFileSystemProvider) {
            return ((RoutingAwareFileSystemProvider)((Object)provider)).canHandleRouting();
        }
        return ourCanHandleRoutingCache.computeIfAbsent(provider, MultiRoutingFileSystemProvider::canHandleRoutingImpl);
    }

    private static boolean canHandleRoutingImpl(FileSystemProvider provider) {
        Class<?> providerClass = provider.getClass();
        do {
            for (Class<?> iface : providerClass.getInterfaces()) {
                if (!iface.getName().equals(RoutingAwareFileSystemProvider.class.getName())) continue;
                try {
                    return (Boolean)iface.getMethod("canHandleRouting", new Class[0]).invoke((Object)provider, new Object[0]);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        } while ((providerClass = providerClass.getSuperclass()) != null);
        return false;
    }

    @Override
    @Contract(value="null -> null; !null -> !null")
    @VisibleForTesting
    @Nullable
    public Path toDelegatePath(@Nullable Path path) {
        if (path == null) {
            return null;
        }
        if (path instanceof MultiRoutingFsPath) {
            return path;
        }
        return new MultiRoutingFsPath(this.myFileSystem, path);
    }

    @Override
    @Contract(value="null -> null; !null -> !null")
    @Nullable
    protected Path fromDelegatePath(@Nullable Path path) {
        if (path instanceof MultiRoutingFsPath) {
            return ((MultiRoutingFsPath)path).getDelegate();
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateFs";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/core/nio/fs/MultiRoutingFileSystemProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/core/nio/fs/MultiRoutingFileSystemProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "newFileSystem";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeBackend";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "wrapDelegateFileSystem";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileSystem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

