/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.kotlin;

import com.intellij.ml.inline.completion.impl.postprocessing.features.Scope;
import com.intellij.ml.inline.completion.impl.postprocessing.features.ScopeAnalyzerBase;
import com.intellij.ml.inline.completion.impl.postprocessing.features.ScopeType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtContainerNodeForControlStructureBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u0006H\u0016J\u001c\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u0006H\u0016J\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R$\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u0004X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/inline/completion/kotlin/KotlinScopeAnalyzer;", "Lcom/intellij/ml/inline/completion/impl/postprocessing/features/ScopeAnalyzerBase;", "()V", "candidates", "", "Ljava/lang/Class;", "Lcom/intellij/psi/PsiElement;", "getCandidates", "()[Ljava/lang/Class;", "[Ljava/lang/Class;", "getNextSibling", "element", "scopeElement", "getPrevSibling", "getScope", "Lcom/intellij/ml/inline/completion/impl/postprocessing/features/Scope;", "offset", "", "intellij.ml.inline.completion.kotlin"})
public final class KotlinScopeAnalyzer
extends ScopeAnalyzerBase {
    @NotNull
    private final Class<? extends PsiElement>[] candidates;

    public KotlinScopeAnalyzer() {
        Class[] classArray = new Class[]{KtValueArgumentList.class, KtParameterList.class, KtCallExpression.class, KtForExpression.class, KtWhileExpression.class, KtWhenExpression.class, KtIfExpression.class, KtTryExpression.class, KtCatchClause.class, KtFinallySection.class, KtWhenEntry.class, KtContainerNodeForControlStructureBody.class, KtProperty.class, KtFunctionLiteral.class, KtFunction.class, KtBlockExpression.class, KtClass.class, KtFile.class};
        this.candidates = classArray;
    }

    @Override
    @NotNull
    public Class<? extends PsiElement>[] getCandidates() {
        return this.candidates;
    }

    @Override
    @Nullable
    public Scope getScope(@Nullable PsiElement element, int offset2) {
        Scope scope;
        PsiElement psiElement = element;
        if (psiElement instanceof KtFile) {
            TextRange textRange = ((KtFile)element).getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            scope = new Scope(ScopeType.File, false, textRange);
        } else if (psiElement instanceof KtParameterList) {
            TextRange textRange = ((KtParameterList)element).getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            scope = new Scope(ScopeType.Parameters, false, textRange);
        } else if (psiElement instanceof KtValueArgumentList) {
            TextRange textRange = ((KtValueArgumentList)element).getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            scope = new Scope(ScopeType.Arguments, false, textRange);
        } else if (psiElement instanceof KtCallExpression) {
            TextRange textRange = ((KtCallExpression)element).getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            scope = new Scope(ScopeType.Call, false, textRange);
        } else if (psiElement instanceof KtProperty) {
            TextRange textRange = ((KtProperty)element).getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            scope = new Scope(ScopeType.Property, true, textRange);
        } else if (psiElement instanceof KtWhileExpression) {
            boolean bl = this.onSameLine(element, offset2);
            TextRange textRange = ((KtWhileExpression)element).getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            scope = new Scope(ScopeType.While, bl, textRange);
        } else if (psiElement instanceof KtForExpression) {
            boolean bl = this.onSameLine(element, offset2);
            TextRange textRange = ((KtForExpression)element).getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            scope = new Scope(ScopeType.For, bl, textRange);
        } else if (psiElement instanceof KtIfExpression) {
            boolean bl = this.onSameLine(element, offset2);
            TextRange textRange = ((KtIfExpression)element).getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            scope = new Scope(ScopeType.If, bl, textRange);
        } else if (psiElement instanceof KtWhenExpression) {
            boolean bl = this.onSameLine(element, offset2);
            TextRange textRange = ((KtWhenExpression)element).getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            scope = new Scope(ScopeType.Switch, bl, textRange);
        } else if (psiElement instanceof KtContainerNodeForControlStructureBody) {
            IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)element);
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.THEN)) {
                boolean bl = this.onSameLine(element, offset2);
                TextRange textRange = ((KtContainerNodeForControlStructureBody)element).getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                scope = new Scope(ScopeType.IfPart, bl, textRange);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.ELSE)) {
                TextRange textRange = ((KtContainerNodeForControlStructureBody)element).getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                scope = new Scope(ScopeType.ElsePart, false, textRange);
            } else {
                PsiElement psiElement2 = ((KtContainerNodeForControlStructureBody)element).getParent();
                if (psiElement2 instanceof KtForExpression) {
                    boolean bl = this.onSameLine(element, offset2);
                    TextRange textRange = ((KtContainerNodeForControlStructureBody)element).getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                    scope = new Scope(ScopeType.ForPart, bl, textRange);
                } else if (psiElement2 instanceof KtWhileExpression) {
                    boolean bl = this.onSameLine(element, offset2);
                    TextRange textRange = ((KtContainerNodeForControlStructureBody)element).getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                    scope = new Scope(ScopeType.WhilePart, bl, textRange);
                } else {
                    TextRange textRange = ((KtContainerNodeForControlStructureBody)element).getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                    scope = new Scope(ScopeType.Block, false, textRange);
                }
            }
        } else if (psiElement instanceof KtWhenEntry) {
            TextRange textRange = ((KtWhenEntry)element).getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            scope = new Scope(ScopeType.Case, false, textRange);
        } else if (psiElement instanceof KtTryExpression) {
            TextRange textRange = ((KtTryExpression)element).getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            scope = new Scope(ScopeType.TryCatch, false, textRange);
        } else if (psiElement instanceof KtCatchClause) {
            boolean bl = this.onSameLine(element, offset2);
            TextRange textRange = ((KtCatchClause)element).getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            scope = new Scope(ScopeType.CatchPart, bl, textRange);
        } else if (psiElement instanceof KtFinallySection) {
            TextRange textRange = ((KtFinallySection)element).getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            scope = new Scope(ScopeType.FinallyPart, false, textRange);
        } else if (psiElement instanceof KtFunctionLiteral) {
            boolean bl = this.onSameLine(element, offset2);
            TextRange textRange = ((KtFunctionLiteral)element).getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            scope = new Scope(ScopeType.Lambda, bl, textRange);
        } else if (psiElement instanceof KtPrimaryConstructor ? true : psiElement instanceof KtSecondaryConstructor) {
            TextRange textRange = element.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            scope = new Scope(ScopeType.Constructor, false, textRange);
        } else if (psiElement instanceof KtFunction) {
            boolean bl = this.onSameLine(element, offset2);
            TextRange textRange = ((KtFunction)element).getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            scope = new Scope(ScopeType.Func, bl, textRange);
        } else if (psiElement instanceof KtClass) {
            boolean bl = this.onSameLine(element, offset2);
            TextRange textRange = ((KtClass)element).getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            scope = new Scope(ScopeType.Class, bl, textRange);
        } else if (psiElement instanceof KtBlockExpression) {
            if (((KtBlockExpression)element).getParent() instanceof KtTryExpression) {
                TextRange textRange = ((KtBlockExpression)element).getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                return new Scope(ScopeType.TryPart, false, textRange);
            }
            TextRange textRange = ((KtBlockExpression)element).getStatements().isEmpty() ? new TextRange(offset2, offset2) : new TextRange(((KtExpression)((KtBlockExpression)element).getStatements().get(0)).getTextRange().getStartOffset(), ((KtExpression)((KtBlockExpression)element).getStatements().get(((KtBlockExpression)element).getStatements().size() - 1)).getTextRange().getEndOffset());
            scope = new Scope(ScopeType.Block, false, textRange);
        } else {
            scope = null;
        }
        return scope;
    }

    @Override
    @Nullable
    public PsiElement getPrevSibling(@NotNull PsiElement element, @Nullable PsiElement scopeElement) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (scopeElement instanceof KtValueArgumentList || scopeElement instanceof KtParameterList) {
            return this.getPrevSibling(scopeElement, scopeElement.getParent());
        }
        return super.getPrevSibling(element, scopeElement);
    }

    @Override
    @Nullable
    public PsiElement getNextSibling(@NotNull PsiElement element, @Nullable PsiElement scopeElement) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (scopeElement instanceof KtValueArgumentList) {
            return this.getNextSibling(scopeElement, ((KtValueArgumentList)scopeElement).getParent());
        }
        return super.getNextSibling(element, scopeElement);
    }
}

