/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.java.features.correctness;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.ml.inline.completion.features.correctness.HighlightedRange;
import com.intellij.ml.inline.completion.features.correctness.RawEnrichmentTool;
import com.intellij.ml.inline.completion.features.correctness.SpecialRange;
import com.intellij.ml.inline.completion.java.features.correctness.JavaNamesHighlighterEnricher;
import com.intellij.ml.inline.completion.java.features.correctness.JavaSuggestionEnricherKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004H\u0007J>\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/inline/completion/java/features/correctness/JavaNamesHighlighterEnricher;", "Lcom/intellij/ml/inline/completion/features/correctness/RawEnrichmentTool;", "()V", "normalize", "", "Lcom/intellij/ml/inline/completion/features/correctness/SpecialRange;", "sources", "Lcom/intellij/ml/inline/completion/features/correctness/HighlightedRange;", "run", "editor", "Lcom/intellij/openapi/editor/Editor;", "originalFile", "Lcom/intellij/psi/PsiFile;", "suggestionOffset", "", "suggestion", "", "fileWithSuggestion", "suggestionRange", "Lcom/intellij/openapi/util/TextRange;", "Companion", "intellij.ml.inline.completion.java"})
@SourceDebugExtension(value={"SMAP\nJavaNamesHighlighterEnricher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaNamesHighlighterEnricher.kt\ncom/intellij/ml/inline/completion/java/features/correctness/JavaNamesHighlighterEnricher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,115:1\n766#2:116\n857#2,2:117\n1045#2:119\n1360#2:120\n1446#2,5:121\n1855#2,2:126\n13#3:128\n*S KotlinDebug\n*F\n+ 1 JavaNamesHighlighterEnricher.kt\ncom/intellij/ml/inline/completion/java/features/correctness/JavaNamesHighlighterEnricher\n*L\n84#1:116\n84#1:117,2\n85#1:119\n36#1:120\n36#1:121,5\n40#1:126,2\n23#1:128\n*E\n"})
public final class JavaNamesHighlighterEnricher
extends RawEnrichmentTool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    @Override
    @NotNull
    public List<SpecialRange> run(@NotNull Editor editor2, @NotNull PsiFile originalFile, int suggestionOffset, @NotNull String suggestion, @NotNull PsiFile fileWithSuggestion, @NotNull TextRange suggestionRange) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        Intrinsics.checkNotNullParameter((Object)fileWithSuggestion, (String)"fileWithSuggestion");
        Intrinsics.checkNotNullParameter((Object)suggestionRange, (String)"suggestionRange");
        HighlightInfoFilter[] highlightInfoFilterArray = new HighlightInfoFilter[]{};
        HighlightInfoHolder highlightInfoHolder2 = new HighlightInfoHolder(fileWithSuggestion, editor2, highlightInfoFilterArray){
            final /* synthetic */ Editor $editor;
            {
                this.$editor = $editor;
                super($fileWithSuggestion, $super_call_param$1);
            }

            @NotNull
            public TextAttributesScheme getColorsScheme() {
                EditorColorsScheme editorColorsScheme = this.$editor.getColorsScheme();
                Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
                return (TextAttributesScheme)editorColorsScheme;
            }
        };
        try {
            HighlightNamesUtil.highlight((PsiFile)fileWithSuggestion, (HighlightInfoHolder)highlightInfoHolder2, arg_0 -> JavaNamesHighlighterEnricher.run$lambda$2(fileWithSuggestion, suggestionRange, arg_0));
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return CollectionsKt.emptyList();
        }
        List result = new ArrayList();
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        EditorColorsScheme globalScheme = editorColorsScheme;
        if (highlightInfoHolder2.size() == 0) {
            return CollectionsKt.emptyList();
        }
        int n = highlightInfoHolder2.size();
        for (int i = 0; i < n; ++i) {
            TextAttributesKey attributesKey;
            HighlightInfo highlightInfo;
            Intrinsics.checkNotNullExpressionValue((Object)highlightInfoHolder2.get(i), (String)"get(...)");
            TextAttributes attributes = highlightInfo.forcedTextAttributes;
            if (attributes != null) {
                result.add(new HighlightedRange(new TextRange(highlightInfo.startOffset, highlightInfo.endOffset), attributes));
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)highlightInfo.type.getAttributesKey(), (String)"getAttributesKey(...)");
            TextRange textRange = new TextRange(highlightInfo.startOffset, highlightInfo.endOffset);
            TextAttributes textAttributes = globalScheme.getAttributes(attributesKey);
            Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"getAttributes(...)");
            result.add(new HighlightedRange(textRange, textAttributes));
        }
        return this.normalize(result);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final List<SpecialRange> normalize(@NotNull List<HighlightedRange> sources) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        Iterable $this$filter$iv = sources;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            HighlightedRange it = (HighlightedRange)element$iv$iv;
            boolean bl = false;
            if (!(it.getAbsoluteLocation().getStartOffset() < it.getAbsoluteLocation().getEndOffset())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List sortedSources = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                HighlightedRange it = (HighlightedRange)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getAbsoluteLocation().getStartOffset());
                it = (HighlightedRange)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getAbsoluteLocation().getStartOffset()));
            }
        });
        List points2 = SequencesKt.toList((Sequence)SequencesKt.sorted((Sequence)SequencesKt.distinct((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)sortedSources), (Function1)normalize.points.1.INSTANCE))));
        List result = new ArrayList();
        int iPoint = 0;
        int iElement = 0;
        while (iElement < sortedSources.size() && iPoint < points2.size() - 1) {
            TextRange currentRange = new TextRange(((Number)points2.get(iPoint)).intValue(), ((Number)points2.get(iPoint + 1)).intValue());
            HighlightedRange currentElement = (HighlightedRange)sortedSources.get(iElement);
            if (currentElement.getAbsoluteLocation().contains(currentRange)) {
                result.add(new HighlightedRange(currentRange, currentElement.getAttributes()));
                ++iPoint;
                continue;
            }
            if (currentElement.getAbsoluteLocation().getStartOffset() >= currentRange.getEndOffset()) {
                ++iPoint;
                continue;
            }
            if (currentElement.getAbsoluteLocation().getEndOffset() > currentRange.getStartOffset()) break;
            ++iElement;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static final void run$lambda$2(PsiFile $fileWithSuggestion, TextRange $suggestionRange, JavaElementVisitor visitor2) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$fileWithSuggestion, (String)"$fileWithSuggestion");
        Intrinsics.checkNotNullParameter((Object)$suggestionRange, (String)"$suggestionRange");
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        Iterable $this$flatMap$iv = JavaSuggestionEnricherKt.findTargetElements($fileWithSuggestion, $suggestionRange);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PsiElement it = (PsiElement)element$iv$iv;
            boolean bl = false;
            List list2 = SyntaxTraverser.psiTraverser((PsiElement)it).onRange($suggestionRange).toList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"toList(...)");
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement element = (PsiElement)element$iv;
            boolean bl = false;
            element.accept((PsiElementVisitor)visitor2);
        }
    }

    @NotNull
    public static final Logger getLogger() {
        return Companion.getLogger();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(JavaNamesHighlighterEnricher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/inline/completion/java/features/correctness/JavaNamesHighlighterEnricher$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$annotations", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.ml.inline.completion.java"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        @JvmStatic
        public static /* synthetic */ void getLogger$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

