/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.RepoStateException;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.repo.GitBranchState;
import git4idea.repo.GitHooksInfo;
import git4idea.repo.GitRefUtil;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepositoryFiles;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRepositoryReader {
    private static final Logger LOG = Logger.getInstance(GitRepositoryReader.class);
    private static final String DETACHED_HEAD = "detached HEAD";
    @NotNull
    private final File myHeadFile;
    @NotNull
    private final File myRefsHeadsDir;
    @NotNull
    private final File myRefsRemotesDir;
    @NotNull
    private final File myPackedRefsFile;
    @NotNull
    private final GitRepositoryFiles myGitFiles;

    GitRepositoryReader(@NotNull GitRepositoryFiles gitFiles) {
        if (gitFiles == null) {
            GitRepositoryReader.$$$reportNull$$$0(0);
        }
        this.myGitFiles = gitFiles;
        this.myHeadFile = gitFiles.getHeadFile();
        this.myRefsHeadsDir = gitFiles.getRefsHeadsFile();
        this.myRefsRemotesDir = gitFiles.getRefsRemotesFile();
        this.myPackedRefsFile = gitFiles.getPackedRefsPath();
    }

    @NotNull
    GitBranchState readState(@NotNull Collection<GitRemote> remotes) {
        String currentRevision;
        GitLocalBranch currentBranch;
        if (remotes == null) {
            GitRepositoryReader.$$$reportNull$$$0(1);
        }
        Pair<Map<GitLocalBranch, Hash>, Map<GitRemoteBranch, Hash>> branches = this.readBranches(remotes);
        Map localBranches2 = (Map)branches.first;
        HeadInfo headInfo = this.readHead();
        Repository.State state2 = this.readRepositoryState(headInfo);
        if (!headInfo.isBranch || !localBranches2.isEmpty()) {
            currentBranch = this.findCurrentBranch(headInfo, state2, localBranches2.keySet());
            currentRevision = GitRepositoryReader.getCurrentRevision(headInfo, currentBranch == null ? null : (Hash)localBranches2.get(currentBranch));
        } else if (headInfo.content != null) {
            currentBranch = new GitLocalBranch(headInfo.content);
            currentRevision = null;
        } else {
            currentBranch = null;
            currentRevision = null;
        }
        if (currentBranch == null && currentRevision == null) {
            LOG.warn("Couldn't identify neither current branch nor current revision. Ref specified in .git/HEAD: [" + headInfo.content + "]");
            LOG.debug("Dumping files in .git/refs/, and the content of .git/packed-refs. Debug enabled: " + LOG.isDebugEnabled());
            GitRefUtil.logDebugAllRefsFiles(this.myGitFiles);
        }
        return new GitBranchState(currentRevision, currentBranch, state2, localBranches2, (Map)branches.second);
    }

    @NotNull
    GitHooksInfo readHooksInfo() {
        boolean hasCommitHook = GitRepositoryReader.isExistingExecutableFile(this.myGitFiles.getPreCommitHookFile()) || GitRepositoryReader.isExistingExecutableFile(this.myGitFiles.getCommitMsgHookFile());
        boolean hasPushHook = GitRepositoryReader.isExistingExecutableFile(this.myGitFiles.getPrePushHookFile());
        return new GitHooksInfo(hasCommitHook, hasPushHook);
    }

    private static boolean isExistingExecutableFile(@NotNull File file2) {
        if (file2 == null) {
            GitRepositoryReader.$$$reportNull$$$0(2);
        }
        return file2.exists() && file2.canExecute();
    }

    boolean hasShallowCommits() {
        File shallowFile = this.myGitFiles.getShallowFile();
        if (!shallowFile.exists()) {
            return false;
        }
        return shallowFile.length() > 0L;
    }

    @Nullable
    private static String getCurrentRevision(@NotNull HeadInfo headInfo, @Nullable Hash currentBranchHash) {
        if (headInfo == null) {
            GitRepositoryReader.$$$reportNull$$$0(3);
        }
        Object currentRevision = !headInfo.isBranch ? headInfo.content : (currentBranchHash == null ? null : currentBranchHash.asString());
        return currentRevision;
    }

    @Nullable
    private GitLocalBranch findCurrentBranch(@NotNull HeadInfo headInfo, @NotNull Repository.State state2, @NotNull Set<GitLocalBranch> localBranches2) {
        String currentBranchName;
        if (headInfo == null) {
            GitRepositoryReader.$$$reportNull$$$0(4);
        }
        if (state2 == null) {
            GitRepositoryReader.$$$reportNull$$$0(5);
        }
        if (localBranches2 == null) {
            GitRepositoryReader.$$$reportNull$$$0(6);
        }
        if ((currentBranchName = this.findCurrentBranchName(state2, headInfo)) == null) {
            return null;
        }
        GitLocalBranch currentBranch = (GitLocalBranch)ContainerUtil.find(localBranches2, branch -> GitReference.BRANCH_NAME_HASHING_STRATEGY.equals((Object)branch.getFullName(), (Object)currentBranchName));
        return currentBranch == null ? new GitLocalBranch(currentBranchName) : currentBranch;
    }

    @NotNull
    private Repository.State readRepositoryState(@NotNull HeadInfo headInfo) {
        if (headInfo == null) {
            GitRepositoryReader.$$$reportNull$$$0(7);
        }
        if (this.isMergeInProgress()) {
            Repository.State state2 = Repository.State.MERGING;
            if (state2 == null) {
                GitRepositoryReader.$$$reportNull$$$0(8);
            }
            return state2;
        }
        if (this.isRebaseInProgress()) {
            Repository.State state3 = Repository.State.REBASING;
            if (state3 == null) {
                GitRepositoryReader.$$$reportNull$$$0(9);
            }
            return state3;
        }
        if (!headInfo.isBranch) {
            Repository.State state4 = Repository.State.DETACHED;
            if (state4 == null) {
                GitRepositoryReader.$$$reportNull$$$0(10);
            }
            return state4;
        }
        if (this.isCherryPickInProgress()) {
            Repository.State state5 = Repository.State.GRAFTING;
            if (state5 == null) {
                GitRepositoryReader.$$$reportNull$$$0(11);
            }
            return state5;
        }
        if (this.isRevertInProgress()) {
            Repository.State state6 = Repository.State.REVERTING;
            if (state6 == null) {
                GitRepositoryReader.$$$reportNull$$$0(12);
            }
            return state6;
        }
        Repository.State state7 = Repository.State.NORMAL;
        if (state7 == null) {
            GitRepositoryReader.$$$reportNull$$$0(13);
        }
        return state7;
    }

    @Nullable
    private String findCurrentBranchName(@NotNull Repository.State state2, @NotNull HeadInfo headInfo) {
        if (state2 == null) {
            GitRepositoryReader.$$$reportNull$$$0(14);
        }
        if (headInfo == null) {
            GitRepositoryReader.$$$reportNull$$$0(15);
        }
        String currentBranch = null;
        if (headInfo.isBranch) {
            currentBranch = headInfo.content;
        } else if (state2 == Repository.State.REBASING) {
            currentBranch = this.tryFindRebaseBranch();
        }
        return GitRefUtil.addRefsHeadsPrefixIfNeeded(currentBranch);
    }

    @Nullable
    private String tryFindRebaseBranch() {
        String currentBranch = GitRepositoryReader.readRebaseDirBranchFile(this.myGitFiles.getRebaseApplyDir());
        if (currentBranch == null) {
            currentBranch = GitRepositoryReader.readRebaseDirBranchFile(this.myGitFiles.getRebaseMergeDir());
        }
        return currentBranch == null || currentBranch.equals(DETACHED_HEAD) ? null : currentBranch;
    }

    @Nullable
    private static String readRebaseDirBranchFile(@NonNls File rebaseDir) {
        File headName;
        if (rebaseDir.exists() && (headName = new File(rebaseDir, "head-name")).exists()) {
            return DvcsUtil.tryLoadFileOrReturn((File)headName, null, (String)"UTF-8");
        }
        return null;
    }

    private boolean isMergeInProgress() {
        return this.myGitFiles.getMergeHeadFile().exists();
    }

    private boolean isRebaseInProgress() {
        return this.myGitFiles.getRebaseApplyDir().exists() || this.myGitFiles.getRebaseMergeDir().exists();
    }

    private boolean isCherryPickInProgress() {
        return this.myGitFiles.getCherryPickHead().exists();
    }

    private boolean isRevertInProgress() {
        return this.myGitFiles.getRevertHead().exists();
    }

    @NotNull
    private Map<String, String> readPackedBranches() {
        Map map2;
        if (!this.myPackedRefsFile.exists()) {
            Map<String, String> map3 = Collections.emptyMap();
            if (map3 == null) {
                GitRepositoryReader.$$$reportNull$$$0(16);
            }
            return map3;
        }
        try {
            String content = DvcsUtil.tryLoadFile((File)this.myPackedRefsFile, (String)"UTF-8");
            map2 = ContainerUtil.map2MapNotNull((Object[])LineTokenizer.tokenize((CharSequence)content, (boolean)false), GitRefUtil::parseBranchesLine);
        }
        catch (RepoStateException e) {
            Map<String, String> map4 = Collections.emptyMap();
            if (map4 == null) {
                GitRepositoryReader.$$$reportNull$$$0(18);
            }
            return map4;
        }
        if (map2 == null) {
            GitRepositoryReader.$$$reportNull$$$0(17);
        }
        return map2;
    }

    @NotNull
    private Pair<Map<GitLocalBranch, Hash>, Map<GitRemoteBranch, Hash>> readBranches(@NotNull Collection<GitRemote> remotes) {
        if (remotes == null) {
            GitRepositoryReader.$$$reportNull$$$0(19);
        }
        Map<String, String> data2 = this.readBranchRefsFromFiles();
        Map<String, Hash> resolvedRefs = GitRefUtil.resolveRefs(data2);
        return GitRepositoryReader.createBranchesFromData(remotes, resolvedRefs);
    }

    @NotNull
    private Map<String, String> readBranchRefsFromFiles() {
        HashMap<String, String> hashMap;
        try {
            HashMap<String, String> result2 = new HashMap<String, String>(this.readPackedBranches());
            result2.putAll(GitRefUtil.readFromRefsFiles(this.myRefsHeadsDir, "refs/heads/", this.myGitFiles));
            result2.putAll(GitRefUtil.readFromRefsFiles(this.myRefsRemotesDir, "refs/remotes/", this.myGitFiles));
            result2.remove("refs/remotes/origin/HEAD");
            hashMap = result2;
        }
        catch (Throwable e) {
            GitRefUtil.logDebugAllRefsFiles(this.myGitFiles);
            LOG.warn("Error reading refs from files", e);
            Map<String, String> map2 = Collections.emptyMap();
            if (map2 == null) {
                GitRepositoryReader.$$$reportNull$$$0(21);
            }
            return map2;
        }
        if (hashMap == null) {
            GitRepositoryReader.$$$reportNull$$$0(20);
        }
        return hashMap;
    }

    @NotNull
    private static Pair<Map<GitLocalBranch, Hash>, Map<GitRemoteBranch, Hash>> createBranchesFromData(@NotNull Collection<GitRemote> remotes, @NotNull Map<String, Hash> data2) {
        if (remotes == null) {
            GitRepositoryReader.$$$reportNull$$$0(22);
        }
        if (data2 == null) {
            GitRepositoryReader.$$$reportNull$$$0(23);
        }
        HashMap<GitLocalBranch, Hash> localBranches2 = new HashMap<GitLocalBranch, Hash>();
        HashMap<GitRemoteBranch, Hash> remoteBranches2 = new HashMap<GitRemoteBranch, Hash>();
        for (Map.Entry<String, Hash> entry : data2.entrySet()) {
            String refName = entry.getKey();
            Hash hash = entry.getValue();
            GitBranch branch = GitRepositoryReader.parseBranchRef(remotes, refName);
            if (branch instanceof GitLocalBranch) {
                localBranches2.put((GitLocalBranch)branch, hash);
                continue;
            }
            if (branch instanceof GitRemoteBranch) {
                remoteBranches2.put((GitRemoteBranch)branch, hash);
                continue;
            }
            LOG.warn(String.format("Unexpected ref format: %s, %s", refName, branch));
        }
        Pair pair = Pair.create(localBranches2, remoteBranches2);
        if (pair == null) {
            GitRepositoryReader.$$$reportNull$$$0(24);
        }
        return pair;
    }

    @Nullable
    public static GitBranch parseBranchRef(@NotNull Collection<GitRemote> remotes, String refName) {
        if (remotes == null) {
            GitRepositoryReader.$$$reportNull$$$0(25);
        }
        if (refName.startsWith("refs/heads/")) {
            return new GitLocalBranch(refName);
        }
        if (refName.startsWith("refs/remotes/")) {
            return GitUtil.parseRemoteBranch(refName, remotes);
        }
        return null;
    }

    @Nullable
    private static String loadHashFromBranchFile(@NotNull File branchFile) {
        if (branchFile == null) {
            GitRepositoryReader.$$$reportNull$$$0(26);
        }
        return DvcsUtil.tryLoadFileOrReturn((File)branchFile, null);
    }

    private static boolean isHidden(@NotNull File file2) {
        if (file2 == null) {
            GitRepositoryReader.$$$reportNull$$$0(27);
        }
        return file2.getName().startsWith(".");
    }

    @NotNull
    private HeadInfo readHead() {
        String headContent;
        try {
            headContent = DvcsUtil.tryLoadFile((File)this.myHeadFile, (String)"UTF-8");
        }
        catch (RepoStateException e) {
            LOG.warn((Throwable)e);
            return new HeadInfo(false, null);
        }
        Hash hash = GitRefUtil.parseHash(headContent);
        if (hash != null) {
            return new HeadInfo(false, headContent);
        }
        String target = GitRefUtil.getTarget(headContent);
        if (target != null) {
            return new HeadInfo(true, target);
        }
        LOG.warn((Throwable)new RepoStateException("Invalid format of the .git/HEAD file: [" + headContent + "]"));
        return new HeadInfo(false, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 12, 13, 16, 17, 18, 20, 21, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitFiles";
                break;
            }
            case 1: 
            case 19: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotes";
                break;
            }
            case 2: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headInfo";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localBranches";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/repo/GitRepositoryReader";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/repo/GitRepositoryReader";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "readRepositoryState";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "readPackedBranches";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "readBranchRefsFromFiles";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createBranchesFromData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isExistingExecutableFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentRevision";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findCurrentBranch";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readRepositoryState";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findCurrentBranchName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "readBranches";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createBranchesFromData";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "parseBranchRef";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "loadHashFromBranchFile";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isHidden";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 12, 13, 16, 17, 18, 20, 21, 24 -> new IllegalStateException(string);
        };
    }

    private static class HeadInfo {
        @Nullable
        private final String content;
        private final boolean isBranch;

        HeadInfo(boolean branch, @Nullable String content) {
            this.isBranch = branch;
            this.content = content;
        }
    }
}

