/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.diagnostic.Logger;
import git4idea.repo.GitConfigHelperKt;
import git4idea.repo.GitSubmoduleInfo;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lgit4idea/repo/GitModulesFileReader;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "MODULE_SECTION", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "read", "", "Lgit4idea/repo/GitSubmoduleInfo;", "file", "Ljava/io/File;", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitModulesFileReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitModulesFileReader.kt\ngit4idea/repo/GitModulesFileReader\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,57:1\n13#2:58\n*S KotlinDebug\n*F\n+ 1 GitModulesFileReader.kt\ngit4idea/repo/GitModulesFileReader\n*L\n25#1:58\n*E\n"})
public final class GitModulesFileReader {
    @NotNull
    private final Logger LOG;
    private final Pattern MODULE_SECTION;

    public GitModulesFileReader() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitModulesFileReader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
        this.MODULE_SECTION = Pattern.compile("submodule \"(.*)\"", 2);
    }

    @NotNull
    public final Collection<GitSubmoduleInfo> read(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!file2.exists()) {
            return CollectionsKt.emptyList();
        }
        Ini ini = null;
        try {
            ini = GitConfigHelperKt.loadIniFile(file2);
        }
        catch (IOException e) {
            return CollectionsKt.emptyList();
        }
        Set modules = new LinkedHashSet();
        for (Map.Entry entry : ((Map)ini).entrySet()) {
            String sectionName = (String)entry.getKey();
            Profile.Section section = (Profile.Section)entry.getValue();
            Matcher matcher = this.MODULE_SECTION.matcher(sectionName);
            if (!matcher.matches() || matcher.groupCount() != 1) continue;
            String path = (String)section.get("path");
            String url = (String)section.get("url");
            if (path == null || url == null) {
                this.LOG.warn("Partially defined submodule: " + section);
                continue;
            }
            GitSubmoduleInfo module = new GitSubmoduleInfo(path, url);
            this.LOG.debug("Found submodule " + module);
            modules.add(module);
        }
        return modules;
    }
}

