/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.data.VcsLogData;
import git4idea.GitProtectedBranchesKt;
import git4idea.i18n.GitBundle;
import git4idea.rebase.log.GitCommitEditingActionBase;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014\u00a8\u0006\u0010"}, d2={"Lgit4idea/rebase/GitSingleCommitEditingAction;", "Lgit4idea/rebase/log/GitCommitEditingActionBase;", "Lgit4idea/rebase/GitSingleCommitEditingAction$SingleCommitEditingData;", "()V", "createCommitEditingData", "Lgit4idea/rebase/log/GitCommitEditingActionBase$CommitEditingDataCreationResult;", "repository", "Lgit4idea/repo/GitRepository;", "selection", "Lcom/intellij/vcs/log/VcsLogCommitSelection;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "lastCheckCommitsEditingAvailability", "", "commitEditingData", "SingleCommitEditingData", "intellij.vcs.git"})
public abstract class GitSingleCommitEditingAction
extends GitCommitEditingActionBase<SingleCommitEditingData> {
    @Override
    @NotNull
    protected GitCommitEditingActionBase.CommitEditingDataCreationResult<SingleCommitEditingData> createCommitEditingData(@NotNull GitRepository repository, @NotNull VcsLogCommitSelection selection, @NotNull VcsLogData logData) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
        if (selection.getCommits().size() != 1) {
            return new GitCommitEditingActionBase.CommitEditingDataCreationResult.Prohibited(null, 1, null);
        }
        return new GitCommitEditingActionBase.CommitEditingDataCreationResult.Created<GitCommitEditingActionBase.MultipleCommitEditingData>(new SingleCommitEditingData(repository, selection, logData));
    }

    @Override
    @Nullable
    protected String lastCheckCommitsEditingAvailability(@NotNull SingleCommitEditingData commitEditingData) {
        Intrinsics.checkNotNullParameter((Object)commitEditingData, (String)"commitEditingData");
        VcsCommitMetadata commit = commitEditingData.getSelectedCommit();
        VcsLogData vcsLogData = commitEditingData.getLogData();
        VirtualFile virtualFile = commit.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        Object object = commit.getId();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getId(...)");
        List<String> branches = GitCommitEditingActionBase.Companion.findContainingBranches(vcsLogData, virtualFile, (Hash)object);
        if (!branches.contains("HEAD")) {
            return GitBundle.message("rebase.log.commit.editing.action.commit.not.in.head.error.text", new Object[0]);
        }
        String protectedBranch = GitProtectedBranchesKt.findProtectedRemoteBranch(commitEditingData.getRepository(), (Collection<String>)branches);
        if (protectedBranch != null) {
            Object[] objectArray = new Object[]{protectedBranch};
            return GitBundle.message("rebase.log.commit.editing.action.commit.pushed.to.protected.branch.error.text", objectArray);
        }
        return null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lgit4idea/rebase/GitSingleCommitEditingAction$SingleCommitEditingData;", "Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "repository", "Lgit4idea/repo/GitRepository;", "selection", "Lcom/intellij/vcs/log/VcsLogCommitSelection;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "(Lgit4idea/repo/GitRepository;Lcom/intellij/vcs/log/VcsLogCommitSelection;Lcom/intellij/vcs/log/data/VcsLogData;)V", "isHeadCommit", "", "()Z", "selectedCommit", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "getSelectedCommit", "()Lcom/intellij/vcs/log/VcsCommitMetadata;", "intellij.vcs.git"})
    public static final class SingleCommitEditingData
    extends GitCommitEditingActionBase.MultipleCommitEditingData {
        @NotNull
        private final VcsCommitMetadata selectedCommit;
        private final boolean isHeadCommit;

        public SingleCommitEditingData(@NotNull GitRepository repository, @NotNull VcsLogCommitSelection selection, @NotNull VcsLogData logData) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
            super(repository, selection, logData);
            this.selectedCommit = (VcsCommitMetadata)CollectionsKt.first((List)selection.getCachedMetadata());
            this.isHeadCommit = Intrinsics.areEqual((Object)((Hash)this.selectedCommit.getId()).asString(), (Object)repository.getCurrentRevision());
        }

        @NotNull
        public final VcsCommitMetadata getSelectedCommit() {
            return this.selectedCommit;
        }

        public final boolean isHeadCommit() {
            return this.isHeadCommit;
        }
    }
}

