/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsRevisionDescription;
import com.intellij.openapi.vcs.history.VcsRevisionDescriptionImpl;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitCommit;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.history.GitLogFullRecord;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogRecord;
import git4idea.history.GitLogUtil;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitHistoryUtils {
    private static final Logger LOG = Logger.getInstance(GitHistoryUtils.class);

    private GitHistoryUtils() {
    }

    public static void loadDetails(@NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<? super GitCommit> commitConsumer, String ... parameters) throws VcsException {
        if (project == null) {
            GitHistoryUtils.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GitHistoryUtils.$$$reportNull$$$0(1);
        }
        if (commitConsumer == null) {
            GitHistoryUtils.$$$reportNull$$$0(2);
        }
        if (parameters == null) {
            GitHistoryUtils.$$$reportNull$$$0(3);
        }
        GitLogUtil.readFullDetails(project, root, arg_0 -> commitConsumer.consume(arg_0), parameters);
    }

    public static void loadTimedCommits(@NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<? super TimedVcsCommit> commitConsumer, String ... parameters) throws VcsException {
        if (project == null) {
            GitHistoryUtils.$$$reportNull$$$0(4);
        }
        if (root == null) {
            GitHistoryUtils.$$$reportNull$$$0(5);
        }
        if (commitConsumer == null) {
            GitHistoryUtils.$$$reportNull$$$0(6);
        }
        if (parameters == null) {
            GitHistoryUtils.$$$reportNull$$$0(7);
        }
        GitLogUtil.readTimedCommits(project, root, Arrays.asList(parameters), null, null, arg_0 -> commitConsumer.consume(arg_0));
    }

    @NotNull
    public static List<? extends TimedVcsCommit> collectTimedCommits(@NotNull Project project, @NotNull VirtualFile root, String ... parameters) throws VcsException {
        if (project == null) {
            GitHistoryUtils.$$$reportNull$$$0(8);
        }
        if (root == null) {
            GitHistoryUtils.$$$reportNull$$$0(9);
        }
        if (parameters == null) {
            GitHistoryUtils.$$$reportNull$$$0(10);
        }
        ArrayList commits2 = new ArrayList();
        GitHistoryUtils.loadTimedCommits(project, root, (Consumer<? super TimedVcsCommit>)((Consumer)commits2::add), parameters);
        ArrayList arrayList = commits2;
        if (arrayList == null) {
            GitHistoryUtils.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Nullable
    public static List<? extends VcsCommitMetadata> collectCommitsMetadata(@NotNull Project project, @NotNull VirtualFile root, String ... hashes2) throws VcsException {
        List<? extends VcsCommitMetadata> result2;
        if (project == null) {
            GitHistoryUtils.$$$reportNull$$$0(12);
        }
        if (root == null) {
            GitHistoryUtils.$$$reportNull$$$0(13);
        }
        if (hashes2 == null) {
            GitHistoryUtils.$$$reportNull$$$0(14);
        }
        if ((result2 = GitLogUtil.collectMetadata(project, root, Arrays.asList(hashes2))).size() != hashes2.length) {
            return null;
        }
        return result2;
    }

    @NotNull
    public static List<GitCommit> history(@NotNull Project project, @NotNull VirtualFile root, String ... parameters) throws VcsException {
        VcsLogObjectsFactory factory;
        if (project == null) {
            GitHistoryUtils.$$$reportNull$$$0(15);
        }
        if (root == null) {
            GitHistoryUtils.$$$reportNull$$$0(16);
        }
        if ((factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project)) == null) {
            List<GitCommit> list2 = Collections.emptyList();
            if (list2 == null) {
                GitHistoryUtils.$$$reportNull$$$0(17);
            }
            return list2;
        }
        ArrayList<GitCommit> commits2 = new ArrayList<GitCommit>();
        try {
            GitLogUtil.readFullDetails(project, root, commits2::add, parameters);
        }
        catch (VcsException e) {
            if (commits2.isEmpty()) {
                throw e;
            }
            LOG.warn("Error during loading details, returning partially loaded commits\n", (Throwable)e);
        }
        ArrayList<GitCommit> arrayList = commits2;
        if (arrayList == null) {
            GitHistoryUtils.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    public static String @NotNull [] formHashParameters(@NotNull Project project, @NotNull Collection<String> hashes2) {
        if (project == null) {
            GitHistoryUtils.$$$reportNull$$$0(19);
        }
        if (hashes2 == null) {
            GitHistoryUtils.$$$reportNull$$$0(20);
        }
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(GitLogUtil.getNoWalkParameter(project));
        parameters.addAll(hashes2);
        String[] stringArray = ArrayUtilRt.toStringArray(parameters);
        if (stringArray == null) {
            GitHistoryUtils.$$$reportNull$$$0(21);
        }
        return stringArray;
    }

    @Nullable
    public static VcsRevisionNumber getCurrentRevision(@NotNull Project project, @NotNull FilePath filePath, @Nullable String branch) throws VcsException {
        if (project == null) {
            GitHistoryUtils.$$$reportNull$$$0(22);
        }
        if (filePath == null) {
            GitHistoryUtils.$$$reportNull$$$0(23);
        }
        filePath = VcsUtil.getLastCommitPath((Project)project, (FilePath)filePath);
        GitLineHandler h = new GitLineHandler(project, GitUtil.getRootForFile(project, filePath), GitCommand.LOG);
        GitLogParser<GitLogRecord> parser = GitLogParser.createDefaultParser(project, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME);
        h.setSilent(true);
        h.addParameters("-n1", parser.getPretty());
        h.addParameters(!StringUtil.isEmpty((String)branch) ? branch : "--all");
        h.endOptions();
        h.addRelativePaths(filePath);
        String result2 = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        if (result2.isEmpty()) {
            return null;
        }
        GitLogRecord record = parser.parseOneRecord(result2);
        if (record == null) {
            return null;
        }
        record.setUsedHandler(h);
        return new GitRevisionNumber(record.getHash(), record.getDate());
    }

    @Nullable
    public static VcsRevisionDescription getCurrentRevisionDescription(@NotNull Project project, @NotNull FilePath filePath) throws VcsException {
        if (project == null) {
            GitHistoryUtils.$$$reportNull$$$0(24);
        }
        if (filePath == null) {
            GitHistoryUtils.$$$reportNull$$$0(25);
        }
        filePath = VcsUtil.getLastCommitPath((Project)project, (FilePath)filePath);
        GitLineHandler h = new GitLineHandler(project, GitUtil.getRootForFile(project, filePath), GitCommand.LOG);
        GitLogParser<GitLogRecord> parser = GitLogParser.createDefaultParser(project, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY);
        h.setSilent(true);
        h.addParameters("-n1", parser.getPretty());
        h.addParameters("--encoding=UTF-8");
        h.addParameters("--all");
        h.endOptions();
        h.addRelativePaths(filePath);
        String result2 = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        if (result2.isEmpty()) {
            return null;
        }
        GitLogRecord record = parser.parseOneRecord(result2);
        if (record == null) {
            return null;
        }
        record.setUsedHandler(h);
        String author = Objects.equals(record.getAuthorName(), record.getCommitterName()) ? record.getAuthorName() : record.getAuthorName() + " (" + record.getCommitterName() + ")";
        return new VcsRevisionDescriptionImpl((VcsRevisionNumber)new GitRevisionNumber(record.getHash(), record.getDate()), record.getDate(), author, record.getFullMessage());
    }

    @Nullable
    public static ItemLatestState getLastRevision(@NotNull Project project, @NotNull FilePath filePath) throws VcsException {
        GitRemoteBranch t;
        if (project == null) {
            GitHistoryUtils.$$$reportNull$$$0(26);
        }
        if (filePath == null) {
            GitHistoryUtils.$$$reportNull$$$0(27);
        }
        GitRepository repository = GitUtil.getRepositoryForFile(project, filePath);
        VirtualFile root = repository.getRoot();
        GitLocalBranch c = repository.getCurrentBranch();
        GitBranchTrackInfo info = c == null ? null : repository.getBranchTrackInfo(c.getName());
        GitRemoteBranch gitRemoteBranch = t = info == null ? null : info.getRemoteBranch();
        if (t == null) {
            return new ItemLatestState(GitHistoryUtils.getCurrentRevision(project, filePath, null), true, false);
        }
        filePath = VcsUtil.getLastCommitPath((Project)project, (FilePath)filePath);
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.LOG);
        GitLogParser<GitLogFullRecord> parser = GitLogParser.createDefaultParser(project, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.PARENTS);
        h.setSilent(true);
        h.addParameters("-n1", parser.getPretty(), "--name-status", t.getFullName());
        h.endOptions();
        h.addRelativePaths(filePath);
        String result2 = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        if (result2.isEmpty()) {
            return null;
        }
        GitLogFullRecord record = parser.parseOneRecord(result2);
        if (record == null) {
            return null;
        }
        List<Change> changes = record.parseChanges(project, root);
        boolean exists = changes.isEmpty() || !FileStatus.DELETED.equals(changes.get(0).getFileStatus());
        record.setUsedHandler(h);
        return new ItemLatestState((VcsRevisionNumber)new GitRevisionNumber(record.getHash(), record.getDate()), exists, false);
    }

    @Nullable
    public static String getNumberOfCommitsBetween(@NotNull GitRepository repository, @NotNull String from, @NotNull String to) {
        if (repository == null) {
            GitHistoryUtils.$$$reportNull$$$0(28);
        }
        if (from == null) {
            GitHistoryUtils.$$$reportNull$$$0(29);
        }
        if (to == null) {
            GitHistoryUtils.$$$reportNull$$$0(30);
        }
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REV_LIST);
        handler.addParameters("--count", from + ".." + to);
        handler.setSilent(true);
        try {
            return Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]).trim();
        }
        catch (VcsException e) {
            LOG.debug(e.getMessage());
            return null;
        }
    }

    @Nullable
    public static GitRevisionNumber getMergeBase(@NotNull Project project, @NotNull VirtualFile root, @NotNull String first, @NotNull String second) throws VcsException {
        if (project == null) {
            GitHistoryUtils.$$$reportNull$$$0(31);
        }
        if (root == null) {
            GitHistoryUtils.$$$reportNull$$$0(32);
        }
        if (first == null) {
            GitHistoryUtils.$$$reportNull$$$0(33);
        }
        if (second == null) {
            GitHistoryUtils.$$$reportNull$$$0(34);
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.MERGE_BASE);
        h.setSilent(true);
        h.addParameters(first, second);
        GitCommandResult result2 = Git.getInstance().runCommand(h);
        if (!result2.success()) {
            return null;
        }
        String output = result2.getOutputAsJoinedString().trim();
        if (output.isEmpty()) {
            return null;
        }
        return GitRevisionNumber.resolve(project, root, output);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 17, 18, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 13: 
            case 16: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitConsumer";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 11: 
            case 17: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/history/GitHistoryUtils";
                break;
            }
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/history/GitHistoryUtils";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTimedCommits";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "history";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "formHashParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadDetails";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadTimedCommits";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectTimedCommits";
                break;
            }
            case 11: 
            case 17: 
            case 18: 
            case 21: {
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectCommitsMetadata";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "history";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "formHashParameters";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentRevision";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentRevisionDescription";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getLastRevision";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getNumberOfCommitsBetween";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getMergeBase";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 17, 18, 21 -> new IllegalStateException(string);
        };
    }
}

