/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions.tag;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import git4idea.GitBranch;
import git4idea.GitReference;
import git4idea.GitTag;
import git4idea.actions.branch.GitBranchActionsUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0018\u0012\u0011\u0010\u0004\u001a\r\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J3\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016J/\u0010\u001a\u001a\u0004\u0018\u00018\u00002\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u00142\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u0014H\u0014\u00a2\u0006\u0002\u0010\u001fJ\u0015\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\"JB\u0010#\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u00142\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u0014H\u0002J\u000e\u0010$\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J3\u0010%\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006&"}, d2={"Lgit4idea/actions/tag/GitSingleRefAction;", "T", "Lgit4idea/GitReference;", "Lcom/intellij/openapi/project/DumbAwareAction;", "dynamicText", "Ljava/util/function/Supplier;", "", "Lcom/intellij/openapi/util/NlsActions$ActionText;", "(Ljava/util/function/Supplier;)V", "disabledForCurrent", "", "getDisabledForCurrent", "()Z", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "reference", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;Lcom/intellij/openapi/project/Project;Ljava/util/List;Lgit4idea/GitReference;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getRef", "branches", "Lgit4idea/GitBranch;", "tags", "Lgit4idea/GitTag;", "(Ljava/util/List;Ljava/util/List;)Lgit4idea/GitReference;", "isDisabledForRef", "ref", "(Lgit4idea/GitReference;)Z", "isEnabledAndVisible", "update", "updateIfEnabledAndVisible", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitSingleRefAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitSingleRefAction.kt\ngit4idea/actions/tag/GitSingleRefAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1747#2,3:80\n*S KotlinDebug\n*F\n+ 1 GitSingleRefAction.kt\ngit4idea/actions/tag/GitSingleRefAction\n*L\n70#1:80,3\n*E\n"})
public abstract class GitSingleRefAction<T extends GitReference>
extends DumbAwareAction {
    private final boolean disabledForCurrent;

    public GitSingleRefAction(@NotNull Supplier<String> dynamicText) {
        Intrinsics.checkNotNullParameter(dynamicText, (String)"dynamicText");
        super(dynamicText);
    }

    public boolean getDisabledForCurrent() {
        return this.disabledForCurrent;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public final void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        List<GitRepository> repositories2 = GitBranchActionsUtil.getAffectedRepositories(e);
        List branches = (List)e.getData(GitBranchActionsUtil.BRANCHES_KEY);
        List tags2 = (List)e.getData(GitBranchActionsUtil.TAGS_KEY);
        e.getPresentation().setEnabledAndVisible(this.isEnabledAndVisible(project, repositories2, branches, tags2));
        DvcsUtil.disableActionIfAnyRepositoryIsFresh((AnActionEvent)e, repositories2, (String)GitBundle.message("action.not.possible.in.fresh.repo.generic", new Object[0]));
        if (e.getPresentation().isEnabledAndVisible()) {
            Project project2 = project;
            Intrinsics.checkNotNull((Object)project2);
            T t = this.getRef(branches, tags2);
            Intrinsics.checkNotNull(t);
            this.updateIfEnabledAndVisible(e, project2, repositories2, t);
        }
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        List branches = (List)e.getData(GitBranchActionsUtil.BRANCHES_KEY);
        List tags2 = (List)e.getData(GitBranchActionsUtil.TAGS_KEY);
        T t = this.getRef(branches, tags2);
        if (t == null) {
            return;
        }
        T ref = t;
        List<GitRepository> repositories2 = GitBranchActionsUtil.getAffectedRepositories(e);
        this.actionPerformed(e, project2, repositories2, ref);
    }

    public abstract void actionPerformed(@NotNull AnActionEvent var1, @NotNull Project var2, @NotNull List<? extends GitRepository> var3, @NotNull T var4);

    public void updateIfEnabledAndVisible(@NotNull AnActionEvent e, @NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull T reference) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
        Intrinsics.checkNotNullParameter(reference, (String)"reference");
    }

    protected boolean isDisabledForRef(@NotNull T ref) {
        Intrinsics.checkNotNullParameter(ref, (String)"ref");
        return false;
    }

    @Nullable
    protected T getRef(@Nullable List<? extends GitBranch> branches, @Nullable List<GitTag> tags2) {
        GitReference gitReference;
        List<GitTag> list2 = tags2;
        if (list2 != null && (list2 = (GitTag)CollectionsKt.singleOrNull(list2)) != null) {
            gitReference = (GitReference)((Object)list2);
        } else {
            List<? extends GitBranch> list3 = branches;
            gitReference = list3 != null ? (GitBranch)CollectionsKt.singleOrNull(list3) : null;
        }
        GitReference gitReference2 = gitReference;
        return (T)(gitReference2 instanceof GitReference ? gitReference2 : null);
    }

    private final boolean isEnabledAndVisible(Project project, List<? extends GitRepository> repositories2, List<? extends GitBranch> branches, List<GitTag> tags2) {
        if (project == null) {
            return false;
        }
        Collection collection = repositories2;
        if (collection == null || collection.isEmpty()) {
            return false;
        }
        T t = this.getRef(branches, tags2);
        if (t == null) {
            return false;
        }
        T ref = t;
        if (this.isDisabledForRef(ref)) {
            return false;
        }
        if (this.getDisabledForCurrent()) {
            boolean bl;
            block9: {
                Iterable $this$any$iv = repositories2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GitRepository it = (GitRepository)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getCurrentBranch(), ref)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return false;
            }
        }
        return true;
    }
}

