/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.utils.vfs;

import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.vfs.newvfs.persistent.VFSHealthChecker;
import com.intellij.testFramework.utils.vfs.CheckVFSHealthKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00152\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001\u0015B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0005B9\b\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0012\u0010\u0011\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0012\u0010\u0012\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0012\u0010\u0013\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/testFramework/utils/vfs/CheckVFSHealthExtension;", "Lorg/junit/jupiter/api/extension/BeforeAllCallback;", "Lorg/junit/jupiter/api/extension/AfterAllCallback;", "Lorg/junit/jupiter/api/extension/BeforeEachCallback;", "Lorg/junit/jupiter/api/extension/AfterEachCallback;", "()V", "checkBeforeEach", "", "checkAfterEach", "checkBeforeAll", "checkAfterAll", "checkOnlyNewErrors", "(ZZZZZ)V", "afterAll", "", "context", "Lorg/junit/jupiter/api/extension/ExtensionContext;", "afterEach", "beforeAll", "beforeEach", "checkVFS", "Companion", "intellij.platform.testFramework"})
@TestOnly
public final class CheckVFSHealthExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean checkBeforeEach;
    private final boolean checkAfterEach;
    private final boolean checkBeforeAll;
    private final boolean checkAfterAll;
    private final boolean checkOnlyNewErrors;
    @NotNull
    private static final ExtensionContext.Namespace LOCAL_NAMESPACE;

    private CheckVFSHealthExtension(boolean checkBeforeEach, boolean checkAfterEach, boolean checkBeforeAll, boolean checkAfterAll, boolean checkOnlyNewErrors) {
        this.checkBeforeEach = checkBeforeEach;
        this.checkAfterEach = checkAfterEach;
        this.checkBeforeAll = checkBeforeAll;
        this.checkAfterAll = checkAfterAll;
        this.checkOnlyNewErrors = checkOnlyNewErrors;
        if (!(this.checkBeforeAll || this.checkBeforeEach || this.checkAfterAll || this.checkAfterEach)) {
            throw new IllegalArgumentException("All check[Before|After][All|Each] flags are false -- nothing to do. At least one of flags must be true");
        }
        if (!(!this.checkOnlyNewErrors || this.checkBeforeAll && this.checkAfterAll || this.checkBeforeEach && this.checkAfterEach)) {
            throw new IllegalArgumentException("checkOnlyNewErrors=true requires before AND after (" + this + ")");
        }
    }

    /* synthetic */ CheckVFSHealthExtension(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        if ((n & 8) != 0) {
            bl4 = false;
        }
        if ((n & 0x10) != 0) {
            bl5 = true;
        }
        this(bl, bl2, bl3, bl4, bl5);
    }

    public CheckVFSHealthExtension() {
        this(false, false, true, true, true);
    }

    public void beforeAll(@Nullable ExtensionContext context2) {
        if (this.checkBeforeAll) {
            ExtensionContext extensionContext = context2;
            Intrinsics.checkNotNull((Object)extensionContext);
            this.checkVFS(extensionContext);
        }
    }

    public void afterAll(@Nullable ExtensionContext context2) {
        if (this.checkAfterAll) {
            ExtensionContext extensionContext = context2;
            Intrinsics.checkNotNull((Object)extensionContext);
            this.checkVFS(extensionContext);
        }
    }

    public void beforeEach(@Nullable ExtensionContext context2) {
        if (this.checkBeforeEach) {
            ExtensionContext extensionContext = context2;
            Intrinsics.checkNotNull((Object)extensionContext);
            this.checkVFS(extensionContext);
        }
    }

    public void afterEach(@Nullable ExtensionContext context2) {
        if (this.checkAfterEach) {
            ExtensionContext extensionContext = context2;
            Intrinsics.checkNotNull((Object)extensionContext);
            this.checkVFS(extensionContext);
        }
    }

    private final void checkVFS(ExtensionContext context2) throws Exception {
        VFSHealthChecker checker = new VFSHealthChecker();
        VFSHealthChecker.VFSHealthCheckReport currentReport2 = (VFSHealthChecker.VFSHealthCheckReport)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super VFSHealthChecker.VFSHealthCheckReport>, Object>(checker, null){
            int label;
            final /* synthetic */ VFSHealthChecker $checker;
            {
                this.$checker = $checker;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$checker.checkHealth(true, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super VFSHealthChecker.VFSHealthCheckReport> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        context2.publishReportEntry("vfs-health-report-key", currentReport2.toString());
        if (this.checkOnlyNewErrors) {
            ExtensionContext.Store localStore = context2.getStore(LOCAL_NAMESPACE);
            VFSHealthChecker.VFSHealthCheckReport previousReport = (VFSHealthChecker.VFSHealthCheckReport)localStore.get((Object)"vfs-health-report-key", VFSHealthChecker.VFSHealthCheckReport.class);
            if (previousReport == null) {
                localStore.put((Object)"vfs-health-report-key", (Object)currentReport2);
            } else {
                CheckVFSHealthKt.access$assertVFSErrorsAreNotIncreased(currentReport2, previousReport);
            }
        } else if (!currentReport2.getHealthy()) {
            throw new AssertionError((Object)("VFS has errors: " + currentReport2));
        }
    }

    @JvmStatic
    @NotNull
    public static final CheckVFSHealthExtension beforeAndAfterAll() {
        return Companion.beforeAndAfterAll();
    }

    @JvmStatic
    @NotNull
    public static final CheckVFSHealthExtension beforeAndAfterEach() {
        return Companion.beforeAndAfterEach();
    }

    static {
        Object[] objectArray = new Object[]{"CheckVFSHealthExtension"};
        ExtensionContext.Namespace namespace = ExtensionContext.Namespace.create((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"create(...)");
        LOCAL_NAMESPACE = namespace;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\u0007H\u0007R\u0016\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/testFramework/utils/vfs/CheckVFSHealthExtension$Companion;", "", "()V", "LOCAL_NAMESPACE", "Lorg/junit/jupiter/api/extension/ExtensionContext$Namespace;", "getLOCAL_NAMESPACE$annotations", "beforeAndAfterAll", "Lcom/intellij/testFramework/utils/vfs/CheckVFSHealthExtension;", "beforeAndAfterEach", "intellij.platform.testFramework"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CheckVFSHealthExtension beforeAndAfterAll() {
            return new CheckVFSHealthExtension(false, false, true, true, false, 19, null);
        }

        @JvmStatic
        @NotNull
        public final CheckVFSHealthExtension beforeAndAfterEach() {
            return new CheckVFSHealthExtension(true, true, false, false, false, 28, null);
        }

        @JvmStatic
        private static /* synthetic */ void getLOCAL_NAMESPACE$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

