/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.bucketing;

import com.intellij.TestCaseLoader;
import com.intellij.testFramework.TeamCityLogger;
import com.intellij.testFramework.bucketing.TestsDurationBucketingUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010&\n\u0002\b\u0005\b\u00c1\u0002\u0018\u00002\u00020\u0001:\u0004\u001f !\"B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0007J0\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u00042\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J2\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\u0018\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001c\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J<\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00170\f0\u0004\"\u0004\b\u0000\u0010\u00172\u0018\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00020\u001a0\u00190\u00042\u0006\u0010\u001b\u001a\u00020\u0010H\u0002J\u001e\u0010\u001c\u001a\u00020\n\"\u0004\b\u0000\u0010\u001d*\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H\u001d0\u001eH\u0002\u00a8\u0006#"}, d2={"Lcom/intellij/testFramework/bucketing/TestsDurationBucketingUtils;", "", "()V", "calculateBucketFilters", "", "Lcom/intellij/testFramework/bucketing/TestsDurationBucketingUtils$BucketFilter;", "filter", "Lcom/intellij/TestCaseLoader$TestClassesFilterArgs;", "classes", "", "", "createBucketsFromTestsStatistics", "Lcom/intellij/testFramework/bucketing/TestsDurationBucketingUtils$ItemsAndTotalTime;", "Lcom/intellij/testFramework/bucketing/TestsDurationBucketingUtils$PackageClassesGroup;", "statistics", "", "", "bucketsCount", "getBucketFilter", "currentBucketIndex", "getGroupsToLoad", "loadDurationData", "tossElementsIntoBuckets", "T", "elements", "Lkotlin/Pair;", "Lkotlin/time/Duration;", "binCount", "packageName", "V", "", "BucketClassFilter", "BucketFilter", "ItemsAndTotalTime", "PackageClassesGroup", "intellij.platform.testFramework.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTestsDurationBucketingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestsDurationBucketingUtils.kt\ncom/intellij/testFramework/bucketing/TestsDurationBucketingUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,238:1\n1360#2:239\n1446#2,5:240\n1477#2:245\n1502#2,3:246\n1505#2,3:256\n1559#2:259\n1590#2,3:260\n1179#2,2:263\n1253#2,2:265\n1045#2:267\n1620#2,3:268\n1256#2:271\n1593#2:272\n1864#2,2:274\n1045#2:276\n1866#2:277\n1477#2:278\n1502#2,3:279\n1505#2,3:289\n1045#2:296\n1360#2:297\n1446#2,2:298\n1045#2:300\n1448#2,3:301\n1549#2:304\n1620#2,3:305\n1054#2:308\n1045#2:309\n766#2:310\n857#2,2:311\n372#3,7:249\n372#3,7:282\n1#4:273\n125#5:292\n152#5,3:293\n1313#6,2:313\n*S KotlinDebug\n*F\n+ 1 TestsDurationBucketingUtils.kt\ncom/intellij/testFramework/bucketing/TestsDurationBucketingUtils\n*L\n72#1:239\n72#1:240,5\n72#1:245\n72#1:246,3\n72#1:256,3\n74#1:259\n74#1:260,3\n75#1:263,2\n75#1:265,2\n76#1:267\n80#1:268,3\n75#1:271\n74#1:272\n94#1:274,2\n99#1:276\n94#1:277\n120#1:278\n120#1:279,3\n120#1:289,3\n126#1:296\n126#1:297\n126#1:298,2\n131#1:300\n126#1:301,3\n153#1:304\n153#1:305,3\n163#1:308\n168#1:309\n198#1:310\n198#1:311,2\n72#1:249,7\n120#1:282,7\n120#1:292\n120#1:293,3\n202#1:313,2\n*E\n"})
public final class TestsDurationBucketingUtils {
    @NotNull
    public static final TestsDurationBucketingUtils INSTANCE = new TestsDurationBucketingUtils();

    private TestsDurationBucketingUtils() {
    }

    @JvmStatic
    @NotNull
    public static final List<BucketFilter> calculateBucketFilters(@NotNull TestCaseLoader.TestClassesFilterArgs filter, @NotNull Set<String> classes) {
        Object[] objectArray;
        Object object;
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        Map classesDurations = new HashMap<String, Integer>(INSTANCE.loadDurationData(filter));
        int loadedSize = classesDurations.size();
        classesDurations.keySet().retainAll((Collection)classes);
        int relevantSize = classesDurations.size();
        Object[] objectArray2 = new Object[]{loadedSize, relevantSize};
        System.out.printf("Loaded tests duration for %d classes. Filtered out of scope ones, left with %d relevant classes%n", objectArray2);
        Set missing = new HashSet(classes);
        missing.removeAll(classesDurations.keySet());
        missing.remove("_FirstInSuiteTest");
        missing.remove("_LastInSuiteTest");
        missing = new TreeSet(missing);
        if (!((Collection)missing).isEmpty()) {
            object = new Object[]{missing.size()};
            System.out.printf("%d classes are in scope, but without duration info:%n", (Object[])object);
            for (String name : missing) {
                objectArray = new Object[]{name};
                System.out.printf("  %s%n", objectArray);
            }
        }
        if (TeamCityLogger.isUnderTC) {
            String string = "##teamcity[buildStatisticValue key='testDurationClasses.loaded' value='%d']";
            objectArray = new Object[]{loadedSize};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            object = string2;
            System.out.println(object);
            string = "##teamcity[buildStatisticValue key='testDurationClasses.relevant' value='%d']";
            objectArray = new Object[]{relevantSize};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            object = string3;
            System.out.println(object);
            string = "##teamcity[buildStatisticValue key='testDurationClasses.missing' value='%d']";
            objectArray = new Object[]{missing.size()};
            String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            object = string4;
            System.out.println(object);
        }
        if (classesDurations.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        return INSTANCE.getBucketFilter(classesDurations, TestCaseLoader.TEST_RUNNERS_COUNT, TestCaseLoader.TEST_RUNNER_INDEX);
    }

    /*
     * WARNING - void declaration
     */
    private final List<BucketFilter> getBucketFilter(Map<String, Integer> statistics, int bucketsCount, int currentBucketIndex) {
        PackageClassesGroup it;
        Map map;
        Object object;
        String $this$mapIndexedTo$iv$iv;
        int $i$f$getOrPut;
        Object $this$getOrPut$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Iterator list$iv$iv;
        Object it2;
        void $this$flatMapTo$iv$iv;
        if (!(bucketsCount > 0)) {
            boolean $i$a$-require-TestsDurationBucketingUtils$getBucketFilter$22 = false;
            String $i$a$-require-TestsDurationBucketingUtils$getBucketFilter$22 = "Total buckets count '" + bucketsCount + "' must be greater than zero";
            throw new IllegalArgumentException($i$a$-require-TestsDurationBucketingUtils$getBucketFilter$22.toString());
        }
        List<ItemsAndTotalTime<PackageClassesGroup>> buckets = this.createBucketsFromTestsStatistics(statistics, bucketsCount);
        Iterable $this$flatMap$iv = buckets;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it2 = (ItemsAndTotalTime)element$iv$iv;
            boolean bl = false;
            list$iv$iv = ((ItemsAndTotalTime)it2).getItems();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)((Object)list$iv$iv));
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            it2 = (PackageClassesGroup)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = ((PackageClassesGroup)it2).getPackageName();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            $i$f$getOrPut = 0;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Object groupsPerPackages = destination$iv$iv;
        Iterable $this$mapIndexed$iv = buckets;
        boolean $i$f$mapIndexed = false;
        destination$iv$iv = $this$mapIndexed$iv;
        Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo222 = false;
        int index$iv$iv = 0;
        list$iv$iv = $this$mapIndexedTo$iv$iv.iterator();
        while (list$iv$iv.hasNext()) {
            void index;
            void $this$associateTo$iv$iv;
            void bucket;
            int key$iv$iv;
            Object item$iv$iv = list$iv$iv.next();
            if ((key$iv$iv = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            $this$getOrPut$iv$iv$iv = (ItemsAndTotalTime)item$iv$iv;
            $i$f$getOrPut = key$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            Iterable $this$associate$iv = bucket.getItems();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            object = $this$associate$iv;
            Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                BucketClassFilter bucketClassFilter;
                map = destination$iv$iv3;
                it = (PackageClassesGroup)element$iv$iv;
                boolean bl3 = false;
                Iterable $this$sortedBy$iv = (Iterable)MapsKt.getValue((Map)groupsPerPackages, (Object)it.getPackageName());
                boolean $i$f$sortedBy2 = false;
                List packageGroups = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        PackageClassesGroup it = (PackageClassesGroup)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getGroupIndex());
                        it = (PackageClassesGroup)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getGroupIndex()));
                    }
                });
                if (packageGroups.size() == 1) {
                    bucketClassFilter = null;
                } else {
                    void $this$mapTo$iv;
                    Iterable $i$f$sortedBy2 = it.getClasses();
                    Collection destination$iv = new LinkedHashSet(it.getClasses().size());
                    boolean $i$f$mapTo = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        void it3;
                        Map.Entry entry = (Map.Entry)item$iv;
                        Collection collection2 = destination$iv;
                        boolean bl4 = false;
                        collection2.add((String)it3.getKey());
                    }
                    Set set = (Set)destination$iv;
                    bucketClassFilter = new BucketClassFilter(set);
                }
                BucketClassFilter bucketClassFilter2 = bucketClassFilter;
                it = new Pair((Object)it.getPackageName(), bucketClassFilter2);
                map.put(it.getFirst(), it.getSecond());
            }
            Map packageClassesForCurrentBucket = destination$iv$iv3;
            collection.add(new BucketFilter((int)index, packageClassesForCurrentBucket));
        }
        List filters = (List)destination$iv$iv2;
        destination$iv$iv2 = buckets;
        long $i$f$mapIndexedTo222 = 0L;
        list$iv$iv = destination$iv$iv2.iterator();
        while (list$iv$iv.hasNext()) {
            void it4;
            Object e = list$iv$iv.next();
            ItemsAndTotalTime key$iv$iv = (ItemsAndTotalTime)e;
            long l = $i$f$mapIndexedTo222;
            boolean bl = false;
            long l2 = Duration.getInWholeMilliseconds-impl((long)it4.getTotalTime-UwyO8pc());
            $i$f$mapIndexedTo222 = l + l2;
        }
        long averageTime = DurationKt.toDuration((long)($i$f$mapIndexedTo222 / (long)bucketsCount), (DurationUnit)DurationUnit.MILLISECONDS);
        System.out.println((Object)("*** Calculated bucket partitions, average bucket time is " + Duration.toString-impl((long)averageTime)));
        if (TeamCityLogger.isUnderTC) {
            destination$iv$iv2 = "##teamcity[buildStatisticValue key='buckets.averageMs' value='%d']";
            Object $i$f$mapIndexedTo222 = new Object[]{Duration.getInWholeMilliseconds-impl((long)averageTime)};
            String string = String.format((String)destination$iv$iv2, Arrays.copyOf($i$f$mapIndexedTo222, ((Object[])$i$f$mapIndexedTo222).length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            $this$mapIndexedTo$iv$iv = string;
            System.out.println((Object)$this$mapIndexedTo$iv$iv);
            ItemsAndTotalTime<PackageClassesGroup> bucket = buckets.get(currentBucketIndex);
            $i$f$mapIndexedTo222 = "##teamcity[buildStatisticValue key='buckets.currentMs' value='%d']";
            Object[] objectArray = new Object[]{Duration.getInWholeMilliseconds-impl((long)bucket.getTotalTime-UwyO8pc())};
            String string2 = String.format((String)$i$f$mapIndexedTo222, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            destination$iv$iv2 = string2;
            System.out.println(destination$iv$iv2);
        }
        Iterable $this$forEachIndexed$iv = filters;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void filter;
            int n;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            BucketFilter it4 = (BucketFilter)item$iv;
            int index = n2;
            boolean bl = false;
            ItemsAndTotalTime<PackageClassesGroup> bucket = buckets.get(index);
            String current = index == currentBucketIndex ? " (current)" : "";
            Object $i$f$associate = bucket.getItems();
            int n3 = bucket.getItems().size();
            object = Duration.toString-impl((long)bucket.getTotalTime-UwyO8pc());
            String string = current;
            int n4 = index + 1;
            int n5 = 0;
            Iterator iterator = $i$f$associate.iterator();
            while (iterator.hasNext()) {
                map = iterator.next();
                it = (PackageClassesGroup)((Object)map);
                n = n5;
                boolean bl5 = false;
                int n6 = it.getClasses().size();
                n5 = n + n6;
            }
            n = n5;
            $i$f$associate = "  Bucket " + n4 + string + ", total time: " + (String)object + ", total packages: " + n3 + ", total classes: " + n + ":";
            System.out.println($i$f$associate);
            Iterable $this$sortedBy$iv = filter.getPackageClasses().entrySet();
            boolean $i$f$sortedBy = false;
            System.out.println((Object)CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                    it = (Map.Entry)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
                }
            }), (CharSequence)"\n", null, null, (int)0, null, (Function1)getBucketFilter.2.3.INSTANCE, (int)30, null));
        }
        return filters;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ItemsAndTotalTime<PackageClassesGroup>> createBucketsFromTestsStatistics(Map<String, Integer> statistics, int bucketsCount) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object it;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Object list$iv$iv;
        Object key$iv$iv;
        Map.Entry it22;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv = statistics.entrySet();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it22 = (Map.Entry)element$iv$iv;
            boolean bl = false;
            key$iv$iv = INSTANCE.packageName(it22);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv2;
        destination$iv$iv = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo22 = false;
        Iterator<Object> iterator = $this$mapTo$iv$iv2.entrySet().iterator();
        while (iterator.hasNext()) {
            int n;
            Object item$iv$iv;
            list$iv$iv = item$iv$iv = (Map.Entry)iterator.next();
            Object object = destination$iv$iv;
            boolean bl = false;
            key$iv$iv = (Iterable)it22.getValue();
            Iterator iterator2 = (List)it22.getValue();
            int answer$iv$iv$iv = 0;
            Iterator iterator3 = key$iv$iv.iterator();
            while (iterator3.hasNext()) {
                void it3;
                Object t = iterator3.next();
                Map.Entry entry = (Map.Entry)t;
                n = answer$iv$iv$iv;
                boolean bl3 = false;
                int n2 = ((Number)it3.getValue()).intValue();
                answer$iv$iv$iv = n + n2;
            }
            n = answer$iv$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            long l = DurationKt.toDuration((int)n, (DurationUnit)DurationUnit.MILLISECONDS);
            List list = iterator2;
            object.add(new ItemsAndTotalTime(list, l, defaultConstructorMarker));
        }
        List partitionPerPackages = (List)destination$iv$iv;
        Iterable iterable2 = partitionPerPackages;
        long $i$f$mapTo22 = 0L;
        for (Map.Entry it22 : iterable2) {
            void it4;
            ItemsAndTotalTime bl = (ItemsAndTotalTime)((Object)it22);
            long l = $i$f$mapTo22;
            boolean bl4 = false;
            long l2 = Duration.getInWholeMilliseconds-impl((long)it4.getTotalTime-UwyO8pc());
            $i$f$mapTo22 = l + l2;
        }
        long averageTime = DurationKt.toDuration((long)($i$f$mapTo22 / (long)bucketsCount), (DurationUnit)DurationUnit.MILLISECONDS);
        long deltaTimeMax = Duration.times-UwyO8pc((long)averageTime, (double)0.1);
        Iterable $this$sortedBy$iv = partitionPerPackages;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ItemsAndTotalTime it = (ItemsAndTotalTime)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)TestsDurationBucketingUtils.access$packageName(TestsDurationBucketingUtils.INSTANCE, (Map.Entry)it.getItems().get(0)));
                it = (ItemsAndTotalTime)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)TestsDurationBucketingUtils.access$packageName(TestsDurationBucketingUtils.INSTANCE, (Map.Entry)it.getItems().get(0)))));
            }
        });
        boolean $i$f$flatMap = false;
        it22 = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            it = (ItemsAndTotalTime)element$iv$iv;
            boolean bl = false;
            if (Duration.compareTo-LRDsOJo((long)((ItemsAndTotalTime)it).getTotalTime-UwyO8pc(), (long)Duration.plus-LRDsOJo((long)averageTime, (long)deltaTimeMax)) < 0) {
                list = CollectionsKt.listOf((Object)new PackageClassesGroup(INSTANCE.packageName((Map.Entry)((ItemsAndTotalTime)it).getItems().get(0)), ((ItemsAndTotalTime)it).getItems(), ((ItemsAndTotalTime)it).getTotalTime-UwyO8pc(), 0, null));
            } else {
                List result2 = new ArrayList();
                Iterable $this$sortedBy$iv2 = ((ItemsAndTotalTime)it).getItems();
                boolean $i$f$sortedBy22 = false;
                List pendingClasses = CollectionsKt.toMutableList((Collection)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Map.Entry it = (Map.Entry)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                        it = (Map.Entry)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
                    }
                }));
                while (!((Collection)pendingClasses).isEmpty()) {
                    Object[] $i$f$sortedBy22 = new Map.Entry[]{CollectionsKt.removeFirst((List)pendingClasses)};
                    List group = CollectionsKt.mutableListOf((Object[])$i$f$sortedBy22);
                    Ref.LongRef groupTime = new Ref.LongRef();
                    groupTime.element = DurationKt.toDuration((int)((Number)((Map.Entry)group.get(0)).getValue()).intValue(), (DurationUnit)DurationUnit.MILLISECONDS);
                    pendingClasses.removeIf(arg_0 -> TestsDurationBucketingUtils.createBucketsFromTestsStatistics$lambda$18$lambda$17((Function1)new Function1<Map.Entry<? extends String, ? extends Integer>, Boolean>(groupTime, averageTime, deltaTimeMax, (List<Map.Entry<String, Integer>>)group){
                        final /* synthetic */ Ref.LongRef $groupTime;
                        final /* synthetic */ long $averageTime;
                        final /* synthetic */ long $deltaTimeMax;
                        final /* synthetic */ List<Map.Entry<String, Integer>> $group;
                        {
                            this.$groupTime = $groupTime;
                            this.$averageTime = $averageTime;
                            this.$deltaTimeMax = $deltaTimeMax;
                            this.$group = $group;
                            super(1);
                        }

                        /*
                         * Enabled aggressive block sorting
                         */
                        @NotNull
                        public final Boolean invoke(@NotNull Map.Entry<String, Integer> pending) {
                            boolean bl;
                            Intrinsics.checkNotNullParameter(pending, (String)"pending");
                            if (Duration.compareTo-LRDsOJo((long)this.$groupTime.element, (long)this.$averageTime) < 0) {
                                if (Duration.compareTo-LRDsOJo((long)Duration.plus-LRDsOJo((long)this.$groupTime.element, (long)DurationKt.toDuration((int)((Number)pending.getValue()).intValue(), (DurationUnit)DurationUnit.MILLISECONDS)), (long)Duration.plus-LRDsOJo((long)this.$averageTime, (long)this.$deltaTimeMax)) < 0) {
                                    this.$group.add(pending);
                                    this.$groupTime.element = Duration.plus-LRDsOJo((long)this.$groupTime.element, (long)DurationKt.toDuration((int)((Number)pending.getValue()).intValue(), (DurationUnit)DurationUnit.MILLISECONDS));
                                    bl = true;
                                    return bl;
                                }
                            }
                            bl = false;
                            return bl;
                        }
                    }, arg_0));
                    result2.add(new PackageClassesGroup(INSTANCE.packageName((Map.Entry)group.get(0)), group, groupTime.element, result2.size(), null));
                }
                list = result2;
            }
            Iterable list$iv$iv2 = list;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv2);
        }
        List partition2 = (List)destination$iv$iv2;
        $this$flatMap$iv = partition2;
        TestsDurationBucketingUtils testsDurationBucketingUtils = this;
        boolean $i$f$map2 = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (PackageClassesGroup)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(new Pair(it, (Object)Duration.box-impl((long)((PackageClassesGroup)it).getGroupTime-UwyO8pc())));
        }
        return testsDurationBucketingUtils.tossElementsIntoBuckets((List)destination$iv$iv2, bucketsCount);
    }

    private final <T> List<ItemsAndTotalTime<T>> tossElementsIntoBuckets(List<? extends Pair<? extends T, Duration>> elements, int binCount) {
        PriorityQueue<Object> queue2 = new PriorityQueue<Object>(binCount, Comparator.comparing(arg_0 -> TestsDurationBucketingUtils.tossElementsIntoBuckets$lambda$20(tossElementsIntoBuckets.queue.1.INSTANCE, arg_0)));
        for (int i2 = 0; i2 < binCount; ++i2) {
            queue2.add(new ItemsAndTotalTime(CollectionsKt.emptyList(), Duration.Companion.getZERO-UwyO8pc(), null));
        }
        Iterable $this$sortedByDescending$iv = elements;
        boolean $i$f$sortedByDescending = false;
        for (Pair element2 : CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)b;
                boolean bl = false;
                Comparable comparable = (Comparable)((Duration)it.getSecond());
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Duration)it.getSecond())));
            }
        })) {
            ItemsAndTotalTime smallestBin = (ItemsAndTotalTime)queue2.poll();
            queue2.add(new ItemsAndTotalTime(CollectionsKt.plus((Collection)smallestBin.getItems(), (Object)element2.getFirst()), Duration.plus-LRDsOJo((long)smallestBin.getTotalTime-UwyO8pc(), (long)((Duration)element2.getSecond()).unbox-impl()), null));
        }
        Iterable $this$sortedBy$iv = queue2;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ItemsAndTotalTime it = (ItemsAndTotalTime)a;
                boolean bl = false;
                Comparable comparable = (Comparable)Duration.box-impl((long)it.getTotalTime-UwyO8pc());
                it = (ItemsAndTotalTime)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)Duration.box-impl((long)it.getTotalTime-UwyO8pc())));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Map<String, Integer> loadDurationData(TestCaseLoader.TestClassesFilterArgs filter) {
        List<String> groupsToLoad = this.getGroupsToLoad(filter);
        HashMap result2 = new HashMap();
        Object object = new String[]{System.getenv("JPS_PROJECT_HOME"), System.getenv("JPS_BOOTSTRAP_COMMUNITY_HOME"), System.getProperty("idea.home.path"), System.getProperty("user.dir")};
        Sequence directories2 = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)SetsKt.setOfNotNull((Object[])object)), (Function1)loadDurationData.directories.1.INSTANCE), (Function1)loadDurationData.directories.2.INSTANCE), (Function1)loadDurationData.directories.3.INSTANCE), (Function1)loadDurationData.directories.4.INSTANCE);
        if ((object = directories2.iterator()).hasNext()) {
            Path directory = (Path)object.next();
            try {
                Path $this$filterTo$iv$iv;
                void $this$filter$iv;
                Intrinsics.checkNotNull((Object)directory);
                Iterable iterable = PathsKt.listDirectoryEntries((Path)directory, (String)"*.csv");
                boolean $i$f$filter = false;
                void var10_10 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Path it = (Path)element$iv$iv;
                    boolean bl = false;
                    if (!(groupsToLoad == null || groupsToLoad.contains(PathsKt.getNameWithoutExtension((Path)it)))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List files = (List)destination$iv$iv;
                for (Path path : files) {
                    try {
                        $this$filterTo$iv$iv = path;
                        Charset charset = StandardCharsets.UTF_8;
                        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                        Closeable closeable = Files.newBufferedReader($this$filterTo$iv$iv, charset);
                        Object object2 = null;
                        try {
                            BufferedReader bufferedReader = (BufferedReader)closeable;
                            Intrinsics.checkNotNull((Object)bufferedReader);
                            Sequence lines2 = TextStreamsKt.lineSequence((BufferedReader)bufferedReader);
                            boolean bl = false;
                            Sequence $this$forEach$iv = lines2;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                String line = (String)element$iv;
                                boolean bl2 = false;
                                char[] cArray = new char[]{','};
                                List split = StringsKt.split$default((CharSequence)line, (char[])cArray, (boolean)false, (int)3, (int)2, null);
                                if (split.size() != 2) continue;
                                String name = (String)split.get(0);
                                int duration = Integer.parseInt((String)split.get(1));
                                Integer n = duration;
                                ((Map)result2).put(name, n);
                            }
                            bufferedReader = Unit.INSTANCE;
                        }
                        catch (Throwable throwable) {
                            try {
                                object2 = throwable;
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                CloseableKt.closeFinally((Closeable)closeable, object2);
                                throw throwable2;
                            }
                        }
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
                    }
                    catch (Exception e) {
                        System.err.println("Failed to load test classes duration from '" + path + "': " + e.getMessage());
                    }
                }
            }
            catch (IOException e) {
                System.err.println("Failed to load test classes duration from files in '" + directory + "': " + e.getMessage());
            }
            return result2;
        }
        return result2;
    }

    private final List<String> getGroupsToLoad(TestCaseLoader.TestClassesFilterArgs filter) {
        CharSequence charSequence = filter.patterns();
        if (!(charSequence == null || charSequence.length() == 0)) {
            return null;
        }
        List<String> testGroupNames = filter.testGroupNames();
        if (testGroupNames == null) {
            return null;
        }
        if (testGroupNames.contains("ALL")) {
            return null;
        }
        if (testGroupNames.contains("ALL_EXCLUDE_DEFINED")) {
            return null;
        }
        return testGroupNames;
    }

    private final <V> String packageName(Map.Entry<String, ? extends V> $this$packageName) {
        return StringsKt.substringBeforeLast((String)$this$packageName.getKey(), (char)'.', (String)"");
    }

    private static final boolean createBucketsFromTestsStatistics$lambda$18$lambda$17(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Duration tossElementsIntoBuckets$lambda$20(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Duration)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$packageName(TestsDurationBucketingUtils $this, Map.Entry $receiver) {
        return $this.packageName($receiver);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/testFramework/bucketing/TestsDurationBucketingUtils$BucketClassFilter;", "", "classes", "", "", "(Ljava/util/Set;)V", "getClasses", "()Ljava/util/Set;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.testFramework.core"})
    public static final class BucketClassFilter {
        @NotNull
        private final Set<String> classes;

        public BucketClassFilter(@NotNull Set<String> classes) {
            Intrinsics.checkNotNullParameter(classes, (String)"classes");
            this.classes = classes;
        }

        @NotNull
        public final Set<String> getClasses() {
            return this.classes;
        }

        @NotNull
        public final Set<String> component1() {
            return this.classes;
        }

        @NotNull
        public final BucketClassFilter copy(@NotNull Set<String> classes) {
            Intrinsics.checkNotNullParameter(classes, (String)"classes");
            return new BucketClassFilter(classes);
        }

        public static /* synthetic */ BucketClassFilter copy$default(BucketClassFilter bucketClassFilter, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                set = bucketClassFilter.classes;
            }
            return bucketClassFilter.copy(set);
        }

        @NotNull
        public String toString() {
            return "BucketClassFilter(classes=" + this.classes + ")";
        }

        public int hashCode() {
            return ((Object)this.classes).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BucketClassFilter)) {
                return false;
            }
            BucketClassFilter bucketClassFilter = (BucketClassFilter)other;
            return Intrinsics.areEqual(this.classes, bucketClassFilter.classes);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0017\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u00c6\u0003J+\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/intellij/testFramework/bucketing/TestsDurationBucketingUtils$BucketFilter;", "", "index", "", "packageClasses", "", "", "Lcom/intellij/testFramework/bucketing/TestsDurationBucketingUtils$BucketClassFilter;", "(ILjava/util/Map;)V", "getIndex", "()I", "getPackageClasses", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "intellij.platform.testFramework.core"})
    public static final class BucketFilter {
        private final int index;
        @NotNull
        private final Map<String, BucketClassFilter> packageClasses;

        public BucketFilter(int index, @NotNull Map<String, BucketClassFilter> packageClasses) {
            Intrinsics.checkNotNullParameter(packageClasses, (String)"packageClasses");
            this.index = index;
            this.packageClasses = packageClasses;
        }

        public final int getIndex() {
            return this.index;
        }

        @NotNull
        public final Map<String, BucketClassFilter> getPackageClasses() {
            return this.packageClasses;
        }

        public final int component1() {
            return this.index;
        }

        @NotNull
        public final Map<String, BucketClassFilter> component2() {
            return this.packageClasses;
        }

        @NotNull
        public final BucketFilter copy(int index, @NotNull Map<String, BucketClassFilter> packageClasses) {
            Intrinsics.checkNotNullParameter(packageClasses, (String)"packageClasses");
            return new BucketFilter(index, packageClasses);
        }

        public static /* synthetic */ BucketFilter copy$default(BucketFilter bucketFilter, int n, Map map, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = bucketFilter.index;
            }
            if ((n2 & 2) != 0) {
                map = bucketFilter.packageClasses;
            }
            return bucketFilter.copy(n, map);
        }

        @NotNull
        public String toString() {
            return "BucketFilter(index=" + this.index + ", packageClasses=" + this.packageClasses + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.index);
            result2 = result2 * 31 + ((Object)this.packageClasses).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BucketFilter)) {
                return false;
            }
            BucketFilter bucketFilter = (BucketFilter)other;
            if (this.index != bucketFilter.index) {
                return false;
            }
            return Intrinsics.areEqual(this.packageClasses, bucketFilter.packageClasses);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0003J\u0016\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000f\u0010\u000bJ3\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\u0005\u001a\u00020\u0006\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001a"}, d2={"Lcom/intellij/testFramework/bucketing/TestsDurationBucketingUtils$ItemsAndTotalTime;", "T", "", "items", "", "totalTime", "Lkotlin/time/Duration;", "(Ljava/util/List;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getItems", "()Ljava/util/List;", "getTotalTime-UwyO8pc", "()J", "J", "component1", "component2", "component2-UwyO8pc", "copy", "copy-HG0u8IE", "(Ljava/util/List;J)Lcom/intellij/testFramework/bucketing/TestsDurationBucketingUtils$ItemsAndTotalTime;", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.testFramework.core"})
    private static final class ItemsAndTotalTime<T> {
        @NotNull
        private final List<T> items;
        private final long totalTime;

        private ItemsAndTotalTime(List<? extends T> items, long totalTime) {
            Intrinsics.checkNotNullParameter(items, (String)"items");
            this.items = items;
            this.totalTime = totalTime;
        }

        @NotNull
        public final List<T> getItems() {
            return this.items;
        }

        public final long getTotalTime-UwyO8pc() {
            return this.totalTime;
        }

        @NotNull
        public final List<T> component1() {
            return this.items;
        }

        public final long component2-UwyO8pc() {
            return this.totalTime;
        }

        @NotNull
        public final ItemsAndTotalTime<T> copy-HG0u8IE(@NotNull List<? extends T> items, long totalTime) {
            Intrinsics.checkNotNullParameter(items, (String)"items");
            return new ItemsAndTotalTime<T>(items, totalTime, null);
        }

        public static /* synthetic */ ItemsAndTotalTime copy-HG0u8IE$default(ItemsAndTotalTime itemsAndTotalTime, List list, long l, int n, Object object) {
            if ((n & 1) != 0) {
                list = itemsAndTotalTime.items;
            }
            if ((n & 2) != 0) {
                l = itemsAndTotalTime.totalTime;
            }
            return itemsAndTotalTime.copy-HG0u8IE(list, l);
        }

        @NotNull
        public String toString() {
            return "ItemsAndTotalTime(items=" + this.items + ", totalTime=" + Duration.toString-impl((long)this.totalTime) + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.items).hashCode();
            result2 = result2 * 31 + Duration.hashCode-impl((long)this.totalTime);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ItemsAndTotalTime)) {
                return false;
            }
            ItemsAndTotalTime itemsAndTotalTime = (ItemsAndTotalTime)other;
            if (!Intrinsics.areEqual(this.items, itemsAndTotalTime.items)) {
                return false;
            }
            return Duration.equals-impl0((long)this.totalTime, (long)itemsAndTotalTime.totalTime);
        }

        public /* synthetic */ ItemsAndTotalTime(List items, long totalTime, DefaultConstructorMarker $constructor_marker) {
            this(items, totalTime);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010&\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u001b\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u00060\u0005H\u00c6\u0003J\u0016\u0010\u0017\u001a\u00020\tH\u00c6\u0003\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0011J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003JM\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u001a\b\u0002\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u00060\u00052\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0007H\u00c6\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020\u0007H\u00d6\u0001J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001R#\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\b\u001a\u00020\t\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\""}, d2={"Lcom/intellij/testFramework/bucketing/TestsDurationBucketingUtils$PackageClassesGroup;", "", "packageName", "", "classes", "", "", "", "groupTime", "Lkotlin/time/Duration;", "groupIndex", "(Ljava/lang/String;Ljava/util/List;JILkotlin/jvm/internal/DefaultConstructorMarker;)V", "getClasses", "()Ljava/util/List;", "getGroupIndex", "()I", "getGroupTime-UwyO8pc", "()J", "J", "getPackageName", "()Ljava/lang/String;", "component1", "component2", "component3", "component3-UwyO8pc", "component4", "copy", "copy-exY8QGI", "(Ljava/lang/String;Ljava/util/List;JI)Lcom/intellij/testFramework/bucketing/TestsDurationBucketingUtils$PackageClassesGroup;", "equals", "", "other", "hashCode", "toString", "intellij.platform.testFramework.core"})
    private static final class PackageClassesGroup {
        @NotNull
        private final String packageName;
        @NotNull
        private final List<Map.Entry<String, Integer>> classes;
        private final long groupTime;
        private final int groupIndex;

        private PackageClassesGroup(String packageName, List<? extends Map.Entry<String, Integer>> classes, long groupTime, int groupIndex) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter(classes, (String)"classes");
            this.packageName = packageName;
            this.classes = classes;
            this.groupTime = groupTime;
            this.groupIndex = groupIndex;
        }

        @NotNull
        public final String getPackageName() {
            return this.packageName;
        }

        @NotNull
        public final List<Map.Entry<String, Integer>> getClasses() {
            return this.classes;
        }

        public final long getGroupTime-UwyO8pc() {
            return this.groupTime;
        }

        public final int getGroupIndex() {
            return this.groupIndex;
        }

        @NotNull
        public final String component1() {
            return this.packageName;
        }

        @NotNull
        public final List<Map.Entry<String, Integer>> component2() {
            return this.classes;
        }

        public final long component3-UwyO8pc() {
            return this.groupTime;
        }

        public final int component4() {
            return this.groupIndex;
        }

        @NotNull
        public final PackageClassesGroup copy-exY8QGI(@NotNull String packageName, @NotNull List<? extends Map.Entry<String, Integer>> classes, long groupTime, int groupIndex) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter(classes, (String)"classes");
            return new PackageClassesGroup(packageName, classes, groupTime, groupIndex, null);
        }

        public static /* synthetic */ PackageClassesGroup copy-exY8QGI$default(PackageClassesGroup packageClassesGroup, String string, List list, long l, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = packageClassesGroup.packageName;
            }
            if ((n2 & 2) != 0) {
                list = packageClassesGroup.classes;
            }
            if ((n2 & 4) != 0) {
                l = packageClassesGroup.groupTime;
            }
            if ((n2 & 8) != 0) {
                n = packageClassesGroup.groupIndex;
            }
            return packageClassesGroup.copy-exY8QGI(string, list, l, n);
        }

        @NotNull
        public String toString() {
            return "PackageClassesGroup(packageName=" + this.packageName + ", classes=" + this.classes + ", groupTime=" + Duration.toString-impl((long)this.groupTime) + ", groupIndex=" + this.groupIndex + ")";
        }

        public int hashCode() {
            int result2 = this.packageName.hashCode();
            result2 = result2 * 31 + ((Object)this.classes).hashCode();
            result2 = result2 * 31 + Duration.hashCode-impl((long)this.groupTime);
            result2 = result2 * 31 + Integer.hashCode(this.groupIndex);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PackageClassesGroup)) {
                return false;
            }
            PackageClassesGroup packageClassesGroup = (PackageClassesGroup)other;
            if (!Intrinsics.areEqual((Object)this.packageName, (Object)packageClassesGroup.packageName)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.classes, packageClassesGroup.classes)) {
                return false;
            }
            if (!Duration.equals-impl0((long)this.groupTime, (long)packageClassesGroup.groupTime)) {
                return false;
            }
            return this.groupIndex == packageClassesGroup.groupIndex;
        }

        public /* synthetic */ PackageClassesGroup(String packageName, List classes, long groupTime, int groupIndex, DefaultConstructorMarker $constructor_marker) {
            this(packageName, classes, groupTime, groupIndex);
        }
    }
}

