/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.concurrency.ThreadContext;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.Location;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateManagerImpl;
import com.intellij.ide.projectView.impl.nodes.ExternalLibrariesNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.model.psi.PsiSymbolReferenceService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PerformWithDocumentsCommitted;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.paths.UrlReference;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.platform.testFramework.core.FileComparisonFailedError;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.testFramework.CpuUsageData;
import com.intellij.testFramework.HeavyTestHelper;
import com.intellij.testFramework.IndexingTestUtil;
import com.intellij.testFramework.MapDataContext;
import com.intellij.testFramework.OpenProjectTaskBuilder;
import com.intellij.testFramework.OpenProjectTaskBuilderKt;
import com.intellij.testFramework.PerformanceTestInfo;
import com.intellij.testFramework.PerformanceTestInfoLoader;
import com.intellij.testFramework.TeamCityLogger;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.common.TestApplicationKt;
import com.intellij.testFramework.fixtures.IdeaTestExecutionPolicy;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.Decompressor;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.InvocationEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import junit.framework.AssertionFailedError;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.junit.Assert;
import org.junit.AssumptionViolatedException;

public final class PlatformTestUtil {
    private static final Logger LOG = Logger.getInstance(PlatformTestUtil.class);
    public static final boolean COVERAGE_ENABLED_BUILD = "true".equals(System.getProperty("idea.coverage.enabled.build"));
    private static final List<Runnable> ourProjectCleanups = new CopyOnWriteArrayList<Runnable>();
    private static final long MAX_WAIT_TIME = TimeUnit.MINUTES.toMillis(2L);

    @NotNull
    public static String getTestName(@NotNull String name, boolean lowercaseFirstLetter) {
        if (name == null) {
            PlatformTestUtil.$$$reportNull$$$0(0);
        }
        return StringUtil.isEmpty((String)(name = StringUtil.trimStart((String)name, (String)"test"))) ? "" : PlatformTestUtil.lowercaseFirstLetter(name, lowercaseFirstLetter);
    }

    @NotNull
    public static String lowercaseFirstLetter(@NotNull String name, boolean lowercaseFirstLetter) {
        if (name == null) {
            PlatformTestUtil.$$$reportNull$$$0(1);
        }
        if (lowercaseFirstLetter && !PlatformTestUtil.isAllUppercaseName((String)name)) {
            name = Character.toLowerCase(((String)name).charAt(0)) + ((String)name).substring(1);
        }
        String string = name;
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static boolean isAllUppercaseName(@NotNull String name) {
        if (name == null) {
            PlatformTestUtil.$$$reportNull$$$0(3);
        }
        int uppercaseChars = 0;
        for (int i2 = 0; i2 < name.length(); ++i2) {
            if (Character.isLowerCase(name.charAt(i2))) {
                return false;
            }
            if (!Character.isUpperCase(name.charAt(i2))) continue;
            ++uppercaseChars;
        }
        return uppercaseChars >= 3;
    }

    @Deprecated
    static void loadApp(@NotNull Runnable setupEventQueue) {
        if (setupEventQueue == null) {
            PlatformTestUtil.$$$reportNull$$$0(4);
        }
        TestApplicationKt.loadApp(setupEventQueue);
    }

    public static <T> void maskExtensions(@NotNull ProjectExtensionPointName<T> pointName, @NotNull Project project2, @NotNull List<? extends T> newExtensions, @NotNull Disposable parentDisposable) {
        if (pointName == null) {
            PlatformTestUtil.$$$reportNull$$$0(5);
        }
        if (project2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(6);
        }
        if (newExtensions == null) {
            PlatformTestUtil.$$$reportNull$$$0(7);
        }
        if (parentDisposable == null) {
            PlatformTestUtil.$$$reportNull$$$0(8);
        }
        ((ExtensionPointImpl)pointName.getPoint((AreaInstance)project2)).maskAll(newExtensions, parentDisposable, true);
    }

    @Nullable
    public static String toString(@Nullable Object node2, @Nullable Queryable.PrintInfo printInfo) {
        if (node2 instanceof AbstractTreeNode) {
            if (printInfo != null) {
                return ((AbstractTreeNode)node2).toTestString(printInfo);
            }
            return ((AbstractTreeNode)node2).getTestPresentation();
        }
        return String.valueOf(node2);
    }

    @NotNull
    public static String print(@NotNull JTree tree, boolean withSelection) {
        if (tree == null) {
            PlatformTestUtil.$$$reportNull$$$0(9);
        }
        String string = PlatformTestUtil.print(tree, new TreePath(tree.getModel().getRoot()), withSelection, null, null);
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static String print(@NotNull JTree tree, @NotNull TreePath path, @Nullable Queryable.PrintInfo printInfo, boolean withSelection) {
        if (tree == null) {
            PlatformTestUtil.$$$reportNull$$$0(11);
        }
        if (path == null) {
            PlatformTestUtil.$$$reportNull$$$0(12);
        }
        String string = PlatformTestUtil.print(tree, path, withSelection, printInfo, null);
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public static String print(@NotNull JTree tree, boolean withSelection, @Nullable Predicate<? super String> nodePrintCondition) {
        if (tree == null) {
            PlatformTestUtil.$$$reportNull$$$0(14);
        }
        String string = PlatformTestUtil.print(tree, new TreePath(tree.getModel().getRoot()), withSelection, null, nodePrintCondition);
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static String print(JTree tree, TreePath path, boolean withSelection, @Nullable Queryable.PrintInfo printInfo, @Nullable Predicate<? super String> nodePrintCondition) {
        ArrayList strings = new ArrayList();
        PlatformTestUtil.printImpl(tree, path, strings, 0, withSelection, printInfo, nodePrintCondition);
        return String.join((CharSequence)"\n", strings);
    }

    private static void printImpl(JTree tree, TreePath path, Collection<? super String> strings, int level, boolean withSelection, @Nullable Queryable.PrintInfo printInfo, @Nullable Predicate<? super String> nodePrintCondition) {
        Object pathComponent = path.getLastPathComponent();
        Object userObject = TreeUtil.getUserObject((Object)pathComponent);
        String nodeText = PlatformTestUtil.toString(userObject, printInfo);
        if (nodePrintCondition != null && !nodePrintCondition.test(nodeText)) {
            return;
        }
        StringBuilder buff = new StringBuilder();
        StringUtil.repeatSymbol((Appendable)buff, (char)' ', (int)level);
        boolean expanded = tree.isExpanded(path);
        int childCount = tree.getModel().getChildCount(pathComponent);
        if (childCount > 0) {
            buff.append(expanded ? (char)'-' : '+');
        }
        boolean selected = tree.getSelectionModel().isPathSelected(path);
        if (withSelection && selected) {
            buff.append('[');
        }
        buff.append(nodeText);
        if (withSelection && selected) {
            buff.append(']');
        }
        strings.add(buff.toString());
        if (expanded) {
            for (int i2 = 0; i2 < childCount; ++i2) {
                TreePath childPath = path.pathByAddingChild(tree.getModel().getChild(pathComponent, i2));
                PlatformTestUtil.printImpl(tree, childPath, strings, level + 1, withSelection, printInfo, nodePrintCondition);
            }
        }
    }

    public static void assertTreeEqual(@NotNull JTree tree, @NonNls String expected) {
        if (tree == null) {
            PlatformTestUtil.$$$reportNull$$$0(16);
        }
        PlatformTestUtil.assertTreeEqual(tree, expected, false);
    }

    public static void assertTreeEqual(@NotNull JTree tree, String expected, boolean checkSelected) {
        if (tree == null) {
            PlatformTestUtil.$$$reportNull$$$0(17);
        }
        PlatformTestUtil.assertTreeEqual(tree, expected, checkSelected, false);
    }

    public static void assertTreeEqual(@NotNull JTree tree, @NotNull String expected, boolean checkSelected, boolean ignoreOrder) {
        if (tree == null) {
            PlatformTestUtil.$$$reportNull$$$0(18);
        }
        if (expected == null) {
            PlatformTestUtil.$$$reportNull$$$0(19);
        }
        String treeStringPresentation = PlatformTestUtil.print(tree, checkSelected);
        if (ignoreOrder) {
            List actualLines = ContainerUtil.sorted((Collection)ContainerUtil.map((Object[])StringUtil.splitByLines((String)treeStringPresentation), String::trim));
            List expectedLines = ContainerUtil.sorted((Collection)ContainerUtil.map((Object[])StringUtil.splitByLines((String)expected), String::trim));
            Assert.assertEquals((String)("Expected:\n" + expected + "\nActual:\n" + treeStringPresentation), (Object)expectedLines, (Object)actualLines);
        } else {
            UsefulTestCase.assertSameLines(expected.trim(), treeStringPresentation.trim());
        }
    }

    public static void expand(@NotNull JTree tree, int ... rows) {
        if (tree == null) {
            PlatformTestUtil.$$$reportNull$$$0(20);
        }
        if (rows == null) {
            PlatformTestUtil.$$$reportNull$$$0(21);
        }
        for (int row : rows) {
            tree.expandRow(row);
            PlatformTestUtil.waitWhileBusy(tree);
        }
    }

    public static void expandAll(@NotNull JTree tree) {
        if (tree == null) {
            PlatformTestUtil.$$$reportNull$$$0(22);
        }
        PlatformTestUtil.expandAll(tree, path -> !(TreeUtil.getLastUserObject((TreePath)path) instanceof ExternalLibrariesNode));
    }

    public static void expandAll(@NotNull JTree tree, @NotNull @NotNull Predicate<@NotNull TreePath> predicate) {
        if (tree == null) {
            PlatformTestUtil.$$$reportNull$$$0(23);
        }
        if (predicate == null) {
            PlatformTestUtil.$$$reportNull$$$0(24);
        }
        PlatformTestUtil.waitForPromise(TreeUtil.promiseExpand((JTree)tree, (int)Integer.MAX_VALUE, predicate));
    }

    private static long getMillisSince(long startTimeMillis) {
        return System.currentTimeMillis() - startTimeMillis;
    }

    private static void assertMaxWaitTimeSince(long startTimeMillis) {
        PlatformTestUtil.assertMaxWaitTimeSince(startTimeMillis, MAX_WAIT_TIME);
    }

    private static void assertMaxWaitTimeSince(long startTimeMillis, long timeout) {
        long took = PlatformTestUtil.getMillisSince(startTimeMillis);
        if (took > timeout) assert (false) : String.format("the waiting takes too long. Expected to take no more than: %d ms but took: %d ms\nThread dump: %s", timeout, took, ThreadDumper.dumpThreadsToString());
    }

    private static void assertDispatchThreadWithoutWriteAccess() {
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            PlatformTestUtil.assertEventQueueDispatchThread();
        } else {
            assert (!application.isWriteAccessAllowed()) : "do not wait under write action to avoid possible deadlock";
            ThreadingAssertions.assertEventDispatchThread();
        }
    }

    private static void assertEventQueueDispatchThread() {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("Must be called from EDT but got: " + Thread.currentThread());
        }
    }

    private static boolean isBusy(@NotNull JTree tree, TreeModel model2) {
        if (tree == null) {
            PlatformTestUtil.$$$reportNull$$$0(25);
        }
        UIUtil.dispatchAllInvocationEvents();
        if (ClientProperty.isTrue((Component)tree, (Object)TreeUtil.TREE_IS_BUSY)) {
            return true;
        }
        if (model2 instanceof AsyncTreeModel) {
            AsyncTreeModel async = (AsyncTreeModel)model2;
            if (async.isProcessing()) {
                return true;
            }
            UIUtil.dispatchAllInvocationEvents();
            return async.isProcessing();
        }
        return false;
    }

    public static void waitWhileBusy(@NotNull JTree tree) {
        if (tree == null) {
            PlatformTestUtil.$$$reportNull$$$0(26);
        }
        PlatformTestUtil.waitWhileBusy(() -> PlatformTestUtil.isBusy(tree, tree.getModel()));
    }

    public static void waitWhileBusy(@NotNull Supplier<Boolean> busyCondition) {
        if (busyCondition == null) {
            PlatformTestUtil.$$$reportNull$$$0(27);
        }
        PlatformTestUtil.assertDispatchThreadWithoutWriteAccess();
        long startTimeMillis = System.currentTimeMillis();
        while (busyCondition.get().booleanValue()) {
            PlatformTestUtil.assertMaxWaitTimeSince(startTimeMillis);
            TimeoutUtil.sleep((long)5L);
            UIUtil.dispatchAllInvocationEvents();
        }
    }

    public static void waitForCallback(@NotNull ActionCallback callback) {
        if (callback == null) {
            PlatformTestUtil.$$$reportNull$$$0(28);
        }
        AsyncPromise promise = new AsyncPromise();
        callback.doWhenDone(() -> promise.setResult(null)).doWhenRejected(() -> ((AsyncPromise)promise).cancel());
        PlatformTestUtil.waitForPromise(promise);
    }

    @Nullable
    public static <T> T waitForPromise(@NotNull Promise<T> promise) {
        if (promise == null) {
            PlatformTestUtil.$$$reportNull$$$0(29);
        }
        return PlatformTestUtil.waitForPromise(promise, MAX_WAIT_TIME, false);
    }

    @Nullable
    public static <T> T waitForPromise(@NotNull Promise<T> promise, long timeout) {
        if (promise == null) {
            PlatformTestUtil.$$$reportNull$$$0(30);
        }
        return PlatformTestUtil.waitForPromise(promise, timeout, false);
    }

    @Nullable
    public static <T> T assertPromiseSucceeds(@NotNull Promise<T> promise) {
        if (promise == null) {
            PlatformTestUtil.$$$reportNull$$$0(31);
        }
        return PlatformTestUtil.waitForPromise(promise, MAX_WAIT_TIME, true);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static <T> T waitForPromise(@NotNull Promise<T> promise, long timeout, boolean bl) {
        if (promise == null) {
            PlatformTestUtil.$$$reportNull$$$0(32);
        }
        PlatformTestUtil.assertDispatchThreadWithoutWriteAccess();
        long start = System.currentTimeMillis();
        while (true) {
            if (promise.getState() == Promise.State.PENDING) {
                UIUtil.dispatchAllInvocationEvents();
            }
            try {
                return (T)promise.blockingGet(20, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
            }
            catch (Exception e) {
                void assertSucceeded;
                if (assertSucceeded != false) {
                    throw new AssertionError((Object)e);
                }
                return null;
            }
            PlatformTestUtil.assertMaxWaitTimeSince(start, timeout);
        }
    }

    public static <T> T waitForFuture(@NotNull Future<T> future) {
        if (future == null) {
            PlatformTestUtil.$$$reportNull$$$0(33);
        }
        return PlatformTestUtil.waitForFuture(future, MAX_WAIT_TIME);
    }

    public static <T> T waitForFuture(@NotNull Future<T> future, long timeoutMillis) {
        if (future == null) {
            PlatformTestUtil.$$$reportNull$$$0(34);
        }
        PlatformTestUtil.assertDispatchThreadWithoutWriteAccess();
        long start = System.currentTimeMillis();
        while (true) {
            if (!future.isDone()) {
                UIUtil.dispatchAllInvocationEvents();
            }
            try {
                return future.get(10L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
            PlatformTestUtil.assertMaxWaitTimeSince(start, timeoutMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForAlarm(int delay2) {
        @NotNull Application app = ApplicationManager.getApplication();
        PlatformTestUtil.assertDispatchThreadWithoutWriteAccess();
        Disposable tempDisposable = Disposer.newDisposable();
        AtomicBoolean runnableInvoked = new AtomicBoolean();
        AtomicBoolean pooledRunnableInvoked = new AtomicBoolean();
        AtomicBoolean alarmInvoked1 = new AtomicBoolean();
        AtomicBoolean alarmInvoked2 = new AtomicBoolean();
        Alarm alarm = new Alarm();
        Alarm pooledAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, tempDisposable);
        ModalityState initialModality = ModalityState.current();
        alarm.addRequest(() -> {
            alarmInvoked1.set(true);
            app.invokeLater(() -> {
                runnableInvoked.set(true);
                alarm.addRequest(() -> alarmInvoked2.set(true), delay2);
            });
        }, delay2);
        pooledAlarm.addRequest(() -> pooledRunnableInvoked.set(true), delay2);
        UIUtil.dispatchAllInvocationEvents();
        long start = System.currentTimeMillis();
        try {
            boolean sleptAlready = false;
            while (!alarmInvoked2.get()) {
                AtomicBoolean laterInvoked = new AtomicBoolean();
                app.invokeLater(() -> laterInvoked.set(true));
                UIUtil.dispatchAllInvocationEvents();
                Assert.assertTrue((boolean)laterInvoked.get());
                TimeoutUtil.sleep((long)(sleptAlready ? 10L : (long)delay2));
                sleptAlready = true;
                if (PlatformTestUtil.getMillisSince(start) <= MAX_WAIT_TIME) continue;
                String queue2 = ((AppScheduledExecutorService)AppExecutorUtil.getAppScheduledExecutorService()).dumpQueue();
                throw new AssertionError((Object)("Couldn't await alarm; alarm passed=" + alarmInvoked1.get() + "; modality1=" + initialModality + "; modality2=" + ModalityState.current() + "; non-modal=" + (initialModality == ModalityState.nonModal()) + "; invokeLater passed=" + runnableInvoked.get() + "; pooled alarm passed=" + pooledRunnableInvoked.get() + "; app.disposed=" + app.isDisposed() + "; alarm.disposed=" + alarm.isDisposed() + "; alarm.requests=" + alarm.getActiveRequestCount() + "\n delayQueue=" + StringUtil.trimLog((String)queue2, (int)1000) + "\n invocatorEdtQueue=" + LaterInvocator.getLaterInvocatorEdtQueue()));
            }
        }
        finally {
            Disposer.dispose((Disposable)tempDisposable);
        }
        UIUtil.dispatchAllInvocationEvents();
    }

    public static void dispatchAllInvocationEventsInIdeEventQueue() {
        PlatformTestUtil.assertDispatchThreadWithoutWriteAccess();
        IdeEventQueue eventQueue = IdeEventQueue.getInstance();
        try (AccessToken ignored = ThreadContext.resetThreadContext();){
            AWTEvent event;
            while ((event = eventQueue.peekEvent()) != null) {
                event = eventQueue.getNextEvent();
                if (!(event instanceof InvocationEvent)) continue;
                eventQueue.dispatchEvent(event);
            }
        }
    }

    public static void dispatchAllEventsInIdeEventQueue() {
        PlatformTestUtil.assertEventQueueDispatchThread();
        try {
            while (PlatformTestUtil.dispatchNextEventIfAny() != null) {
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static AWTEvent dispatchNextEventIfAny() throws InterruptedException {
        try (AccessToken ignored = ThreadContext.resetThreadContext();){
            PlatformTestUtil.assertEventQueueDispatchThread();
            IdeEventQueue eventQueue = IdeEventQueue.getInstance();
            AWTEvent event = eventQueue.peekEvent();
            if (event == null) {
                AWTEvent aWTEvent = null;
                return aWTEvent;
            }
            AWTEvent event1 = eventQueue.getNextEvent();
            eventQueue.dispatchEvent(event1);
            AWTEvent aWTEvent = event1;
            return aWTEvent;
        }
    }

    @NotNull
    public static StringBuilder print(@NotNull AbstractTreeStructure structure, @NotNull Object node2, int currentLevel, @Nullable Comparator<?> comparator, int maxRowCount, char paddingChar, @Nullable Queryable.PrintInfo printInfo) {
        if (structure == null) {
            PlatformTestUtil.$$$reportNull$$$0(35);
        }
        if (node2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(36);
        }
        return PlatformTestUtil.print(structure, node2, currentLevel, comparator, maxRowCount, paddingChar, (Object o) -> PlatformTestUtil.toString(o, printInfo));
    }

    @NotNull
    public static String print(@NotNull AbstractTreeStructure structure, @NotNull Object node2, @NotNull Function<Object, String> nodePresenter) {
        if (structure == null) {
            PlatformTestUtil.$$$reportNull$$$0(37);
        }
        if (node2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(38);
        }
        if (nodePresenter == null) {
            PlatformTestUtil.$$$reportNull$$$0(39);
        }
        String string = PlatformTestUtil.print(structure, node2, 0, Comparator.comparing(nodePresenter), -1, ' ', nodePresenter).toString();
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(40);
        }
        return string;
    }

    @NotNull
    private static StringBuilder print(AbstractTreeStructure structure, Object node2, int currentLevel, @Nullable Comparator<?> comparator, int maxRowCount, char paddingChar, Function<Object, String> nodePresenter) {
        StringBuilder buffer = new StringBuilder();
        PlatformTestUtil.doPrint(buffer, currentLevel, node2, structure, comparator, maxRowCount, 0, paddingChar, nodePresenter);
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            PlatformTestUtil.$$$reportNull$$$0(41);
        }
        return stringBuilder;
    }

    private static int doPrint(StringBuilder buffer, int currentLevel, Object node2, AbstractTreeStructure structure, @Nullable Comparator<?> comparator, int maxRowCount, int currentLine, char paddingChar, Function<Object, String> nodePresenter) {
        if (currentLine >= maxRowCount && maxRowCount != -1) {
            return currentLine;
        }
        StringUtil.repeatSymbol((Appendable)buffer, (char)paddingChar, (int)currentLevel);
        buffer.append(nodePresenter.apply(node2)).append("\n");
        ++currentLine;
        Object[] children = structure.getChildElements(node2);
        if (comparator != null) {
            ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(children));
            Comparator<?> c = comparator;
            list.sort(c);
            children = ArrayUtil.toObjectArray(list);
        }
        for (Object child : children) {
            currentLine = PlatformTestUtil.doPrint(buffer, currentLevel + 1, child, structure, comparator, maxRowCount, currentLine, paddingChar, nodePresenter);
        }
        return currentLine;
    }

    @NotNull
    public static String print(Object @NotNull [] objects) {
        if (objects == null) {
            PlatformTestUtil.$$$reportNull$$$0(42);
        }
        return PlatformTestUtil.print(Arrays.asList(objects));
    }

    @NotNull
    public static String print(@NotNull Collection<?> c) {
        if (c == null) {
            PlatformTestUtil.$$$reportNull$$$0(43);
        }
        String string = c.stream().map(each -> PlatformTestUtil.toString(each, null)).collect(Collectors.joining("\n"));
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(44);
        }
        return string;
    }

    @NotNull
    public static String print(@NotNull ListModel<?> model2) {
        if (model2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(45);
        }
        StringBuilder result2 = new StringBuilder();
        for (int i2 = 0; i2 < model2.getSize(); ++i2) {
            result2.append(PlatformTestUtil.toString(model2.getElementAt(i2), null));
            result2.append("\n");
        }
        String string = result2.toString();
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(46);
        }
        return string;
    }

    @NotNull
    public static String print(@NotNull JTree tree) {
        if (tree == null) {
            PlatformTestUtil.$$$reportNull$$$0(47);
        }
        return PlatformTestUtil.print(tree, false);
    }

    public static void invokeNamedAction(@NotNull String actionId) {
        if (actionId == null) {
            PlatformTestUtil.$$$reportNull$$$0(48);
        }
        AnAction action = ActionManager.getInstance().getAction(actionId);
        Assert.assertNotNull((Object)action);
        DataContext context2 = DataManager.getInstance().getDataContext();
        AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)action, null, (String)"", (DataContext)context2);
        PerformWithDocumentsCommitted.commitDocumentsIfNeeded((AnAction)action, (AnActionEvent)event);
        ActionUtil.performDumbAwareUpdate((AnAction)action, (AnActionEvent)event, (boolean)false);
        Assert.assertTrue((boolean)event.getPresentation().isEnabled());
        ActionUtil.performActionDumbAwareWithCallbacks((AnAction)action, (AnActionEvent)event);
    }

    /*
     * WARNING - void declaration
     */
    public static void assertTiming(@NotNull String message, long expectedMs, long l) {
        void actual;
        if (message == null) {
            PlatformTestUtil.$$$reportNull$$$0(49);
        }
        if (COVERAGE_ENABLED_BUILD) {
            return;
        }
        long expectedOnMyMachine = Math.max(1L, expectedMs * Timings.CPU_TIMING / 200L);
        Object logMessage = message;
        if (actual > expectedOnMyMachine) {
            int percentage = (int)(100.0 * (double)(actual - expectedOnMyMachine) / (double)expectedOnMyMachine);
            logMessage = (String)logMessage + ". Operation took " + percentage + "% longer than expected";
        }
        logMessage = (String)logMessage + ". Expected on my machine: " + expectedOnMyMachine + ". Actual: " + (long)actual + ". Expected on Standard machine: " + expectedMs + "; Timings: CPU=" + Timings.CPU_TIMING + ", I/O=" + Timings.IO_TIMING + ".";
        double acceptableChangeFactor = 1.1;
        if (actual < expectedOnMyMachine) {
            System.out.println((String)logMessage);
            TeamCityLogger.info((String)logMessage);
        } else if ((double)actual < (double)expectedOnMyMachine * acceptableChangeFactor) {
            TeamCityLogger.warning((String)logMessage, null);
        } else {
            throw new AssertionFailedError((String)logMessage);
        }
    }

    @Contract(pure=true)
    @NotNull
    public static PerformanceTestInfo newPerformanceTest(@NonNls @NotNull String launchName, @NotNull ThrowableRunnable<?> test) {
        if (launchName == null) {
            PlatformTestUtil.$$$reportNull$$$0(50);
        }
        if (test == null) {
            PlatformTestUtil.$$$reportNull$$$0(51);
        }
        return PlatformTestUtil.newPerformanceTestWithVariableInputSize(launchName, 1, () -> {
            test.run();
            return 1;
        });
    }

    @Contract(pure=true)
    @NotNull
    public static PerformanceTestInfo newPerformanceTestWithVariableInputSize(@NonNls @NotNull String launchName, int expectedInputSize, @NotNull ThrowableComputable<Integer, ?> test) {
        if (launchName == null) {
            PlatformTestUtil.$$$reportNull$$$0(52);
        }
        if (test == null) {
            PlatformTestUtil.$$$reportNull$$$0(53);
        }
        PerformanceTestInfo performanceTestInfo = PerformanceTestInfoLoader.Companion.getInstance().initialize(test, expectedInputSize, launchName);
        if (performanceTestInfo == null) {
            PlatformTestUtil.$$$reportNull$$$0(54);
        }
        return performanceTestInfo;
    }

    public static void assertPathsEqual(@Nullable String expected, @Nullable String actual) {
        if (expected != null) {
            expected = FileUtil.toSystemIndependentName((String)expected);
        }
        if (actual != null) {
            actual = FileUtil.toSystemIndependentName((String)actual);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @NotNull
    public static String getJavaExe() {
        String string = SystemProperties.getJavaHome() + (SystemInfo.isWindows ? "\\bin\\java.exe" : "/bin/java");
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(55);
        }
        return string;
    }

    @NotNull
    public static URL getRtJarURL() {
        URL uRL;
        String home = SystemProperties.getJavaHome();
        try {
            uRL = JavaVersion.current().feature >= 9 ? new URL("jrt:" + home) : new File(home + "/lib/rt.jar").toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        if (uRL == null) {
            PlatformTestUtil.$$$reportNull$$$0(56);
        }
        return uRL;
    }

    public static void forceCloseProjectWithoutSaving(@NotNull Project project2) {
        if (project2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(57);
        }
        if (!project2.isDisposed()) {
            ApplicationManager.getApplication().invokeAndWait(() -> ProjectManagerEx.getInstanceEx().forceCloseProject(project2));
        }
    }

    public static void saveProject(@NotNull Project project2) {
        if (project2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(58);
        }
        OpenProjectTaskBuilderKt.saveProject(project2, false);
    }

    public static void saveProject(@NotNull Project project2, boolean isForceSavingAllSettings) {
        if (project2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(59);
        }
        OpenProjectTaskBuilderKt.saveProject(project2, isForceSavingAllSettings);
    }

    public static void waitForAllBackgroundActivityToCalmDown() {
        CpuUsageData data;
        for (int i2 = 0; i2 < 50 && (data = CpuUsageData.measureCpuUsage(() -> TimeoutUtil.sleep((long)100L))).hasAnyActivityBesides(Thread.currentThread()); ++i2) {
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void assertTiming(@NotNull String message, long expected, @NotNull Runnable runnable2) {
        void actionToMeasure;
        if (message == null) {
            PlatformTestUtil.$$$reportNull$$$0(60);
        }
        if (runnable2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(61);
        }
        PlatformTestUtil.assertTiming(message, expected, 4, (Runnable)actionToMeasure);
    }

    /*
     * WARNING - void declaration
     */
    public static void assertTiming(@NotNull String message, long expected, int attempts, @NotNull Runnable runnable2) {
        if (message == null) {
            PlatformTestUtil.$$$reportNull$$$0(62);
        }
        if (runnable2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(63);
        }
        while (true) {
            void actionToMeasure;
            --attempts;
            PlatformTestUtil.waitForAllBackgroundActivityToCalmDown();
            long duration = TimeoutUtil.measureExecutionTime(((Runnable)actionToMeasure)::run);
            try {
                PlatformTestUtil.assertTiming(message, expected, duration);
            }
            catch (AssertionFailedError e) {
                if (attempts == 0) {
                    throw e;
                }
                System.gc();
                System.gc();
                System.gc();
                String s = e.getMessage() + "\n  " + attempts + " " + StringUtil.pluralize((String)"attempt", (int)attempts) + " remain";
                TeamCityLogger.warning(s, null);
                System.err.println(s);
                continue;
            }
            break;
        }
    }

    @NotNull
    private static Map<String, VirtualFile> buildNameToFileMap(VirtualFile @NotNull [] files, @Nullable VirtualFileFilter filter, @Nullable Function<VirtualFile, String> fileNameMapper) {
        if (files == null) {
            PlatformTestUtil.$$$reportNull$$$0(64);
        }
        HashMap<String, VirtualFile> map = new HashMap<String, VirtualFile>();
        for (VirtualFile file2 : files) {
            if (filter != null && !filter.accept(file2)) continue;
            String fileName = fileNameMapper != null ? fileNameMapper.apply(file2) : file2.getName();
            map.put(fileName, file2);
        }
        HashMap<String, VirtualFile> hashMap = map;
        if (hashMap == null) {
            PlatformTestUtil.$$$reportNull$$$0(65);
        }
        return hashMap;
    }

    public static void assertDirectoriesEqual(@NotNull VirtualFile dirExpected, @NotNull VirtualFile dirActual) throws IOException {
        if (dirExpected == null) {
            PlatformTestUtil.$$$reportNull$$$0(66);
        }
        if (dirActual == null) {
            PlatformTestUtil.$$$reportNull$$$0(67);
        }
        PlatformTestUtil.assertDirectoriesEqual(dirExpected, dirActual, null);
    }

    public static void assertDirectoriesEqual(@NotNull VirtualFile dirExpected, @NotNull VirtualFile dirActual, @Nullable VirtualFileFilter fileFilter) throws IOException {
        if (dirExpected == null) {
            PlatformTestUtil.$$$reportNull$$$0(68);
        }
        if (dirActual == null) {
            PlatformTestUtil.$$$reportNull$$$0(69);
        }
        PlatformTestUtil.assertDirectoriesEqual(dirExpected, dirActual, fileFilter, null);
    }

    public static void assertDirectoriesEqual(@NotNull VirtualFile dirExpected, @NotNull VirtualFile dirActual, @Nullable VirtualFileFilter fileFilter, @Nullable Function<VirtualFile, String> fileNameMapper) throws IOException {
        if (dirExpected == null) {
            PlatformTestUtil.$$$reportNull$$$0(70);
        }
        if (dirActual == null) {
            PlatformTestUtil.$$$reportNull$$$0(71);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        VirtualFile[] childrenAfter = dirExpected.getChildren();
        PlatformTestUtil.shallowCompare(dirExpected, childrenAfter);
        VirtualFile[] childrenBefore = dirActual.getChildren();
        PlatformTestUtil.shallowCompare(dirActual, childrenBefore);
        Map<String, VirtualFile> mapAfter = PlatformTestUtil.buildNameToFileMap(childrenAfter, fileFilter, fileNameMapper);
        Map<String, VirtualFile> mapBefore = PlatformTestUtil.buildNameToFileMap(childrenBefore, fileFilter, fileNameMapper);
        Set<String> keySetAfter = mapAfter.keySet();
        Set<String> keySetBefore = mapBefore.keySet();
        Assert.assertEquals((String)dirExpected.getPath(), keySetAfter, keySetBefore);
        for (String name : keySetAfter) {
            VirtualFile fileAfter = mapAfter.get(name);
            VirtualFile fileBefore = mapBefore.get(name);
            if (fileAfter.isDirectory()) {
                PlatformTestUtil.assertDirectoriesEqual(fileAfter, fileBefore, fileFilter, fileNameMapper);
                continue;
            }
            PlatformTestUtil.assertFilesEqual(fileAfter, fileBefore);
        }
    }

    private static void shallowCompare(@NotNull VirtualFile dir, VirtualFile @NotNull [] vfs) {
        if (dir == null) {
            PlatformTestUtil.$$$reportNull$$$0(72);
        }
        if (vfs == null) {
            PlatformTestUtil.$$$reportNull$$$0(73);
        }
        if (dir.isInLocalFileSystem() && dir.getFileSystem() != TempFileSystem.getInstance()) {
            String vfsPaths = Stream.of(vfs).map(VirtualFile::getPath).sorted().collect(Collectors.joining("\n"));
            File[] io = Objects.requireNonNull(new File(dir.getPath()).listFiles());
            String ioPaths = Stream.of(io).map(f -> FileUtil.toSystemIndependentName((String)f.getPath())).sorted().collect(Collectors.joining("\n"));
            Assert.assertEquals((Object)vfsPaths, (Object)ioPaths);
        }
    }

    public static void assertFilesEqual(@NotNull VirtualFile fileExpected, @NotNull VirtualFile fileActual) throws IOException {
        block5: {
            if (fileExpected == null) {
                PlatformTestUtil.$$$reportNull$$$0(74);
            }
            if (fileActual == null) {
                PlatformTestUtil.$$$reportNull$$$0(75);
            }
            try {
                PlatformTestUtil.assertJarFilesEqual(VfsUtilCore.virtualToIoFile((VirtualFile)fileExpected), VfsUtilCore.virtualToIoFile((VirtualFile)fileActual));
            }
            catch (IOException e) {
                String actual = PlatformTestUtil.fileText(fileActual);
                String expected = PlatformTestUtil.fileText(fileExpected);
                if (expected == null || actual == null) {
                    Assert.assertArrayEquals((String)fileExpected.getPath(), (byte[])fileExpected.contentsToByteArray(), (byte[])fileActual.contentsToByteArray());
                }
                if (StringUtil.equals((CharSequence)expected, (CharSequence)actual)) break block5;
                throw new FileComparisonFailedError("Text mismatch in the file " + fileExpected.getName(), expected, actual, (String)fileActual.getUserData(VfsTestUtil.TEST_DATA_FILE_PATH));
            }
        }
    }

    private static String fileText(@NotNull VirtualFile file2) throws IOException {
        Document doc;
        if (file2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(76);
        }
        if ((doc = FileDocumentManager.getInstance().getDocument(file2)) != null) {
            return doc.getText();
        }
        if (!file2.getFileType().isBinary() || FileTypeRegistry.getInstance().isFileOfType(file2, FileTypes.UNKNOWN)) {
            return LoadTextUtil.getTextByBinaryPresentation((byte[])file2.contentsToByteArray(false), (VirtualFile)file2).toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertJarFilesEqual(File file1, File file2) throws IOException {
        Path tempDir2 = Files.createTempDirectory("assert_jar_tmp_", new FileAttribute[0]);
        try (JarFile jarFile1 = new JarFile(file1);
             JarFile jarFile2 = new JarFile(file2);){
            Path tempDirectory1 = Files.createDirectory(tempDir2.resolve("tmp1"), new FileAttribute[0]);
            Path tempDirectory2 = Files.createDirectory(tempDir2.resolve("tmp2"), new FileAttribute[0]);
            new Decompressor.Zip(new File(jarFile1.getName())).extract(tempDirectory1);
            new Decompressor.Zip(new File(jarFile2.getName())).extract(tempDirectory2);
            VirtualFile dirAfter = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(tempDirectory1);
            Assert.assertNotNull((String)tempDirectory1.toString(), (Object)dirAfter);
            VirtualFile dirBefore = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(tempDirectory2);
            Assert.assertNotNull((String)tempDirectory2.toString(), (Object)dirBefore);
            ApplicationManager.getApplication().runWriteAction(() -> {
                dirAfter.refresh(false, true);
                dirBefore.refresh(false, true);
            });
            PlatformTestUtil.assertDirectoriesEqual(dirAfter, dirBefore);
        }
        finally {
            NioFiles.deleteRecursively((Path)tempDir2);
        }
    }

    @NotNull
    public static String getCommunityPath() {
        Object homePath = IdeaTestExecutionPolicy.getHomePathWithPolicy();
        if (new File((String)homePath, "community/.idea").isDirectory()) {
            homePath = (String)homePath + File.separatorChar + "community";
        }
        String string = homePath;
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(77);
        }
        return string;
    }

    @NotNull
    public static String getPlatformTestDataPath() {
        String string = PlatformTestUtil.getCommunityPath().replace(File.separatorChar, '/') + "/platform/platform-tests/testData/";
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(78);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static Comparator<AbstractTreeNode<?>> createComparator(Queryable.PrintInfo printInfo) {
        Comparator comparator = (o1, o2) -> {
            String displayText1 = o1.toTestString(printInfo);
            String displayText2 = o2.toTestString(printInfo);
            return Comparing.compare((Comparable)((Object)displayText1), (Comparable)((Object)displayText2));
        };
        if (comparator == null) {
            PlatformTestUtil.$$$reportNull$$$0(79);
        }
        return comparator;
    }

    @NotNull
    public static String loadFileText(@NotNull String fileName) throws IOException {
        if (fileName == null) {
            PlatformTestUtil.$$$reportNull$$$0(80);
        }
        String string = StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)new File(fileName)));
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(81);
        }
        return string;
    }

    public static void withEncoding(@NotNull String encoding, @NotNull ThrowableRunnable<?> r) {
        if (encoding == null) {
            PlatformTestUtil.$$$reportNull$$$0(82);
        }
        if (r == null) {
            PlatformTestUtil.$$$reportNull$$$0(83);
        }
        Charset.forName(encoding);
        try {
            Charset oldCharset = Charset.defaultCharset();
            try {
                PlatformTestUtil.patchSystemFileEncoding(encoding);
                r.run();
            }
            finally {
                PlatformTestUtil.patchSystemFileEncoding(oldCharset.name());
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static void patchSystemFileEncoding(@NotNull String encoding) {
        if (encoding == null) {
            PlatformTestUtil.$$$reportNull$$$0(84);
        }
        ReflectionUtil.resetField(Charset.class, Charset.class, (String)"defaultCharset");
        System.setProperty("file.encoding", encoding);
    }

    public static void withStdErrSuppressed(@NotNull Runnable r) {
        if (r == null) {
            PlatformTestUtil.$$$reportNull$$$0(85);
        }
        PrintStream std = System.err;
        System.setErr(new PrintStream(OutputStream.nullOutputStream()));
        try {
            r.run();
        }
        finally {
            System.setErr(std);
        }
    }

    public static void assertSuccessful(@NotNull GeneralCommandLine command) {
        if (command == null) {
            PlatformTestUtil.$$$reportNull$$$0(86);
        }
        try {
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)command.withRedirectErrorStream(true));
            Assert.assertEquals((String)output.getStdout(), (long)0L, (long)output.getExitCode());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static List<WebReference> collectWebReferences(@NotNull PsiElement element2) {
        if (element2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(87);
        }
        final ArrayList<WebReference> refs = new ArrayList<WebReference>();
        element2.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (PsiReference ref : element2.getReferences()) {
                    if (!(ref instanceof WebReference)) continue;
                    refs.add((WebReference)ref);
                }
                super.visitElement(element2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/testFramework/PlatformTestUtil$1", "visitElement"));
            }
        });
        ArrayList<WebReference> arrayList = refs;
        if (arrayList == null) {
            PlatformTestUtil.$$$reportNull$$$0(88);
        }
        return arrayList;
    }

    @NotNull
    public static List<UrlReference> collectUrlReferences(@NotNull PsiElement element2) {
        if (element2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(89);
        }
        SmartList result2 = new SmartList();
        element2.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor((List)result2){
            final /* synthetic */ List val$result;
            {
                this.val$result = list;
            }

            public void visitElement(@NotNull PsiElement element2) {
                if (element2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.val$result.addAll(PsiSymbolReferenceService.getService().getReferences(element2, UrlReference.class));
                super.visitElement(element2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/testFramework/PlatformTestUtil$2", "visitElement"));
            }
        });
        SmartList smartList = result2;
        if (smartList == null) {
            PlatformTestUtil.$$$reportNull$$$0(90);
        }
        return smartList;
    }

    @NotNull
    public static <T extends PsiReference> T getReferenceOfTypeWithAssertion(@Nullable PsiReference reference, @NotNull Class<T> refType) {
        if (refType == null) {
            PlatformTestUtil.$$$reportNull$$$0(91);
        }
        if (refType.isInstance(reference)) {
            PsiReference psiReference = reference;
            if (psiReference == null) {
                PlatformTestUtil.$$$reportNull$$$0(92);
            }
            return (T)psiReference;
        }
        if (reference instanceof PsiMultiReference) {
            PsiReference[] psiReferences;
            for (PsiReference psiReference : psiReferences = ((PsiMultiReference)reference).getReferences()) {
                if (!refType.isInstance(psiReference)) continue;
                PsiReference psiReference2 = psiReference;
                if (psiReference2 == null) {
                    PlatformTestUtil.$$$reportNull$$$0(93);
                }
                return (T)psiReference2;
            }
        }
        throw new AssertionError((Object)("given reference should be " + refType + " but " + (reference != null ? reference.getClass() : null) + " was given"));
    }

    public static void registerProjectCleanup(@NotNull Runnable cleanup) {
        if (cleanup == null) {
            PlatformTestUtil.$$$reportNull$$$0(94);
        }
        ourProjectCleanups.add(cleanup);
    }

    public static void cleanupAllProjects() {
        for (Runnable each : ourProjectCleanups) {
            each.run();
        }
        ourProjectCleanups.clear();
    }

    public static <T> void assertComparisonContractNotViolated(@NotNull List<? extends T> values, @NotNull Comparator<? super T> comparator, @NotNull BiPredicate<? super T, ? super T> equality) {
        if (values == null) {
            PlatformTestUtil.$$$reportNull$$$0(95);
        }
        if (comparator == null) {
            PlatformTestUtil.$$$reportNull$$$0(96);
        }
        if (equality == null) {
            PlatformTestUtil.$$$reportNull$$$0(97);
        }
        for (int i1 = 0; i1 < values.size(); ++i1) {
            for (int i2 = i1; i2 < values.size(); ++i2) {
                T value1 = values.get(i1);
                T value2 = values.get(i2);
                int result12 = comparator.compare(value1, value2);
                int result21 = comparator.compare(value2, value1);
                if (equality.test(value1, value2)) {
                    if (result12 != 0) {
                        Assert.fail((String)String.format("Equal, but not 0: '%s' - '%s'", value1, value2));
                    }
                    if (result21 != 0) {
                        Assert.fail((String)String.format("Equal, but not 0: '%s' - '%s'", value2, value1));
                    }
                } else {
                    if (result12 == 0) {
                        Assert.fail((String)String.format("Not equal, but 0: '%s' - '%s'", value1, value2));
                    }
                    if (result21 == 0) {
                        Assert.fail((String)String.format("Not equal, but 0: '%s' - '%s'", value2, value1));
                    }
                    if (Integer.signum(result12) == Integer.signum(result21)) {
                        Assert.fail((String)String.format("Not symmetrical: '%s' - '%s'", value1, value2));
                    }
                }
                for (int i3 = i2; i3 < values.size(); ++i3) {
                    int result31;
                    T value3 = values.get(i3);
                    int result23 = comparator.compare(value2, value3);
                    if (PlatformTestUtil.isTransitive(result12, result23, result31 = comparator.compare(value3, value1))) continue;
                    Assert.fail((String)String.format("Not transitive: '%s' - '%s' - '%s'", value1, value2, value3));
                }
            }
        }
    }

    private static boolean isTransitive(int result12, int result23, int result31) {
        if (result12 == 0 && result23 == 0 && result31 == 0) {
            return true;
        }
        if (result12 > 0 && result23 > 0 && result31 > 0) {
            return false;
        }
        if (result12 < 0 && result23 < 0 && result31 < 0) {
            return false;
        }
        if (result12 == 0 && Integer.signum(result23) * Integer.signum(result31) >= 0) {
            return false;
        }
        if (result23 == 0 && Integer.signum(result12) * Integer.signum(result31) >= 0) {
            return false;
        }
        return result31 != 0 || Integer.signum(result23) * Integer.signum(result12) < 0;
    }

    public static void setLongMeaninglessFileIncludeTemplateTemporarilyFor(@NotNull Project project2, @NotNull Disposable parentDisposable) {
        if (project2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(98);
        }
        if (parentDisposable == null) {
            PlatformTestUtil.$$$reportNull$$$0(99);
        }
        FileTemplateManagerImpl templateManager = (FileTemplateManagerImpl)FileTemplateManager.getInstance((Project)project2);
        templateManager.setDefaultFileIncludeTemplateTextTemporarilyForTest("File Header", "/**\n * Created by ${USER} on ${DATE}.\n */\n", parentDisposable);
    }

    @NotNull
    public static VirtualFile getOrCreateProjectBaseDir(@NotNull Project project2) {
        if (project2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(100);
        }
        VirtualFile virtualFile = HeavyTestHelper.getOrCreateProjectBaseDir(project2);
        if (virtualFile == null) {
            PlatformTestUtil.$$$reportNull$$$0(101);
        }
        return virtualFile;
    }

    @Nullable
    public static RunConfiguration getRunConfiguration(@NotNull PsiElement element2, @NotNull RunConfigurationProducer<?> producer) {
        if (element2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(102);
        }
        if (producer == null) {
            PlatformTestUtil.$$$reportNull$$$0(103);
        }
        MapDataContext dataContext = new MapDataContext();
        dataContext.put(CommonDataKeys.PROJECT, element2.getProject());
        dataContext.put(PlatformCoreDataKeys.MODULE, ModuleUtilCore.findModuleForPsiElement((PsiElement)element2));
        Location location = PsiLocation.fromPsiElement((PsiElement)element2);
        dataContext.put(Location.DATA_KEY, location);
        ConfigurationContext cc = ConfigurationContext.getFromContext((DataContext)dataContext, (String)"unknown");
        ConfigurationFromContext configuration = producer.createConfigurationFromContext(cc);
        return configuration != null ? configuration.getConfiguration() : null;
    }

    @NotNull
    public static ExecutionEnvironment executeConfigurationAndWait(@NotNull RunConfiguration runConfiguration) throws InterruptedException {
        if (runConfiguration == null) {
            PlatformTestUtil.$$$reportNull$$$0(104);
        }
        return PlatformTestUtil.executeConfigurationAndWait(runConfiguration, "Run");
    }

    @NotNull
    public static ExecutionEnvironment executeConfigurationAndWait(@NotNull RunConfiguration runConfiguration, long timeoutInSeconds) throws InterruptedException {
        if (runConfiguration == null) {
            PlatformTestUtil.$$$reportNull$$$0(105);
        }
        return PlatformTestUtil.executeConfigurationAndWait(runConfiguration, "Run", timeoutInSeconds);
    }

    @NotNull
    public static ExecutionEnvironment executeConfigurationAndWait(@NotNull RunConfiguration runConfiguration, @NotNull String executorId) throws InterruptedException {
        if (runConfiguration == null) {
            PlatformTestUtil.$$$reportNull$$$0(106);
        }
        if (executorId == null) {
            PlatformTestUtil.$$$reportNull$$$0(107);
        }
        return PlatformTestUtil.executeConfigurationAndWait(runConfiguration, executorId, 60L);
    }

    @NotNull
    public static ExecutionEnvironment executeConfigurationAndWait(@NotNull RunConfiguration runConfiguration, @NotNull String executorId, long timeoutInSeconds) throws InterruptedException {
        if (runConfiguration == null) {
            PlatformTestUtil.$$$reportNull$$$0(108);
        }
        if (executorId == null) {
            PlatformTestUtil.$$$reportNull$$$0(109);
        }
        Pair<@NotNull ExecutionEnvironment, RunContentDescriptor> result2 = PlatformTestUtil.executeConfiguration(runConfiguration, executorId, null);
        ProcessHandler processHandler = ((RunContentDescriptor)result2.second).getProcessHandler();
        Assert.assertNotNull((String)"Process handler must not be null!", (Object)processHandler);
        PlatformTestUtil.waitWithEventsDispatching(() -> "Process failed to finish in " + timeoutInSeconds + " seconds: " + processHandler, () -> ((ProcessHandler)processHandler).isProcessTerminated(), Math.toIntExact(timeoutInSeconds), () -> {
            if (!processHandler.isProcessTerminated()) {
                LOG.debug("Destroying process: " + processHandler);
                processHandler.destroyProcess();
            }
        });
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)result2.first;
        if (executionEnvironment == null) {
            PlatformTestUtil.$$$reportNull$$$0(110);
        }
        return executionEnvironment;
    }

    @NotNull
    public static @NotNull Pair<@NotNull ExecutionEnvironment, RunContentDescriptor> executeConfiguration(@NotNull RunConfiguration runConfiguration, @NotNull String executorId, @Nullable Consumer<? super RunContentDescriptor> contentDescriptorProcessor) throws InterruptedException {
        if (runConfiguration == null) {
            PlatformTestUtil.$$$reportNull$$$0(111);
        }
        if (executorId == null) {
            PlatformTestUtil.$$$reportNull$$$0(112);
        }
        Executor executor = ExecutorRegistry.getInstance().getExecutorById(executorId);
        Assert.assertNotNull((String)("Unable to find executor: " + executorId), (Object)executor);
        return PlatformTestUtil.executeConfiguration(runConfiguration, executor, contentDescriptorProcessor);
    }

    @NotNull
    public static @NotNull Pair<@NotNull ExecutionEnvironment, RunContentDescriptor> executeConfiguration(@NotNull RunConfiguration runConfiguration, @NotNull Executor executor, final @Nullable Consumer<? super RunContentDescriptor> descriptorProcessor) throws InterruptedException {
        if (runConfiguration == null) {
            PlatformTestUtil.$$$reportNull$$$0(113);
        }
        if (executor == null) {
            PlatformTestUtil.$$$reportNull$$$0(114);
        }
        Project project2 = runConfiguration.getProject();
        ConfigurationFactory factory = runConfiguration.getFactory();
        if (factory == null) {
            Assert.fail((String)("No factory found for: " + runConfiguration));
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunManager.getInstance((Project)project2).createConfiguration(runConfiguration, factory);
        ProgramRunner runner = ProgramRunner.getRunner((String)executor.getId(), (RunProfile)runConfiguration);
        if (runner == null) {
            Assert.fail((String)("No runner found for: " + executor.getId() + " and " + runConfiguration));
        }
        final Ref refRunContentDescriptor = new Ref();
        ExecutionEnvironment executionEnvironment = new ExecutionEnvironment(executor, runner, runnerAndConfigurationSettings, project2);
        final boolean[] failure = new boolean[]{false};
        ProgramRunnerUtil.executeConfigurationAsync((ExecutionEnvironment)executionEnvironment, (boolean)false, (boolean)false, (ProgramRunner.Callback)new ProgramRunner.Callback(){

            public void processNotStarted(@Nullable Throwable error2) {
                failure[0] = true;
            }

            public void processStarted(RunContentDescriptor descriptor) {
                final ProcessHandler processHandler = descriptor.getProcessHandler();
                LOG.debug("Process started: ", new Object[]{processHandler});
                if (descriptorProcessor != null) {
                    descriptorProcessor.accept(descriptor);
                }
                Assert.assertNotNull((Object)processHandler);
                processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void startNotified(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        LOG.debug("Process notified: ", new Object[]{processHandler});
                    }

                    public void processTerminated(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        LOG.debug("Process terminated: exitCode: ", new Object[]{event.getExitCode(), "; text: ", event.getText(), "; process: ", processHandler});
                    }

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                        if (event == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (outputType == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        LOG.debug(outputType + ": " + event.getText());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "event";
                                break;
                            }
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "outputType";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/testFramework/PlatformTestUtil$3$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "startNotified";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processTerminated";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onTextAvailable";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                refRunContentDescriptor.set((Object)descriptor);
            }
        });
        NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
        PlatformTestUtil.waitWithEventsDispatching("Process failed to start in 60 seconds", () -> !refRunContentDescriptor.isNull() || failure[0], 60);
        Assert.assertFalse((String)("Process could not start for configuration: " + runConfiguration), (boolean)failure[0]);
        Pair pair = Pair.create((Object)executionEnvironment, (Object)((RunContentDescriptor)refRunContentDescriptor.get()));
        if (pair == null) {
            PlatformTestUtil.$$$reportNull$$$0(115);
        }
        return pair;
    }

    public static void waitWithEventsDispatching(@NotNull String errorMessage, @NotNull BooleanSupplier condition, int timeoutInSeconds) {
        if (errorMessage == null) {
            PlatformTestUtil.$$$reportNull$$$0(116);
        }
        if (condition == null) {
            PlatformTestUtil.$$$reportNull$$$0(117);
        }
        PlatformTestUtil.waitWithEventsDispatching(() -> errorMessage, condition, timeoutInSeconds);
    }

    public static void waitWithEventsDispatching(@NotNull Supplier<String> errorMessageSupplier, @NotNull BooleanSupplier condition, int timeoutInSeconds) {
        if (errorMessageSupplier == null) {
            PlatformTestUtil.$$$reportNull$$$0(118);
        }
        if (condition == null) {
            PlatformTestUtil.$$$reportNull$$$0(119);
        }
        PlatformTestUtil.waitWithEventsDispatching(errorMessageSupplier, condition, timeoutInSeconds, null);
    }

    public static void waitWithEventsDispatching(@NotNull Supplier<String> errorMessageSupplier, @NotNull BooleanSupplier condition, int timeoutInSeconds, @Nullable Runnable callback) {
        if (errorMessageSupplier == null) {
            PlatformTestUtil.$$$reportNull$$$0(120);
        }
        if (condition == null) {
            PlatformTestUtil.$$$reportNull$$$0(121);
        }
        long start = System.currentTimeMillis();
        try {
            while (true) {
                if (System.currentTimeMillis() - start > (long)timeoutInSeconds * 1000L) {
                    if (callback != null) {
                        callback.run();
                    }
                    Assert.fail((String)errorMessageSupplier.get());
                }
                if (condition.getAsBoolean()) {
                    if (callback != null) {
                        callback.run();
                    }
                    break;
                }
                PlatformTestUtil.dispatchAllEventsInIdeEventQueue();
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static PsiElement findElementBySignature(@NotNull String signature, @NotNull String fileRelativePath, @NotNull Project project2) {
        if (signature == null) {
            PlatformTestUtil.$$$reportNull$$$0(122);
        }
        if (fileRelativePath == null) {
            PlatformTestUtil.$$$reportNull$$$0(123);
        }
        if (project2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(124);
        }
        String filePath = project2.getBasePath() + File.separator + fileRelativePath;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (virtualFile == null || !virtualFile.exists()) {
            throw new IllegalArgumentException(String.format("File '%s' doesn't exist", filePath));
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(virtualFile);
        if (psiFile == null) {
            return null;
        }
        int offset = psiFile.getText().indexOf(signature);
        return psiFile.findElementAt(offset);
    }

    public static void useAppConfigDir(@NotNull ThrowableRunnable<? extends Exception> task2) throws Exception {
        Path configCopy;
        Path configDir;
        if (task2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(125);
        }
        if (Files.exists(configDir = PathManager.getConfigDir(), new LinkOption[0])) {
            configCopy = Files.move(configDir, Paths.get(configDir + "_bak", new String[0]), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        } else {
            FileUtil.delete((Path)configDir);
            configCopy = null;
        }
        try {
            task2.run();
        }
        catch (Throwable throwable) {
            FileUtil.delete((Path)configDir);
            if (configCopy != null) {
                Files.move(configCopy, configDir, StandardCopyOption.ATOMIC_MOVE);
            }
            throw throwable;
        }
        FileUtil.delete((Path)configDir);
        if (configCopy != null) {
            Files.move(configCopy, configDir, StandardCopyOption.ATOMIC_MOVE);
        }
    }

    @NotNull
    public static Project loadAndOpenProject(@NotNull Path path, @NotNull Disposable parent) {
        if (path == null) {
            PlatformTestUtil.$$$reportNull$$$0(126);
        }
        if (parent == null) {
            PlatformTestUtil.$$$reportNull$$$0(127);
        }
        Project project2 = Objects.requireNonNull(ProjectManagerEx.getInstanceEx().openProject(path, new OpenProjectTaskBuilder().build()));
        Disposer.register((Disposable)parent, () -> PlatformTestUtil.forceCloseProjectWithoutSaving(project2));
        IndexingTestUtil.waitUntilIndexesAreReady(project2);
        Project project3 = project2;
        if (project3 == null) {
            PlatformTestUtil.$$$reportNull$$$0(128);
        }
        return project3;
    }

    public static boolean isUnderCommunityClassPath() {
        return StdFileTypes.JSPX == FileTypes.PLAIN_TEXT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Throwable> void withSystemProperty(@NotNull String key, String value2, @NotNull ThrowableRunnable<E> task2) throws E {
        if (key == null) {
            PlatformTestUtil.$$$reportNull$$$0(129);
        }
        if (task2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(130);
        }
        String original = System.setProperty(key, value2);
        try {
            task2.run();
        }
        finally {
            SystemProperties.setProperty((String)key, (String)original);
        }
    }

    public static void assumeEnoughParallelism() throws AssumptionViolatedException {
        int N = Math.min(Runtime.getRuntime().availableProcessors(), Math.min(ForkJoinPool.getCommonPoolParallelism(), ForkJoinPool.commonPool().getParallelism()));
        if (N < 4) {
            throw new AssumptionViolatedException("not enough parallelism, couldn't test parallel performance: available CPU cores=" + Runtime.getRuntime().availableProcessors() + "; FJP configured parallelism=" + ForkJoinPool.getCommonPoolParallelism() + "; FJP actual common pool parallelism=" + ForkJoinPool.commonPool().getParallelism());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 10, 13, 15, 40, 41, 44, 46, 54, 55, 56, 65, 77, 78, 79, 81, 88, 90, 92, 93, 101, 110, 115, 128 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 10: 
            case 13: 
            case 15: 
            case 40: 
            case 41: 
            case 44: 
            case 46: 
            case 54: 
            case 55: 
            case 56: 
            case 65: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 101: 
            case 110: 
            case 115: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/PlatformTestUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setupEventQueue";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointName";
                break;
            }
            case 6: 
            case 57: 
            case 58: 
            case 59: 
            case 98: 
            case 100: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExtensions";
                break;
            }
            case 8: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 12: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "busyCondition";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePresenter";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 49: 
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchName";
                break;
            }
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionToMeasure";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 66: 
            case 68: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirExpected";
                break;
            }
            case 67: 
            case 69: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirActual";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfs";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileExpected";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileActual";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 82: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 83: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 87: 
            case 89: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refType";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cleanup";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equality";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 111: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 107: 
            case 109: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 117: 
            case 119: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 118: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessageSupplier";
                break;
            }
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileRelativePath";
                break;
            }
            case 125: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/PlatformTestUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "lowercaseFirstLetter";
                break;
            }
            case 10: 
            case 13: 
            case 15: 
            case 40: 
            case 41: 
            case 44: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "print";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "newPerformanceTestWithVariableInputSize";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaExe";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getRtJarURL";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNameToFileMap";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommunityPath";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformTestDataPath";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "createComparator";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFileText";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "collectWebReferences";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUrlReferences";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceOfTypeWithAssertion";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateProjectBaseDir";
                break;
            }
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "executeConfigurationAndWait";
                break;
            }
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "executeConfiguration";
                break;
            }
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAndOpenProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTestName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "lowercaseFirstLetter";
                break;
            }
            case 2: 
            case 10: 
            case 13: 
            case 15: 
            case 40: 
            case 41: 
            case 44: 
            case 46: 
            case 54: 
            case 55: 
            case 56: 
            case 65: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 101: 
            case 110: 
            case 115: 
            case 128: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAllUppercaseName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadApp";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "maskExtensions";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 45: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "assertTreeEqual";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "expandAll";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isBusy";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "waitWhileBusy";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "waitForCallback";
                break;
            }
            case 29: 
            case 30: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "waitForPromise";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "assertPromiseSucceeds";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "waitForFuture";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "invokeNamedAction";
                break;
            }
            case 49: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "assertTiming";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "newPerformanceTest";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "newPerformanceTestWithVariableInputSize";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "forceCloseProjectWithoutSaving";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "saveProject";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "buildNameToFileMap";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "assertDirectoriesEqual";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "shallowCompare";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "assertFilesEqual";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "fileText";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "loadFileText";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "withEncoding";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "patchSystemFileEncoding";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "withStdErrSuppressed";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "assertSuccessful";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "collectWebReferences";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "collectUrlReferences";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceOfTypeWithAssertion";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "registerProjectCleanup";
                break;
            }
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "assertComparisonContractNotViolated";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "setLongMeaninglessFileIncludeTemplateTemporarilyFor";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateProjectBaseDir";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "getRunConfiguration";
                break;
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "executeConfigurationAndWait";
                break;
            }
            case 111: 
            case 112: 
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "executeConfiguration";
                break;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "waitWithEventsDispatching";
                break;
            }
            case 122: 
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "findElementBySignature";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "useAppConfigDir";
                break;
            }
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "loadAndOpenProject";
                break;
            }
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "withSystemProperty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 10, 13, 15, 40, 41, 44, 46, 54, 55, 56, 65, 77, 78, 79, 81, 88, 90, 92, 93, 101, 110, 115, 128 -> new IllegalStateException(string);
        };
    }
}

