/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.dashboard;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.StopAction;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.RunDashboardCustomizer;
import com.intellij.execution.dashboard.RunDashboardGroup;
import com.intellij.execution.dashboard.RunDashboardGroupingRule;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardNode;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.dashboard.actions.ExecutorAction;
import com.intellij.execution.dashboard.actions.RunDashboardGroupNode;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.FakeRerunAction;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewDnDDescriptor;
import com.intellij.execution.services.ServiceViewGroupingContributor;
import com.intellij.execution.services.ServiceViewLocatableDescriptor;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.ServiceViewProvidingContributor;
import com.intellij.execution.services.ServiceViewToolWindowDescriptor;
import com.intellij.execution.services.SimpleServiceViewDescriptor;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.MoreActionGroup;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.execution.dashboard.RunDashboardComponentWrapper;
import com.intellij.platform.execution.dashboard.RunDashboardManagerImpl;
import com.intellij.platform.execution.dashboard.RunDashboardServiceViewDeleteProvider;
import com.intellij.platform.execution.dashboard.tree.FolderDashboardGroupingRule;
import com.intellij.platform.execution.dashboard.tree.GroupingNode;
import com.intellij.platform.execution.dashboard.tree.RunConfigurationNode;
import com.intellij.platform.execution.dashboard.tree.RunDashboardGroupImpl;
import com.intellij.platform.execution.dashboard.tree.RunDashboardStatusFilter;
import com.intellij.platform.execution.serviceView.ServiceViewManagerImpl;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RunDashboardServiceViewContributor
implements ServiceViewGroupingContributor<RunConfigurationContributor, GroupingNode>,
RunDashboardGroupNode {
    @NonNls
    static final String RUN_DASHBOARD_CONTENT_TOOLBAR = "RunDashboardContentToolbar";
    private static final Key<DefaultActionGroup> MORE_ACTION_GROUP_KEY = Key.create((String)"ServicesMoreActionGroup");

    @NotNull
    public ServiceViewDescriptor getViewDescriptor(@NotNull Project project) {
        if (project == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(0);
        }
        return new RunDashboardContributorViewDescriptor(project);
    }

    @NotNull
    public List<RunConfigurationContributor> getServices(@NotNull Project project) {
        if (project == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(1);
        }
        RunDashboardManagerImpl runDashboardManager = (RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)project);
        List list = ContainerUtil.map(runDashboardManager.getRunConfigurations(), value -> new RunConfigurationContributor(new RunConfigurationNode(project, (RunDashboardManager.RunDashboardService)value, RunDashboardManagerImpl.getCustomizers(value.getSettings(), value.getDescriptor()))));
        if (list == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public ServiceViewDescriptor getServiceDescriptor(@NotNull Project project, @NotNull RunConfigurationContributor contributor) {
        if (project == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(3);
        }
        if (contributor == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(4);
        }
        ServiceViewDescriptor serviceViewDescriptor = contributor.getViewDescriptor(project);
        if (serviceViewDescriptor == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(5);
        }
        return serviceViewDescriptor;
    }

    @NotNull
    public List<GroupingNode> getGroups(@NotNull RunConfigurationContributor contributor) {
        if (contributor == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(6);
        }
        ArrayList<GroupingNode> result = new ArrayList<GroupingNode>();
        GroupingNode parentGroupNode = null;
        for (RunDashboardGroupingRule groupingRule : (RunDashboardGroupingRule[])RunDashboardManagerImpl.GROUPING_RULE_EP_NAME.getExtensions()) {
            RunDashboardGroup group = groupingRule.getGroup((AbstractTreeNode)contributor.asService());
            if (group == null) continue;
            GroupingNode node = new GroupingNode(contributor.asService().getProject(), parentGroupNode == null ? null : parentGroupNode.getGroup(), group);
            node.setParent(parentGroupNode);
            result.add(node);
            parentGroupNode = node;
        }
        ArrayList<GroupingNode> arrayList = result;
        if (arrayList == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    public ServiceViewDescriptor getGroupDescriptor(@NotNull GroupingNode node) {
        RunDashboardGroup group;
        if (node == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(8);
        }
        if ((group = node.getGroup()) instanceof FolderDashboardGroupingRule.FolderDashboardGroup) {
            return new RunDashboardFolderGroupViewDescriptor(node);
        }
        return new RunDashboardGroupViewDescriptor(node);
    }

    @NotNull
    public @NotNull List<@NotNull Object> getChildren(@NotNull Project project, @NotNull AnActionEvent e) {
        if (project == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(9);
        }
        if (e == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(10);
        }
        List list = ((ServiceViewManagerImpl)ServiceViewManager.getInstance((Project)project)).getChildrenSafe(e, List.of(this), RunDashboardServiceViewContributor.class);
        if (list == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static ActionGroup getToolbarActions(@Nullable RunContentDescriptor descriptor) {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(ActionManager.getInstance().getAction(RUN_DASHBOARD_CONTENT_TOOLBAR));
        List<AnAction> leftToolbarActions = null;
        RunnerLayoutUiImpl ui = RunDashboardManagerImpl.getRunnerLayoutUi(descriptor);
        if (ui != null) {
            leftToolbarActions = ui.getActions();
        } else {
            ActionToolbar toolbar = RunDashboardManagerImpl.findActionToolbar(descriptor);
            if (toolbar != null) {
                leftToolbarActions = toolbar.getActions();
            }
        }
        if (leftToolbarActions != null) {
            if (leftToolbarActions.size() == 1 && leftToolbarActions.get(0) instanceof ActionGroup) {
                leftToolbarActions = Arrays.asList(((ActionGroup)leftToolbarActions.get(0)).getChildren(null));
            }
            for (AnAction action : leftToolbarActions) {
                if (action instanceof MoreActionGroup) {
                    actionGroup.add((AnAction)RunDashboardServiceViewContributor.getServicesMoreActionGroup((MoreActionGroup)action, descriptor));
                    continue;
                }
                if (action instanceof StopAction || action instanceof FakeRerunAction || action instanceof ExecutorAction) continue;
                actionGroup.add(action);
            }
        }
        return actionGroup;
    }

    private static DefaultActionGroup getServicesMoreActionGroup(MoreActionGroup contentGroup, RunContentDescriptor descriptor) {
        if (descriptor == null) {
            return contentGroup;
        }
        Content content = descriptor.getAttachedContent();
        if (content == null) {
            return contentGroup;
        }
        DefaultActionGroup moreGroup = (DefaultActionGroup)content.getUserData(MORE_ACTION_GROUP_KEY);
        if (moreGroup == null) {
            moreGroup = new MoreActionGroup(false);
            content.putUserData(MORE_ACTION_GROUP_KEY, (Object)moreGroup);
        }
        moreGroup.removeAll();
        moreGroup.addAll(contentGroup.getChildren(ActionManager.getInstance()));
        return moreGroup;
    }

    private static ActionGroup getPopupActions() {
        DefaultActionGroup actions = new DefaultActionGroup();
        ActionManager actionManager = ActionManager.getInstance();
        actions.add(actionManager.getAction(RUN_DASHBOARD_CONTENT_TOOLBAR));
        actions.addSeparator();
        actions.add(actionManager.getAction("RunDashboardPopup"));
        return actions;
    }

    @Nullable
    private static RunDashboardRunConfigurationNode getRunConfigurationNode(@NotNull DnDEvent event, @NotNull Project project) {
        Object object;
        if (event == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(12);
        }
        if (project == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(13);
        }
        if (!((object = event.getAttachedObject()) instanceof DataProvider)) {
            return null;
        }
        Object data = ((DataProvider)object).getData(PlatformCoreDataKeys.SELECTED_ITEMS.getName());
        if (!(data instanceof Object[])) {
            return null;
        }
        Object[] items = (Object[])data;
        if (items.length != 1) {
            return null;
        }
        RunDashboardRunConfigurationNode node = (RunDashboardRunConfigurationNode)ObjectUtils.tryCast((Object)items[0], RunDashboardRunConfigurationNode.class);
        if (node != null && !node.getConfigurationSettings().getConfiguration().getProject().equals(project)) {
            return null;
        }
        return node;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 7, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getServices";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceDescriptor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroups";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getViewDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getServices";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 11: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getServiceDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getGroups";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getGroupDescriptor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRunConfigurationNode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 7, 11 -> new IllegalStateException(string);
        };
    }

    private static final class RunDashboardContributorViewDescriptor
    extends SimpleServiceViewDescriptor
    implements ServiceViewToolWindowDescriptor {
        private final Project myProject;

        RunDashboardContributorViewDescriptor(@NotNull Project project) {
            if (project == null) {
                RunDashboardContributorViewDescriptor.$$$reportNull$$$0(0);
            }
            super("Run Dashboard", AllIcons.Actions.Execute);
            this.myProject = project;
        }

        public ActionGroup getToolbarActions() {
            return RunDashboardServiceViewContributor.getToolbarActions(null);
        }

        public ActionGroup getPopupActions() {
            return RunDashboardServiceViewContributor.getPopupActions();
        }

        public DataProvider getDataProvider() {
            return id -> PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(id) ? new RunDashboardServiceViewDeleteProvider() : null;
        }

        @Nullable
        public JComponent getContentComponent() {
            return ((RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)this.myProject)).getEmptyContent();
        }

        @NotNull
        public String getToolWindowId() {
            String string = this.getId();
            if (string == null) {
                RunDashboardContributorViewDescriptor.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public Icon getToolWindowIcon() {
            Icon icon = AllIcons.Toolwindows.ToolWindowRun;
            if (icon == null) {
                RunDashboardContributorViewDescriptor.$$$reportNull$$$0(2);
            }
            return icon;
        }

        @NotNull
        public String getStripeTitle() {
            String title;
            String string = title = this.getToolWindowId();
            if (string == null) {
                RunDashboardContributorViewDescriptor.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean isExclusionAllowed() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor$RunDashboardContributorViewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor$RunDashboardContributorViewDescriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToolWindowId";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToolWindowIcon";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStripeTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    static final class RunConfigurationContributor
    implements ServiceViewProvidingContributor<AbstractTreeNode<?>, RunConfigurationNode> {
        private final RunConfigurationNode myNode;

        RunConfigurationContributor(@NotNull RunConfigurationNode node) {
            if (node == null) {
                RunConfigurationContributor.$$$reportNull$$$0(0);
            }
            this.myNode = node;
        }

        @NotNull
        public RunConfigurationNode asService() {
            RunConfigurationNode runConfigurationNode = this.myNode;
            if (runConfigurationNode == null) {
                RunConfigurationContributor.$$$reportNull$$$0(1);
            }
            return runConfigurationNode;
        }

        @NotNull
        public ServiceViewDescriptor getViewDescriptor(@NotNull Project project) {
            if (project == null) {
                RunConfigurationContributor.$$$reportNull$$$0(2);
            }
            return new RunConfigurationServiceViewDescriptor(this.myNode);
        }

        @NotNull
        public List<AbstractTreeNode<?>> getServices(@NotNull Project project) {
            if (project == null) {
                RunConfigurationContributor.$$$reportNull$$$0(3);
            }
            return new ArrayList(this.myNode.getChildren());
        }

        @NotNull
        public ServiceViewDescriptor getServiceDescriptor(@NotNull Project project, final @NotNull AbstractTreeNode service) {
            if (project == null) {
                RunConfigurationContributor.$$$reportNull$$$0(4);
            }
            if (service == null) {
                RunConfigurationContributor.$$$reportNull$$$0(5);
            }
            return new ServiceViewDescriptor(){

                public ActionGroup getToolbarActions() {
                    return RunDashboardServiceViewContributor.getToolbarActions(null);
                }

                public ActionGroup getPopupActions() {
                    return RunDashboardServiceViewContributor.getPopupActions();
                }

                @NotNull
                public ItemPresentation getPresentation() {
                    PresentationData presentationData = service.getPresentation();
                    if (presentationData == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return presentationData;
                }

                @Nullable
                public String getId() {
                    List fragments;
                    ItemPresentation presentation = this.getPresentation();
                    String text = presentation.getPresentableText();
                    if (!StringUtil.isEmpty((String)text)) {
                        return text;
                    }
                    if (presentation instanceof PresentationData && !(fragments = ((PresentationData)presentation).getColoredText()).isEmpty()) {
                        StringBuilder result = new StringBuilder();
                        for (PresentableNodeDescriptor.ColoredFragment fragment : fragments) {
                            result.append(fragment.getText());
                        }
                        return result.toString();
                    }
                    return null;
                }

                @Nullable
                public Runnable getRemover() {
                    return service instanceof RunDashboardNode ? ((RunDashboardNode)service).getRemover() : null;
                }

                @Nullable
                public JComponent getContentComponent() {
                    return ((RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)myNode.getProject())).getEmptyContent();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor$RunConfigurationContributor$1", "getPresentation"));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor$RunConfigurationContributor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor$RunConfigurationContributor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asService";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getViewDescriptor";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getServices";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getServiceDescriptor";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class RunDashboardFolderGroupViewDescriptor
    extends RunDashboardGroupViewDescriptor
    implements ServiceViewDnDDescriptor {
        RunDashboardFolderGroupViewDescriptor(GroupingNode node) {
            super(node);
        }

        @Override
        @Nullable
        public Runnable getRemover() {
            return () -> {
                String groupName = this.myGroup.getName();
                Project project = ((FolderDashboardGroupingRule.FolderDashboardGroup)this.myGroup).getProject();
                List services = RunDashboardManager.getInstance((Project)project).getRunConfigurations();
                RunManagerImpl runManager = RunManagerImpl.getInstanceImpl((Project)project);
                runManager.fireBeginUpdate();
                try {
                    for (RunDashboardManager.RunDashboardService service : services) {
                        RunnerAndConfigurationSettings settings = service.getSettings();
                        if (!groupName.equals(settings.getFolderName())) continue;
                        settings.setFolderName(null);
                    }
                }
                finally {
                    runManager.fireEndUpdate();
                }
            };
        }

        public boolean canDrop(@NotNull DnDEvent event, @NotNull ServiceViewDnDDescriptor.Position position) {
            if (event == null) {
                RunDashboardFolderGroupViewDescriptor.$$$reportNull$$$0(0);
            }
            if (position == null) {
                RunDashboardFolderGroupViewDescriptor.$$$reportNull$$$0(1);
            }
            return position == ServiceViewDnDDescriptor.Position.INTO && RunDashboardServiceViewContributor.getRunConfigurationNode(event, ((FolderDashboardGroupingRule.FolderDashboardGroup)this.myGroup).getProject()) != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drop(@NotNull DnDEvent event, @NotNull ServiceViewDnDDescriptor.Position position) {
            Project project;
            RunDashboardRunConfigurationNode node;
            if (event == null) {
                RunDashboardFolderGroupViewDescriptor.$$$reportNull$$$0(2);
            }
            if (position == null) {
                RunDashboardFolderGroupViewDescriptor.$$$reportNull$$$0(3);
            }
            if ((node = RunDashboardServiceViewContributor.getRunConfigurationNode(event, project = ((FolderDashboardGroupingRule.FolderDashboardGroup)this.myGroup).getProject())) == null) {
                return;
            }
            RunManagerImpl runManager = RunManagerImpl.getInstanceImpl((Project)project);
            runManager.fireBeginUpdate();
            try {
                node.getConfigurationSettings().setFolderName(this.myGroup.getName());
            }
            finally {
                runManager.fireEndUpdate();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor$RunDashboardFolderGroupViewDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canDrop";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "drop";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class RunDashboardGroupViewDescriptor
    implements ServiceViewDescriptor,
    WeighedItem {
        protected final RunDashboardGroup myGroup;
        private final GroupingNode myNode;
        private final PresentationData myPresentationData;

        protected RunDashboardGroupViewDescriptor(GroupingNode node) {
            this.myNode = node;
            this.myGroup = node.getGroup();
            this.myPresentationData = new PresentationData();
            this.myPresentationData.setPresentableText(this.myGroup.getName());
            this.myPresentationData.setIcon(this.myGroup.getIcon());
        }

        @Nullable
        public String getId() {
            return RunDashboardGroupViewDescriptor.getId(this.myNode);
        }

        public ActionGroup getToolbarActions() {
            return RunDashboardServiceViewContributor.getToolbarActions(null);
        }

        public ActionGroup getPopupActions() {
            return RunDashboardServiceViewContributor.getPopupActions();
        }

        @NotNull
        public ItemPresentation getPresentation() {
            PresentationData presentationData = this.myPresentationData;
            if (presentationData == null) {
                RunDashboardGroupViewDescriptor.$$$reportNull$$$0(0);
            }
            return presentationData;
        }

        public int getWeight() {
            Object value = ((RunDashboardGroupImpl)this.myGroup).getValue();
            if (value instanceof WeighedItem) {
                return ((WeighedItem)value).getWeight();
            }
            return 0;
        }

        @Nullable
        public Runnable getRemover() {
            ConfigurationType type = (ConfigurationType)ObjectUtils.tryCast(((RunDashboardGroupImpl)this.myGroup).getValue(), ConfigurationType.class);
            if (type != null) {
                return () -> {
                    RunDashboardManager runDashboardManager = RunDashboardManager.getInstance((Project)this.myNode.getProject());
                    HashSet types = new HashSet(runDashboardManager.getTypes());
                    types.remove(type.getId());
                    runDashboardManager.setTypes(types);
                };
            }
            return null;
        }

        @Nullable
        public JComponent getContentComponent() {
            return ((RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)this.myNode.getProject())).getEmptyContent();
        }

        private static String getId(GroupingNode node) {
            AbstractTreeNode parent = node.getParent();
            if (parent instanceof GroupingNode) {
                return RunDashboardGroupViewDescriptor.getId((GroupingNode)parent) + "/" + RunDashboardGroupViewDescriptor.getId(node.getGroup());
            }
            return RunDashboardGroupViewDescriptor.getId(node.getGroup());
        }

        private static String getId(RunDashboardGroup group) {
            Object value;
            if (group instanceof RunDashboardGroupImpl && (value = ((RunDashboardGroupImpl)group).getValue()) instanceof ConfigurationType) {
                return ((ConfigurationType)value).getId();
            }
            return group.getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor$RunDashboardGroupViewDescriptor", "getPresentation"));
        }
    }

    private static final class RunConfigurationServiceViewDescriptor
    implements ServiceViewDescriptor,
    ServiceViewLocatableDescriptor,
    ServiceViewDnDDescriptor {
        private final RunConfigurationNode myNode;

        RunConfigurationServiceViewDescriptor(RunConfigurationNode node) {
            this.myNode = node;
        }

        @Nullable
        public String getId() {
            RunConfiguration configuration = this.myNode.getConfigurationSettings().getConfiguration();
            return configuration.getType().getId() + "/" + configuration.getName();
        }

        public JComponent getContentComponent() {
            RunDashboardManagerImpl manager = (RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)this.myNode.getProject());
            RunDashboardComponentWrapper wrapper = manager.getContentWrapper();
            Content content = this.myNode.getContent();
            if (content == null) {
                wrapper.setContent(manager.getEmptyContent());
                wrapper.setContentId(null);
            } else {
                ContentManager contentManager = content.getManager();
                if (contentManager == null) {
                    return null;
                }
                wrapper.setContent(contentManager.getComponent());
                wrapper.setContentId(this.getContentId());
            }
            return wrapper;
        }

        private Integer getContentId() {
            RunContentDescriptor descriptor = this.myNode.getDescriptor();
            ProcessHandler handler = descriptor == null ? null : descriptor.getProcessHandler();
            return handler == null ? null : Integer.valueOf(handler.hashCode());
        }

        @NotNull
        public ItemPresentation getContentPresentation() {
            Content content = this.myNode.getContent();
            if (content != null) {
                return new PresentationData(content.getDisplayName(), null, content.getIcon(), null);
            }
            RunConfiguration configuration = this.myNode.getConfigurationSettings().getConfiguration();
            return new PresentationData(configuration.getName(), null, configuration.getIcon(), null);
        }

        public ActionGroup getToolbarActions() {
            return RunDashboardServiceViewContributor.getToolbarActions(this.myNode.getDescriptor());
        }

        public ActionGroup getPopupActions() {
            return RunDashboardServiceViewContributor.getPopupActions();
        }

        @NotNull
        public ItemPresentation getPresentation() {
            PresentationData presentationData = this.myNode.getPresentation();
            if (presentationData == null) {
                RunConfigurationServiceViewDescriptor.$$$reportNull$$$0(0);
            }
            return presentationData;
        }

        @Nullable
        public DataProvider getDataProvider() {
            Content content = this.myNode.getContent();
            if (content == null) {
                return null;
            }
            return DataManagerImpl.getDataProviderEx((Object)content.getComponent());
        }

        public void onNodeSelected(List<Object> selectedServices) {
            Content content = this.myNode.getContent();
            if (content == null) {
                return;
            }
            ((RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)this.myNode.getProject())).setSelectedContent(content);
        }

        public void onNodeUnselected() {
            Content content = this.myNode.getContent();
            if (content == null) {
                return;
            }
            ((RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)this.myNode.getProject())).removeFromSelection(content);
        }

        @Nullable
        public Navigatable getNavigatable() {
            final NullableLazyValue value = NullableLazyValue.lazyNullable(() -> {
                for (RunDashboardCustomizer customizer : this.myNode.getCustomizers()) {
                    PsiElement psiElement = customizer.getPsiElement((RunDashboardRunConfigurationNode)this.myNode);
                    if (psiElement == null) continue;
                    return psiElement;
                }
                return null;
            });
            return new Navigatable(){

                public void navigate(boolean requestFocus) {
                    PsiNavigateUtil.navigate((PsiElement)((PsiElement)value.getValue()), (boolean)requestFocus);
                }

                public boolean canNavigate() {
                    return value.getValue() != null;
                }

                public boolean canNavigateToSource() {
                    return this.canNavigate();
                }
            };
        }

        @Nullable
        public VirtualFile getVirtualFile() {
            return (VirtualFile)ReadAction.compute(() -> {
                for (RunDashboardCustomizer customizer : this.myNode.getCustomizers()) {
                    PsiElement psiElement = customizer.getPsiElement((RunDashboardRunConfigurationNode)this.myNode);
                    if (psiElement == null) continue;
                    return PsiUtilCore.getVirtualFile((PsiElement)psiElement);
                }
                return null;
            });
        }

        @Nullable
        public Object getPresentationTag(Object fragment) {
            Map links = (Map)this.myNode.getUserData(RunDashboardCustomizer.NODE_LINKS);
            return links == null ? null : links.get(fragment);
        }

        @Nullable
        public Runnable getRemover() {
            RunnerAndConfigurationSettings settings = this.myNode.getConfigurationSettings();
            RunManager runManager = RunManager.getInstance((Project)settings.getConfiguration().getProject());
            return runManager.hasSettings(settings) ? () -> runManager.removeConfiguration(settings) : null;
        }

        public boolean canDrop(@NotNull DnDEvent event, @NotNull ServiceViewDnDDescriptor.Position position) {
            if (event == null) {
                RunConfigurationServiceViewDescriptor.$$$reportNull$$$0(1);
            }
            if (position == null) {
                RunConfigurationServiceViewDescriptor.$$$reportNull$$$0(2);
            }
            if (position != ServiceViewDnDDescriptor.Position.INTO) {
                return RunDashboardServiceViewContributor.getRunConfigurationNode(event, this.myNode.getConfigurationSettings().getConfiguration().getProject()) != null;
            }
            for (RunDashboardCustomizer customizer : this.myNode.getCustomizers()) {
                if (!customizer.canDrop((RunDashboardRunConfigurationNode)this.myNode, event)) continue;
                return true;
            }
            return false;
        }

        public void drop(@NotNull DnDEvent event, @NotNull ServiceViewDnDDescriptor.Position position) {
            if (event == null) {
                RunConfigurationServiceViewDescriptor.$$$reportNull$$$0(3);
            }
            if (position == null) {
                RunConfigurationServiceViewDescriptor.$$$reportNull$$$0(4);
            }
            if (position != ServiceViewDnDDescriptor.Position.INTO) {
                Project project = this.myNode.getConfigurationSettings().getConfiguration().getProject();
                RunDashboardRunConfigurationNode node = RunDashboardServiceViewContributor.getRunConfigurationNode(event, project);
                if (node != null) {
                    this.reorderConfigurations(project, node, position);
                }
                return;
            }
            for (RunDashboardCustomizer customizer : this.myNode.getCustomizers()) {
                if (!customizer.canDrop((RunDashboardRunConfigurationNode)this.myNode, event)) continue;
                customizer.drop((RunDashboardRunConfigurationNode)this.myNode, event);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reorderConfigurations(Project project, RunDashboardRunConfigurationNode node, ServiceViewDnDDescriptor.Position position) {
            RunManagerImpl runManager = RunManagerImpl.getInstanceImpl((Project)project);
            runManager.fireBeginUpdate();
            try {
                node.getConfigurationSettings().setFolderName(this.myNode.getConfigurationSettings().getFolderName());
                Object2IntOpenHashMap indices = new Object2IntOpenHashMap();
                int i = 0;
                for (RunnerAndConfigurationSettings each : runManager.getAllSettings()) {
                    if (each.equals(node.getConfigurationSettings())) continue;
                    if (each.equals(this.myNode.getConfigurationSettings())) {
                        if (position == ServiceViewDnDDescriptor.Position.ABOVE) {
                            indices.put((Object)node.getConfigurationSettings(), i++);
                            indices.put((Object)this.myNode.getConfigurationSettings(), i++);
                            continue;
                        }
                        if (position != ServiceViewDnDDescriptor.Position.BELOW) continue;
                        indices.put((Object)this.myNode.getConfigurationSettings(), i++);
                        indices.put((Object)node.getConfigurationSettings(), i++);
                        continue;
                    }
                    indices.put((Object)each, i++);
                }
                runManager.setOrder(Comparator.comparingInt(arg_0 -> ((Object2IntMap)indices).getInt(arg_0)));
            }
            finally {
                runManager.fireEndUpdate();
            }
        }

        public boolean isVisible() {
            RunDashboardStatusFilter statusFilter = ((RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)this.myNode.getProject())).getStatusFilter();
            return statusFilter.isVisible(this.myNode);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor$RunConfigurationServiceViewDescriptor";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor$RunConfigurationServiceViewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "canDrop";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "drop";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

