/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;

public final class LibrariesUtil {
    public static final String SOME_GROOVY_CLASS = "org.codehaus.groovy.control.CompilationUnit";
    @NlsSafe
    private static final String LIB = "lib";
    @NlsSafe
    private static final String EMBEDDABLE = "embeddable";

    private LibrariesUtil() {
    }

    public static Library[] getLibrariesByCondition(Module module, Condition<? super Library> condition) {
        if (module == null) {
            return Library.EMPTY_ARRAY;
        }
        ArrayList libraries = new ArrayList();
        ApplicationManager.getApplication().runReadAction(() -> LibrariesUtil.populateOrderEntries(module, condition, libraries, false, new HashSet()));
        return libraries.toArray(Library.EMPTY_ARRAY);
    }

    private static void populateOrderEntries(@NotNull Module module, Condition<? super Library> condition, ArrayList<? super Library> libraries, boolean exportedOnly, Set<? super Module> visited) {
        if (module == null) {
            LibrariesUtil.$$$reportNull$$$0(0);
        }
        if (!visited.add((Module)module)) {
            return;
        }
        for (OrderEntry entry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            Module dep;
            if (entry instanceof LibraryOrderEntry) {
                Library library;
                LibraryOrderEntry libEntry = (LibraryOrderEntry)entry;
                if (exportedOnly && !libEntry.isExported() || !condition.value((Object)(library = libEntry.getLibrary()))) continue;
                libraries.add((Library)library);
                continue;
            }
            if (!(entry instanceof ModuleOrderEntry) || (dep = ((ModuleOrderEntry)entry).getModule()) == null) continue;
            LibrariesUtil.populateOrderEntries(dep, condition, libraries, true, visited);
        }
    }

    public static Library[] getGlobalLibraries(Condition<? super Library> condition) {
        LibraryTable table = LibraryTablesRegistrar.getInstance().getLibraryTable();
        List libs = ContainerUtil.findAll((Object[])table.getLibraries(), condition);
        return libs.toArray(Library.EMPTY_ARRAY);
    }

    @NotNull
    public static String getGroovyLibraryHome(Library library) {
        VirtualFile[] classRoots = library.getFiles(OrderRootType.CLASSES);
        String home = LibrariesUtil.getGroovyLibraryHome(classRoots);
        String string = home == null ? "" : home;
        if (string == null) {
            LibrariesUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static boolean hasGroovySdk(@Nullable Module module) {
        return module != null && LibrariesUtil.getGroovyHomePath(module) != null;
    }

    @Nullable
    public static VirtualFile findJarWithClass(@NotNull Module module, String classQName) {
        if (module == null) {
            LibrariesUtil.$$$reportNull$$$0(2);
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        for (PsiClass psiClass : JavaPsiFacade.getInstance((Project)module.getProject()).findClasses(classQName, scope)) {
            VirtualFile virtualFile = psiClass.getContainingFile().getVirtualFile();
            VirtualFile local = LibrariesUtil.getLocalFor(virtualFile);
            if (local == null) continue;
            return local;
        }
        return null;
    }

    private static VirtualFile getLocalFor(VirtualFile virtualFile) {
        VirtualFileSystem fileSystem;
        if (virtualFile != null && (fileSystem = virtualFile.getFileSystem()) instanceof ArchiveFileSystem) {
            return ((ArchiveFileSystem)fileSystem).getLocalByEntry(virtualFile);
        }
        return null;
    }

    @Nullable
    public static String getGroovyHomePath(@NotNull Module module) {
        VirtualFile parent2;
        VirtualFile local;
        if (module == null) {
            LibrariesUtil.$$$reportNull$$$0(3);
        }
        if (!DumbService.isDumb((Project)module.getProject()) && (local = LibrariesUtil.findJarWithClass(module, SOME_GROOVY_CLASS)) != null && (parent2 = local.getParent()) != null) {
            if ((LIB.equals(parent2.getName()) || EMBEDDABLE.equals(parent2.getName())) && parent2.getParent() != null) {
                return parent2.getParent().getPath();
            }
            return parent2.getPath();
        }
        String home = LibrariesUtil.getGroovyLibraryHome(OrderEnumerator.orderEntries((Module)module).getAllLibrariesAndSdkClassesRoots());
        return StringUtil.isEmpty((String)home) ? null : home;
    }

    @Nullable
    private static String getGroovySdkHome(VirtualFile[] classRoots) {
        for (VirtualFile file : classRoots) {
            File parentFile;
            String jarPath;
            File realFile;
            String name = file.getName();
            if (!GroovyConfigUtils.GROOVY_JAR_PATTERN.matcher(name).matches() || !(realFile = new File(jarPath = file.getPresentableUrl())).exists() || (parentFile = realFile.getParentFile()) == null) continue;
            if (LIB.equals(parentFile.getName())) {
                return parentFile.getParent();
            }
            return parentFile.getPath();
        }
        return null;
    }

    @Nullable
    private static String getEmbeddableGroovyJar(VirtualFile[] classRoots) {
        for (VirtualFile file : classRoots) {
            String jarPath;
            File realFile;
            String name = file.getName();
            if (!GroovyConfigUtils.matchesGroovyAll(name) || !(realFile = new File(jarPath = file.getPresentableUrl())).exists()) continue;
            return realFile.getPath();
        }
        return null;
    }

    @Nullable
    public static String getGroovyLibraryHome(VirtualFile[] classRoots) {
        File emb;
        String sdkHome = LibrariesUtil.getGroovySdkHome(classRoots);
        if (sdkHome != null) {
            return sdkHome;
        }
        String embeddable = LibrariesUtil.getEmbeddableGroovyJar(classRoots);
        if (embeddable != null && (emb = new File(embeddable)).exists()) {
            File parent2 = emb.getParentFile();
            if (EMBEDDABLE.equals(parent2.getName()) || LIB.equals(parent2.getName())) {
                return parent2.getParent();
            }
            return parent2.getPath();
        }
        return null;
    }

    @NotNull
    public static VirtualFile getLocalFile(@NotNull VirtualFile libFile) {
        VirtualFile local;
        if (libFile == null) {
            LibrariesUtil.$$$reportNull$$$0(4);
        }
        if ((local = LibrariesUtil.getLocalFor(libFile)) != null) {
            VirtualFile virtualFile = local;
            if (virtualFile == null) {
                LibrariesUtil.$$$reportNull$$$0(5);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = libFile;
        if (virtualFile == null) {
            LibrariesUtil.$$$reportNull$$$0(6);
        }
        return virtualFile;
    }

    public static void placeEntryToCorrectPlace(ModifiableRootModel model, LibraryOrderEntry addedEntry) {
        OrderEntry[] order = model.getOrderEntries();
        assert (order[order.length - 1] == addedEntry);
        int insertionPoint = -1;
        for (int i2 = 0; i2 < order.length - 1; ++i2) {
            if (!(order[i2] instanceof ModuleSourceOrderEntry)) continue;
            insertionPoint = i2 + 1;
            break;
        }
        if (insertionPoint >= 0) {
            System.arraycopy(order, insertionPoint, order, insertionPoint + 1, order.length - 1 - insertionPoint);
            order[insertionPoint] = addedEntry;
            model.rearrangeOrderEntries(order);
        }
    }

    public static File[] getFilesInDirectoryByPattern(String dirPath, Pattern pattern) {
        File distDir = new File(dirPath);
        File[] files = distDir.listFiles((dir, name) -> pattern.matcher(name).matches());
        return files != null ? files : new File[]{};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/util/LibrariesUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/util/LibrariesUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroovyLibraryHome";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "populateOrderEntries";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findJarWithClass";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getGroovyHomePath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLocalFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 6 -> new IllegalStateException(string);
        };
    }
}

