/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.rename;

import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.rename.PropertyForRename;
import org.jetbrains.plugins.groovy.refactoring.rename.RenamePropertyUtil;

public final class PropertyRenameHandler
implements RenameHandler,
TitledHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        PsiElement element;
        if (dataContext == null) {
            PropertyRenameHandler.$$$reportNull$$$0(0);
        }
        if ((element = PropertyRenameHandler.getElement(dataContext)) instanceof GrField && ((GrField)element).isProperty()) {
            return true;
        }
        if (element instanceof GrAccessorMethod) {
            return true;
        }
        return element instanceof GrMethod && GroovyPropertyUtils.isSimplePropertyAccessor((PsiMethod)element);
    }

    @Nullable
    private static PsiElement getElement(DataContext dataContext) {
        return (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, @Nullable DataContext dataContext) {
        if (project == null) {
            PropertyRenameHandler.$$$reportNull$$$0(1);
        }
        PsiElement element = PropertyRenameHandler.getElement(dataContext);
        PropertyRenameHandler.invokeInner(project, editor, element);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, @Nullable DataContext dataContext) {
        PsiElement element;
        if (project == null) {
            PropertyRenameHandler.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            PropertyRenameHandler.$$$reportNull$$$0(3);
        }
        PsiElement psiElement = element = elements.length == 1 ? elements[0] : null;
        if (element == null) {
            element = PropertyRenameHandler.getElement(dataContext);
        }
        Editor editor = dataContext == null ? null : (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PropertyRenameHandler.invokeInner(project, editor, element);
    }

    private static void invokeInner(Project project, Editor editor, PsiElement element) {
        Pair<List<? extends PsiElement>, String> pair = RenamePropertyUtil.askToRenameProperty((PsiMember)element);
        List result2 = (List)pair.getFirst();
        if (result2.isEmpty()) {
            return;
        }
        PsiElement propertyToRename = PropertyRenameHandler.getPropertyToRename(element, result2, (String)pair.getSecond());
        PsiElementRenameHandler.invoke((PsiElement)propertyToRename, (Project)project, (PsiElement)element, (Editor)editor);
    }

    private static PsiElement getPropertyToRename(PsiElement element, List<? extends PsiElement> result2, String propertyName) {
        if (result2.size() == 1) {
            return result2.get(0);
        }
        return new PropertyForRename(result2, propertyName, element.getManager());
    }

    public String getActionTitle() {
        return GroovyRefactoringBundle.message("rename.groovy.property", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/rename/PropertyRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

