/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionContext;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GenerationUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.TypeWriter;

class ArgumentListGenerator {
    private static final Logger LOG = Logger.getInstance(ArgumentListGenerator.class);
    private final StringBuilder myBuilder;
    private final ExpressionGenerator myExpressionGenerator;

    ArgumentListGenerator(StringBuilder builder, ExpressionContext context) {
        this.myBuilder = builder;
        this.myExpressionGenerator = new ExpressionGenerator(builder, context);
    }

    public void generate(@Nullable GrSignature signature, GrExpression @NotNull [] exprs, GrNamedArgument @NotNull [] namedArgs, GrClosableBlock @NotNull [] clArgs, @NotNull GroovyPsiElement context) {
        PsiSubstitutor substitutor2;
        Object[] argInfos;
        if (context == null) {
            ArgumentListGenerator.$$$reportNull$$$0(0);
        }
        if (exprs == null) {
            ArgumentListGenerator.$$$reportNull$$$0(1);
        }
        if (namedArgs == null) {
            ArgumentListGenerator.$$$reportNull$$$0(2);
        }
        if (clArgs == null) {
            ArgumentListGenerator.$$$reportNull$$$0(3);
        }
        Object[] objectArray = argInfos = signature == null ? null : GrClosureSignatureUtil.mapParametersToArguments(signature, namedArgs, exprs, clArgs, context, false, false);
        if (argInfos == null && signature != null) {
            argInfos = GrClosureSignatureUtil.mapParametersToArguments(signature, namedArgs, exprs, clArgs, context, true, true);
        }
        PsiSubstitutor psiSubstitutor = substitutor2 = signature == null ? PsiSubstitutor.EMPTY : signature.getSubstitutor();
        if (argInfos == null || ArrayUtil.contains(null, (Object[])argInfos)) {
            this.generateSimple(exprs, namedArgs, clArgs, context, substitutor2);
            return;
        }
        GrClosureParameter[] params = signature.getParameters();
        Project project = context.getProject();
        this.myBuilder.append('(');
        boolean hasCommaAtEnd = false;
        for (int i2 = 0; i2 < argInfos.length; ++i2) {
            boolean generated;
            Object arg = argInfos[i2];
            if (arg == null) continue;
            GrClosureParameter param = params[i2];
            boolean bl = generated = ((GrClosureSignatureUtil.ArgInfo)arg).isMultiArg ? this.generateMultiArg((GrClosureSignatureUtil.ArgInfo<PsiElement>)arg, param, substitutor2, project, context) : this.generateSingeArg((GrClosureSignatureUtil.ArgInfo<PsiElement>)arg, param);
            if (!generated) continue;
            hasCommaAtEnd = true;
            this.myBuilder.append(", ");
        }
        if (hasCommaAtEnd) {
            this.myBuilder.delete(this.myBuilder.length() - 2, this.myBuilder.length());
        }
        this.myBuilder.append(')');
    }

    private boolean generateSingeArg(GrClosureSignatureUtil.ArgInfo<PsiElement> arg, GrClosureParameter param) {
        boolean argExists;
        boolean bl = argExists = !arg.args.isEmpty() && arg.args.get(0) != null;
        if (argExists) {
            PsiElement actual = (PsiElement)arg.args.get(0);
            LOG.assertTrue(actual instanceof GrExpression);
            PsiType type2 = param.getType();
            PsiType declaredType = GenerationUtil.getDeclaredType((GrExpression)actual, this.myExpressionGenerator.getContext());
            if (type2 != null && declaredType != null && !TypesUtil.isAssignableByMethodCallConversion(type2, declaredType, actual)) {
                this.myBuilder.append('(');
                TypeWriter.writeType(this.myBuilder, type2, actual);
                this.myBuilder.append(')');
            }
            ((GrExpression)actual).accept(this.myExpressionGenerator);
            return true;
        }
        return false;
    }

    private boolean generateMultiArg(GrClosureSignatureUtil.ArgInfo<PsiElement> arg, GrClosureParameter param, PsiSubstitutor substitutor2, Project project, GroovyPsiElement context) {
        PsiType type2 = param.getType();
        if (type2 instanceof PsiEllipsisType) {
            for (PsiElement element : arg.args) {
                LOG.assertTrue(element instanceof GrExpression);
                ((GrExpression)element).accept(this.myExpressionGenerator);
                this.myBuilder.append(", ");
            }
            if (!arg.args.isEmpty()) {
                this.myBuilder.delete(this.myBuilder.length() - 2, this.myBuilder.length());
                return true;
            }
            return false;
        }
        if (type2 instanceof PsiArrayType) {
            this.myBuilder.append("new ");
            if (arg.args.isEmpty()) {
                TypeWriter.writeType(this.myBuilder, ((PsiArrayType)type2).getComponentType(), context);
                this.myBuilder.append("[0]");
            } else {
                TypeWriter.writeTypeForNew(this.myBuilder, type2, context);
                this.myBuilder.append("{");
                for (PsiElement element : arg.args) {
                    LOG.assertTrue(element instanceof GrExpression);
                    ((GrExpression)element).accept(this.myExpressionGenerator);
                    this.myBuilder.append(", ");
                }
                if (!arg.args.isEmpty()) {
                    this.myBuilder.delete(this.myBuilder.length() - 2, this.myBuilder.length());
                }
                this.myBuilder.append('}');
            }
        } else {
            GrExpression listOrMap = GroovyRefactoringUtil.generateArgFromMultiArg(substitutor2, arg.args, type2, project);
            LOG.assertTrue(listOrMap instanceof GrListOrMap);
            listOrMap.accept(this.myExpressionGenerator);
        }
        return true;
    }

    private void generateSimple(GrExpression[] exprs, GrNamedArgument[] namedArgs, GrClosableBlock[] closures, GroovyPsiElement context, PsiSubstitutor substitutor2) {
        this.myBuilder.append('(');
        if (namedArgs.length > 0) {
            GrExpression listOrMap = GroovyRefactoringUtil.generateArgFromMultiArg(substitutor2, Arrays.asList(namedArgs), null, context.getProject());
            LOG.assertTrue(listOrMap instanceof GrListOrMap);
            listOrMap.accept(this.myExpressionGenerator);
            this.myBuilder.append(", ");
        }
        for (GrExpression grExpression : exprs) {
            grExpression.accept(this.myExpressionGenerator);
            this.myBuilder.append(", ");
        }
        for (GrExpression grExpression : closures) {
            grExpression.accept(this.myExpressionGenerator);
            this.myBuilder.append(", ");
        }
        if (namedArgs.length + exprs.length + closures.length > 0) {
            this.myBuilder.delete(this.myBuilder.length() - 2, this.myBuilder.length());
        }
        this.myBuilder.append(')');
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "exprs";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "namedArgs";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "clArgs";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/refactoring/convertToJava/ArgumentListGenerator";
        objectArray[2] = "generate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

