/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions.strings;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.GrPsiUpdateIntention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringContent;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public final class ConvertToRegexIntention
extends GrPsiUpdateIntention {
    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull ActionContext context, @NotNull ModPsiUpdater updater) {
        if (element == null) {
            ConvertToRegexIntention.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ConvertToRegexIntention.$$$reportNull$$$0(1);
        }
        if (updater == null) {
            ConvertToRegexIntention.$$$reportNull$$$0(2);
        }
        if (!(element instanceof GrLiteral)) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("/");
        if (GrStringUtil.isDollarSlashyString((GrLiteral)element)) {
            buffer.append(GrStringUtil.removeQuotes(element.getText()));
        } else if (element instanceof GrLiteralImpl) {
            GroovyPsiElement[] value2 = ((GrLiteralImpl)element).getValue();
            if (value2 instanceof String) {
                GrStringUtil.escapeSymbolsForSlashyStrings(buffer, (String)value2);
            } else {
                String rawText = GrStringUtil.removeQuotes(element.getText());
                ConvertToRegexIntention.unescapeAndAppend(buffer, rawText);
            }
        } else if (element instanceof GrString) {
            for (GroovyPsiElement part : ((GrString)element).getAllContentParts()) {
                if (part instanceof GrStringContent) {
                    ConvertToRegexIntention.unescapeAndAppend(buffer, part.getText());
                    continue;
                }
                if (!(part instanceof GrStringInjection)) continue;
                buffer.append(part.getText());
            }
        }
        buffer.append("/");
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(context.project());
        GrExpression regex = factory.createExpressionFromText(buffer);
        element.replace((PsiElement)regex);
    }

    private static void unescapeAndAppend(StringBuilder buffer, String rawText) {
        String parsed = GrStringUtil.unescapeString(rawText);
        GrStringUtil.escapeSymbolsForSlashyStrings(buffer, parsed);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                return element instanceof GrLiteral && GrStringUtil.isStringLiteral((GrLiteral)element) && !GrStringUtil.removeQuotes(element.getText()).isEmpty() && !GrStringUtil.isSlashyString((GrLiteral)element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertToRegexIntention$1", "satisfiedBy"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "updater";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertToRegexIntention";
        objectArray[2] = "processIntention";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

