/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gant.ant;

import com.intellij.lang.Language;
import com.intellij.lang.ant.AntIntrospector;
import com.intellij.lang.ant.dom.AntDomExtender;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import icons.AntIcons;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;

final class AntBuilderMethod
extends LightMethodBuilder {
    @NotNull
    private final PsiFile myFile;
    @Nullable
    private final Class<?> myAntClass;

    AntBuilderMethod(@NotNull PsiFile file, @NotNull String name, @Nullable Class<?> antClass) {
        if (file == null) {
            AntBuilderMethod.$$$reportNull$$$0(0);
        }
        if (name == null) {
            AntBuilderMethod.$$$reportNull$$$0(1);
        }
        super(file.getManager(), (Language)GroovyLanguage.INSTANCE, name);
        this.myFile = file;
        this.myAntClass = antClass;
        this.setModifiers(new String[]{"public"});
        this.setBaseIcon(AntIcons.Task);
        this.setMethodReturnType(() -> PsiType.getJavaLangObject((PsiManager)this.getManager(), (GlobalSearchScope)this.getResolveScope()));
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiClass psiClass;
        if (this.myAntClass != null && (psiClass = JavaPsiFacade.getInstance((Project)this.getProject()).findClass(this.myAntClass.getName(), this.myFile.getResolveScope())) != null) {
            PsiClass psiClass2 = psiClass;
            if (psiClass2 == null) {
                AntBuilderMethod.$$$reportNull$$$0(2);
            }
            return psiClass2;
        }
        AntBuilderMethod antBuilderMethod = this;
        if (antBuilderMethod == null) {
            AntBuilderMethod.$$$reportNull$$$0(3);
        }
        return antBuilderMethod;
    }

    public boolean processNestedElements(PsiScopeProcessor processor) {
        if (!ResolveUtilKt.shouldProcessMethods(processor)) {
            return true;
        }
        AntIntrospector introspector = AntDomExtender.getIntrospector(this.myAntClass);
        if (introspector == null) {
            return true;
        }
        String expectedName = ResolveUtil.getNameHint(processor);
        PsiClassType mapType = TypesUtil.createType("java.util.LinkedHashMap", (PsiElement)this.myFile);
        PsiClassType stringType = TypesUtil.createType("java.lang.String", (PsiElement)this.myFile);
        PsiClassType closureType = TypesUtil.createType("groovy.lang.Closure", (PsiElement)this.myFile);
        for (String name : Collections.list(introspector.getNestedElements())) {
            if (expectedName != null && !expectedName.equals(name)) continue;
            Class antClass = introspector.getElementType(name);
            for (LightMethodBuilder method : AntBuilderMethod.methods(this.myFile, name, antClass, (PsiType)mapType, (PsiType)stringType, (PsiType)closureType)) {
                if (processor.execute((PsiElement)method, ResolveState.initial())) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    static List<LightMethodBuilder> methods(@NotNull PsiFile file, @NotNull String name, @Nullable Class<?> antClass, @NotNull PsiType mapType, @NotNull PsiType stringType, @NotNull PsiType closureType) {
        if (file == null) {
            AntBuilderMethod.$$$reportNull$$$0(4);
        }
        if (name == null) {
            AntBuilderMethod.$$$reportNull$$$0(5);
        }
        if (mapType == null) {
            AntBuilderMethod.$$$reportNull$$$0(6);
        }
        if (stringType == null) {
            AntBuilderMethod.$$$reportNull$$$0(7);
        }
        if (closureType == null) {
            AntBuilderMethod.$$$reportNull$$$0(8);
        }
        AntBuilderMethod method = new AntBuilderMethod(file, name, antClass);
        method.addParameter(new GrLightParameter("args", mapType, (PsiElement)method));
        method.addParameter(new GrLightParameter("singleArg", stringType, (PsiElement)method));
        method.addParameter(new GrLightParameter("body", closureType, (PsiElement)method).setOptional(true));
        AntBuilderMethod method2 = new AntBuilderMethod(file, name, antClass);
        method2.addParameter(new GrLightParameter("args", mapType, (PsiElement)method2));
        method2.addParameter(new GrLightParameter("body", closureType, (PsiElement)method2).setOptional(true));
        AntBuilderMethod method3 = new AntBuilderMethod(file, name, antClass);
        method3.addParameter(new GrLightParameter("singleArg", stringType, (PsiElement)method3));
        method3.addParameter(new GrLightParameter("body", closureType, (PsiElement)method3).setOptional(true));
        AntBuilderMethod method4 = new AntBuilderMethod(file, name, antClass);
        method4.addParameter(new GrLightParameter("body", closureType, (PsiElement)method4).setOptional(true));
        List<LightMethodBuilder> list = Arrays.asList(new LightMethodBuilder[]{method, method2, method3, method4});
        if (list == null) {
            AntBuilderMethod.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/gant/ant/AntBuilderMethod";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closureType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/gant/ant/AntBuilderMethod";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "methods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "methods";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 9 -> new IllegalStateException(string);
        };
    }
}

