/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.exception;

import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.exception.GrExceptionUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public final class GroovyEmptyCatchBlockInspection
extends BaseInspection {
    public boolean myIgnore = true;
    public boolean myCountCommentsAsContent = true;
    @NlsSafe
    private static final String NEW_NAME = "ignored";

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    @Override
    @NotNull
    public OptPane getGroovyOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"myCountCommentsAsContent", (String)GroovyBundle.message("comments.count.as.content", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"myIgnore", (String)GroovyBundle.message("ignore.when.catch.parameter.is.named.ignore.or.ignored", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            GroovyEmptyCatchBlockInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/exception/GroovyEmptyCatchBlockInspection", "getGroovyOptionsPane"));
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitCatchClause(@NotNull GrCatchClause catchClause) {
            LocalQuickFix[] localQuickFixArray;
            if (catchClause == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitCatchClause(catchClause);
            GrOpenBlock body = catchClause.getBody();
            if (body == null || !this.isEmpty(body)) {
                return;
            }
            GrParameter parameter = catchClause.getParameter();
            if (parameter == null) {
                return;
            }
            if (GroovyEmptyCatchBlockInspection.this.myIgnore && GrExceptionUtil.ignore(parameter)) {
                return;
            }
            LocalQuickFixAndIntentionActionOnPsiElement fix = QuickFixFactory.getInstance().createRenameElementFix((PsiNamedElement)parameter, GroovyEmptyCatchBlockInspection.NEW_NAME);
            if (GroovyEmptyCatchBlockInspection.this.myIgnore) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = fix;
            } else {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            this.registerError(catchClause.getFirstChild(), GroovyBundle.message("inspection.message.empty.ref.block", new Object[0]), fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }

        private boolean isEmpty(@NotNull GrOpenBlock body) {
            PsiElement next;
            PsiElement brace;
            GrStatement[] statements2;
            if (body == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if ((statements2 = body.getStatements()).length != 0) {
                return false;
            }
            return !GroovyEmptyCatchBlockInspection.this.myCountCommentsAsContent || (brace = body.getLBrace()) == null || !((next = PsiUtil.skipWhitespaces(brace.getNextSibling(), true)) instanceof PsiComment);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "catchClause";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "body";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/exception/GroovyEmptyCatchBlockInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCatchClause";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEmpty";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

