/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.AnnotationFixRegistrar;
import org.jetbrains.plugins.groovy.annotator.GrReferenceHighlighterFactory;
import org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess.ReferenceFixesKt;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GroovyDocPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStaticChecker;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u000f"}, d2={"illegalJvmNameSymbols", "Lkotlin/text/Regex;", "getIllegalJvmNameSymbols", "()Lkotlin/text/Regex;", "checkInnerClassReferenceFromInstanceContext", "", "ref", "Lorg/jetbrains/plugins/groovy/lang/psi/api/types/GrCodeReferenceElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "checkUnresolvedCodeReference", "annotationHolder", "isResolvedStaticImport", "", "refElement", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\nimpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 impl.kt\norg/jetbrains/plugins/groovy/annotator/ImplKt\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n66#2,2:80\n1855#3,2:82\n1855#3,2:84\n*S KotlinDebug\n*F\n+ 1 impl.kt\norg/jetbrains/plugins/groovy/annotator/ImplKt\n*L\n29#1:80,2\n40#1:82,2\n41#1:84,2\n*E\n"})
public final class ImplKt {
    @NotNull
    private static final Regex illegalJvmNameSymbols = new Regex("[.;\\[/<>]");

    public static final void checkUnresolvedCodeReference(@NotNull GrCodeReferenceElement ref2, @NotNull AnnotationHolder annotationHolder) {
        IntentionAction it;
        Intrinsics.checkNotNullParameter((Object)ref2, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)annotationHolder, (String)"annotationHolder");
        if (!GrReferenceHighlighterFactory.shouldHighlight(annotationHolder.getCurrentAnnotationSession().getFile())) {
            return;
        }
        PsiElement $this$parentOfType_u24default$iv = ref2;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        if (PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, GroovyDocPsiElement.class, (boolean)true) != null) {
            return;
        }
        if (ref2.getParent() instanceof GrPackageDefinition) {
            return;
        }
        PsiElement psiElement = ref2.getReferenceNameElement();
        if (psiElement == null) {
            return;
        }
        PsiElement nameElement = psiElement;
        String string = ref2.getReferenceName();
        if (string == null) {
            return;
        }
        String referenceName = string;
        if (ImplKt.isResolvedStaticImport(ref2)) {
            return;
        }
        if (ref2.resolve() != null) {
            return;
        }
        Object[] objectArray = new Object[]{referenceName};
        AnnotationBuilder annotationBuilder = annotationHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("cannot.resolve", objectArray)).range(nameElement).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        Intrinsics.checkNotNullExpressionValue((Object)annotationBuilder, (String)"highlightType(...)");
        AnnotationBuilder builder = annotationBuilder;
        Iterable $this$forEach$iv = ReferenceFixesKt.generateCreateClassActions(ref2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IntentionAction)element$iv;
            boolean bl = false;
            builder.withFix(it);
        }
        $this$forEach$iv = ReferenceFixesKt.generateAddImportActions(ref2);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IntentionAction)element$iv;
            boolean bl = false;
            builder.withFix(it);
        }
        AnnotationFixRegistrar fixRegistrar = new AnnotationFixRegistrar(builder);
        UnresolvedReferenceQuickFixProvider.registerReferenceFixes((PsiReference)((PsiReference)ref2), (QuickFixActionRegistrar)fixRegistrar);
        ArrayList registrar2 = new ArrayList();
        QuickFixFactory.getInstance().registerOrderEntryFixes((PsiReference)ref2, (List)registrar2);
        for (IntentionAction fix : registrar2) {
            Intrinsics.checkNotNull((Object)fix);
            fixRegistrar.register(fix);
        }
        builder.create();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isResolvedStaticImport(GrCodeReferenceElement refElement) {
        PsiElement parent2 = refElement.getParent();
        if (!(parent2 instanceof GrImportStatement)) return false;
        if (!((GrImportStatement)parent2).isStatic()) return false;
        GroovyResolveResult[] groovyResolveResultArray = refElement.multiResolve(false);
        Intrinsics.checkNotNullExpressionValue((Object)groovyResolveResultArray, (String)"multiResolve(...)");
        if (((Object[])groovyResolveResultArray).length != 0) return true;
        return false;
    }

    public static final void checkInnerClassReferenceFromInstanceContext(@NotNull GrCodeReferenceElement ref2, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)ref2, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiElement psiElement = ref2.getReferenceNameElement();
        if (psiElement == null) {
            return;
        }
        PsiElement nameElement = psiElement;
        PsiElement parent2 = ref2.getParent();
        if (!(parent2 instanceof GrNewExpression) || PsiImplUtil.hasArguments((GrCall)parent2)) {
            return;
        }
        if (!GrStaticChecker.isInStaticContext(ref2)) {
            return;
        }
        PsiElement psiElement2 = ref2.resolve();
        PsiClass psiClass = psiElement2 instanceof PsiClass ? (PsiClass)psiElement2 : null;
        if (psiClass == null) {
            return;
        }
        PsiClass resolved = psiClass;
        if (!com.intellij.psi.util.PsiUtil.isInnerClass((PsiClass)resolved)) {
            return;
        }
        String string = resolved.getQualifiedName();
        if (string == null) {
            return;
        }
        String qname = string;
        PsiClass psiClass2 = resolved.getContainingClass();
        if (psiClass2 == null) {
            return;
        }
        PsiClass outerClass = psiClass2;
        if (PsiUtil.hasEnclosingInstanceInScope(outerClass, parent2, true)) {
            return;
        }
        Object[] objectArray = new Object[]{qname};
        holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("cannot.reference.non.static", objectArray)).range(nameElement).create();
    }

    @NotNull
    public static final Regex getIllegalJvmNameSymbols() {
        return illegalJvmNameSymbols;
    }
}

