/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.inspections;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.uiDesigner.inspections.BaseFormInspection;
import com.intellij.uiDesigner.inspections.FormErrorCollector;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IContainer;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.lw.ITabbedPane;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.propertyInspector.properties.BorderProperty;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class StringDescriptorInspection
extends BaseFormInspection {
    private static final NotNullLazyValue<BorderProperty> myBorderProperty = NotNullLazyValue.lazy(() -> new BorderProperty(null));

    public StringDescriptorInspection(@NonNls String inspectionKey) {
        super(inspectionKey);
    }

    @Override
    protected void checkComponentProperties(Module module2, @NotNull IComponent component, FormErrorCollector collector) {
        IContainer descriptor2;
        IContainer container;
        StringDescriptor descriptor2;
        if (component == null) {
            StringDescriptorInspection.$$$reportNull$$$0(0);
        }
        for (IProperty prop : component.getModifiedProperties()) {
            Object propValue = prop.getPropertyValue(component);
            if (!(propValue instanceof StringDescriptor)) continue;
            StringDescriptor descriptor3 = (StringDescriptor)propValue;
            this.checkStringDescriptor(module2, component, prop, descriptor3, collector);
        }
        if (component instanceof IContainer && (descriptor2 = (container = (IContainer)component).getBorderTitle()) != null) {
            this.checkStringDescriptor(module2, component, (IProperty)myBorderProperty.getValue(), descriptor2, collector);
        }
        if ((descriptor2 = component.getParentContainer()) instanceof ITabbedPane) {
            ITabbedPane parentTabbedPane = (ITabbedPane)descriptor2;
            if ((descriptor2 = parentTabbedPane.getTabProperty(component, "Tab Title")) != null) {
                this.checkStringDescriptor(module2, component, MockTabTitleProperty.INSTANCE, (StringDescriptor)descriptor2, collector);
            }
            if ((descriptor2 = parentTabbedPane.getTabProperty(component, "Tab Tooltip")) != null) {
                this.checkStringDescriptor(module2, component, MockTabToolTipProperty.INSTANCE, (StringDescriptor)descriptor2, collector);
            }
        }
    }

    protected abstract void checkStringDescriptor(Module var1, IComponent var2, IProperty var3, StringDescriptor var4, FormErrorCollector var5);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/uiDesigner/inspections/StringDescriptorInspection", "checkComponentProperties"));
    }

    private static class MockTabTitleProperty
    implements IProperty {
        public static MockTabTitleProperty INSTANCE = new MockTabTitleProperty();

        private MockTabTitleProperty() {
        }

        public String getName() {
            return "Tab Title";
        }

        public Object getPropertyValue(IComponent component) {
            return null;
        }
    }

    private static class MockTabToolTipProperty
    implements IProperty {
        public static MockTabToolTipProperty INSTANCE = new MockTabToolTipProperty();

        private MockTabToolTipProperty() {
        }

        public String getName() {
            return "Tab Tooltip";
        }

        public Object getPropertyValue(IComponent component) {
            return null;
        }
    }
}

