/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.inspections;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.core.SupportCode;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.inspections.AssignMnemonicFix;
import com.intellij.uiDesigner.inspections.BaseFormInspection;
import com.intellij.uiDesigner.inspections.EditorQuickFixProvider;
import com.intellij.uiDesigner.inspections.FormErrorCollector;
import com.intellij.uiDesigner.inspections.FormInspectionUtil;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.quickFixes.QuickFix;
import com.intellij.uiDesigner.radComponents.RadComponent;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public final class MissingMnemonicInspection
extends BaseFormInspection {
    public MissingMnemonicInspection() {
        super("MissingMnemonic");
    }

    @Override
    protected void checkComponentProperties(Module module2, @NotNull IComponent component, FormErrorCollector collector) {
        String value;
        if (component == null) {
            MissingMnemonicInspection.$$$reportNull$$$0(0);
        }
        if ((value = FormInspectionUtil.getText(module2, component)) == null) {
            return;
        }
        IProperty textProperty = FormInspectionUtil.findProperty(component, "text");
        SupportCode.TextWithMnemonic twm = SupportCode.parseText((String)value);
        if (twm.myMnemonicIndex < 0 && !twm.myText.isEmpty()) {
            IProperty labelForProperty;
            if (FormInspectionUtil.isComponentClass(module2, component, AbstractButton.class)) {
                collector.addError(this.getID(), component, textProperty, UIDesignerBundle.message("inspection.missing.mnemonics.message", value), new MyEditorQuickFixProvider());
            } else if (FormInspectionUtil.isComponentClass(module2, component, JLabel.class) && (labelForProperty = FormInspectionUtil.findProperty(component, "labelFor")) != null && !StringUtil.isEmpty((String)((String)labelForProperty.getPropertyValue(component)))) {
                collector.addError(this.getID(), component, textProperty, UIDesignerBundle.message("inspection.missing.mnemonics.message", value), new MyEditorQuickFixProvider());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/uiDesigner/inspections/MissingMnemonicInspection", "checkComponentProperties"));
    }

    private static class MyEditorQuickFixProvider
    implements EditorQuickFixProvider {
        private MyEditorQuickFixProvider() {
        }

        @Override
        @NotNull
        public QuickFix createQuickFix(GuiEditor editor, @NotNull RadComponent component) {
            if (component == null) {
                MyEditorQuickFixProvider.$$$reportNull$$$0(0);
            }
            return new AssignMnemonicFix(editor, component, UIDesignerBundle.message("inspections.missing.mnemonic.quickfix", new Object[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/uiDesigner/inspections/MissingMnemonicInspection$MyEditorQuickFixProvider", "createQuickFix"));
        }
    }
}

