/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.designSurface;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.lw.IRootContainer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.util.concurrency.AppExecutorUtil;
import icons.UIDesignerIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.swing.JButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListenerNavigateButton
extends JButton
implements ActionListener {
    private static final Logger LOG = Logger.getInstance(ListenerNavigateButton.class);
    private final RadComponent myComponent;

    public ListenerNavigateButton(RadComponent component) {
        this.myComponent = component;
        this.setIcon(UIDesignerIcons.Listener);
        this.setOpaque(false);
        this.setFocusable(false);
        this.setBorderPainted(false);
        this.setSize(new Dimension(this.getIcon().getIconWidth(), this.getIcon().getIconHeight()));
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ListenerNavigateButton.showNavigatePopup(this.myComponent, false);
    }

    public static void showNavigatePopup(RadComponent component, boolean showIfEmpty) {
        ReadAction.nonBlocking(() -> ListenerNavigateButton.prepareActionGroup(component)).finishOnUiThread(ModalityState.nonModal(), actionGroup -> {
            if (actionGroup != null && actionGroup.getChildrenCount() == 0 && showIfEmpty) {
                actionGroup.add((AnAction)new MyNavigateAction(UIDesignerBundle.message("navigate.to.listener.empty", new Object[0]), null));
            }
            if (actionGroup != null && actionGroup.getChildrenCount() > 0) {
                DataContext context = DataManager.getInstance().getDataContext((Component)component.getDelegee());
                JBPopupFactory factory = JBPopupFactory.getInstance();
                ListPopup popup = factory.createActionGroupPopup(UIDesignerBundle.message("navigate.to.listener.title", new Object[0]), (ActionGroup)actionGroup, context, JBPopupFactory.ActionSelectionAid.NUMBERING, true);
                FormEditingUtil.showPopupUnderComponent((JBPopup)popup, component);
            }
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    @Nullable
    public static DefaultActionGroup prepareActionGroup(RadComponent component) {
        PsiField boundField;
        PsiClass aClass;
        String classToBind;
        IRootContainer root = FormEditingUtil.getRoot(component);
        String string = classToBind = root == null ? null : root.getClassToBind();
        if (classToBind != null && (aClass = FormEditingUtil.findClassToBind(component.getModule(), classToBind)) != null && (boundField = aClass.findFieldByName(component.getBinding(), false)) != null) {
            return ListenerNavigateButton.buildNavigateActionGroup(component, boundField);
        }
        return null;
    }

    private static DefaultActionGroup buildNavigateActionGroup(RadComponent component, PsiField boundField) {
        EventSetDescriptor[] eventSetDescriptors;
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(component.getComponentClass());
            eventSetDescriptors = beanInfo.getEventSetDescriptors();
        }
        catch (IntrospectionException e) {
            LOG.error((Throwable)e);
            return null;
        }
        PsiFile boundClassFile = boundField.getContainingFile();
        if (boundClassFile == null) {
            return null;
        }
        LocalSearchScope scope = new LocalSearchScope((PsiElement)boundClassFile);
        ReferencesSearch.search((PsiElement)boundField, (SearchScope)scope).forEach(ref -> {
            PsiReferenceExpression refExpr;
            PsiElement patt4776$temp;
            PsiElement element = ref.getElement();
            PsiElement patt4699$temp = element.getParent();
            if (patt4699$temp instanceof PsiReferenceExpression && (patt4776$temp = (refExpr = (PsiReferenceExpression)patt4699$temp).getParent()) instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCall = (PsiMethodCallExpression)patt4776$temp;
                PsiElement psiElement = refExpr.resolve();
                if (psiElement instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)psiElement;
                    for (EventSetDescriptor eventSetDescriptor : eventSetDescriptors) {
                        if (!Objects.equals(eventSetDescriptor.getAddListenerMethod().getName(), method.getName())) continue;
                        String eventName = eventSetDescriptor.getName();
                        PsiExpression[] args = methodCall.getArgumentList().getExpressions();
                        if (args.length <= 0) continue;
                        ListenerNavigateButton.addListenerRef(actionGroup, eventName, args[0]);
                    }
                }
            }
            return true;
        });
        return actionGroup;
    }

    private static void addListenerRef(DefaultActionGroup actionGroup, String eventName, PsiExpression listenerArg) {
        PsiClass listenerClass;
        PsiType type = listenerArg.getType();
        if (type instanceof PsiClassType && (listenerClass = ((PsiClassType)type).resolve()) != null) {
            PsiCodeBlock codeBlock;
            PsiElement[] defs;
            PsiElement psiElement;
            if (!ListenerNavigateButton.isAbstractOrInterface(listenerClass)) {
                actionGroup.add((AnAction)new MyNavigateAction(eventName + ": " + ClassPresentationUtil.getNameForClass((PsiClass)listenerClass, (boolean)false), (PsiElement)listenerClass));
                return;
            }
            if (listenerArg instanceof PsiReferenceExpression && (psiElement = ((PsiReferenceExpression)listenerArg).resolve()) instanceof PsiVariable && (defs = DefUseUtil.getDefs((PsiCodeBlock)(codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)listenerArg, PsiCodeBlock.class)), (PsiVariable)((PsiVariable)psiElement), (PsiElement)listenerArg)).length == 1) {
                PsiElement def = defs[0];
                if (def instanceof PsiVariable) {
                    PsiVariable var = (PsiVariable)def;
                    if (var.getInitializer() != listenerArg) {
                        ListenerNavigateButton.addListenerRef(actionGroup, eventName, var.getInitializer());
                        return;
                    }
                } else {
                    PsiAssignmentExpression assignmentExpr;
                    PsiElement psiElement2 = def.getParent();
                    if (psiElement2 instanceof PsiAssignmentExpression && def.equals((assignmentExpr = (PsiAssignmentExpression)psiElement2).getLExpression())) {
                        ListenerNavigateButton.addListenerRef(actionGroup, eventName, assignmentExpr.getRExpression());
                        return;
                    }
                }
            }
        }
        actionGroup.add((AnAction)new MyNavigateAction(eventName + ": " + listenerArg.getText(), (PsiElement)listenerArg));
    }

    private static boolean isAbstractOrInterface(PsiClass element) {
        return element.isInterface() || element.hasModifierProperty("abstract");
    }

    private static class MyNavigateAction
    extends AnAction {
        private final PsiElement myElement;

        MyNavigateAction(@NlsSafe String name, PsiElement element) {
            super(name);
            this.myElement = element;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyNavigateAction.$$$reportNull$$$0(0);
            }
            if (this.myElement instanceof Navigatable) {
                ((Navigatable)this.myElement).navigate(true);
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MyNavigateAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyNavigateAction.$$$reportNull$$$0(2);
            }
            e.getPresentation().setEnabled(this.myElement != null && (!(this.myElement instanceof PsiClass) || !ListenerNavigateButton.isAbstractOrInterface((PsiClass)this.myElement)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/uiDesigner/designSurface/ListenerNavigateButton$MyNavigateAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/uiDesigner/designSurface/ListenerNavigateButton$MyNavigateAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

