/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui.component;

import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.GithubErrorMessage;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;
import org.jetbrains.plugins.github.i18n.GithubBundle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/github/ui/component/GHHtmlErrorPanel;", "", "()V", "getLoadingErrorText", "", "error", "", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHHtmlErrorPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHHtmlErrorPanel.kt\norg/jetbrains/plugins/github/ui/component/GHHtmlErrorPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,41:1\n1549#2:42\n1620#2,3:43\n*S KotlinDebug\n*F\n+ 1 GHHtmlErrorPanel.kt\norg/jetbrains/plugins/github/ui/component/GHHtmlErrorPanel\n*L\n25#1:42\n25#1:43,3\n*E\n"})
public final class GHHtmlErrorPanel {
    @NotNull
    public static final GHHtmlErrorPanel INSTANCE = new GHHtmlErrorPanel();

    private GHHtmlErrorPanel() {
    }

    /*
     * WARNING - void declaration
     */
    @Nls
    @NotNull
    public final String getLoadingErrorText(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if (error instanceof GithubStatusCodeException && ((GithubStatusCodeException)error).getError() != null) {
            GithubErrorMessage githubErrorMessage = ((GithubStatusCodeException)error).getError();
            Intrinsics.checkNotNull((Object)githubErrorMessage);
            if (githubErrorMessage.getMessage() != null) {
                List list;
                GithubErrorMessage githubErrorMessage2 = ((GithubStatusCodeException)error).getError();
                Intrinsics.checkNotNull((Object)githubErrorMessage2);
                GithubErrorMessage githubError = githubErrorMessage2;
                String string = githubError.getMessage();
                Intrinsics.checkNotNull((Object)string);
                String message2 = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)string, (CharSequence)"["), (CharSequence)"]");
                HtmlBuilder builder = new HtmlBuilder().append(message2);
                if (StringsKt.startsWith((String)message2, (String)"Could not resolve to a Repository", (boolean)true)) {
                    String explanation = " Either repository doesn't exist or you don't have access. The most probable cause is that OAuth App access restrictions are enabled in organization.";
                    builder.append(explanation);
                }
                List<GithubErrorMessage.Error> list2 = githubError.getErrors();
                if (list2 != null) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = list2;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void e;
                        GithubErrorMessage.Error error2 = (GithubErrorMessage.Error)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        String string2 = e.getMessage();
                        if (string2 == null) {
                            Object[] objectArray = new Object[3];
                            objectArray[0] = e.getCode();
                            objectArray[1] = e.getResource();
                            String string3 = e.getField();
                            if (string3 == null) {
                                string3 = "";
                            }
                            objectArray[2] = string3;
                            string2 = GithubBundle.message("gql.error.in.field", objectArray);
                        }
                        collection.add(HtmlChunk.text((String)string2));
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = null;
                }
                List errors = list;
                Collection collection = errors;
                if (!(collection == null || collection.isEmpty())) {
                    builder.append(": ").append((HtmlChunk)HtmlChunk.br()).appendWithSeparators((HtmlChunk)HtmlChunk.br(), (Iterable)errors);
                }
                String string4 = builder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                return string4;
            }
        }
        if (error instanceof UnknownHostException) {
            Object[] objectArray = new Object[]{error.getMessage()};
            String string = GithubBundle.message("unknown.host.error", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        String string = error.getMessage();
        if (string == null) {
            String string5 = GithubBundle.message("unknown.loading.error", new Object[0]);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        }
        return string;
    }
}

