/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.selector;

import com.intellij.collaboration.auth.ServerAccount;
import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.collaboration.ui.ExceptionUtil;
import com.intellij.collaboration.ui.codereview.list.error.ErrorStatusPresenter;
import com.intellij.openapi.project.Project;
import git4idea.remote.hosting.ui.RepositoryAndAccountSelectorViewModel;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.authentication.AuthorizationType;
import org.jetbrains.plugins.github.authentication.GHAccountAuthData;
import org.jetbrains.plugins.github.authentication.GHAccountsUtil;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/selector/GHSelectorErrorStatusPresenter;", "Lcom/intellij/collaboration/ui/codereview/list/error/ErrorStatusPresenter$Text;", "Lgit4idea/remote/hosting/ui/RepositoryAndAccountSelectorViewModel$Error;", "project", "Lcom/intellij/openapi/project/Project;", "resetAction", "Lkotlin/Function0;", "", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;)V", "getErrorAction", "Ljavax/swing/Action;", "error", "getErrorDescription", "", "getErrorTitle", "LogInAgain", "intellij.vcs.github"})
public final class GHSelectorErrorStatusPresenter
implements ErrorStatusPresenter.Text<RepositoryAndAccountSelectorViewModel.Error> {
    @NotNull
    private final Project project;
    @NotNull
    private final Function0<Unit> resetAction;

    public GHSelectorErrorStatusPresenter(@NotNull Project project, @NotNull Function0<Unit> resetAction) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(resetAction, (String)"resetAction");
        this.project = project;
        this.resetAction = resetAction;
    }

    public /* synthetic */ GHSelectorErrorStatusPresenter(Project project, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function0 = 1.INSTANCE;
        }
        this(project, (Function0<Unit>)function0);
    }

    @NotNull
    public String getErrorTitle(@NotNull RepositoryAndAccountSelectorViewModel.Error error) {
        String string;
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        RepositoryAndAccountSelectorViewModel.Error error2 = error;
        if (error2 instanceof RepositoryAndAccountSelectorViewModel.Error.SubmissionError) {
            Object[] objectArray = new Object[]{((RepositoryAndAccountSelectorViewModel.Error.SubmissionError)error).getRepo().getRepository(), ((RepositoryAndAccountSelectorViewModel.Error.SubmissionError)error).getAccount()};
            String string2 = CollaborationToolsBundle.message((String)"review.list.connection.failed.repository.account", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            string = string2;
        } else if (error2 instanceof RepositoryAndAccountSelectorViewModel.Error.MissingCredentials) {
            String string3 = CollaborationToolsBundle.message((String)"review.list.connection.failed", (Object[])new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public String getErrorDescription(@NotNull RepositoryAndAccountSelectorViewModel.Error error) {
        String string;
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        RepositoryAndAccountSelectorViewModel.Error error2 = error;
        if (error2 instanceof RepositoryAndAccountSelectorViewModel.Error.SubmissionError) {
            string = ExceptionUtil.INSTANCE.getPresentableMessage(((RepositoryAndAccountSelectorViewModel.Error.SubmissionError)error).getException());
        } else if (error2 instanceof RepositoryAndAccountSelectorViewModel.Error.MissingCredentials) {
            String string2 = CollaborationToolsBundle.message((String)"account.token.missing", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @Nullable
    public Action getErrorAction(@NotNull RepositoryAndAccountSelectorViewModel.Error error) {
        Action action2;
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if (error instanceof RepositoryAndAccountSelectorViewModel.Error.SubmissionError) {
            ServerAccount serverAccount = ((RepositoryAndAccountSelectorViewModel.Error.SubmissionError)error).getAccount();
            Intrinsics.checkNotNull((Object)serverAccount, (String)"null cannot be cast to non-null type org.jetbrains.plugins.github.authentication.accounts.GithubAccount");
            action2 = new LogInAgain(this.project, (GithubAccount)serverAccount, this.resetAction);
        } else {
            action2 = null;
        }
        return action2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/selector/GHSelectorErrorStatusPresenter$LogInAgain;", "Ljavax/swing/AbstractAction;", "project", "Lcom/intellij/openapi/project/Project;", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "resetAction", "Lkotlin/Function0;", "", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;Lkotlin/jvm/functions/Function0;)V", "actionPerformed", "event", "Ljava/awt/event/ActionEvent;", "intellij.vcs.github"})
    private static final class LogInAgain
    extends AbstractAction {
        @NotNull
        private final Project project;
        @NotNull
        private final GithubAccount account;
        @NotNull
        private final Function0<Unit> resetAction;

        public LogInAgain(@NotNull Project project, @NotNull GithubAccount account, @NotNull Function0<Unit> resetAction) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
            Intrinsics.checkNotNullParameter(resetAction, (String)"resetAction");
            super(CollaborationToolsBundle.message((String)"login.again.action.text", (Object[])new Object[0]));
            this.project = project;
            this.account = account;
            this.resetAction = resetAction;
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Object object = event.getSource();
            JComponent jComponent = object instanceof JComponent ? (JComponent)object : null;
            if (jComponent == null) {
                return;
            }
            JComponent parentComponent = jComponent;
            GHAccountAuthData authData = GHAccountsUtil.requestReLogin(this.account, this.project, parentComponent, AuthorizationType.UNDEFINED);
            if (authData != null) {
                this.resetAction.invoke();
            }
        }
    }
}

