/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data;

import com.intellij.collaboration.ui.html.AsyncHtmlImageLoader;
import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHReactionContent;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.pullrequest.data.GHListLoader;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataProviderRepository;
import org.jetbrains.plugins.github.pullrequest.data.GHPRFilesManager;
import org.jetbrains.plugins.github.pullrequest.data.GHPRListLoader;
import org.jetbrains.plugins.github.pullrequest.data.GHPRListUpdatesChecker;
import org.jetbrains.plugins.github.pullrequest.data.GHReactionsService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRChangesService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRCreationService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRDetailsService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRPersistentInteractionState;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRRepositoryDataService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRSecurityService;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B\u008d\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0010\u0010\u0018\u001a\f\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001b\u0012\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0019\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\u0006\u0010 \u001a\u00020!\u00a2\u0006\u0002\u0010\"R\u001b\u0010\u0018\u001a\f\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0013\u00107\u001a\u000708\u00a2\u0006\u0002\b9X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010$R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010B\u00a8\u0006C"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContext;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "listLoader", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRListLoader;", "listUpdatesChecker", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRListUpdatesChecker;", "dataProviderRepository", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataProviderRepository;", "securityService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;", "repositoryDataService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;", "creationService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRCreationService;", "detailsService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRDetailsService;", "changesService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRChangesService;", "reactionsService", "Lorg/jetbrains/plugins/github/pullrequest/data/GHReactionsService;", "htmlImageLoader", "Lcom/intellij/collaboration/ui/html/AsyncHtmlImageLoader;", "avatarIconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "reactionIconsProvider", "Lorg/jetbrains/plugins/github/api/data/GHReactionContent;", "filesManager", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRFilesManager;", "interactionState", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRPersistentInteractionState;", "(Lkotlinx/coroutines/CoroutineScope;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRListLoader;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRListUpdatesChecker;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataProviderRepository;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRCreationService;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRDetailsService;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRChangesService;Lorg/jetbrains/plugins/github/pullrequest/data/GHReactionsService;Lcom/intellij/collaboration/ui/html/AsyncHtmlImageLoader;Lcom/intellij/collaboration/ui/icon/IconsProvider;Lcom/intellij/collaboration/ui/icon/IconsProvider;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRFilesManager;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRPersistentInteractionState;)V", "getAvatarIconsProvider", "()Lcom/intellij/collaboration/ui/icon/IconsProvider;", "getChangesService", "()Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRChangesService;", "getCreationService", "()Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRCreationService;", "getDataProviderRepository", "()Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataProviderRepository;", "getDetailsService", "()Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRDetailsService;", "getFilesManager", "()Lorg/jetbrains/plugins/github/pullrequest/data/GHPRFilesManager;", "getHtmlImageLoader", "()Lcom/intellij/collaboration/ui/html/AsyncHtmlImageLoader;", "getInteractionState", "()Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRPersistentInteractionState;", "getListLoader", "()Lorg/jetbrains/plugins/github/pullrequest/data/GHPRListLoader;", "getListUpdatesChecker", "()Lorg/jetbrains/plugins/github/pullrequest/data/GHPRListUpdatesChecker;", "listenersDisposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "getReactionIconsProvider", "getReactionsService", "()Lorg/jetbrains/plugins/github/pullrequest/data/GHReactionsService;", "getRepositoryDataService", "()Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "getSecurityService", "()Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;", "intellij.vcs.github"})
public final class GHPRDataContext {
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final GHPRListLoader listLoader;
    @NotNull
    private final GHPRListUpdatesChecker listUpdatesChecker;
    @NotNull
    private final GHPRDataProviderRepository dataProviderRepository;
    @NotNull
    private final GHPRSecurityService securityService;
    @NotNull
    private final GHPRRepositoryDataService repositoryDataService;
    @NotNull
    private final GHPRCreationService creationService;
    @NotNull
    private final GHPRDetailsService detailsService;
    @NotNull
    private final GHPRChangesService changesService;
    @NotNull
    private final GHReactionsService reactionsService;
    @NotNull
    private final AsyncHtmlImageLoader htmlImageLoader;
    @NotNull
    private final IconsProvider<String> avatarIconsProvider;
    @NotNull
    private final IconsProvider<GHReactionContent> reactionIconsProvider;
    @NotNull
    private final GHPRFilesManager filesManager;
    @NotNull
    private final GHPRPersistentInteractionState interactionState;
    @NotNull
    private final Disposable listenersDisposable;

    public GHPRDataContext(@NotNull CoroutineScope scope, @NotNull GHPRListLoader listLoader, @NotNull GHPRListUpdatesChecker listUpdatesChecker, @NotNull GHPRDataProviderRepository dataProviderRepository2, @NotNull GHPRSecurityService securityService, @NotNull GHPRRepositoryDataService repositoryDataService, @NotNull GHPRCreationService creationService, @NotNull GHPRDetailsService detailsService, @NotNull GHPRChangesService changesService, @NotNull GHReactionsService reactionsService, @NotNull AsyncHtmlImageLoader htmlImageLoader, @NotNull IconsProvider<String> avatarIconsProvider, @NotNull IconsProvider<GHReactionContent> reactionIconsProvider, @NotNull GHPRFilesManager filesManager, @NotNull GHPRPersistentInteractionState interactionState) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)listLoader, (String)"listLoader");
        Intrinsics.checkNotNullParameter((Object)listUpdatesChecker, (String)"listUpdatesChecker");
        Intrinsics.checkNotNullParameter((Object)dataProviderRepository2, (String)"dataProviderRepository");
        Intrinsics.checkNotNullParameter((Object)securityService, (String)"securityService");
        Intrinsics.checkNotNullParameter((Object)repositoryDataService, (String)"repositoryDataService");
        Intrinsics.checkNotNullParameter((Object)creationService, (String)"creationService");
        Intrinsics.checkNotNullParameter((Object)detailsService, (String)"detailsService");
        Intrinsics.checkNotNullParameter((Object)changesService, (String)"changesService");
        Intrinsics.checkNotNullParameter((Object)reactionsService, (String)"reactionsService");
        Intrinsics.checkNotNullParameter((Object)htmlImageLoader, (String)"htmlImageLoader");
        Intrinsics.checkNotNullParameter(avatarIconsProvider, (String)"avatarIconsProvider");
        Intrinsics.checkNotNullParameter(reactionIconsProvider, (String)"reactionIconsProvider");
        Intrinsics.checkNotNullParameter((Object)filesManager, (String)"filesManager");
        Intrinsics.checkNotNullParameter((Object)((Object)interactionState), (String)"interactionState");
        this.scope = scope;
        this.listLoader = listLoader;
        this.listUpdatesChecker = listUpdatesChecker;
        this.dataProviderRepository = dataProviderRepository2;
        this.securityService = securityService;
        this.repositoryDataService = repositoryDataService;
        this.creationService = creationService;
        this.detailsService = detailsService;
        this.changesService = changesService;
        this.reactionsService = reactionsService;
        this.htmlImageLoader = htmlImageLoader;
        this.avatarIconsProvider = avatarIconsProvider;
        this.reactionIconsProvider = reactionIconsProvider;
        this.filesManager = filesManager;
        this.interactionState = interactionState;
        Disposable disposable = Disposer.newDisposable((String)"GH PR context listeners disposable");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.listenersDisposable = disposable;
        this.listLoader.addDataListener(this.listenersDisposable, new GHListLoader.ListDataListener(){

            @Override
            public void onDataAdded(int startIdx) {
                this.getListUpdatesChecker().start();
            }

            @Override
            public void onAllDataRemoved() {
                this.getListUpdatesChecker().stop();
            }
        });
        this.dataProviderRepository.addDetailsLoadedListener(this.listenersDisposable, (Function1<? super GHPullRequest, Unit>)((Function1)new Function1<GHPullRequest, Unit>(){

            public final void invoke(final @NotNull GHPullRequest details2) {
                Intrinsics.checkNotNullParameter((Object)details2, (String)"details");
                this.getListLoader().updateData((Function1)new Function1<GHPullRequestShort, GHPullRequestShort>(){

                    @Nullable
                    public final GHPullRequestShort invoke(@NotNull GHPullRequestShort it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return Intrinsics.areEqual((Object)it.getId(), (Object)details2.getId()) ? (GHPullRequestShort)details2 : null;
                    }
                });
                this.getFilesManager().updateTimelineFilePresentation(details2);
            }
        }));
        BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain().getImmediate()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GHPRDataContext this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = DelayKt.awaitCancellation((Continuation)((Continuation)this));
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        Object object3;
                        try {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            object3 = $result;
                            throw new KotlinNothingValueException();
                        }
                        catch (Throwable throwable) {
                            Disposer.dispose((Disposable)this.this$0.getFilesManager());
                            Disposer.dispose((Disposable)this.this$0.listenersDisposable);
                            Disposer.dispose((Disposable)this.this$0.getDataProviderRepository());
                            Disposer.dispose((Disposable)this.this$0.getListLoader());
                            Disposer.dispose((Disposable)this.this$0.getListUpdatesChecker());
                            throw throwable;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @NotNull
    public final CoroutineScope getScope() {
        return this.scope;
    }

    @NotNull
    public final GHPRListLoader getListLoader() {
        return this.listLoader;
    }

    @NotNull
    public final GHPRListUpdatesChecker getListUpdatesChecker() {
        return this.listUpdatesChecker;
    }

    @NotNull
    public final GHPRDataProviderRepository getDataProviderRepository() {
        return this.dataProviderRepository;
    }

    @NotNull
    public final GHPRSecurityService getSecurityService() {
        return this.securityService;
    }

    @NotNull
    public final GHPRRepositoryDataService getRepositoryDataService() {
        return this.repositoryDataService;
    }

    @NotNull
    public final GHPRCreationService getCreationService() {
        return this.creationService;
    }

    @NotNull
    public final GHPRDetailsService getDetailsService() {
        return this.detailsService;
    }

    @NotNull
    public final GHPRChangesService getChangesService() {
        return this.changesService;
    }

    @NotNull
    public final GHReactionsService getReactionsService() {
        return this.reactionsService;
    }

    @NotNull
    public final AsyncHtmlImageLoader getHtmlImageLoader() {
        return this.htmlImageLoader;
    }

    @NotNull
    public final IconsProvider<String> getAvatarIconsProvider() {
        return this.avatarIconsProvider;
    }

    @NotNull
    public final IconsProvider<GHReactionContent> getReactionIconsProvider() {
        return this.reactionIconsProvider;
    }

    @NotNull
    public final GHPRFilesManager getFilesManager() {
        return this.filesManager;
    }

    @NotNull
    public final GHPRPersistentInteractionState getInteractionState() {
        return this.interactionState;
    }
}

