/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Appender;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransConfiguration;
import org.pentaho.di.www.SocketPortAllocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationMap {
    private Map<String, Trans> transformationMap = new Hashtable<String, Trans>();
    private Map<String, TransConfiguration> configurationMap = new Hashtable<String, TransConfiguration>();
    private Map<String, Appender> loggingMap = new Hashtable<String, Appender>();
    private Map<String, List<SocketPortAllocation>> hostServerSocketPortsMap = new Hashtable<String, List<SocketPortAllocation>>();

    public TransformationMap(String parentThreadName) {
        this();
    }

    public TransformationMap() {
    }

    public synchronized void addTransformation(String transformationName, Trans trans, TransConfiguration transConfiguration) {
        this.transformationMap.put(transformationName, trans);
        this.configurationMap.put(transformationName, transConfiguration);
    }

    public synchronized Trans getTransformation(String transformationName) {
        return this.transformationMap.get(transformationName);
    }

    public synchronized TransConfiguration getConfiguration(String transformationName) {
        return this.configurationMap.get(transformationName);
    }

    public synchronized void removeTransformation(String transformationName) {
        this.transformationMap.remove(transformationName);
        this.configurationMap.remove(transformationName);
    }

    public synchronized Appender getAppender(String transformationName) {
        return this.loggingMap.get(transformationName);
    }

    public synchronized void addAppender(String transformationName, Appender appender) {
        this.loggingMap.put(transformationName, appender);
    }

    public synchronized void removeAppender(String transformationName) {
        this.loggingMap.remove(transformationName);
    }

    public String[] getTransformationNames() {
        Set<String> keySet = this.transformationMap.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    public Map<String, TransConfiguration> getConfigurationMap() {
        return this.configurationMap;
    }

    public void setConfigurationMap(Map<String, TransConfiguration> configurationMap) {
        this.configurationMap = configurationMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SocketPortAllocation allocateServerSocketPort(int portRangeStart, String hostname, String transformationName, String sourceSlaveName, String sourceStepName, String sourceStepCopy, String targetSlaveName, String targetStepName, String targetStepCopy) {
        Map<String, List<SocketPortAllocation>> map = this.hostServerSocketPortsMap;
        synchronized (map) {
            List<SocketPortAllocation> serverSocketPortsMap = this.hostServerSocketPortsMap.get(hostname);
            if (serverSocketPortsMap == null) {
                serverSocketPortsMap = new ArrayList<SocketPortAllocation>();
                this.hostServerSocketPortsMap.put(hostname, serverSocketPortsMap);
            }
            SocketPortAllocation socketPortAllocation = null;
            int maxPort = portRangeStart - 1;
            for (int index = 0; index < serverSocketPortsMap.size(); ++index) {
                SocketPortAllocation spa = serverSocketPortsMap.get(index);
                if (spa.getPort() > maxPort) {
                    maxPort = spa.getPort();
                }
                if (spa.getSourceSlaveName().equalsIgnoreCase(sourceSlaveName) && spa.getTargetSlaveName().equalsIgnoreCase(targetSlaveName) && spa.getTransformationName().equalsIgnoreCase(transformationName) && spa.getSourceStepName().equalsIgnoreCase(sourceStepName) && spa.getSourceStepCopy().equalsIgnoreCase(sourceStepCopy) && spa.getTargetStepName().equalsIgnoreCase(targetStepName) && spa.getTargetStepCopy().equalsIgnoreCase(targetStepCopy)) {
                    spa.setAllocated(true);
                    socketPortAllocation = spa;
                    break;
                }
                if (spa.isAllocated() || !spa.getSourceSlaveName().equalsIgnoreCase(sourceSlaveName) || !spa.getTargetSlaveName().equalsIgnoreCase(targetSlaveName)) continue;
                socketPortAllocation = new SocketPortAllocation(spa.getPort(), new Date(), transformationName, sourceSlaveName, sourceStepName, sourceStepCopy, targetSlaveName, targetStepName, targetStepCopy);
                serverSocketPortsMap.set(index, socketPortAllocation);
                LogWriter.getInstance().logBasic("MASTER", "Port " + hostname + ":" + socketPortAllocation.getPort() + " REUSED for slave [" + sourceSlaveName + "], transformation=[" + transformationName + "]", new Object[0]);
                break;
            }
            if (socketPortAllocation == null) {
                socketPortAllocation = new SocketPortAllocation(maxPort + 1, new Date(), transformationName, sourceSlaveName, sourceStepName, sourceStepCopy, targetSlaveName, targetStepName, targetStepCopy);
                serverSocketPortsMap.add(socketPortAllocation);
                LogWriter.getInstance().logBasic("MASTER", "Port " + hostname + ":" + socketPortAllocation.getPort() + " allocated for slave [" + sourceSlaveName + "], transformation=[" + transformationName + "]", new Object[0]);
            }
            for (int i = 0; i < serverSocketPortsMap.size(); ++i) {
                for (int j = 0; j < serverSocketPortsMap.size(); ++j) {
                    if (i == j) continue;
                    SocketPortAllocation one = serverSocketPortsMap.get(i);
                    SocketPortAllocation two = serverSocketPortsMap.get(j);
                    if (one.getPort() != two.getPort()) continue;
                    System.out.println("WTF!!! Identical ports discovered in the ports list.");
                }
            }
            return socketPortAllocation;
        }
    }

    public void deallocateServerSocketPorts(String transName) {
        for (String hostname : this.hostServerSocketPortsMap.keySet()) {
            for (SocketPortAllocation spa : this.hostServerSocketPortsMap.get(hostname)) {
                if (!spa.getTransformationName().equalsIgnoreCase(transName)) continue;
                spa.setAllocated(false);
            }
        }
    }

    public void deallocateServerSocketPort(int port, String hostname) {
        List<SocketPortAllocation> serverSocketPortsMap = this.hostServerSocketPortsMap.get(hostname);
        if (serverSocketPortsMap == null) {
            return;
        }
        for (SocketPortAllocation spa : new ArrayList<SocketPortAllocation>(serverSocketPortsMap)) {
            if (spa.getPort() != port) continue;
            spa.setAllocated(false);
            return;
        }
    }
}

