/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.firestore.FieldPath;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AggregateField {
    @Nullable
    FieldPath fieldPath;

    @Nonnull
    public static CountAggregateField count() {
        return new CountAggregateField();
    }

    @Nonnull
    public static SumAggregateField sum(@Nonnull String field) {
        return new SumAggregateField(FieldPath.fromDotSeparatedString(field));
    }

    @Nonnull
    public static SumAggregateField sum(@Nonnull FieldPath fieldPath) {
        return new SumAggregateField(fieldPath);
    }

    @Nonnull
    public static AverageAggregateField average(@Nonnull String field) {
        return new AverageAggregateField(FieldPath.fromDotSeparatedString(field));
    }

    @Nonnull
    public static AverageAggregateField average(@Nonnull FieldPath fieldPath) {
        return new AverageAggregateField(fieldPath);
    }

    @Nonnull
    String getAlias() {
        return this.getOperator() + (this.fieldPath == null ? "" : "_" + this.fieldPath.getEncodedPath());
    }

    @Nonnull
    String getFieldPath() {
        return this.fieldPath == null ? "" : this.fieldPath.getEncodedPath();
    }

    @Nonnull
    abstract String getOperator();

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AggregateField)) {
            return false;
        }
        AggregateField otherAggregateField = (AggregateField)other;
        return this.getOperator().equals(otherAggregateField.getOperator()) && this.getFieldPath().equals(otherAggregateField.getFieldPath());
    }

    public int hashCode() {
        return Objects.hash(this.getOperator(), this.getFieldPath());
    }

    public static class CountAggregateField
    extends AggregateField {
        private CountAggregateField() {
        }

        @Override
        @Nonnull
        public String getOperator() {
            return "count";
        }
    }

    public static class SumAggregateField
    extends AggregateField {
        private SumAggregateField(@Nonnull FieldPath field) {
            this.fieldPath = field;
        }

        @Override
        @Nonnull
        public String getOperator() {
            return "sum";
        }
    }

    public static class AverageAggregateField
    extends AggregateField {
        private AverageAggregateField(@Nonnull FieldPath field) {
            this.fieldPath = field;
        }

        @Override
        @Nonnull
        public String getOperator() {
            return "average";
        }
    }
}

