/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.beans.PropertyVetoException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Stamps;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.StartLog;
import org.netbeans.core.startup.layers.LayerCacheManager;
import org.netbeans.core.startup.layers.SystemFileSystem;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleLayeredFileSystem
extends MultiFileSystem
implements LookupListener {
    private static final long serialVersionUID = 782910986724201983L;
    private static final String LAYER_STAMP = "layer-stamp.txt";
    static final Logger err = Logger.getLogger("org.netbeans.core.projects");
    private static Lookup.Result<FileSystem> result = Lookup.getDefault().lookupResult(FileSystem.class);
    private List<URL> urls;
    private LayerCacheManager manager;
    private final FileSystem writableLayer;
    private FileSystem cacheLayer;
    private final FileSystem[] otherLayers;
    private final boolean addLookup;

    ModuleLayeredFileSystem(FileSystem fileSystem, boolean bl, FileSystem[] fileSystemArray, boolean bl2) throws IOException {
        this(fileSystem, bl, fileSystemArray, LayerCacheManager.manager(bl2));
    }

    private ModuleLayeredFileSystem(FileSystem fileSystem, boolean bl, FileSystem[] fileSystemArray, LayerCacheManager layerCacheManager) throws IOException {
        this(fileSystem, bl, fileSystemArray, layerCacheManager, ModuleLayeredFileSystem.loadCache(layerCacheManager));
    }

    private ModuleLayeredFileSystem(FileSystem fileSystem, boolean bl, FileSystem[] fileSystemArray, LayerCacheManager layerCacheManager, FileSystem fileSystem2) throws IOException {
        super(ModuleLayeredFileSystem.appendLayers(fileSystem, bl, fileSystemArray, fileSystem2, bl));
        this.manager = layerCacheManager;
        this.writableLayer = fileSystem;
        this.otherLayers = fileSystemArray;
        this.cacheLayer = fileSystem2;
        this.addLookup = bl;
        this.setPropagateMasks(true);
        this.urls = null;
        if (bl) {
            result.addLookupListener((LookupListener)this);
            result.allItems();
        }
    }

    private static FileSystem loadCache(LayerCacheManager layerCacheManager) throws IOException {
        FileSystem fileSystem;
        block4: {
            String string = layerCacheManager.cacheLocation();
            fileSystem = null;
            if (string != null) {
                ModuleLayeredFileSystem.setStatusText(NbBundle.getMessage(ModuleLayeredFileSystem.class, (String)"MSG_start_load_cache"));
                MappedByteBuffer mappedByteBuffer = Stamps.getModulesJARs().asMappedByteBuffer(string);
                if (mappedByteBuffer != null) {
                    try {
                        StartLog.logStart("Loading layers");
                        fileSystem = layerCacheManager.load(layerCacheManager.createEmptyFileSystem(), mappedByteBuffer);
                        ModuleLayeredFileSystem.setStatusText(NbBundle.getMessage(ModuleLayeredFileSystem.class, (String)"MSG_end_load_cache"));
                        StartLog.logEnd("Loading layers");
                    }
                    catch (IOException iOException) {
                        LayerCacheManager.err.log(Level.WARNING, "Ignoring cache of layers");
                        if (!LayerCacheManager.err.isLoggable(Level.FINE)) break block4;
                        LayerCacheManager.err.log(Level.WARNING, "Ignoring cache of layers", iOException);
                    }
                }
            }
        }
        return fileSystem != null ? fileSystem : layerCacheManager.createEmptyFileSystem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileSystem[] appendLayers(FileSystem fileSystem, boolean bl, FileSystem[] fileSystemArray, FileSystem fileSystem2, boolean bl2) {
        ArrayList<URL> arrayList;
        ArrayList<Object> arrayList2 = new ArrayList<Object>(fileSystemArray.length + 2);
        arrayList2.add(fileSystem);
        if (bl) {
            arrayList = result.allInstances();
            arrayList2.addAll(arrayList);
        }
        arrayList2.addAll(Arrays.asList(fileSystemArray));
        arrayList2.add(fileSystem2);
        if (bl2) {
            arrayList = new ArrayList<URL>();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                for (URL uRL : NbCollections.iterable(classLoader.getResources("META-INF/MANIFEST.MF"))) {
                    InputStream inputStream = uRL.openStream();
                    try {
                        Manifest manifest = new Manifest(inputStream);
                        String string = manifest.getMainAttributes().getValue("OpenIDE-Module-Layer");
                        if (string == null) continue;
                        URL uRL2 = classLoader.getResource(string);
                        if (uRL2 != null) {
                            arrayList.add(uRL2);
                            continue;
                        }
                        err.warning("No such layer: " + string);
                    }
                    finally {
                        inputStream.close();
                    }
                }
                XMLFileSystem xMLFileSystem = new XMLFileSystem();
                xMLFileSystem.setXmlUrls(arrayList.toArray(new URL[arrayList.size()]));
                arrayList2.add(xMLFileSystem);
                err.log(Level.FINE, "Loading classpath layers: {0}", arrayList);
            }
            catch (Exception exception) {
                err.log(Level.WARNING, "Setting layer URLs: " + arrayList, exception);
            }
        }
        return arrayList2.toArray(new FileSystem[arrayList2.size()]);
    }

    public final FileSystem[] getLayers() {
        return this.getDelegates();
    }

    final FileSystem getWritableLayer() {
        return this.writableLayer;
    }

    public static ModuleLayeredFileSystem getInstallationModuleLayer() {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        SystemFileSystem systemFileSystem = (SystemFileSystem)fileSystem;
        ModuleLayeredFileSystem moduleLayeredFileSystem = systemFileSystem.getInstallationLayer();
        if (moduleLayeredFileSystem != null) {
            return moduleLayeredFileSystem;
        }
        return systemFileSystem.getUserLayer();
    }

    public static ModuleLayeredFileSystem getUserModuleLayer() {
        SystemFileSystem systemFileSystem = (SystemFileSystem)Repository.getDefault().getDefaultFileSystem();
        return systemFileSystem.getUserLayer();
    }

    public void setURLs(final List<URL> list) throws Exception {
        if (list.contains(null)) {
            throw new NullPointerException("urls=" + list);
        }
        if (err.isLoggable(Level.FINE)) {
            err.fine("setURLs: " + list);
        }
        if (this.urls != null && ((Object)list).equals(this.urls)) {
            err.fine("no-op");
            return;
        }
        StartLog.logStart("setURLs");
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Updater
        implements FileSystem.AtomicAction,
        Stamps.Updater {
            private byte[] data;

            Updater() {
            }

            public void flushCaches(DataOutputStream dataOutputStream) throws IOException {
                err.log(Level.FINEST, "flushing layers");
                dataOutputStream.write(this.data);
                err.log(Level.FINEST, "layers flushed");
            }

            public void cacheReady() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ModuleLayeredFileSystem moduleLayeredFileSystem = ModuleLayeredFileSystem.this;
                synchronized (moduleLayeredFileSystem) {
                    try {
                        err.log(Level.FINEST, "storing to memory {0}", list);
                        ModuleLayeredFileSystem.this.manager.store(ModuleLayeredFileSystem.this.cacheLayer, list, byteArrayOutputStream);
                        this.data = byteArrayOutputStream.toByteArray();
                        ByteBuffer byteBuffer = ByteBuffer.wrap(this.data);
                        err.log(Level.FINEST, "reading from memory, size {0}", byteBuffer.limit());
                        ModuleLayeredFileSystem.this.cacheLayer = ModuleLayeredFileSystem.this.manager.load(ModuleLayeredFileSystem.this.cacheLayer, byteBuffer.order(ByteOrder.LITTLE_ENDIAN));
                    }
                    catch (IOException iOException) {
                        err.log(Level.WARNING, null, iOException);
                        XMLFileSystem xMLFileSystem = new XMLFileSystem();
                        try {
                            xMLFileSystem.setXmlUrls(list.toArray(new URL[0]));
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            Exceptions.printStackTrace((Throwable)propertyVetoException);
                        }
                        ModuleLayeredFileSystem.this.cacheLayer = (FileSystem)xMLFileSystem;
                    }
                }
                err.log(Level.FINEST, "changing delegates");
                ModuleLayeredFileSystem.this.setDelegates(ModuleLayeredFileSystem.appendLayers(ModuleLayeredFileSystem.this.writableLayer, ModuleLayeredFileSystem.this.addLookup, ModuleLayeredFileSystem.this.otherLayers, ModuleLayeredFileSystem.this.cacheLayer, false));
                err.log(Level.FINEST, "delegates changed");
                err.log(Level.FINEST, "scheduling save");
                Stamps.getModulesJARs().scheduleSave((Stamps.Updater)this, ModuleLayeredFileSystem.this.manager.cacheLocation(), false);
            }
        }
        Updater updater = new Updater();
        this.runAtomicAction(updater);
        this.urls = list;
        this.firePropertyChange("layers", null, null);
        StartLog.logEnd("setURLs");
    }

    public void addURLs(Collection<URL> collection) throws Exception {
        if (collection.contains(null)) {
            throw new NullPointerException("urls=" + collection);
        }
        ArrayList<URL> arrayList = new ArrayList<URL>(collection);
        if (this.urls != null) {
            arrayList.addAll(this.urls);
        }
        this.setURLs(arrayList);
    }

    public void removeURLs(Collection<URL> collection) throws Exception {
        if (collection.contains(null)) {
            throw new NullPointerException("urls=" + collection);
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (this.urls != null) {
            arrayList.addAll(this.urls);
        }
        arrayList.removeAll(collection);
        this.setURLs(arrayList);
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.setDelegates(ModuleLayeredFileSystem.appendLayers(this.writableLayer, this.addLookup, this.otherLayers, this.cacheLayer, false));
    }

    private static void setStatusText(String string) {
        Main.setStatusText(string);
    }
}

