"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createAlertingADCluster;
var _adPlugin = _interopRequireDefault(require("./adPlugin"));
var _constants = require("../../services/utils/constants");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function createAlertingADCluster(core, globalConfig, dataSourceEnabled, dataSource) {
  const {
    customHeaders,
    ...rest
  } = globalConfig.opensearch;
  if (dataSourceEnabled) {
    dataSource.registerCustomApiSchema(_adPlugin.default);
  }
  return core.opensearch.legacy.createClient(_constants.CLUSTER.AD_ALERTING, {
    plugins: [_adPlugin.default],
    // Currently we are overriding any headers with our own since we explicitly required User-Agent to be OpenSearch Dashboards
    // for integration with our backend plugin.
    // TODO: Change our required header to x-<Header> to avoid overriding
    customHeaders: {
      ...customHeaders,
      ..._constants.DEFAULT_HEADERS
    },
    ...rest
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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