/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.xxhash;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct XXH32_canonical_t")
public class XXH32Canonical
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DIGEST;

    public XXH32Canonical(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XXH32Canonical.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned char[4]")
    public ByteBuffer digest() {
        return XXH32Canonical.ndigest(this.address());
    }

    @NativeType(value="unsigned char")
    public byte digest(int index) {
        return XXH32Canonical.ndigest(this.address(), index);
    }

    public static XXH32Canonical malloc() {
        return (XXH32Canonical)XXH32Canonical.wrap(XXH32Canonical.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XXH32Canonical calloc() {
        return (XXH32Canonical)XXH32Canonical.wrap(XXH32Canonical.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XXH32Canonical create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XXH32Canonical)XXH32Canonical.wrap(XXH32Canonical.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XXH32Canonical create(long address) {
        return (XXH32Canonical)XXH32Canonical.wrap(XXH32Canonical.class, (long)address);
    }

    @Nullable
    public static XXH32Canonical createSafe(long address) {
        return address == 0L ? null : (XXH32Canonical)XXH32Canonical.wrap(XXH32Canonical.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XXH32Canonical.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XXH32Canonical.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XXH32Canonical.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XXH32Canonical.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XXH32Canonical.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XXH32Canonical.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XXH32Canonical.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static XXH32Canonical mallocStack() {
        return XXH32Canonical.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XXH32Canonical callocStack() {
        return XXH32Canonical.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XXH32Canonical mallocStack(MemoryStack stack) {
        return XXH32Canonical.malloc(stack);
    }

    @Deprecated
    public static XXH32Canonical callocStack(MemoryStack stack) {
        return XXH32Canonical.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return XXH32Canonical.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return XXH32Canonical.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return XXH32Canonical.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return XXH32Canonical.calloc(capacity, stack);
    }

    public static XXH32Canonical malloc(MemoryStack stack) {
        return (XXH32Canonical)XXH32Canonical.wrap(XXH32Canonical.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XXH32Canonical calloc(MemoryStack stack) {
        return (XXH32Canonical)XXH32Canonical.wrap(XXH32Canonical.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XXH32Canonical.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XXH32Canonical.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static ByteBuffer ndigest(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DIGEST), (int)4);
    }

    public static byte ndigest(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)DIGEST + Checks.check((int)index, (int)4) * 1L);
    }

    static {
        Struct.Layout layout = XXH32Canonical.__struct((Struct.Member[])new Struct.Member[]{XXH32Canonical.__array((int)1, (int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DIGEST = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<XXH32Canonical, Buffer>
    implements NativeResource {
        private static final XXH32Canonical ELEMENT_FACTORY = XXH32Canonical.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XXH32Canonical getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned char[4]")
        public ByteBuffer digest() {
            return XXH32Canonical.ndigest(this.address());
        }

        @NativeType(value="unsigned char")
        public byte digest(int index) {
            return XXH32Canonical.ndigest(this.address(), index);
        }
    }
}

