/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.llvm.LLVMMCJITCompilerOptions;
import org.lwjgl.llvm.LLVMMemoryManagerAllocateCodeSectionCallbackI;
import org.lwjgl.llvm.LLVMMemoryManagerAllocateDataSectionCallbackI;
import org.lwjgl.llvm.LLVMMemoryManagerDestroyCallbackI;
import org.lwjgl.llvm.LLVMMemoryManagerFinalizeMemoryCallbackI;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class LLVMExecutionEngine {
    protected LLVMExecutionEngine() {
        throw new UnsupportedOperationException();
    }

    public static void LLVMLinkInMCJIT() {
        long __functionAddress = Functions.LinkInMCJIT;
        JNI.invokeV((long)__functionAddress);
    }

    public static void LLVMLinkInInterpreter() {
        long __functionAddress = Functions.LinkInInterpreter;
        JNI.invokeV((long)__functionAddress);
    }

    @NativeType(value="LLVMGenericValueRef")
    public static long LLVMCreateGenericValueOfInt(@NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="unsigned long long") long N, @NativeType(value="LLVMBool") boolean IsSigned) {
        long __functionAddress = Functions.CreateGenericValueOfInt;
        if (Checks.CHECKS) {
            Checks.check((long)Ty);
        }
        return JNI.invokePJP((long)Ty, (long)N, (int)(IsSigned ? 1 : 0), (long)__functionAddress);
    }

    @NativeType(value="LLVMGenericValueRef")
    public static long LLVMCreateGenericValueOfPointer(@NativeType(value="void *") long P) {
        long __functionAddress = Functions.CreateGenericValueOfPointer;
        if (Checks.CHECKS) {
            Checks.check((long)P);
        }
        return JNI.invokePP((long)P, (long)__functionAddress);
    }

    @NativeType(value="LLVMGenericValueRef")
    public static long LLVMCreateGenericValueOfFloat(@NativeType(value="LLVMTypeRef") long Ty, double N) {
        long __functionAddress = Functions.CreateGenericValueOfFloat;
        if (Checks.CHECKS) {
            Checks.check((long)Ty);
        }
        return JNI.invokePP((long)Ty, (double)N, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGenericValueIntWidth(@NativeType(value="LLVMGenericValueRef") long GenValRef) {
        long __functionAddress = Functions.GenericValueIntWidth;
        if (Checks.CHECKS) {
            Checks.check((long)GenValRef);
        }
        return JNI.invokePI((long)GenValRef, (long)__functionAddress);
    }

    @NativeType(value="unsigned long long")
    public static long LLVMGenericValueToInt(@NativeType(value="LLVMGenericValueRef") long GenVal, @NativeType(value="LLVMBool") boolean IsSigned) {
        long __functionAddress = Functions.GenericValueToInt;
        if (Checks.CHECKS) {
            Checks.check((long)GenVal);
        }
        return JNI.invokePJ((long)GenVal, (int)(IsSigned ? 1 : 0), (long)__functionAddress);
    }

    @NativeType(value="void *")
    public static long LLVMGenericValueToPointer(@NativeType(value="LLVMGenericValueRef") long GenVal) {
        long __functionAddress = Functions.GenericValueToPointer;
        if (Checks.CHECKS) {
            Checks.check((long)GenVal);
        }
        return JNI.invokePP((long)GenVal, (long)__functionAddress);
    }

    public static double LLVMGenericValueToFloat(@NativeType(value="LLVMTypeRef") long TyRef, @NativeType(value="LLVMGenericValueRef") long GenVal) {
        long __functionAddress = Functions.GenericValueToFloat;
        if (Checks.CHECKS) {
            Checks.check((long)TyRef);
            Checks.check((long)GenVal);
        }
        return JNI.invokePPD((long)TyRef, (long)GenVal, (long)__functionAddress);
    }

    public static void LLVMDisposeGenericValue(@NativeType(value="LLVMGenericValueRef") long GenVal) {
        long __functionAddress = Functions.DisposeGenericValue;
        if (Checks.CHECKS) {
            Checks.check((long)GenVal);
        }
        JNI.invokePV((long)GenVal, (long)__functionAddress);
    }

    public static int nLLVMCreateExecutionEngineForModule(long OutEE, long M, long OutError) {
        long __functionAddress = Functions.CreateExecutionEngineForModule;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        return JNI.invokePPPI((long)OutEE, (long)M, (long)OutError, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMCreateExecutionEngineForModule(@NativeType(value="LLVMExecutionEngineRef *") PointerBuffer OutEE, @NativeType(value="LLVMModuleRef") long M, @NativeType(value="char **") PointerBuffer OutError) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)OutEE, (int)1);
            Checks.check((CustomBuffer)OutError, (int)1);
        }
        return LLVMExecutionEngine.nLLVMCreateExecutionEngineForModule(MemoryUtil.memAddress((CustomBuffer)OutEE), M, MemoryUtil.memAddress((CustomBuffer)OutError)) != 0;
    }

    public static int nLLVMCreateInterpreterForModule(long OutInterp, long M, long OutError) {
        long __functionAddress = Functions.CreateInterpreterForModule;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        return JNI.invokePPPI((long)OutInterp, (long)M, (long)OutError, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMCreateInterpreterForModule(@NativeType(value="LLVMExecutionEngineRef *") PointerBuffer OutInterp, @NativeType(value="LLVMModuleRef") long M, @NativeType(value="char **") PointerBuffer OutError) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)OutInterp, (int)1);
            Checks.check((CustomBuffer)OutError, (int)1);
        }
        return LLVMExecutionEngine.nLLVMCreateInterpreterForModule(MemoryUtil.memAddress((CustomBuffer)OutInterp), M, MemoryUtil.memAddress((CustomBuffer)OutError)) != 0;
    }

    public static int nLLVMCreateJITCompilerForModule(long OutJIT, long M, int OptLevel, long OutError) {
        long __functionAddress = Functions.CreateJITCompilerForModule;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        return JNI.invokePPPI((long)OutJIT, (long)M, (int)OptLevel, (long)OutError, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMCreateJITCompilerForModule(@NativeType(value="LLVMExecutionEngineRef *") PointerBuffer OutJIT, @NativeType(value="LLVMModuleRef") long M, @NativeType(value="unsigned int") int OptLevel, @NativeType(value="char **") PointerBuffer OutError) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)OutJIT, (int)1);
            Checks.check((CustomBuffer)OutError, (int)1);
        }
        return LLVMExecutionEngine.nLLVMCreateJITCompilerForModule(MemoryUtil.memAddress((CustomBuffer)OutJIT), M, OptLevel, MemoryUtil.memAddress((CustomBuffer)OutError)) != 0;
    }

    public static void nLLVMInitializeMCJITCompilerOptions(long Options, long SizeOfOptions) {
        long __functionAddress = Functions.InitializeMCJITCompilerOptions;
        JNI.invokePPV((long)Options, (long)SizeOfOptions, (long)__functionAddress);
    }

    public static void LLVMInitializeMCJITCompilerOptions(@NativeType(value="struct LLVMMCJITCompilerOptions *") LLVMMCJITCompilerOptions.Buffer Options) {
        LLVMExecutionEngine.nLLVMInitializeMCJITCompilerOptions(Options.address(), Options.remaining());
    }

    public static int nLLVMCreateMCJITCompilerForModule(long OutJIT, long M, long Options, long SizeOfOptions, long OutError) {
        long __functionAddress = Functions.CreateMCJITCompilerForModule;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        return JNI.invokePPPPPI((long)OutJIT, (long)M, (long)Options, (long)SizeOfOptions, (long)OutError, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMCreateMCJITCompilerForModule(@NativeType(value="LLVMExecutionEngineRef *") PointerBuffer OutJIT, @NativeType(value="LLVMModuleRef") long M, @NativeType(value="struct LLVMMCJITCompilerOptions *") LLVMMCJITCompilerOptions.Buffer Options, @NativeType(value="char **") PointerBuffer OutError) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)OutJIT, (int)1);
            Checks.check((CustomBuffer)OutError, (int)1);
        }
        return LLVMExecutionEngine.nLLVMCreateMCJITCompilerForModule(MemoryUtil.memAddress((CustomBuffer)OutJIT), M, Options.address(), Options.remaining(), MemoryUtil.memAddress((CustomBuffer)OutError)) != 0;
    }

    public static void LLVMDisposeExecutionEngine(@NativeType(value="LLVMExecutionEngineRef") long EE) {
        long __functionAddress = Functions.DisposeExecutionEngine;
        if (Checks.CHECKS) {
            Checks.check((long)EE);
        }
        JNI.invokePV((long)EE, (long)__functionAddress);
    }

    public static void LLVMRunStaticConstructors(@NativeType(value="LLVMExecutionEngineRef") long EE) {
        long __functionAddress = Functions.RunStaticConstructors;
        if (Checks.CHECKS) {
            Checks.check((long)EE);
        }
        JNI.invokePV((long)EE, (long)__functionAddress);
    }

    public static void LLVMRunStaticDestructors(@NativeType(value="LLVMExecutionEngineRef") long EE) {
        long __functionAddress = Functions.RunStaticDestructors;
        if (Checks.CHECKS) {
            Checks.check((long)EE);
        }
        JNI.invokePV((long)EE, (long)__functionAddress);
    }

    public static int nLLVMRunFunctionAsMain(long EE, long F, int ArgC, long ArgV, long EnvP) {
        long __functionAddress = Functions.RunFunctionAsMain;
        if (Checks.CHECKS) {
            Checks.check((long)EE);
            Checks.check((long)F);
        }
        return JNI.invokePPPPI((long)EE, (long)F, (int)ArgC, (long)ArgV, (long)EnvP, (long)__functionAddress);
    }

    public static int LLVMRunFunctionAsMain(@NativeType(value="LLVMExecutionEngineRef") long EE, @NativeType(value="LLVMValueRef") long F, @NativeType(value="char const * const *") PointerBuffer ArgV, @NativeType(value="char const * const *") PointerBuffer EnvP) {
        if (Checks.CHECKS) {
            Checks.checkNT((PointerBuffer)EnvP);
        }
        return LLVMExecutionEngine.nLLVMRunFunctionAsMain(EE, F, ArgV.remaining(), MemoryUtil.memAddress((CustomBuffer)ArgV), MemoryUtil.memAddress((CustomBuffer)EnvP));
    }

    public static long nLLVMRunFunction(long EE, long F, int NumArgs, long Args) {
        long __functionAddress = Functions.RunFunction;
        if (Checks.CHECKS) {
            Checks.check((long)EE);
            Checks.check((long)F);
        }
        return JNI.invokePPPP((long)EE, (long)F, (int)NumArgs, (long)Args, (long)__functionAddress);
    }

    @NativeType(value="LLVMGenericValueRef")
    public static long LLVMRunFunction(@NativeType(value="LLVMExecutionEngineRef") long EE, @NativeType(value="LLVMValueRef") long F, @NativeType(value="LLVMGenericValueRef *") PointerBuffer Args) {
        return LLVMExecutionEngine.nLLVMRunFunction(EE, F, Args.remaining(), MemoryUtil.memAddress((CustomBuffer)Args));
    }

    public static void LLVMFreeMachineCodeForFunction(@NativeType(value="LLVMExecutionEngineRef") long EE, @NativeType(value="LLVMValueRef") long F) {
        long __functionAddress = Functions.FreeMachineCodeForFunction;
        if (Checks.CHECKS) {
            Checks.check((long)EE);
            Checks.check((long)F);
        }
        JNI.invokePPV((long)EE, (long)F, (long)__functionAddress);
    }

    public static void LLVMAddModule(@NativeType(value="LLVMExecutionEngineRef") long EE, @NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.AddModule;
        if (Checks.CHECKS) {
            Checks.check((long)EE);
            Checks.check((long)M);
        }
        JNI.invokePPV((long)EE, (long)M, (long)__functionAddress);
    }

    public static int nLLVMRemoveModule(long EE, long M, long OutMod, long OutError) {
        long __functionAddress = Functions.RemoveModule;
        if (Checks.CHECKS) {
            Checks.check((long)EE);
            Checks.check((long)M);
        }
        return JNI.invokePPPPI((long)EE, (long)M, (long)OutMod, (long)OutError, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMRemoveModule(@NativeType(value="LLVMExecutionEngineRef") long EE, @NativeType(value="LLVMModuleRef") long M, @NativeType(value="LLVMModuleRef *") PointerBuffer OutMod, @NativeType(value="char **") PointerBuffer OutError) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)OutMod, (int)1);
            Checks.check((CustomBuffer)OutError, (int)1);
        }
        return LLVMExecutionEngine.nLLVMRemoveModule(EE, M, MemoryUtil.memAddress((CustomBuffer)OutMod), MemoryUtil.memAddress((CustomBuffer)OutError)) != 0;
    }

    public static int nLLVMFindFunction(long EE, long Name, long OutFn) {
        long __functionAddress = Functions.FindFunction;
        if (Checks.CHECKS) {
            Checks.check((long)EE);
        }
        return JNI.invokePPPI((long)EE, (long)Name, (long)OutFn, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMFindFunction(@NativeType(value="LLVMExecutionEngineRef") long EE, @NativeType(value="char const *") ByteBuffer Name, @NativeType(value="LLVMValueRef *") PointerBuffer OutFn) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)Name, (int)1);
            Checks.check((CustomBuffer)OutFn, (int)1);
        }
        return LLVMExecutionEngine.nLLVMFindFunction(EE, MemoryUtil.memAddress((ByteBuffer)Name), MemoryUtil.memAddress((CustomBuffer)OutFn)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMBool")
    public static boolean LLVMFindFunction(@NativeType(value="LLVMExecutionEngineRef") long EE, @NativeType(value="char const *") CharSequence Name, @NativeType(value="LLVMValueRef *") PointerBuffer OutFn) {
        if (Checks.CHECKS) {
            Checks.check((CharSequence)Name, (int)1);
            Checks.check((CustomBuffer)OutFn, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            boolean bl = LLVMExecutionEngine.nLLVMFindFunction(EE, NameEncoded, MemoryUtil.memAddress((CustomBuffer)OutFn)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="void *")
    public static long LLVMRecompileAndRelinkFunction(@NativeType(value="LLVMExecutionEngineRef") long EE, @NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.RecompileAndRelinkFunction;
        if (Checks.CHECKS) {
            Checks.check((long)EE);
            Checks.check((long)Fn);
        }
        return JNI.invokePPP((long)EE, (long)Fn, (long)__functionAddress);
    }

    @NativeType(value="LLVMTargetDataRef")
    public static long LLVMGetExecutionEngineTargetData(@NativeType(value="LLVMExecutionEngineRef") long EE) {
        long __functionAddress = Functions.GetExecutionEngineTargetData;
        if (Checks.CHECKS) {
            Checks.check((long)EE);
        }
        return JNI.invokePP((long)EE, (long)__functionAddress);
    }

    @NativeType(value="LLVMTargetMachineRef")
    public static long LLVMGetExecutionEngineTargetMachine(@NativeType(value="LLVMExecutionEngineRef") long EE) {
        long __functionAddress = Functions.GetExecutionEngineTargetMachine;
        if (Checks.CHECKS) {
            Checks.check((long)EE);
        }
        return JNI.invokePP((long)EE, (long)__functionAddress);
    }

    public static void LLVMAddGlobalMapping(@NativeType(value="LLVMExecutionEngineRef") long EE, @NativeType(value="LLVMValueRef") long Global, @NativeType(value="void *") long Addr) {
        long __functionAddress = Functions.AddGlobalMapping;
        if (Checks.CHECKS) {
            Checks.check((long)EE);
            Checks.check((long)Global);
            Checks.check((long)Addr);
        }
        JNI.invokePPPV((long)EE, (long)Global, (long)Addr, (long)__functionAddress);
    }

    @NativeType(value="void *")
    public static long LLVMGetPointerToGlobal(@NativeType(value="LLVMExecutionEngineRef") long EE, @NativeType(value="LLVMValueRef") long Global) {
        long __functionAddress = Functions.GetPointerToGlobal;
        if (Checks.CHECKS) {
            Checks.check((long)EE);
            Checks.check((long)Global);
        }
        return JNI.invokePPP((long)EE, (long)Global, (long)__functionAddress);
    }

    public static long nLLVMGetGlobalValueAddress(long EE, long Name) {
        long __functionAddress = Functions.GetGlobalValueAddress;
        if (Checks.CHECKS) {
            Checks.check((long)EE);
        }
        return JNI.invokePPJ((long)EE, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="uint64_t")
    public static long LLVMGetGlobalValueAddress(@NativeType(value="LLVMExecutionEngineRef") long EE, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMExecutionEngine.nLLVMGetGlobalValueAddress(EE, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint64_t")
    public static long LLVMGetGlobalValueAddress(@NativeType(value="LLVMExecutionEngineRef") long EE, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMExecutionEngine.nLLVMGetGlobalValueAddress(EE, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetFunctionAddress(long EE, long Name) {
        long __functionAddress = Functions.GetFunctionAddress;
        if (Checks.CHECKS) {
            Checks.check((long)EE);
        }
        return JNI.invokePPJ((long)EE, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="uint64_t")
    public static long LLVMGetFunctionAddress(@NativeType(value="LLVMExecutionEngineRef") long EE, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMExecutionEngine.nLLVMGetFunctionAddress(EE, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint64_t")
    public static long LLVMGetFunctionAddress(@NativeType(value="LLVMExecutionEngineRef") long EE, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMExecutionEngine.nLLVMGetFunctionAddress(EE, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nLLVMExecutionEngineGetErrMsg(long EE, long OutError) {
        long __functionAddress = Functions.ExecutionEngineGetErrMsg;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)EE);
        }
        return JNI.invokePPI((long)EE, (long)OutError, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMExecutionEngineGetErrMsg(@NativeType(value="LLVMExecutionEngineRef") long EE, @NativeType(value="char **") PointerBuffer OutError) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)OutError, (int)1);
        }
        return LLVMExecutionEngine.nLLVMExecutionEngineGetErrMsg(EE, MemoryUtil.memAddress((CustomBuffer)OutError)) != 0;
    }

    public static long nLLVMCreateSimpleMCJITMemoryManager(long Opaque, long AllocateCodeSection, long AllocateDataSection, long FinalizeMemory, long Destroy) {
        long __functionAddress = Functions.CreateSimpleMCJITMemoryManager;
        if (Checks.CHECKS) {
            Checks.check((long)Opaque);
        }
        return JNI.invokePPPPPP((long)Opaque, (long)AllocateCodeSection, (long)AllocateDataSection, (long)FinalizeMemory, (long)Destroy, (long)__functionAddress);
    }

    @NativeType(value="LLVMMCJITMemoryManagerRef")
    public static long LLVMCreateSimpleMCJITMemoryManager(@NativeType(value="void *") long Opaque, @NativeType(value="uint8_t * (*) (void *, uintptr_t, unsigned int, unsigned int, char const *)") LLVMMemoryManagerAllocateCodeSectionCallbackI AllocateCodeSection, @NativeType(value="uint8_t * (*) (void *, uintptr_t, unsigned int, unsigned int, char const *, LLVMBool)") LLVMMemoryManagerAllocateDataSectionCallbackI AllocateDataSection, @NativeType(value="LLVMBool (*) (void *, char **)") LLVMMemoryManagerFinalizeMemoryCallbackI FinalizeMemory, @NativeType(value="void (*) (void *)") LLVMMemoryManagerDestroyCallbackI Destroy) {
        return LLVMExecutionEngine.nLLVMCreateSimpleMCJITMemoryManager(Opaque, AllocateCodeSection.address(), AllocateDataSection.address(), FinalizeMemory.address(), Destroy.address());
    }

    public static void LLVMDisposeMCJITMemoryManager(@NativeType(value="LLVMMCJITMemoryManagerRef") long MM) {
        long __functionAddress = Functions.DisposeMCJITMemoryManager;
        if (Checks.CHECKS) {
            Checks.check((long)MM);
        }
        JNI.invokePV((long)MM, (long)__functionAddress);
    }

    @NativeType(value="LLVMJITEventListenerRef")
    public static long LLVMCreateGDBRegistrationListener() {
        long __functionAddress = Functions.CreateGDBRegistrationListener;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="LLVMJITEventListenerRef")
    public static long LLVMCreateIntelJITEventListener() {
        long __functionAddress = Functions.CreateIntelJITEventListener;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="LLVMJITEventListenerRef")
    public static long LLVMCreateOProfileJITEventListener() {
        long __functionAddress = Functions.CreateOProfileJITEventListener;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="LLVMJITEventListenerRef")
    public static long LLVMCreatePerfJITEventListener() {
        long __functionAddress = Functions.CreatePerfJITEventListener;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.invokeP((long)__functionAddress);
    }

    public static final class Functions {
        public static final long LinkInMCJIT = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMLinkInMCJIT");
        public static final long LinkInInterpreter = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMLinkInInterpreter");
        public static final long CreateGenericValueOfInt = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMCreateGenericValueOfInt");
        public static final long CreateGenericValueOfPointer = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMCreateGenericValueOfPointer");
        public static final long CreateGenericValueOfFloat = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMCreateGenericValueOfFloat");
        public static final long GenericValueIntWidth = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGenericValueIntWidth");
        public static final long GenericValueToInt = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGenericValueToInt");
        public static final long GenericValueToPointer = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGenericValueToPointer");
        public static final long GenericValueToFloat = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGenericValueToFloat");
        public static final long DisposeGenericValue = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDisposeGenericValue");
        public static final long CreateExecutionEngineForModule = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMCreateExecutionEngineForModule");
        public static final long CreateInterpreterForModule = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMCreateInterpreterForModule");
        public static final long CreateJITCompilerForModule = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMCreateJITCompilerForModule");
        public static final long InitializeMCJITCompilerOptions = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMInitializeMCJITCompilerOptions");
        public static final long CreateMCJITCompilerForModule = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMCreateMCJITCompilerForModule");
        public static final long DisposeExecutionEngine = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDisposeExecutionEngine");
        public static final long RunStaticConstructors = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMRunStaticConstructors");
        public static final long RunStaticDestructors = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMRunStaticDestructors");
        public static final long RunFunctionAsMain = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMRunFunctionAsMain");
        public static final long RunFunction = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMRunFunction");
        public static final long FreeMachineCodeForFunction = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMFreeMachineCodeForFunction");
        public static final long AddModule = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMAddModule");
        public static final long RemoveModule = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMRemoveModule");
        public static final long FindFunction = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMFindFunction");
        public static final long RecompileAndRelinkFunction = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMRecompileAndRelinkFunction");
        public static final long GetExecutionEngineTargetData = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetExecutionEngineTargetData");
        public static final long GetExecutionEngineTargetMachine = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetExecutionEngineTargetMachine");
        public static final long AddGlobalMapping = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMAddGlobalMapping");
        public static final long GetPointerToGlobal = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetPointerToGlobal");
        public static final long GetGlobalValueAddress = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetGlobalValueAddress");
        public static final long GetFunctionAddress = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetFunctionAddress");
        public static final long ExecutionEngineGetErrMsg = LLVMCore.getLibrary().getFunctionAddress((CharSequence)"LLVMExecutionEngineGetErrMsg");
        public static final long CreateSimpleMCJITMemoryManager = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMCreateSimpleMCJITMemoryManager");
        public static final long DisposeMCJITMemoryManager = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDisposeMCJITMemoryManager");
        public static final long CreateGDBRegistrationListener = LLVMCore.getLibrary().getFunctionAddress((CharSequence)"LLVMCreateGDBRegistrationListener");
        public static final long CreateIntelJITEventListener = LLVMCore.getLibrary().getFunctionAddress((CharSequence)"LLVMCreateIntelJITEventListener");
        public static final long CreateOProfileJITEventListener = LLVMCore.getLibrary().getFunctionAddress((CharSequence)"LLVMCreateOProfileJITEventListener");
        public static final long CreatePerfJITEventListener = LLVMCore.getLibrary().getFunctionAddress((CharSequence)"LLVMCreatePerfJITEventListener");

        private Functions() {
        }
    }
}

