/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.linkedin;

import org.keycloak.broker.oidc.OIDCIdentityProvider;
import org.keycloak.broker.oidc.OIDCIdentityProviderConfig;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.keys.PublicKeyLoader;
import org.keycloak.keys.PublicKeyStorageProvider;
import org.keycloak.keys.PublicKeyStorageUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.social.linkedin.LinkedInPublicKeyLoader;

public class LinkedInOIDCIdentityProvider
extends OIDCIdentityProvider
implements SocialIdentityProvider<OIDCIdentityProviderConfig> {
    public static final String DEFAULT_SCOPE = "openid profile email";

    public LinkedInOIDCIdentityProvider(KeycloakSession session, OIDCIdentityProviderConfig config) {
        super(session, config);
    }

    @Override
    protected String getDefaultScopes() {
        return DEFAULT_SCOPE;
    }

    @Override
    protected KeyWrapper getIdentityProviderKeyWrapper(JWSInput jws) {
        LinkedInPublicKeyLoader loader = new LinkedInPublicKeyLoader(this.session, (OIDCIdentityProviderConfig)this.getConfig());
        PublicKeyStorageProvider keyStorage = (PublicKeyStorageProvider)this.session.getProvider(PublicKeyStorageProvider.class);
        String modelKey = PublicKeyStorageUtils.getIdpModelCacheKey((String)this.session.getContext().getRealm().getId(), (String)((OIDCIdentityProviderConfig)this.getConfig()).getInternalId());
        return keyStorage.getPublicKey(modelKey, jws.getHeader().getKeyId(), jws.getHeader().getRawAlgorithm(), (PublicKeyLoader)loader);
    }
}

