/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.client;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.HttpUpgrader;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.RetainableByteBufferPool;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.websocket.core.Behavior;
import org.eclipse.jetty.websocket.core.Configuration;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.ExtensionConfig;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.core.WebSocketConstants;
import org.eclipse.jetty.websocket.core.client.UpgradeListener;
import org.eclipse.jetty.websocket.core.client.WebSocketCoreClient;
import org.eclipse.jetty.websocket.core.client.internal.HttpUpgraderOverHTTP;
import org.eclipse.jetty.websocket.core.client.internal.HttpUpgraderOverHTTP2;
import org.eclipse.jetty.websocket.core.exception.UpgradeException;
import org.eclipse.jetty.websocket.core.exception.WebSocketException;
import org.eclipse.jetty.websocket.core.internal.ExtensionStack;
import org.eclipse.jetty.websocket.core.internal.Negotiated;
import org.eclipse.jetty.websocket.core.internal.WebSocketConnection;
import org.eclipse.jetty.websocket.core.internal.WebSocketCoreSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CoreClientUpgradeRequest
extends HttpRequest
implements Response.CompleteListener,
HttpUpgrader.Factory {
    private static final Logger LOG = LoggerFactory.getLogger(CoreClientUpgradeRequest.class);
    protected final CompletableFuture<CoreSession> futureCoreSession;
    private final WebSocketCoreClient wsClient;
    private FrameHandler frameHandler;
    private final Configuration.ConfigurationCustomizer customizer = new Configuration.ConfigurationCustomizer();
    private final List<UpgradeListener> upgradeListeners = new ArrayList<UpgradeListener>();
    private List<ExtensionConfig> requestedExtensions = new ArrayList<ExtensionConfig>();

    public static CoreClientUpgradeRequest from(WebSocketCoreClient webSocketClient, URI requestURI, final FrameHandler frameHandler) {
        return new CoreClientUpgradeRequest(webSocketClient, requestURI){

            @Override
            public FrameHandler getFrameHandler() {
                return frameHandler;
            }
        };
    }

    public CoreClientUpgradeRequest(WebSocketCoreClient webSocketClient, URI requestURI) {
        super(webSocketClient.getHttpClient(), new HttpConversation(), requestURI);
        if (!requestURI.isAbsolute()) {
            throw new IllegalArgumentException("WebSocket URI must be absolute");
        }
        if (StringUtil.isBlank(requestURI.getScheme())) {
            throw new IllegalArgumentException("WebSocket URI must include a scheme");
        }
        String scheme = requestURI.getScheme();
        if (!HttpScheme.WS.is(scheme) && !HttpScheme.WSS.is(scheme)) {
            throw new IllegalArgumentException("WebSocket URI scheme only supports [ws] and [wss], not [" + scheme + "]");
        }
        if (requestURI.getHost() == null) {
            throw new IllegalArgumentException("Invalid WebSocket URI: host not present");
        }
        this.wsClient = webSocketClient;
        this.futureCoreSession = new CompletableFuture();
        this.futureCoreSession.whenComplete((session, throwable) -> {
            if (throwable != null) {
                this.abort((Throwable)throwable);
            }
        });
    }

    public void setConfiguration(Configuration.ConfigurationCustomizer config) {
        config.customize(this.customizer);
    }

    public void addListener(UpgradeListener listener) {
        this.upgradeListeners.add(listener);
    }

    public void addExtensions(ExtensionConfig ... configs) {
        this.requestedExtensions.addAll(Arrays.asList(configs));
    }

    public void addExtensions(String ... configs) {
        for (String config : configs) {
            this.requestedExtensions.add(ExtensionConfig.parse(config));
        }
    }

    public List<ExtensionConfig> getExtensions() {
        return this.requestedExtensions;
    }

    public void setExtensions(List<ExtensionConfig> configs) {
        this.requestedExtensions = configs;
    }

    public List<String> getSubProtocols() {
        return this.getHeaders().getCSV(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL, true);
    }

    public void setSubProtocols(String ... protocols) {
        this.headers(headers -> {
            headers.remove(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL);
            for (String protocol : protocols) {
                headers.add(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL, protocol);
            }
        });
    }

    public void setSubProtocols(List<String> protocols) {
        this.headers(headers -> {
            headers.remove(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL);
            for (String protocol : protocols) {
                headers.add(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL, protocol);
            }
        });
    }

    @Override
    public void send(Response.CompleteListener listener) {
        try {
            this.frameHandler = this.getFrameHandler();
            if (this.frameHandler == null) {
                throw new IllegalArgumentException("FrameHandler could not be created");
            }
        }
        catch (Throwable t2) {
            throw new IllegalArgumentException("FrameHandler could not be created", t2);
        }
        super.send(listener);
    }

    public CompletableFuture<CoreSession> sendAsync() {
        this.send(this);
        return this.futureCoreSession;
    }

    @Override
    public void onComplete(Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onComplete() - {}", (Object)result);
        }
        URI requestURI = result.getRequest().getURI();
        Response response = result.getResponse();
        int responseStatusCode = response.getStatus();
        String responseLine = responseStatusCode + " " + response.getReason();
        if (result.isFailed()) {
            Throwable failure;
            boolean wrapFailure;
            if (LOG.isDebugEnabled()) {
                if (result.getFailure() != null) {
                    LOG.debug("General Failure", result.getFailure());
                }
                if (result.getRequestFailure() != null) {
                    LOG.debug("Request Failure", result.getRequestFailure());
                }
                if (result.getResponseFailure() != null) {
                    LOG.debug("Response Failure", result.getResponseFailure());
                }
            }
            boolean bl = wrapFailure = !((failure = result.getFailure()) instanceof IOException) && !(failure instanceof UpgradeException);
            if (wrapFailure) {
                failure = new UpgradeException(requestURI, responseStatusCode, responseLine, failure);
            }
            this.handleException(failure);
            return;
        }
        if (responseStatusCode != 101) {
            this.handleException(new UpgradeException(requestURI, responseStatusCode, "Failed to upgrade to websocket: Unexpected HTTP Response Status Code: " + responseLine));
        }
    }

    protected void handleException(Throwable failure) {
        this.futureCoreSession.completeExceptionally(failure);
        if (this.frameHandler != null) {
            try {
                this.frameHandler.onError(failure, Callback.NOOP);
            }
            catch (Throwable t2) {
                LOG.warn("FrameHandler onError threw", t2);
            }
        }
    }

    @Override
    public HttpUpgrader newHttpUpgrader(HttpVersion version) {
        if (version == HttpVersion.HTTP_1_1) {
            return new HttpUpgraderOverHTTP(this);
        }
        if (version == HttpVersion.HTTP_2) {
            return new HttpUpgraderOverHTTP2(this);
        }
        throw new UnsupportedOperationException("Unsupported HTTP version for upgrade: " + String.valueOf((Object)version));
    }

    protected void customize(EndPoint endPoint) {
    }

    public abstract FrameHandler getFrameHandler();

    public void requestComplete() {
        Exception listenerError;
        String extensionString = this.requestedExtensions.stream().filter(ec -> !ec.getName().startsWith("@")).map(ExtensionConfig::getParameterizedNameWithoutInternalParams).collect(Collectors.joining(","));
        if (!StringUtil.isEmpty(extensionString)) {
            this.headers(headers -> headers.add(HttpHeader.SEC_WEBSOCKET_EXTENSIONS, extensionString));
        }
        if ((listenerError = this.notifyUpgradeListeners(listener -> listener.onHandshakeRequest(this))) != null) {
            this.abort(listenerError);
            return;
        }
        String extsAfterListener = String.join((CharSequence)",", this.getHeaders().getCSV(HttpHeader.SEC_WEBSOCKET_EXTENSIONS, true));
        if (!extensionString.equals(extsAfterListener)) {
            if (!this.requestedExtensions.isEmpty()) {
                this.abort(new IllegalStateException("Extensions set in both the ClientUpgradeRequest and UpgradeListener"));
            }
            this.requestedExtensions = ExtensionConfig.parseList(extsAfterListener);
        }
    }

    private Exception notifyUpgradeListeners(Consumer<UpgradeListener> action) {
        MultiException multiException = null;
        for (UpgradeListener listener : this.upgradeListeners) {
            try {
                action.accept(listener);
            }
            catch (Throwable t2) {
                LOG.info("Exception while invoking listener {}", (Object)listener, (Object)t2);
                if (multiException == null) {
                    multiException = new MultiException();
                }
                multiException.add(t2);
            }
        }
        return multiException;
    }

    public void upgrade(HttpResponse response, EndPoint endPoint) {
        Object[] values2;
        String[] extValues;
        ArrayList<ExtensionConfig> negotiatedExtensions = new ArrayList<ExtensionConfig>();
        HttpField extField = response.getHeaders().getField(HttpHeader.SEC_WEBSOCKET_EXTENSIONS);
        if (extField != null && (extValues = extField.getValues()) != null) {
            for (String extVal : extValues) {
                QuotedStringTokenizer tok = new QuotedStringTokenizer(extVal, ",");
                while (tok.hasMoreTokens()) {
                    negotiatedExtensions.add(ExtensionConfig.parse(tok.nextToken()));
                }
            }
        }
        ArrayList<ExtensionConfig> negotiatedWithInternal = new ArrayList<ExtensionConfig>(this.requestedExtensions);
        Iterator iterator2 = negotiatedWithInternal.iterator();
        while (iterator2.hasNext()) {
            ExtensionConfig extConfig = (ExtensionConfig)iterator2.next();
            if (extConfig.isInternalExtension()) continue;
            long negExtsCount = negotiatedExtensions.stream().filter(ec -> extConfig.getName().equals(ec.getName())).count();
            if (negExtsCount < 1L) {
                iterator2.remove();
                continue;
            }
            long duplicateCount = negotiatedWithInternal.stream().filter(ec -> extConfig.getName().equals(ec.getName())).count();
            if (duplicateCount <= 1L) continue;
            iterator2.remove();
        }
        for (ExtensionConfig config : negotiatedExtensions) {
            if (config.getName().startsWith("@")) continue;
            boolean wasRequested = false;
            for (ExtensionConfig requestedConfig : this.requestedExtensions) {
                if (!config.getName().equalsIgnoreCase(requestedConfig.getName())) continue;
                for (Map.Entry<String, String> entry : requestedConfig.getInternalParameters()) {
                    config.setParameter(entry.getKey(), entry.getValue());
                }
                wasRequested = true;
                break;
            }
            if (!wasRequested) {
                throw new WebSocketException("Upgrade failed: Sec-WebSocket-Extensions contained extension not requested");
            }
            long numExtsWithSameName = negotiatedExtensions.stream().filter(c -> config.getName().equalsIgnoreCase(c.getName())).count();
            if (numExtsWithSameName <= 1L) continue;
            throw new WebSocketException("Upgrade failed: Sec-WebSocket-Extensions contained more than one extension of the same name");
        }
        ExtensionStack extensionStack = new ExtensionStack(this.wsClient.getWebSocketComponents(), Behavior.CLIENT);
        extensionStack.negotiate(this.requestedExtensions, negotiatedWithInternal);
        Object negotiatedSubProtocol = null;
        HttpField subProtocolField = response.getHeaders().getField(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL);
        if (subProtocolField != null && (values2 = subProtocolField.getValues()) != null) {
            if (values2.length > 1) {
                throw new WebSocketException("Upgrade failed: Too many WebSocket subprotocol's in response: " + Arrays.toString(values2));
            }
            if (values2.length == 1) {
                negotiatedSubProtocol = values2[0];
            }
        }
        List<String> offeredSubProtocols = this.getSubProtocols();
        if (negotiatedSubProtocol != null && !offeredSubProtocols.contains(negotiatedSubProtocol)) {
            throw new WebSocketException("Upgrade failed: subprotocol [" + negotiatedSubProtocol + "] not found in offered subprotocols " + String.valueOf(offeredSubProtocols));
        }
        this.customize(endPoint);
        Request request = response.getRequest();
        Negotiated negotiated = new Negotiated(request.getURI(), (String)negotiatedSubProtocol, HttpClient.isSchemeSecure(request.getScheme()), extensionStack, WebSocketConstants.SPEC_VERSION_STRING);
        WebSocketCoreSession coreSession = new WebSocketCoreSession(this.frameHandler, Behavior.CLIENT, negotiated, this.wsClient.getWebSocketComponents());
        coreSession.setClassLoader(this.wsClient.getClassLoader());
        this.customizer.customize(coreSession);
        HttpClient httpClient = this.wsClient.getHttpClient();
        ByteBufferPool bufferPool = this.wsClient.getWebSocketComponents().getBufferPool();
        RetainableByteBufferPool retainableByteBufferPool = bufferPool.asRetainableByteBufferPool();
        WebSocketConnection wsConnection = new WebSocketConnection(endPoint, httpClient.getExecutor(), httpClient.getScheduler(), bufferPool, retainableByteBufferPool, coreSession);
        this.wsClient.getEventListeners().forEach(wsConnection::addEventListener);
        coreSession.setWebSocketConnection(wsConnection);
        Exception listenerError = this.notifyUpgradeListeners(listener -> listener.onHandshakeResponse(this, response));
        if (listenerError != null) {
            throw new WebSocketException("onHandshakeResponse error", listenerError);
        }
        try {
            endPoint.upgrade(wsConnection);
            if (!this.futureCoreSession.complete(coreSession)) {
                this.futureCoreSession.exceptionally(t2 -> {
                    coreSession.processConnectionError((Throwable)t2, Callback.NOOP);
                    return null;
                });
            }
        }
        catch (Throwable t3) {
            this.futureCoreSession.completeExceptionally(t3);
        }
    }
}

