"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomImportMapPlugin = void 0;

var _operators = require("rxjs/operators");

var _flights_saved_objects = require("./services/sample_data/flights_saved_objects");

var _clusters = require("./clusters");

var _services = require("./services");

var _routes = require("../server/routes");

var _saved_objects = require("./saved_objects");

var _capabilities_provider = require("./saved_objects/capabilities_provider");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } /*
                                                                                                                                                                                                                   * Copyright OpenSearch Contributors
                                                                                                                                                                                                                   * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                   */

class CustomImportMapPlugin {
  constructor(initializerContext) {
    _defineProperty(this, "logger", void 0);

    _defineProperty(this, "globalConfig$", void 0);

    _defineProperty(this, "config$", void 0);

    this.logger = initializerContext.logger.get();
    this.globalConfig$ = initializerContext.config.legacy.globalConfig$;
    this.config$ = initializerContext.config.create();
  } // Adds dashboards-maps saved objects to existing sample datasets using home plugin


  addMapsSavedObjects(home, config) {
    home.sampleData.addSavedObjectsToSampleDataset('flights', (0, _flights_saved_objects.getFlightsSavedObjects)(config));
  }

  async setup(core, plugins) {
    this.logger.debug('customImportMap: Setup'); // @ts-ignore

    const globalConfig = await this.globalConfig$.pipe((0, _operators.first)()).toPromise(); // @ts-ignore

    const config = await this.config$.pipe((0, _operators.first)()).toPromise();
    const geospatialClient = (0, _clusters.createGeospatialCluster)(core, globalConfig); // Initialize services

    const geospatialService = new _services.GeospatialService(geospatialClient);
    const opensearchService = new _services.OpensearchService(geospatialClient);
    const router = core.http.createRouter();
    const {
      home
    } = plugins; // Register server side APIs

    (0, _routes.geospatial)(geospatialService, router);
    (0, _routes.opensearch)(opensearchService, router);
    (0, _routes.statsRoute)(router, this.logger); // Register saved object types

    core.savedObjects.registerType(_saved_objects.mapSavedObjectsType); // Register capabilities

    core.capabilities.registerProvider(_capabilities_provider.capabilitiesProvider);
    if (home) this.addMapsSavedObjects(home, config);
    return {};
  }

  start(core) {
    this.logger.debug('customImportMap: Started');
    return {};
  }

  stop() {}

}

exports.CustomImportMapPlugin = CustomImportMapPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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