/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.gvt;

import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import org.apache.batik.swing.gvt.InteractorAdapter;
import org.apache.batik.swing.gvt.JGVTComponent;

public class AbstractImageZoomInteractor
extends InteractorAdapter {
    protected boolean finished = true;
    protected int xStart;
    protected int yStart;
    protected int xCurrent;
    protected int yCurrent;

    public boolean endInteraction() {
        return this.finished;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.finished) {
            JGVTComponent jGVTComponent = (JGVTComponent)mouseEvent.getSource();
            jGVTComponent.setPaintingTransform(null);
            return;
        }
        this.finished = false;
        this.xStart = mouseEvent.getX();
        this.yStart = mouseEvent.getY();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.finished = true;
        JGVTComponent jGVTComponent = (JGVTComponent)mouseEvent.getSource();
        AffineTransform affineTransform = jGVTComponent.getPaintingTransform();
        if (affineTransform != null) {
            AffineTransform affineTransform2 = (AffineTransform)jGVTComponent.getRenderingTransform().clone();
            affineTransform2.preConcatenate(affineTransform);
            jGVTComponent.setRenderingTransform(affineTransform2);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        JGVTComponent jGVTComponent = (JGVTComponent)mouseEvent.getSource();
        this.xCurrent = mouseEvent.getX();
        this.yCurrent = mouseEvent.getY();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.xStart, this.yStart);
        int n = this.yCurrent - this.yStart;
        n = n < 0 ? (n > -5 ? 15 : n - 10) : (n < 5 ? 15 : n + 10);
        double d = (double)n / 15.0;
        d = d > 0.0 ? d : -1.0 / d;
        affineTransform.scale(d, d);
        affineTransform.translate(-this.xStart, -this.yStart);
        jGVTComponent.setPaintingTransform(affineTransform);
    }
}

