# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("winfax.dll")
prototypes = \
    {
        #
        'FaxConnectFaxServerA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["MachineName", "FaxHandle"]),
        #
        'FaxConnectFaxServerW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["MachineName", "FaxHandle"]),
        #
        'FaxClose': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxHandle"]),
        #
        'FaxOpenPort': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxHandle", "DeviceId", "Flags", "FaxPortHandle"]),
        #
        'FaxCompleteJobParamsA': SimTypeFunction([SimTypePointer(SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "RecipientNumber": SimTypeBottom(label="PSTR"), "RecipientName": SimTypeBottom(label="PSTR"), "Tsid": SimTypeBottom(label="PSTR"), "SenderName": SimTypeBottom(label="PSTR"), "SenderCompany": SimTypeBottom(label="PSTR"), "SenderDept": SimTypeBottom(label="PSTR"), "BillingCode": SimTypeBottom(label="PSTR"), "ScheduleAction": SimTypeInt(signed=False, label="UInt32"), "ScheduleTime": SimTypeBottom(label="SYSTEMTIME"), "DeliveryReportType": SimTypeInt(signed=False, label="UInt32"), "DeliveryReportAddress": SimTypeBottom(label="PSTR"), "DocumentName": SimTypeBottom(label="PSTR"), "CallHandle": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), 3)}, name="FAX_JOB_PARAMA", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "CoverPageName": SimTypeBottom(label="PSTR"), "UseServerCoverPage": SimTypeBottom(label="BOOL"), "RecName": SimTypeBottom(label="PSTR"), "RecFaxNumber": SimTypeBottom(label="PSTR"), "RecCompany": SimTypeBottom(label="PSTR"), "RecStreetAddress": SimTypeBottom(label="PSTR"), "RecCity": SimTypeBottom(label="PSTR"), "RecState": SimTypeBottom(label="PSTR"), "RecZip": SimTypeBottom(label="PSTR"), "RecCountry": SimTypeBottom(label="PSTR"), "RecTitle": SimTypeBottom(label="PSTR"), "RecDepartment": SimTypeBottom(label="PSTR"), "RecOfficeLocation": SimTypeBottom(label="PSTR"), "RecHomePhone": SimTypeBottom(label="PSTR"), "RecOfficePhone": SimTypeBottom(label="PSTR"), "SdrName": SimTypeBottom(label="PSTR"), "SdrFaxNumber": SimTypeBottom(label="PSTR"), "SdrCompany": SimTypeBottom(label="PSTR"), "SdrAddress": SimTypeBottom(label="PSTR"), "SdrTitle": SimTypeBottom(label="PSTR"), "SdrDepartment": SimTypeBottom(label="PSTR"), "SdrOfficeLocation": SimTypeBottom(label="PSTR"), "SdrHomePhone": SimTypeBottom(label="PSTR"), "SdrOfficePhone": SimTypeBottom(label="PSTR"), "Note": SimTypeBottom(label="PSTR"), "Subject": SimTypeBottom(label="PSTR"), "TimeSent": SimTypeBottom(label="SYSTEMTIME"), "PageCount": SimTypeInt(signed=False, label="UInt32")}, name="FAX_COVERPAGE_INFOA", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["JobParams", "CoverpageInfo"]),
        #
        'FaxCompleteJobParamsW': SimTypeFunction([SimTypePointer(SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "RecipientNumber": SimTypeBottom(label="PWSTR"), "RecipientName": SimTypeBottom(label="PWSTR"), "Tsid": SimTypeBottom(label="PWSTR"), "SenderName": SimTypeBottom(label="PWSTR"), "SenderCompany": SimTypeBottom(label="PWSTR"), "SenderDept": SimTypeBottom(label="PWSTR"), "BillingCode": SimTypeBottom(label="PWSTR"), "ScheduleAction": SimTypeInt(signed=False, label="UInt32"), "ScheduleTime": SimTypeBottom(label="SYSTEMTIME"), "DeliveryReportType": SimTypeInt(signed=False, label="UInt32"), "DeliveryReportAddress": SimTypeBottom(label="PWSTR"), "DocumentName": SimTypeBottom(label="PWSTR"), "CallHandle": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), 3)}, name="FAX_JOB_PARAMW", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "CoverPageName": SimTypeBottom(label="PWSTR"), "UseServerCoverPage": SimTypeBottom(label="BOOL"), "RecName": SimTypeBottom(label="PWSTR"), "RecFaxNumber": SimTypeBottom(label="PWSTR"), "RecCompany": SimTypeBottom(label="PWSTR"), "RecStreetAddress": SimTypeBottom(label="PWSTR"), "RecCity": SimTypeBottom(label="PWSTR"), "RecState": SimTypeBottom(label="PWSTR"), "RecZip": SimTypeBottom(label="PWSTR"), "RecCountry": SimTypeBottom(label="PWSTR"), "RecTitle": SimTypeBottom(label="PWSTR"), "RecDepartment": SimTypeBottom(label="PWSTR"), "RecOfficeLocation": SimTypeBottom(label="PWSTR"), "RecHomePhone": SimTypeBottom(label="PWSTR"), "RecOfficePhone": SimTypeBottom(label="PWSTR"), "SdrName": SimTypeBottom(label="PWSTR"), "SdrFaxNumber": SimTypeBottom(label="PWSTR"), "SdrCompany": SimTypeBottom(label="PWSTR"), "SdrAddress": SimTypeBottom(label="PWSTR"), "SdrTitle": SimTypeBottom(label="PWSTR"), "SdrDepartment": SimTypeBottom(label="PWSTR"), "SdrOfficeLocation": SimTypeBottom(label="PWSTR"), "SdrHomePhone": SimTypeBottom(label="PWSTR"), "SdrOfficePhone": SimTypeBottom(label="PWSTR"), "Note": SimTypeBottom(label="PWSTR"), "Subject": SimTypeBottom(label="PWSTR"), "TimeSent": SimTypeBottom(label="SYSTEMTIME"), "PageCount": SimTypeInt(signed=False, label="UInt32")}, name="FAX_COVERPAGE_INFOW", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["JobParams", "CoverpageInfo"]),
        #
        'FaxSendDocumentA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "RecipientNumber": SimTypeBottom(label="PSTR"), "RecipientName": SimTypeBottom(label="PSTR"), "Tsid": SimTypeBottom(label="PSTR"), "SenderName": SimTypeBottom(label="PSTR"), "SenderCompany": SimTypeBottom(label="PSTR"), "SenderDept": SimTypeBottom(label="PSTR"), "BillingCode": SimTypeBottom(label="PSTR"), "ScheduleAction": SimTypeInt(signed=False, label="UInt32"), "ScheduleTime": SimTypeBottom(label="SYSTEMTIME"), "DeliveryReportType": SimTypeInt(signed=False, label="UInt32"), "DeliveryReportAddress": SimTypeBottom(label="PSTR"), "DocumentName": SimTypeBottom(label="PSTR"), "CallHandle": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), 3)}, name="FAX_JOB_PARAMA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "CoverPageName": SimTypeBottom(label="PSTR"), "UseServerCoverPage": SimTypeBottom(label="BOOL"), "RecName": SimTypeBottom(label="PSTR"), "RecFaxNumber": SimTypeBottom(label="PSTR"), "RecCompany": SimTypeBottom(label="PSTR"), "RecStreetAddress": SimTypeBottom(label="PSTR"), "RecCity": SimTypeBottom(label="PSTR"), "RecState": SimTypeBottom(label="PSTR"), "RecZip": SimTypeBottom(label="PSTR"), "RecCountry": SimTypeBottom(label="PSTR"), "RecTitle": SimTypeBottom(label="PSTR"), "RecDepartment": SimTypeBottom(label="PSTR"), "RecOfficeLocation": SimTypeBottom(label="PSTR"), "RecHomePhone": SimTypeBottom(label="PSTR"), "RecOfficePhone": SimTypeBottom(label="PSTR"), "SdrName": SimTypeBottom(label="PSTR"), "SdrFaxNumber": SimTypeBottom(label="PSTR"), "SdrCompany": SimTypeBottom(label="PSTR"), "SdrAddress": SimTypeBottom(label="PSTR"), "SdrTitle": SimTypeBottom(label="PSTR"), "SdrDepartment": SimTypeBottom(label="PSTR"), "SdrOfficeLocation": SimTypeBottom(label="PSTR"), "SdrHomePhone": SimTypeBottom(label="PSTR"), "SdrOfficePhone": SimTypeBottom(label="PSTR"), "Note": SimTypeBottom(label="PSTR"), "Subject": SimTypeBottom(label="PSTR"), "TimeSent": SimTypeBottom(label="SYSTEMTIME"), "PageCount": SimTypeInt(signed=False, label="UInt32")}, name="FAX_COVERPAGE_INFOA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxHandle", "FileName", "JobParams", "CoverpageInfo", "FaxJobId"]),
        #
        'FaxSendDocumentW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "RecipientNumber": SimTypeBottom(label="PWSTR"), "RecipientName": SimTypeBottom(label="PWSTR"), "Tsid": SimTypeBottom(label="PWSTR"), "SenderName": SimTypeBottom(label="PWSTR"), "SenderCompany": SimTypeBottom(label="PWSTR"), "SenderDept": SimTypeBottom(label="PWSTR"), "BillingCode": SimTypeBottom(label="PWSTR"), "ScheduleAction": SimTypeInt(signed=False, label="UInt32"), "ScheduleTime": SimTypeBottom(label="SYSTEMTIME"), "DeliveryReportType": SimTypeInt(signed=False, label="UInt32"), "DeliveryReportAddress": SimTypeBottom(label="PWSTR"), "DocumentName": SimTypeBottom(label="PWSTR"), "CallHandle": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), 3)}, name="FAX_JOB_PARAMW", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "CoverPageName": SimTypeBottom(label="PWSTR"), "UseServerCoverPage": SimTypeBottom(label="BOOL"), "RecName": SimTypeBottom(label="PWSTR"), "RecFaxNumber": SimTypeBottom(label="PWSTR"), "RecCompany": SimTypeBottom(label="PWSTR"), "RecStreetAddress": SimTypeBottom(label="PWSTR"), "RecCity": SimTypeBottom(label="PWSTR"), "RecState": SimTypeBottom(label="PWSTR"), "RecZip": SimTypeBottom(label="PWSTR"), "RecCountry": SimTypeBottom(label="PWSTR"), "RecTitle": SimTypeBottom(label="PWSTR"), "RecDepartment": SimTypeBottom(label="PWSTR"), "RecOfficeLocation": SimTypeBottom(label="PWSTR"), "RecHomePhone": SimTypeBottom(label="PWSTR"), "RecOfficePhone": SimTypeBottom(label="PWSTR"), "SdrName": SimTypeBottom(label="PWSTR"), "SdrFaxNumber": SimTypeBottom(label="PWSTR"), "SdrCompany": SimTypeBottom(label="PWSTR"), "SdrAddress": SimTypeBottom(label="PWSTR"), "SdrTitle": SimTypeBottom(label="PWSTR"), "SdrDepartment": SimTypeBottom(label="PWSTR"), "SdrOfficeLocation": SimTypeBottom(label="PWSTR"), "SdrHomePhone": SimTypeBottom(label="PWSTR"), "SdrOfficePhone": SimTypeBottom(label="PWSTR"), "Note": SimTypeBottom(label="PWSTR"), "Subject": SimTypeBottom(label="PWSTR"), "TimeSent": SimTypeBottom(label="SYSTEMTIME"), "PageCount": SimTypeInt(signed=False, label="UInt32")}, name="FAX_COVERPAGE_INFOW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxHandle", "FileName", "JobParams", "CoverpageInfo", "FaxJobId"]),
        #
        'FaxSendDocumentForBroadcastA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeFunction([SimTypeBottom(label="HANDLE"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "RecipientNumber": SimTypeBottom(label="PSTR"), "RecipientName": SimTypeBottom(label="PSTR"), "Tsid": SimTypeBottom(label="PSTR"), "SenderName": SimTypeBottom(label="PSTR"), "SenderCompany": SimTypeBottom(label="PSTR"), "SenderDept": SimTypeBottom(label="PSTR"), "BillingCode": SimTypeBottom(label="PSTR"), "ScheduleAction": SimTypeInt(signed=False, label="UInt32"), "ScheduleTime": SimTypeBottom(label="SYSTEMTIME"), "DeliveryReportType": SimTypeInt(signed=False, label="UInt32"), "DeliveryReportAddress": SimTypeBottom(label="PSTR"), "DocumentName": SimTypeBottom(label="PSTR"), "CallHandle": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), 3)}, name="FAX_JOB_PARAMA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "CoverPageName": SimTypeBottom(label="PSTR"), "UseServerCoverPage": SimTypeBottom(label="BOOL"), "RecName": SimTypeBottom(label="PSTR"), "RecFaxNumber": SimTypeBottom(label="PSTR"), "RecCompany": SimTypeBottom(label="PSTR"), "RecStreetAddress": SimTypeBottom(label="PSTR"), "RecCity": SimTypeBottom(label="PSTR"), "RecState": SimTypeBottom(label="PSTR"), "RecZip": SimTypeBottom(label="PSTR"), "RecCountry": SimTypeBottom(label="PSTR"), "RecTitle": SimTypeBottom(label="PSTR"), "RecDepartment": SimTypeBottom(label="PSTR"), "RecOfficeLocation": SimTypeBottom(label="PSTR"), "RecHomePhone": SimTypeBottom(label="PSTR"), "RecOfficePhone": SimTypeBottom(label="PSTR"), "SdrName": SimTypeBottom(label="PSTR"), "SdrFaxNumber": SimTypeBottom(label="PSTR"), "SdrCompany": SimTypeBottom(label="PSTR"), "SdrAddress": SimTypeBottom(label="PSTR"), "SdrTitle": SimTypeBottom(label="PSTR"), "SdrDepartment": SimTypeBottom(label="PSTR"), "SdrOfficeLocation": SimTypeBottom(label="PSTR"), "SdrHomePhone": SimTypeBottom(label="PSTR"), "SdrOfficePhone": SimTypeBottom(label="PSTR"), "Note": SimTypeBottom(label="PSTR"), "Subject": SimTypeBottom(label="PSTR"), "TimeSent": SimTypeBottom(label="SYSTEMTIME"), "PageCount": SimTypeInt(signed=False, label="UInt32")}, name="FAX_COVERPAGE_INFOA", pack=False, align=None), offset=0)], SimTypeBottom(label="BOOL"), arg_names=["FaxHandle", "RecipientNumber", "Context", "JobParams", "CoverpageInfo"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxHandle", "FileName", "FaxJobId", "FaxRecipientCallback", "Context"]),
        #
        'FaxSendDocumentForBroadcastW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeFunction([SimTypeBottom(label="HANDLE"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "RecipientNumber": SimTypeBottom(label="PWSTR"), "RecipientName": SimTypeBottom(label="PWSTR"), "Tsid": SimTypeBottom(label="PWSTR"), "SenderName": SimTypeBottom(label="PWSTR"), "SenderCompany": SimTypeBottom(label="PWSTR"), "SenderDept": SimTypeBottom(label="PWSTR"), "BillingCode": SimTypeBottom(label="PWSTR"), "ScheduleAction": SimTypeInt(signed=False, label="UInt32"), "ScheduleTime": SimTypeBottom(label="SYSTEMTIME"), "DeliveryReportType": SimTypeInt(signed=False, label="UInt32"), "DeliveryReportAddress": SimTypeBottom(label="PWSTR"), "DocumentName": SimTypeBottom(label="PWSTR"), "CallHandle": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeFixedSizeArray(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), 3)}, name="FAX_JOB_PARAMW", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "CoverPageName": SimTypeBottom(label="PWSTR"), "UseServerCoverPage": SimTypeBottom(label="BOOL"), "RecName": SimTypeBottom(label="PWSTR"), "RecFaxNumber": SimTypeBottom(label="PWSTR"), "RecCompany": SimTypeBottom(label="PWSTR"), "RecStreetAddress": SimTypeBottom(label="PWSTR"), "RecCity": SimTypeBottom(label="PWSTR"), "RecState": SimTypeBottom(label="PWSTR"), "RecZip": SimTypeBottom(label="PWSTR"), "RecCountry": SimTypeBottom(label="PWSTR"), "RecTitle": SimTypeBottom(label="PWSTR"), "RecDepartment": SimTypeBottom(label="PWSTR"), "RecOfficeLocation": SimTypeBottom(label="PWSTR"), "RecHomePhone": SimTypeBottom(label="PWSTR"), "RecOfficePhone": SimTypeBottom(label="PWSTR"), "SdrName": SimTypeBottom(label="PWSTR"), "SdrFaxNumber": SimTypeBottom(label="PWSTR"), "SdrCompany": SimTypeBottom(label="PWSTR"), "SdrAddress": SimTypeBottom(label="PWSTR"), "SdrTitle": SimTypeBottom(label="PWSTR"), "SdrDepartment": SimTypeBottom(label="PWSTR"), "SdrOfficeLocation": SimTypeBottom(label="PWSTR"), "SdrHomePhone": SimTypeBottom(label="PWSTR"), "SdrOfficePhone": SimTypeBottom(label="PWSTR"), "Note": SimTypeBottom(label="PWSTR"), "Subject": SimTypeBottom(label="PWSTR"), "TimeSent": SimTypeBottom(label="SYSTEMTIME"), "PageCount": SimTypeInt(signed=False, label="UInt32")}, name="FAX_COVERPAGE_INFOW", pack=False, align=None), offset=0)], SimTypeBottom(label="BOOL"), arg_names=["FaxHandle", "RecipientNumber", "Context", "JobParams", "CoverpageInfo"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxHandle", "FileName", "FaxJobId", "FaxRecipientCallback", "Context"]),
        #
        'FaxEnumJobsA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "JobId": SimTypeInt(signed=False, label="UInt32"), "UserName": SimTypeBottom(label="PSTR"), "JobType": SimTypeInt(signed=False, label="UInt32"), "QueueStatus": SimTypeInt(signed=False, label="UInt32"), "Status": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "PageCount": SimTypeInt(signed=False, label="UInt32"), "RecipientNumber": SimTypeBottom(label="PSTR"), "RecipientName": SimTypeBottom(label="PSTR"), "Tsid": SimTypeBottom(label="PSTR"), "SenderName": SimTypeBottom(label="PSTR"), "SenderCompany": SimTypeBottom(label="PSTR"), "SenderDept": SimTypeBottom(label="PSTR"), "BillingCode": SimTypeBottom(label="PSTR"), "ScheduleAction": SimTypeInt(signed=False, label="UInt32"), "ScheduleTime": SimTypeBottom(label="SYSTEMTIME"), "DeliveryReportType": SimTypeInt(signed=False, label="UInt32"), "DeliveryReportAddress": SimTypeBottom(label="PSTR"), "DocumentName": SimTypeBottom(label="PSTR")}, name="FAX_JOB_ENTRYA", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxHandle", "JobEntry", "JobsReturned"]),
        #
        'FaxEnumJobsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "JobId": SimTypeInt(signed=False, label="UInt32"), "UserName": SimTypeBottom(label="PWSTR"), "JobType": SimTypeInt(signed=False, label="UInt32"), "QueueStatus": SimTypeInt(signed=False, label="UInt32"), "Status": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "PageCount": SimTypeInt(signed=False, label="UInt32"), "RecipientNumber": SimTypeBottom(label="PWSTR"), "RecipientName": SimTypeBottom(label="PWSTR"), "Tsid": SimTypeBottom(label="PWSTR"), "SenderName": SimTypeBottom(label="PWSTR"), "SenderCompany": SimTypeBottom(label="PWSTR"), "SenderDept": SimTypeBottom(label="PWSTR"), "BillingCode": SimTypeBottom(label="PWSTR"), "ScheduleAction": SimTypeInt(signed=False, label="UInt32"), "ScheduleTime": SimTypeBottom(label="SYSTEMTIME"), "DeliveryReportType": SimTypeInt(signed=False, label="UInt32"), "DeliveryReportAddress": SimTypeBottom(label="PWSTR"), "DocumentName": SimTypeBottom(label="PWSTR")}, name="FAX_JOB_ENTRYW", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxHandle", "JobEntry", "JobsReturned"]),
        #
        'FaxGetJobA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "JobId": SimTypeInt(signed=False, label="UInt32"), "UserName": SimTypeBottom(label="PSTR"), "JobType": SimTypeInt(signed=False, label="UInt32"), "QueueStatus": SimTypeInt(signed=False, label="UInt32"), "Status": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "PageCount": SimTypeInt(signed=False, label="UInt32"), "RecipientNumber": SimTypeBottom(label="PSTR"), "RecipientName": SimTypeBottom(label="PSTR"), "Tsid": SimTypeBottom(label="PSTR"), "SenderName": SimTypeBottom(label="PSTR"), "SenderCompany": SimTypeBottom(label="PSTR"), "SenderDept": SimTypeBottom(label="PSTR"), "BillingCode": SimTypeBottom(label="PSTR"), "ScheduleAction": SimTypeInt(signed=False, label="UInt32"), "ScheduleTime": SimTypeBottom(label="SYSTEMTIME"), "DeliveryReportType": SimTypeInt(signed=False, label="UInt32"), "DeliveryReportAddress": SimTypeBottom(label="PSTR"), "DocumentName": SimTypeBottom(label="PSTR")}, name="FAX_JOB_ENTRYA", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxHandle", "JobId", "JobEntry"]),
        #
        'FaxGetJobW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "JobId": SimTypeInt(signed=False, label="UInt32"), "UserName": SimTypeBottom(label="PWSTR"), "JobType": SimTypeInt(signed=False, label="UInt32"), "QueueStatus": SimTypeInt(signed=False, label="UInt32"), "Status": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "PageCount": SimTypeInt(signed=False, label="UInt32"), "RecipientNumber": SimTypeBottom(label="PWSTR"), "RecipientName": SimTypeBottom(label="PWSTR"), "Tsid": SimTypeBottom(label="PWSTR"), "SenderName": SimTypeBottom(label="PWSTR"), "SenderCompany": SimTypeBottom(label="PWSTR"), "SenderDept": SimTypeBottom(label="PWSTR"), "BillingCode": SimTypeBottom(label="PWSTR"), "ScheduleAction": SimTypeInt(signed=False, label="UInt32"), "ScheduleTime": SimTypeBottom(label="SYSTEMTIME"), "DeliveryReportType": SimTypeInt(signed=False, label="UInt32"), "DeliveryReportAddress": SimTypeBottom(label="PWSTR"), "DocumentName": SimTypeBottom(label="PWSTR")}, name="FAX_JOB_ENTRYW", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxHandle", "JobId", "JobEntry"]),
        #
        'FaxSetJobA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "JobId": SimTypeInt(signed=False, label="UInt32"), "UserName": SimTypeBottom(label="PSTR"), "JobType": SimTypeInt(signed=False, label="UInt32"), "QueueStatus": SimTypeInt(signed=False, label="UInt32"), "Status": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "PageCount": SimTypeInt(signed=False, label="UInt32"), "RecipientNumber": SimTypeBottom(label="PSTR"), "RecipientName": SimTypeBottom(label="PSTR"), "Tsid": SimTypeBottom(label="PSTR"), "SenderName": SimTypeBottom(label="PSTR"), "SenderCompany": SimTypeBottom(label="PSTR"), "SenderDept": SimTypeBottom(label="PSTR"), "BillingCode": SimTypeBottom(label="PSTR"), "ScheduleAction": SimTypeInt(signed=False, label="UInt32"), "ScheduleTime": SimTypeBottom(label="SYSTEMTIME"), "DeliveryReportType": SimTypeInt(signed=False, label="UInt32"), "DeliveryReportAddress": SimTypeBottom(label="PSTR"), "DocumentName": SimTypeBottom(label="PSTR")}, name="FAX_JOB_ENTRYA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxHandle", "JobId", "Command", "JobEntry"]),
        #
        'FaxSetJobW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "JobId": SimTypeInt(signed=False, label="UInt32"), "UserName": SimTypeBottom(label="PWSTR"), "JobType": SimTypeInt(signed=False, label="UInt32"), "QueueStatus": SimTypeInt(signed=False, label="UInt32"), "Status": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "PageCount": SimTypeInt(signed=False, label="UInt32"), "RecipientNumber": SimTypeBottom(label="PWSTR"), "RecipientName": SimTypeBottom(label="PWSTR"), "Tsid": SimTypeBottom(label="PWSTR"), "SenderName": SimTypeBottom(label="PWSTR"), "SenderCompany": SimTypeBottom(label="PWSTR"), "SenderDept": SimTypeBottom(label="PWSTR"), "BillingCode": SimTypeBottom(label="PWSTR"), "ScheduleAction": SimTypeInt(signed=False, label="UInt32"), "ScheduleTime": SimTypeBottom(label="SYSTEMTIME"), "DeliveryReportType": SimTypeInt(signed=False, label="UInt32"), "DeliveryReportAddress": SimTypeBottom(label="PWSTR"), "DocumentName": SimTypeBottom(label="PWSTR")}, name="FAX_JOB_ENTRYW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxHandle", "JobId", "Command", "JobEntry"]),
        #
        'FaxGetPageData': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxHandle", "JobId", "Buffer", "BufferSize", "ImageWidth", "ImageHeight"]),
        #
        'FaxGetDeviceStatusA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "CallerId": SimTypeBottom(label="PSTR"), "Csid": SimTypeBottom(label="PSTR"), "CurrentPage": SimTypeInt(signed=False, label="UInt32"), "DeviceId": SimTypeInt(signed=False, label="UInt32"), "DeviceName": SimTypeBottom(label="PSTR"), "DocumentName": SimTypeBottom(label="PSTR"), "JobType": SimTypeInt(signed=False, label="UInt32"), "PhoneNumber": SimTypeBottom(label="PSTR"), "RoutingString": SimTypeBottom(label="PSTR"), "SenderName": SimTypeBottom(label="PSTR"), "RecipientName": SimTypeBottom(label="PSTR"), "Size": SimTypeInt(signed=False, label="UInt32"), "StartTime": SimTypeBottom(label="FILETIME"), "Status": SimTypeInt(signed=False, label="UInt32"), "StatusString": SimTypeBottom(label="PSTR"), "SubmittedTime": SimTypeBottom(label="FILETIME"), "TotalPages": SimTypeInt(signed=False, label="UInt32"), "Tsid": SimTypeBottom(label="PSTR"), "UserName": SimTypeBottom(label="PSTR")}, name="FAX_DEVICE_STATUSA", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxPortHandle", "DeviceStatus"]),
        #
        'FaxGetDeviceStatusW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "CallerId": SimTypeBottom(label="PWSTR"), "Csid": SimTypeBottom(label="PWSTR"), "CurrentPage": SimTypeInt(signed=False, label="UInt32"), "DeviceId": SimTypeInt(signed=False, label="UInt32"), "DeviceName": SimTypeBottom(label="PWSTR"), "DocumentName": SimTypeBottom(label="PWSTR"), "JobType": SimTypeInt(signed=False, label="UInt32"), "PhoneNumber": SimTypeBottom(label="PWSTR"), "RoutingString": SimTypeBottom(label="PWSTR"), "SenderName": SimTypeBottom(label="PWSTR"), "RecipientName": SimTypeBottom(label="PWSTR"), "Size": SimTypeInt(signed=False, label="UInt32"), "StartTime": SimTypeBottom(label="FILETIME"), "Status": SimTypeInt(signed=False, label="UInt32"), "StatusString": SimTypeBottom(label="PWSTR"), "SubmittedTime": SimTypeBottom(label="FILETIME"), "TotalPages": SimTypeInt(signed=False, label="UInt32"), "Tsid": SimTypeBottom(label="PWSTR"), "UserName": SimTypeBottom(label="PWSTR")}, name="FAX_DEVICE_STATUSW", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxPortHandle", "DeviceStatus"]),
        #
        'FaxAbort': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxHandle", "JobId"]),
        #
        'FaxGetConfigurationA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Retries": SimTypeInt(signed=False, label="UInt32"), "RetryDelay": SimTypeInt(signed=False, label="UInt32"), "DirtyDays": SimTypeInt(signed=False, label="UInt32"), "Branding": SimTypeBottom(label="BOOL"), "UseDeviceTsid": SimTypeBottom(label="BOOL"), "ServerCp": SimTypeBottom(label="BOOL"), "PauseServerQueue": SimTypeBottom(label="BOOL"), "StartCheapTime": SimStruct({"Hour": SimTypeShort(signed=False, label="UInt16"), "Minute": SimTypeShort(signed=False, label="UInt16")}, name="FAX_TIME", pack=False, align=None), "StopCheapTime": SimStruct({"Hour": SimTypeShort(signed=False, label="UInt16"), "Minute": SimTypeShort(signed=False, label="UInt16")}, name="FAX_TIME", pack=False, align=None), "ArchiveOutgoingFaxes": SimTypeBottom(label="BOOL"), "ArchiveDirectory": SimTypeBottom(label="PSTR"), "Reserved": SimTypeBottom(label="PSTR")}, name="FAX_CONFIGURATIONA", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxHandle", "FaxConfig"]),
        #
        'FaxGetConfigurationW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Retries": SimTypeInt(signed=False, label="UInt32"), "RetryDelay": SimTypeInt(signed=False, label="UInt32"), "DirtyDays": SimTypeInt(signed=False, label="UInt32"), "Branding": SimTypeBottom(label="BOOL"), "UseDeviceTsid": SimTypeBottom(label="BOOL"), "ServerCp": SimTypeBottom(label="BOOL"), "PauseServerQueue": SimTypeBottom(label="BOOL"), "StartCheapTime": SimStruct({"Hour": SimTypeShort(signed=False, label="UInt16"), "Minute": SimTypeShort(signed=False, label="UInt16")}, name="FAX_TIME", pack=False, align=None), "StopCheapTime": SimStruct({"Hour": SimTypeShort(signed=False, label="UInt16"), "Minute": SimTypeShort(signed=False, label="UInt16")}, name="FAX_TIME", pack=False, align=None), "ArchiveOutgoingFaxes": SimTypeBottom(label="BOOL"), "ArchiveDirectory": SimTypeBottom(label="PWSTR"), "Reserved": SimTypeBottom(label="PWSTR")}, name="FAX_CONFIGURATIONW", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxHandle", "FaxConfig"]),
        #
        'FaxSetConfigurationA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Retries": SimTypeInt(signed=False, label="UInt32"), "RetryDelay": SimTypeInt(signed=False, label="UInt32"), "DirtyDays": SimTypeInt(signed=False, label="UInt32"), "Branding": SimTypeBottom(label="BOOL"), "UseDeviceTsid": SimTypeBottom(label="BOOL"), "ServerCp": SimTypeBottom(label="BOOL"), "PauseServerQueue": SimTypeBottom(label="BOOL"), "StartCheapTime": SimStruct({"Hour": SimTypeShort(signed=False, label="UInt16"), "Minute": SimTypeShort(signed=False, label="UInt16")}, name="FAX_TIME", pack=False, align=None), "StopCheapTime": SimStruct({"Hour": SimTypeShort(signed=False, label="UInt16"), "Minute": SimTypeShort(signed=False, label="UInt16")}, name="FAX_TIME", pack=False, align=None), "ArchiveOutgoingFaxes": SimTypeBottom(label="BOOL"), "ArchiveDirectory": SimTypeBottom(label="PSTR"), "Reserved": SimTypeBottom(label="PSTR")}, name="FAX_CONFIGURATIONA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxHandle", "FaxConfig"]),
        #
        'FaxSetConfigurationW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Retries": SimTypeInt(signed=False, label="UInt32"), "RetryDelay": SimTypeInt(signed=False, label="UInt32"), "DirtyDays": SimTypeInt(signed=False, label="UInt32"), "Branding": SimTypeBottom(label="BOOL"), "UseDeviceTsid": SimTypeBottom(label="BOOL"), "ServerCp": SimTypeBottom(label="BOOL"), "PauseServerQueue": SimTypeBottom(label="BOOL"), "StartCheapTime": SimStruct({"Hour": SimTypeShort(signed=False, label="UInt16"), "Minute": SimTypeShort(signed=False, label="UInt16")}, name="FAX_TIME", pack=False, align=None), "StopCheapTime": SimStruct({"Hour": SimTypeShort(signed=False, label="UInt16"), "Minute": SimTypeShort(signed=False, label="UInt16")}, name="FAX_TIME", pack=False, align=None), "ArchiveOutgoingFaxes": SimTypeBottom(label="BOOL"), "ArchiveDirectory": SimTypeBottom(label="PWSTR"), "Reserved": SimTypeBottom(label="PWSTR")}, name="FAX_CONFIGURATIONW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxHandle", "FaxConfig"]),
        #
        'FaxGetLoggingCategoriesA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimStruct({"Name": SimTypeBottom(label="PSTR"), "Category": SimTypeInt(signed=False, label="UInt32"), "Level": SimTypeInt(signed=False, label="UInt32")}, name="FAX_LOG_CATEGORYA", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxHandle", "Categories", "NumberCategories"]),
        #
        'FaxGetLoggingCategoriesW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimStruct({"Name": SimTypeBottom(label="PWSTR"), "Category": SimTypeInt(signed=False, label="UInt32"), "Level": SimTypeInt(signed=False, label="UInt32")}, name="FAX_LOG_CATEGORYW", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxHandle", "Categories", "NumberCategories"]),
        #
        'FaxSetLoggingCategoriesA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Name": SimTypeBottom(label="PSTR"), "Category": SimTypeInt(signed=False, label="UInt32"), "Level": SimTypeInt(signed=False, label="UInt32")}, name="FAX_LOG_CATEGORYA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxHandle", "Categories", "NumberCategories"]),
        #
        'FaxSetLoggingCategoriesW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Name": SimTypeBottom(label="PWSTR"), "Category": SimTypeInt(signed=False, label="UInt32"), "Level": SimTypeInt(signed=False, label="UInt32")}, name="FAX_LOG_CATEGORYW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxHandle", "Categories", "NumberCategories"]),
        #
        'FaxEnumPortsA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "DeviceId": SimTypeInt(signed=False, label="UInt32"), "State": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "Rings": SimTypeInt(signed=False, label="UInt32"), "Priority": SimTypeInt(signed=False, label="UInt32"), "DeviceName": SimTypeBottom(label="PSTR"), "Tsid": SimTypeBottom(label="PSTR"), "Csid": SimTypeBottom(label="PSTR")}, name="FAX_PORT_INFOA", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxHandle", "PortInfo", "PortsReturned"]),
        #
        'FaxEnumPortsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "DeviceId": SimTypeInt(signed=False, label="UInt32"), "State": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "Rings": SimTypeInt(signed=False, label="UInt32"), "Priority": SimTypeInt(signed=False, label="UInt32"), "DeviceName": SimTypeBottom(label="PWSTR"), "Tsid": SimTypeBottom(label="PWSTR"), "Csid": SimTypeBottom(label="PWSTR")}, name="FAX_PORT_INFOW", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxHandle", "PortInfo", "PortsReturned"]),
        #
        'FaxGetPortA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "DeviceId": SimTypeInt(signed=False, label="UInt32"), "State": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "Rings": SimTypeInt(signed=False, label="UInt32"), "Priority": SimTypeInt(signed=False, label="UInt32"), "DeviceName": SimTypeBottom(label="PSTR"), "Tsid": SimTypeBottom(label="PSTR"), "Csid": SimTypeBottom(label="PSTR")}, name="FAX_PORT_INFOA", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxPortHandle", "PortInfo"]),
        #
        'FaxGetPortW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "DeviceId": SimTypeInt(signed=False, label="UInt32"), "State": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "Rings": SimTypeInt(signed=False, label="UInt32"), "Priority": SimTypeInt(signed=False, label="UInt32"), "DeviceName": SimTypeBottom(label="PWSTR"), "Tsid": SimTypeBottom(label="PWSTR"), "Csid": SimTypeBottom(label="PWSTR")}, name="FAX_PORT_INFOW", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxPortHandle", "PortInfo"]),
        #
        'FaxSetPortA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "DeviceId": SimTypeInt(signed=False, label="UInt32"), "State": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "Rings": SimTypeInt(signed=False, label="UInt32"), "Priority": SimTypeInt(signed=False, label="UInt32"), "DeviceName": SimTypeBottom(label="PSTR"), "Tsid": SimTypeBottom(label="PSTR"), "Csid": SimTypeBottom(label="PSTR")}, name="FAX_PORT_INFOA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxPortHandle", "PortInfo"]),
        #
        'FaxSetPortW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "DeviceId": SimTypeInt(signed=False, label="UInt32"), "State": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "Rings": SimTypeInt(signed=False, label="UInt32"), "Priority": SimTypeInt(signed=False, label="UInt32"), "DeviceName": SimTypeBottom(label="PWSTR"), "Tsid": SimTypeBottom(label="PWSTR"), "Csid": SimTypeBottom(label="PWSTR")}, name="FAX_PORT_INFOW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxPortHandle", "PortInfo"]),
        #
        'FaxEnumRoutingMethodsA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "DeviceId": SimTypeInt(signed=False, label="UInt32"), "Enabled": SimTypeBottom(label="BOOL"), "DeviceName": SimTypeBottom(label="PSTR"), "Guid": SimTypeBottom(label="PSTR"), "FriendlyName": SimTypeBottom(label="PSTR"), "FunctionName": SimTypeBottom(label="PSTR"), "ExtensionImageName": SimTypeBottom(label="PSTR"), "ExtensionFriendlyName": SimTypeBottom(label="PSTR")}, name="FAX_ROUTING_METHODA", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxPortHandle", "RoutingMethod", "MethodsReturned"]),
        #
        'FaxEnumRoutingMethodsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "DeviceId": SimTypeInt(signed=False, label="UInt32"), "Enabled": SimTypeBottom(label="BOOL"), "DeviceName": SimTypeBottom(label="PWSTR"), "Guid": SimTypeBottom(label="PWSTR"), "FriendlyName": SimTypeBottom(label="PWSTR"), "FunctionName": SimTypeBottom(label="PWSTR"), "ExtensionImageName": SimTypeBottom(label="PWSTR"), "ExtensionFriendlyName": SimTypeBottom(label="PWSTR")}, name="FAX_ROUTING_METHODW", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxPortHandle", "RoutingMethod", "MethodsReturned"]),
        #
        'FaxEnableRoutingMethodA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxPortHandle", "RoutingGuid", "Enabled"]),
        #
        'FaxEnableRoutingMethodW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxPortHandle", "RoutingGuid", "Enabled"]),
        #
        'FaxEnumGlobalRoutingInfoA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Priority": SimTypeInt(signed=False, label="UInt32"), "Guid": SimTypeBottom(label="PSTR"), "FriendlyName": SimTypeBottom(label="PSTR"), "FunctionName": SimTypeBottom(label="PSTR"), "ExtensionImageName": SimTypeBottom(label="PSTR"), "ExtensionFriendlyName": SimTypeBottom(label="PSTR")}, name="FAX_GLOBAL_ROUTING_INFOA", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxHandle", "RoutingInfo", "MethodsReturned"]),
        #
        'FaxEnumGlobalRoutingInfoW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Priority": SimTypeInt(signed=False, label="UInt32"), "Guid": SimTypeBottom(label="PWSTR"), "FriendlyName": SimTypeBottom(label="PWSTR"), "FunctionName": SimTypeBottom(label="PWSTR"), "ExtensionImageName": SimTypeBottom(label="PWSTR"), "ExtensionFriendlyName": SimTypeBottom(label="PWSTR")}, name="FAX_GLOBAL_ROUTING_INFOW", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxHandle", "RoutingInfo", "MethodsReturned"]),
        #
        'FaxSetGlobalRoutingInfoA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Priority": SimTypeInt(signed=False, label="UInt32"), "Guid": SimTypeBottom(label="PSTR"), "FriendlyName": SimTypeBottom(label="PSTR"), "FunctionName": SimTypeBottom(label="PSTR"), "ExtensionImageName": SimTypeBottom(label="PSTR"), "ExtensionFriendlyName": SimTypeBottom(label="PSTR")}, name="FAX_GLOBAL_ROUTING_INFOA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxHandle", "RoutingInfo"]),
        #
        'FaxSetGlobalRoutingInfoW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "Priority": SimTypeInt(signed=False, label="UInt32"), "Guid": SimTypeBottom(label="PWSTR"), "FriendlyName": SimTypeBottom(label="PWSTR"), "FunctionName": SimTypeBottom(label="PWSTR"), "ExtensionImageName": SimTypeBottom(label="PWSTR"), "ExtensionFriendlyName": SimTypeBottom(label="PWSTR")}, name="FAX_GLOBAL_ROUTING_INFOW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxHandle", "RoutingInfo"]),
        #
        'FaxGetRoutingInfoA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxPortHandle", "RoutingGuid", "RoutingInfoBuffer", "RoutingInfoBufferSize"]),
        #
        'FaxGetRoutingInfoW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxPortHandle", "RoutingGuid", "RoutingInfoBuffer", "RoutingInfoBufferSize"]),
        #
        'FaxSetRoutingInfoA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxPortHandle", "RoutingGuid", "RoutingInfoBuffer", "RoutingInfoBufferSize"]),
        #
        'FaxSetRoutingInfoW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxPortHandle", "RoutingGuid", "RoutingInfoBuffer", "RoutingInfoBufferSize"]),
        #
        'FaxInitializeEventQueue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxHandle", "CompletionPort", "CompletionKey", "hWnd", "MessageStart"]),
        #
        'FaxFreeBuffer': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Buffer"]),
        #
        'FaxStartPrintJobA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "DocName": SimTypeBottom(label="PSTR"), "RecipientName": SimTypeBottom(label="PSTR"), "RecipientNumber": SimTypeBottom(label="PSTR"), "SenderName": SimTypeBottom(label="PSTR"), "SenderCompany": SimTypeBottom(label="PSTR"), "SenderDept": SimTypeBottom(label="PSTR"), "SenderBillingCode": SimTypeBottom(label="PSTR"), "Reserved": SimTypeBottom(label="PSTR"), "DrEmailAddress": SimTypeBottom(label="PSTR"), "OutputFileName": SimTypeBottom(label="PSTR")}, name="FAX_PRINT_INFOA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "hDC": SimTypeBottom(label="HDC"), "ServerName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 16)}, name="FAX_CONTEXT_INFOA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["PrinterName", "PrintInfo", "FaxJobId", "FaxContextInfo"]),
        #
        'FaxStartPrintJobW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "DocName": SimTypeBottom(label="PWSTR"), "RecipientName": SimTypeBottom(label="PWSTR"), "RecipientNumber": SimTypeBottom(label="PWSTR"), "SenderName": SimTypeBottom(label="PWSTR"), "SenderCompany": SimTypeBottom(label="PWSTR"), "SenderDept": SimTypeBottom(label="PWSTR"), "SenderBillingCode": SimTypeBottom(label="PWSTR"), "Reserved": SimTypeBottom(label="PWSTR"), "DrEmailAddress": SimTypeBottom(label="PWSTR"), "OutputFileName": SimTypeBottom(label="PWSTR")}, name="FAX_PRINT_INFOW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "hDC": SimTypeBottom(label="HDC"), "ServerName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 16)}, name="FAX_CONTEXT_INFOW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["PrinterName", "PrintInfo", "FaxJobId", "FaxContextInfo"]),
        #
        'FaxPrintCoverPageA': SimTypeFunction([SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "hDC": SimTypeBottom(label="HDC"), "ServerName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 16)}, name="FAX_CONTEXT_INFOA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "CoverPageName": SimTypeBottom(label="PSTR"), "UseServerCoverPage": SimTypeBottom(label="BOOL"), "RecName": SimTypeBottom(label="PSTR"), "RecFaxNumber": SimTypeBottom(label="PSTR"), "RecCompany": SimTypeBottom(label="PSTR"), "RecStreetAddress": SimTypeBottom(label="PSTR"), "RecCity": SimTypeBottom(label="PSTR"), "RecState": SimTypeBottom(label="PSTR"), "RecZip": SimTypeBottom(label="PSTR"), "RecCountry": SimTypeBottom(label="PSTR"), "RecTitle": SimTypeBottom(label="PSTR"), "RecDepartment": SimTypeBottom(label="PSTR"), "RecOfficeLocation": SimTypeBottom(label="PSTR"), "RecHomePhone": SimTypeBottom(label="PSTR"), "RecOfficePhone": SimTypeBottom(label="PSTR"), "SdrName": SimTypeBottom(label="PSTR"), "SdrFaxNumber": SimTypeBottom(label="PSTR"), "SdrCompany": SimTypeBottom(label="PSTR"), "SdrAddress": SimTypeBottom(label="PSTR"), "SdrTitle": SimTypeBottom(label="PSTR"), "SdrDepartment": SimTypeBottom(label="PSTR"), "SdrOfficeLocation": SimTypeBottom(label="PSTR"), "SdrHomePhone": SimTypeBottom(label="PSTR"), "SdrOfficePhone": SimTypeBottom(label="PSTR"), "Note": SimTypeBottom(label="PSTR"), "Subject": SimTypeBottom(label="PSTR"), "TimeSent": SimTypeBottom(label="SYSTEMTIME"), "PageCount": SimTypeInt(signed=False, label="UInt32")}, name="FAX_COVERPAGE_INFOA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxContextInfo", "CoverPageInfo"]),
        #
        'FaxPrintCoverPageW': SimTypeFunction([SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "hDC": SimTypeBottom(label="HDC"), "ServerName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 16)}, name="FAX_CONTEXT_INFOW", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"SizeOfStruct": SimTypeInt(signed=False, label="UInt32"), "CoverPageName": SimTypeBottom(label="PWSTR"), "UseServerCoverPage": SimTypeBottom(label="BOOL"), "RecName": SimTypeBottom(label="PWSTR"), "RecFaxNumber": SimTypeBottom(label="PWSTR"), "RecCompany": SimTypeBottom(label="PWSTR"), "RecStreetAddress": SimTypeBottom(label="PWSTR"), "RecCity": SimTypeBottom(label="PWSTR"), "RecState": SimTypeBottom(label="PWSTR"), "RecZip": SimTypeBottom(label="PWSTR"), "RecCountry": SimTypeBottom(label="PWSTR"), "RecTitle": SimTypeBottom(label="PWSTR"), "RecDepartment": SimTypeBottom(label="PWSTR"), "RecOfficeLocation": SimTypeBottom(label="PWSTR"), "RecHomePhone": SimTypeBottom(label="PWSTR"), "RecOfficePhone": SimTypeBottom(label="PWSTR"), "SdrName": SimTypeBottom(label="PWSTR"), "SdrFaxNumber": SimTypeBottom(label="PWSTR"), "SdrCompany": SimTypeBottom(label="PWSTR"), "SdrAddress": SimTypeBottom(label="PWSTR"), "SdrTitle": SimTypeBottom(label="PWSTR"), "SdrDepartment": SimTypeBottom(label="PWSTR"), "SdrOfficeLocation": SimTypeBottom(label="PWSTR"), "SdrHomePhone": SimTypeBottom(label="PWSTR"), "SdrOfficePhone": SimTypeBottom(label="PWSTR"), "Note": SimTypeBottom(label="PWSTR"), "Subject": SimTypeBottom(label="PWSTR"), "TimeSent": SimTypeBottom(label="SYSTEMTIME"), "PageCount": SimTypeInt(signed=False, label="UInt32")}, name="FAX_COVERPAGE_INFOW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxContextInfo", "CoverPageInfo"]),
        #
        'FaxRegisterServiceProviderW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["DeviceProvider", "FriendlyName", "ImageName", "TspName"]),
        #
        'FaxUnregisterServiceProviderW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["DeviceProvider"]),
        #
        'FaxRegisterRoutingExtensionW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeFunction([SimTypeBottom(label="HANDLE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeBottom(label="PWSTR"), SimTypeBottom(label="PWSTR"), SimTypeBottom(label="PWSTR"), SimTypeBottom(label="PWSTR")], SimTypeBottom(label="BOOL"), arg_names=["FaxHandle", "Context", "MethodName", "FriendlyName", "FunctionName", "Guid"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxHandle", "ExtensionName", "FriendlyName", "ImageName", "CallBack", "Context"]),
        #
        'FaxAccessCheck': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["FaxHandle", "AccessMask"]),
    }

lib.set_prototypes(prototypes)
