/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.logstream;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.quarkus.vertx.http.runtime.devmode.Json;
import io.quarkus.vertx.http.runtime.logstream.LogController;
import io.quarkus.vertx.http.runtime.logstream.WebSocketLogHandler;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.ext.web.RoutingContext;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogStreamWebSocket
implements Handler<RoutingContext> {
    private static final Logger log = Logger.getLogger(LogStreamWebSocket.class.getName());
    private final WebSocketLogHandler webSocketHandler;
    private static final String TYPE = "type";
    private static final String INIT = "init";
    private static final String START = "start";
    private static final String STOP = "stop";
    private static final String UPDATE = "update";

    public LogStreamWebSocket(WebSocketLogHandler webSocketHandler) {
        this.webSocketHandler = webSocketHandler;
    }

    public void handle(RoutingContext event) {
        if ("websocket".equalsIgnoreCase(event.request().getHeader((CharSequence)HttpHeaderNames.UPGRADE)) && !event.request().isEnded()) {
            event.request().toWebSocket((Handler)new Handler<AsyncResult<ServerWebSocket>>(){

                public void handle(AsyncResult<ServerWebSocket> event) {
                    if (event.succeeded()) {
                        ServerWebSocket socket = (ServerWebSocket)event.result();
                        final SessionState state = new SessionState(socket);
                        socket.closeHandler((Handler)new Handler<Void>(){

                            public void handle(Void event) {
                                LogStreamWebSocket.this.stop(state);
                            }
                        });
                        socket.textMessageHandler((Handler)new Handler<String>(){

                            public void handle(String event) {
                                LogStreamWebSocket.this.onMessage(event, state);
                            }
                        });
                        socket.writeTextMessage(LogStreamWebSocket.this.createInitMessage());
                        LogStreamWebSocket.this.start(state);
                    } else {
                        log.log(Level.SEVERE, "Failed to connect to log server", event.cause());
                    }
                }
            });
        } else {
            event.next();
        }
    }

    public void onMessage(String message, SessionState session) {
        if (message != null && !message.isEmpty()) {
            if (message.equalsIgnoreCase(START)) {
                this.start(session);
            } else if (message.equalsIgnoreCase(STOP)) {
                this.stop(session);
            } else if (message.startsWith(UPDATE)) {
                this.update(message);
            }
        }
    }

    private void start(SessionState session) {
        if (!session.started) {
            session.started = true;
            this.webSocketHandler.addSession(session.id, session.session);
        }
    }

    private void stop(SessionState session) {
        this.webSocketHandler.removeSession(session.id);
        session.started = false;
    }

    private void update(String message) {
        String[] p = message.split("\\|");
        if (p.length == 3) {
            String loggerName = p[1];
            String levelVal = p[2];
            LogController.updateLogLevel(loggerName, levelVal);
        }
    }

    private String createInitMessage() {
        Json.JsonObjectBuilder initMessage = Json.object();
        initMessage.put(TYPE, INIT);
        initMessage.put("loggers", LogController.getLoggers());
        initMessage.put("levels", LogController.getLevels());
        return initMessage.build();
    }

    static class SessionState {
        ServerWebSocket session;
        String id;
        boolean started;

        public SessionState(ServerWebSocket session) {
            this.session = session;
            this.id = UUID.randomUUID().toString();
        }
    }
}

