/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.subscription.ContextSupport;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public abstract class MultiOperatorProcessor<I, O>
implements MultiSubscriber<I>,
Flow.Subscription,
ContextSupport {
    protected volatile MultiSubscriber<? super O> downstream;
    protected volatile Flow.Subscription upstream = null;
    private volatile int cancellationRequested = 0;
    private static final AtomicReferenceFieldUpdater<MultiOperatorProcessor, Flow.Subscription> UPSTREAM_UPDATER = AtomicReferenceFieldUpdater.newUpdater(MultiOperatorProcessor.class, Flow.Subscription.class, "upstream");
    private static final AtomicIntegerFieldUpdater<MultiOperatorProcessor> CANCELLATION_REQUESTED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(MultiOperatorProcessor.class, "cancellationRequested");

    public MultiOperatorProcessor(MultiSubscriber<? super O> downstream) {
        this.downstream = ParameterValidation.nonNull(downstream, "downstream");
    }

    void failAndCancel(Throwable throwable) {
        Flow.Subscription subscription = this.getUpstreamSubscription();
        if (subscription != null) {
            subscription.cancel();
        }
        this.onFailure(throwable);
    }

    protected Flow.Subscription getUpstreamSubscription() {
        return this.upstream;
    }

    protected boolean compareAndSetUpstreamSubscription(Flow.Subscription expectedValue, Flow.Subscription newValue) {
        return UPSTREAM_UPDATER.compareAndSet(this, expectedValue, newValue);
    }

    protected Flow.Subscription getAndSetUpstreamSubscription(Flow.Subscription newValue) {
        return UPSTREAM_UPDATER.getAndSet(this, newValue);
    }

    protected boolean isDone() {
        return this.getUpstreamSubscription() == Subscriptions.CANCELLED;
    }

    protected boolean isCancelled() {
        return this.cancellationRequested == 1;
    }

    @Override
    public Context context() {
        if (this.downstream instanceof ContextSupport) {
            return ((ContextSupport)((Object)this.downstream)).context();
        }
        return Context.empty();
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        if (this.compareAndSetUpstreamSubscription(null, subscription)) {
            this.downstream.onSubscribe(this);
        } else {
            subscription.cancel();
        }
    }

    @Override
    public void onFailure(Throwable throwable) {
        Flow.Subscription subscription = this.getAndSetUpstreamSubscription(Subscriptions.CANCELLED);
        if (subscription != Subscriptions.CANCELLED) {
            this.downstream.onFailure(throwable);
        } else {
            Infrastructure.handleDroppedException(throwable);
        }
    }

    @Override
    public void onItem(I item) {
        Flow.Subscription subscription = this.getUpstreamSubscription();
        if (subscription != Subscriptions.CANCELLED) {
            this.downstream.onItem(item);
        }
    }

    @Override
    public void onCompletion() {
        Flow.Subscription subscription = this.getAndSetUpstreamSubscription(Subscriptions.CANCELLED);
        if (subscription != Subscriptions.CANCELLED) {
            this.downstream.onCompletion();
        }
    }

    @Override
    public void request(long numberOfItems) {
        Flow.Subscription subscription = this.getUpstreamSubscription();
        if (subscription != Subscriptions.CANCELLED) {
            if (numberOfItems <= 0L) {
                this.onFailure(new IllegalArgumentException("Invalid number of request, must be greater than 0"));
                return;
            }
            subscription.request(numberOfItems);
        }
    }

    @Override
    public void cancel() {
        if (this.compareAndSwapDownstreamCancellationRequest()) {
            this.cancelUpstream();
        }
    }

    protected final boolean compareAndSwapDownstreamCancellationRequest() {
        return CANCELLATION_REQUESTED_UPDATER.compareAndSet(this, 0, 1);
    }

    protected void cancelUpstream() {
        this.cancellationRequested = 1;
        Flow.Subscription actual = UPSTREAM_UPDATER.getAndSet(this, Subscriptions.CANCELLED);
        if (actual != null && actual != Subscriptions.CANCELLED) {
            actual.cancel();
        }
    }
}

