/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.util;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.NodeStatsProducer;
import org.jitsi.nlj.util.SsrcAssociation;
import org.jitsi.nlj.util.SsrcAssociationStore;
import org.jitsi.utils.MediaType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0010J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jitsi/nlj/util/ReceiveSsrcStore;", "Lorg/jitsi/nlj/transform/NodeStatsProducer;", "ssrcAssociationStore", "Lorg/jitsi/nlj/util/SsrcAssociationStore;", "(Lorg/jitsi/nlj/util/SsrcAssociationStore;)V", "primaryMediaSsrcs", "", "", "getPrimaryMediaSsrcs", "()Ljava/util/Set;", "primaryVideoSsrcs", "getPrimaryVideoSsrcs", "receiveSsrcs", "getReceiveSsrcs", "receiveSsrcsByMediaType", "", "Lorg/jitsi/utils/MediaType;", "addReceiveSsrc", "", "ssrc", "mediaType", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "onSsrcAssociation", "ssrcAssociation", "Lorg/jitsi/nlj/util/SsrcAssociation;", "removeReceiveSsrc", "jitsi-media-transform"})
public final class ReceiveSsrcStore
implements NodeStatsProducer {
    @NotNull
    private final SsrcAssociationStore ssrcAssociationStore;
    @NotNull
    private final Set<Long> receiveSsrcs;
    @NotNull
    private final Map<MediaType, Set<Long>> receiveSsrcsByMediaType;
    @NotNull
    private final Set<Long> primaryMediaSsrcs;
    @NotNull
    private final Set<Long> primaryVideoSsrcs;

    public ReceiveSsrcStore(@NotNull SsrcAssociationStore ssrcAssociationStore) {
        Intrinsics.checkNotNullParameter(ssrcAssociationStore, "ssrcAssociationStore");
        this.ssrcAssociationStore = ssrcAssociationStore;
        this.receiveSsrcs = new CopyOnWriteArraySet();
        this.receiveSsrcsByMediaType = new ConcurrentHashMap();
        this.primaryMediaSsrcs = new CopyOnWriteArraySet();
        this.primaryVideoSsrcs = new CopyOnWriteArraySet();
        this.ssrcAssociationStore.onAssociation((Function1<? super SsrcAssociation, Unit>)new Function1<SsrcAssociation, Unit>((Object)this){

            @Override
            public final void invoke(@NotNull SsrcAssociation p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                ((ReceiveSsrcStore)this.receiver).onSsrcAssociation(p0);
            }
        });
    }

    @NotNull
    public final Set<Long> getReceiveSsrcs() {
        return this.receiveSsrcs;
    }

    @NotNull
    public final Set<Long> getPrimaryMediaSsrcs() {
        return this.primaryMediaSsrcs;
    }

    @NotNull
    public final Set<Long> getPrimaryVideoSsrcs() {
        return this.primaryVideoSsrcs;
    }

    public final void addReceiveSsrc(long ssrc2, @NotNull MediaType mediaType) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)mediaType, "mediaType");
        Map<MediaType, Set<Long>> $this$getOrPut$iv = this.receiveSsrcsByMediaType;
        boolean $i$f$getOrPut = false;
        Set value$iv = $this$getOrPut$iv.get((Object)mediaType);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(mediaType, answer$iv);
            set = answer$iv;
        } else {
            set = value$iv;
        }
        set.add(ssrc2);
        this.receiveSsrcs.add(ssrc2);
        if (this.ssrcAssociationStore.isPrimarySsrc(ssrc2)) {
            this.primaryMediaSsrcs.add(ssrc2);
            if (mediaType == MediaType.VIDEO) {
                this.primaryVideoSsrcs.add(ssrc2);
            }
        }
    }

    public final void removeReceiveSsrc(long ssrc2) {
        this.receiveSsrcs.remove(ssrc2);
        Iterable $this$forEach$iv = this.receiveSsrcsByMediaType.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Set it = (Set)element$iv;
            boolean bl = false;
            it.remove(ssrc2);
        }
        this.primaryMediaSsrcs.remove(ssrc2);
        this.primaryVideoSsrcs.remove(ssrc2);
    }

    private final void onSsrcAssociation(SsrcAssociation ssrcAssociation) {
        this.primaryVideoSsrcs.remove(ssrcAssociation.getSecondarySsrc());
        this.primaryMediaSsrcs.remove(ssrcAssociation.getSecondarySsrc());
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u2d2 = nodeStatsBlock = new NodeStatsBlock("Receive SSRC store");
        boolean bl = false;
        $this$getNodeStats_u24lambda_u2d2.addString("Receive SSRCs", this.receiveSsrcsByMediaType.toString());
        $this$getNodeStats_u24lambda_u2d2.addString("Primary media SSRCs", this.primaryMediaSsrcs.toString());
        $this$getNodeStats_u24lambda_u2d2.addString("Primary video SSRCs", this.primaryVideoSsrcs.toString());
        return nodeStatsBlock;
    }
}

