/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.nlj.rtp.SsrcAssociationType;
import org.jitsi.nlj.stats.NodeStatsBlock;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 -2\u00020\u0001:\u0001-B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0018J%\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\"J\u000e\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\tJ\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0018J\u000e\u0010(\u001a\u00020)2\u0006\u0010\u001f\u001a\u00020\u0003J\b\u0010*\u001a\u00020+H\u0016J\u001b\u0010,\u001a\u00020\u001e2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a2\u0006\u0002\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR2\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\b@@X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006."}, d2={"Lorg/jitsi/nlj/RtpEncodingDesc;", "", "primarySSRC", "", "eid", "", "(JI)V", "initialLayers", "", "Lorg/jitsi/nlj/RtpLayerDesc;", "(J[Lorg/jitsi/nlj/RtpLayerDesc;I)V", "getEid", "()I", "newLayers", "layers", "getLayers$jitsi_media_transform", "()[Lorg/jitsi/nlj/RtpLayerDesc;", "setLayers$jitsi_media_transform", "([Lorg/jitsi/nlj/RtpLayerDesc;)V", "[Lorg/jitsi/nlj/RtpLayerDesc;", "getPrimarySSRC", "()J", "secondarySsrcs", "", "Lorg/jitsi/nlj/rtp/SsrcAssociationType;", "ssrcs", "", "getSsrcs", "()Ljava/util/Collection;", "addSecondarySsrc", "", "ssrc", "type", "copy", "(J[Lorg/jitsi/nlj/RtpLayerDesc;)Lorg/jitsi/nlj/RtpEncodingDesc;", "encodingId", "layer", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "getSecondarySsrc", "matches", "", "toString", "", "validateLayerEids", "Companion", "jitsi-media-transform"})
public final class RtpEncodingDesc {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long primarySSRC;
    private final int eid;
    @NotNull
    private final Map<Long, SsrcAssociationType> secondarySsrcs;
    @NotNull
    private RtpLayerDesc[] layers;

    @JvmOverloads
    public RtpEncodingDesc(long primarySSRC, @NotNull RtpLayerDesc[] initialLayers, int eid) {
        Intrinsics.checkNotNullParameter(initialLayers, "initialLayers");
        this.primarySSRC = primarySSRC;
        this.eid = eid;
        this.secondarySsrcs = new HashMap();
        this.validateLayerEids(initialLayers);
        this.layers = initialLayers;
    }

    public /* synthetic */ RtpEncodingDesc(long l, RtpLayerDesc[] rtpLayerDescArray, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            RtpLayerDesc rtpLayerDesc = ArraysKt.getOrNull(rtpLayerDescArray, 0);
            Integer n3 = rtpLayerDesc != null ? Integer.valueOf(rtpLayerDesc.getEid()) : null;
            if (n3 == null) {
                boolean bl = false;
                String string = "initialLayers may not be empty if no explicit EID is provided";
                throw new IllegalArgumentException(string.toString());
            }
            n = ((Number)n3).intValue();
        }
        this(l, rtpLayerDescArray, n);
    }

    public final long getPrimarySSRC() {
        return this.primarySSRC;
    }

    public final int getEid() {
        return this.eid;
    }

    public RtpEncodingDesc(long primarySSRC, int eid) {
        this(primarySSRC, new RtpLayerDesc[0], eid);
    }

    public final void addSecondarySsrc(long ssrc2, @NotNull SsrcAssociationType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        Long l = ssrc2;
        this.secondarySsrcs.put(l, type2);
    }

    @NotNull
    public final Collection<Long> getSsrcs() {
        HashSet<Long> hashSet;
        HashSet<Long> set = hashSet = new HashSet<Long>();
        boolean bl = false;
        set.add(this.primarySSRC);
        set.addAll((Collection)this.secondarySsrcs.keySet());
        return hashSet;
    }

    private final void validateLayerEids(RtpLayerDesc[] layers) {
        for (RtpLayerDesc layer : layers) {
            if (layer.getEid() == this.eid) continue;
            boolean bl = false;
            String string = "Cannot add layer with EID " + layer.getEid() + " to encoding with EID " + this.eid;
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final RtpLayerDesc[] getLayers$jitsi_media_transform() {
        return this.layers;
    }

    /*
     * WARNING - void declaration
     */
    public final void setLayers$jitsi_media_transform(@NotNull RtpLayerDesc[] newLayers) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(newLayers, "newLayers");
        this.validateLayerEids(newLayers);
        RtpLayerDesc[] $this$associateBy$iv = this.layers;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity($this$associateBy$iv.length), 16);
        RtpLayerDesc[] rtpLayerDescArray = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        int n = ((void)$this$associateByTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void element$iv$iv;
            void var12_14 = element$iv$iv = $this$associateByTo$iv$iv[i];
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getLayerId(), element$iv$iv);
        }
        Map oldLayerMap = destination$iv$iv;
        int n2 = newLayers.length;
        for (int i = 0; i < n2; ++i) {
            RtpLayerDesc it;
            RtpLayerDesc newLayer = newLayers[i];
            if ((RtpLayerDesc)oldLayerMap.get(newLayer.getLayerId()) == null) continue;
            boolean bl = false;
            newLayer.inheritFrom$jitsi_media_transform(it);
        }
        this.layers = newLayers;
    }

    public final long encodingId(@NotNull RtpLayerDesc layer) {
        Intrinsics.checkNotNullParameter(layer, "layer");
        return Companion.calcEncodingId(this.primarySSRC, layer.getLayerId());
    }

    public final long getSecondarySsrc(@NotNull SsrcAssociationType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        for (Map.Entry<Long, SsrcAssociationType> entry : this.secondarySsrcs.entrySet()) {
            long key = ((Number)entry.getKey()).longValue();
            SsrcAssociationType value2 = entry.getValue();
            if (value2 != type2) continue;
            return key;
        }
        return -1L;
    }

    @NotNull
    public final RtpEncodingDesc copy(long primarySSRC, @NotNull RtpLayerDesc[] layers) {
        RtpEncodingDesc rtpEncodingDesc;
        Intrinsics.checkNotNullParameter(layers, "layers");
        RtpEncodingDesc it = rtpEncodingDesc = new RtpEncodingDesc(primarySSRC, layers, this.eid);
        boolean bl = false;
        Map<Long, SsrcAssociationType> $this$forEach$iv = this.secondarySsrcs;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Long, SsrcAssociationType>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Long, SsrcAssociationType> element$iv;
            Map.Entry<Long, SsrcAssociationType> entry = element$iv = iterator2.next();
            boolean bl2 = false;
            long ssrc2 = ((Number)entry.getKey()).longValue();
            SsrcAssociationType type2 = entry.getValue();
            it.addSecondarySsrc(ssrc2, type2);
        }
        return rtpEncodingDesc;
    }

    public static /* synthetic */ RtpEncodingDesc copy$default(RtpEncodingDesc rtpEncodingDesc, long l, RtpLayerDesc[] rtpLayerDescArray, int n, Object object) {
        if ((n & 1) != 0) {
            l = rtpEncodingDesc.primarySSRC;
        }
        if ((n & 2) != 0) {
            int n2 = 0;
            int n3 = rtpEncodingDesc.layers.length;
            RtpLayerDesc[] rtpLayerDescArray2 = new RtpLayerDesc[n3];
            while (n2 < n3) {
                int n4 = n2++;
                rtpLayerDescArray2[n4] = RtpLayerDesc.copy$default(rtpEncodingDesc.layers[n4], 0, 0, 0, 0, 0.0, null, null, 127, null);
            }
            rtpLayerDescArray = rtpLayerDescArray2;
        }
        return rtpEncodingDesc.copy(l, rtpLayerDescArray);
    }

    @NotNull
    public String toString() {
        return "primary_ssrc=" + this.primarySSRC + ",secondary_ssrcs=" + this.secondarySsrcs + ",layers=\n    " + ArraysKt.joinToString$default(this.layers, (CharSequence)"\n    ", null, null, 0, null, null, 62, null);
    }

    public final boolean matches(long ssrc2) {
        return this.primarySSRC == ssrc2 ? true : this.secondarySsrcs.containsKey(ssrc2);
    }

    @NotNull
    public final NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u2d7 = nodeStatsBlock = new NodeStatsBlock(String.valueOf(this.primarySSRC));
        boolean bl = false;
        $this$getNodeStats_u24lambda_u2d7.addNumber("rtx_ssrc", this.getSecondarySsrc(SsrcAssociationType.RTX));
        $this$getNodeStats_u24lambda_u2d7.addNumber("fec_ssrc", this.getSecondarySsrc(SsrcAssociationType.FEC));
        for (RtpLayerDesc layer : this.layers) {
            $this$getNodeStats_u24lambda_u2d7.addBlock(layer.getNodeStats());
        }
        return nodeStatsBlock;
    }

    @JvmOverloads
    public RtpEncodingDesc(long primarySSRC, @NotNull RtpLayerDesc[] initialLayers) {
        Intrinsics.checkNotNullParameter(initialLayers, "initialLayers");
        this(primarySSRC, initialLayers, 0, 4, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jitsi/nlj/RtpEncodingDesc$Companion;", "", "()V", "calcEncodingId", "", "ssrc", "layerId", "", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        public final long calcEncodingId(long ssrc2, int layerId) {
            return ssrc2 | (long)layerId << 32;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

