/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.publisher;

import java.net.URI;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.mvnsettings.LocalMavenRepositoryLocator;
import org.gradle.api.publish.internal.validation.DuplicatePublicationTracker;
import org.gradle.api.publish.maven.internal.publisher.MavenNormalizedPublication;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value=Scopes.Project.class)
public class MavenDuplicatePublicationTracker {
    private final String projectDisplayName;
    private final DuplicatePublicationTracker duplicatePublicationTracker;
    private final LocalMavenRepositoryLocator mavenRepositoryLocator;

    public MavenDuplicatePublicationTracker(Project project, DuplicatePublicationTracker duplicatePublicationTracker, LocalMavenRepositoryLocator mavenRepositoryLocator) {
        this.projectDisplayName = project.getDisplayName();
        this.duplicatePublicationTracker = duplicatePublicationTracker;
        this.mavenRepositoryLocator = mavenRepositoryLocator;
    }

    public void checkCanPublish(MavenNormalizedPublication publication, @Nullable URI repositoryLocation, String repositoryName) {
        this.duplicatePublicationTracker.checkCanPublish(this.projectDisplayName, publication.getName(), DefaultModuleVersionIdentifier.newId((ModuleComponentIdentifier)publication.getProjectIdentity()), repositoryLocation, repositoryName);
    }

    public void checkCanPublishToMavenLocal(MavenNormalizedPublication publication) {
        this.checkCanPublish(publication, this.mavenRepositoryLocator.getLocalMavenRepository().toURI(), "mavenLocal");
    }
}

