/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.sql.ColumnNotDisplayableException;
import ca.sqlpower.sql.NoRowidException;
import ca.sqlpower.sql.SQL;
import ca.sqlpower.sql.WebResultSet;
import ca.sqlpower.util.Hyperlink;
import ca.sqlpower.util.LongMessageFormat;
import ca.sqlpower.util.NaanSafeNumberFormat;
import java.awt.Color;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;

public abstract class WebResultFormatter {
    protected String rowidParameterName = "row_id";
    protected String checkboxYesValue = "YES";
    protected NumberFormat numberFormatter = new NaanSafeNumberFormat("#,##0.##############");
    protected NumberFormat moneyFormatter = new NaanSafeNumberFormat("$#,##0.00");
    protected NumberFormat percentFormatter = new NaanSafeNumberFormat("0%");
    protected DateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    protected Color rowHighlightColour = Color.yellow;
    protected Color rowNormalColour = new Color(238, 238, 238);

    public String getRowidParameterName() {
        return this.rowidParameterName;
    }

    public void setRowidParameterName(String newName) {
        this.rowidParameterName = newName;
    }

    public String getCheckboxYesValue() {
        return this.checkboxYesValue;
    }

    public void setCheckboxYesValue(String v) {
        this.checkboxYesValue = v;
    }

    public void setNumberFormatter(NumberFormat v) {
        this.numberFormatter = v;
    }

    public void setMoneyFormatter(NumberFormat v) {
        this.moneyFormatter = v;
    }

    public void setPercentFormatter(NumberFormat v) {
        this.percentFormatter = v;
    }

    public void setDateFormatter(DateFormat v) {
        this.dateFormatter = v;
    }

    public Color getRowHighlightColour() {
        return this.rowHighlightColour;
    }

    public void setRowHighlightColour(Color v) {
        this.rowHighlightColour = v;
    }

    public Color getRowNormalColour() {
        return this.rowNormalColour;
    }

    public void setRowNormalColour(Color v) {
        this.rowNormalColour = v;
    }

    protected String beautifyHeading(String heading) {
        StringBuffer newHeading = new StringBuffer(heading);
        for (int i = 0; i < newHeading.length(); ++i) {
            if (newHeading.charAt(i) != '_') continue;
            newHeading.setCharAt(i, ' ');
        }
        return newHeading.toString();
    }

    public static String beautifyColumnName(String colName) {
        StringBuffer newColName = new StringBuffer(colName);
        boolean CAP_NEXT = true;
        int LOWER_NEXT = 2;
        int state = 1;
        block4: for (int i = 0; i < colName.length(); ++i) {
            if (newColName.charAt(i) == '_') {
                newColName.setCharAt(i, ' ');
                state = 1;
                continue;
            }
            switch (state) {
                case 1: {
                    newColName.setCharAt(i, Character.toUpperCase(colName.charAt(i)));
                    state = 2;
                    continue block4;
                }
                case 2: {
                    newColName.setCharAt(i, Character.toLowerCase(colName.charAt(i)));
                }
            }
        }
        return newColName.toString();
    }

    protected void getColumnFormatted(WebResultSet wrs, int i, StringBuffer contents, StringBuffer align) throws SQLException, NoRowidException, ColumnNotDisplayableException, IllegalStateException {
        int type = wrs.getColumnType(i);
        block1 : switch (type) {
            case 1: {
                align.append("right");
                contents.append(this.numberFormatter.format(wrs.getFloat(i)));
                break;
            }
            case 2: {
                align.append("left");
                contents.append(wrs.getString(i));
                break;
            }
            case 18: {
                align.append("left");
                if (wrs.getString(i) == null || wrs.getString(i).equals("")) {
                    contents.append("n/a");
                    break;
                }
                contents.append(wrs.getString(i));
                break;
            }
            case 19: {
                align.append("left");
                if (wrs.getString(i) == null || wrs.getString(i).equals("")) {
                    contents.append("Unknown");
                    break;
                }
                contents.append(wrs.getString(i));
                break;
            }
            case 20: {
                align.append("left");
                if (wrs.getString(i) == null || wrs.getString(i).equals("")) {
                    contents.append("None");
                    break;
                }
                contents.append(wrs.getString(i));
                break;
            }
            case 3: {
                align.append("right");
                contents.append(this.moneyFormatter.format(wrs.getFloat(i)));
                break;
            }
            case 4: {
                align.append("center");
                String tmp = wrs.getString(i);
                if (tmp != null && SQL.decodeInd(tmp)) {
                    contents.append("True");
                    break;
                }
                contents.append("False");
                break;
            }
            case 16: {
                align.append("center");
                if (wrs.getString(i) == null || wrs.getString(i).equals("")) {
                    contents.append("N");
                    break;
                }
                contents.append(wrs.getString(i));
                break;
            }
            case 17: {
                align.append("center");
                if (wrs.getString(i) == null || wrs.getString(i).equals("")) {
                    contents.append("Y");
                    break;
                }
                contents.append(wrs.getString(i));
                break;
            }
            case 7: {
                align.append("right");
                try {
                    contents.append(this.percentFormatter.format(wrs.getFloat(i) / 100.0f));
                }
                catch (SQLException e) {
                    contents.append(wrs.getString(i));
                }
                break;
            }
            case 8: {
                align.append("center");
                Date date = wrs.getDate(i);
                if (date == null) break;
                contents.append(this.dateFormatter.format(new java.util.Date(date.getTime())));
                break;
            }
            case 9: {
                align.append("center");
                contents.append(wrs.getString(i));
                break;
            }
            case 15: 
            case 21: {
                align.append("center");
                if (wrs.getColumnHyperlinks(i) == null) {
                    throw new IllegalStateException("You must supply hyperlink specs in the WebResultSet.");
                }
                contents.append(this.makeHyperlinks(wrs, i));
                break;
            }
            case 10: 
            case 12: {
                throw new ColumnNotDisplayableException();
            }
            case 5: 
            case 6: 
            case 13: {
                throw new UnsupportedOperationException();
            }
            default: {
                ResultSetMetaData md = wrs.getRsmd();
                switch (md.getColumnType(i)) {
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        align.append("right");
                        contents.append(this.numberFormatter.format(wrs.getFloat(i)));
                        break block1;
                    }
                    case 93: {
                        align.append("center");
                        Date tsDate = wrs.getDate(i);
                        if (tsDate == null) break block1;
                        contents.append(this.dateFormatter.format(new java.util.Date(tsDate.getTime())));
                        break block1;
                    }
                    default: {
                        align.append("left");
                        contents.append(wrs.getString(i));
                    }
                }
            }
        }
    }

    public abstract void formatToStream(WebResultSet var1, PrintWriter var2) throws SQLException, NoRowidException;

    public void formatToStream(WebResultSet wrs, Writer out) throws SQLException, NoRowidException {
        this.formatToStream(wrs, new PrintWriter(out));
    }

    public String format(WebResultSet wrs) throws SQLException, NoRowidException {
        StringWriter sout = new StringWriter();
        this.formatToStream(wrs, new PrintWriter(sout));
        return sout.toString();
    }

    protected String makeHyperlinks(WebResultSet wrs, int colNo) throws SQLException {
        List hyperlinks = wrs.getColumnHyperlinks(colNo);
        String style = wrs.getColumnHyperlinkStyle(colNo);
        int type = wrs.getColumnType(colNo);
        StringBuffer contents = new StringBuffer();
        Iterator hlIter = hyperlinks.iterator();
        while (hlIter.hasNext()) {
            Hyperlink link = (Hyperlink)hlIter.next();
            LongMessageFormat textFormat = new LongMessageFormat(link.getText());
            LongMessageFormat hrefFormat = new LongMessageFormat(link.getHref());
            int colCount = wrs.getColumnCount();
            Object[] rowValues = new String[colCount + 1];
            for (int col = 1; col <= colCount; ++col) {
                rowValues[col] = wrs.getString(col);
            }
            contents.append("<a href=\"");
            hrefFormat.format(rowValues, contents, (FieldPosition)null);
            if (style != null) {
                contents.append("\" class=\"").append(style);
            }
            contents.append("\">");
            StringBuffer nullCheck = new StringBuffer();
            textFormat.format(rowValues, nullCheck, (FieldPosition)null);
            String checked = type == 21 ? (nullCheck.toString().equals("&nbsp;1&nbsp;-&nbsp;null") ? "-" : nullCheck.toString()) : nullCheck.toString();
            contents.append(checked);
            contents.append("</a>");
            if (!hlIter.hasNext()) continue;
            contents.append("<br>");
        }
        return contents.toString();
    }
}

