/* header auto-generated by pidl */

#ifndef _PIDL_HEADER_claims
#define _PIDL_HEADER_claims

#include <stdint.h>

#include <core/ntstatus.h>

#ifndef _HEADER_claims
#define _HEADER_claims

#define CLAIM_MINIMUM_BYTES_TO_COMPRESS	( 384 )
enum CLAIM_TYPE
#ifndef USE_UINT_ENUMS
 {
	CLAIM_TYPE_INT64=(int)(1),
	CLAIM_TYPE_UINT64=(int)(2),
	CLAIM_TYPE_STRING=(int)(3),
	CLAIM_TYPE_BOOLEAN=(int)(6)
}
#else
 { __do_not_use_enum_CLAIM_TYPE=0x7FFFFFFF}
#define CLAIM_TYPE_INT64 ( 1 )
#define CLAIM_TYPE_UINT64 ( 2 )
#define CLAIM_TYPE_STRING ( 3 )
#define CLAIM_TYPE_BOOLEAN ( 6 )
#endif
;

enum CLAIMS_SOURCE_TYPE
#ifndef USE_UINT_ENUMS
 {
	CLAIMS_SOURCE_TYPE_AD=(int)(1),
	CLAIMS_SOURCE_TYPE_CERTIFICATE=(int)(2)
}
#else
 { __do_not_use_enum_CLAIMS_SOURCE_TYPE=0x7FFFFFFF}
#define CLAIMS_SOURCE_TYPE_AD ( 1 )
#define CLAIMS_SOURCE_TYPE_CERTIFICATE ( 2 )
#endif
;

enum CLAIMS_COMPRESSION_FORMAT
#ifndef USE_UINT_ENUMS
 {
	CLAIMS_COMPRESSION_FORMAT_NONE=(int)(0),
	CLAIMS_COMPRESSION_FORMAT_LZNT1=(int)(2),
	CLAIMS_COMPRESSION_FORMAT_XPRESS=(int)(3),
	CLAIMS_COMPRESSION_FORMAT_XPRESS_HUFF=(int)(4)
}
#else
 { __do_not_use_enum_CLAIMS_COMPRESSION_FORMAT=0x7FFFFFFF}
#define CLAIMS_COMPRESSION_FORMAT_NONE ( 0 )
#define CLAIMS_COMPRESSION_FORMAT_LZNT1 ( 2 )
#define CLAIMS_COMPRESSION_FORMAT_XPRESS ( 3 )
#define CLAIMS_COMPRESSION_FORMAT_XPRESS_HUFF ( 4 )
#endif
;

struct CLAIM_INT64 {
	uint32_t value_count;/* [range(1,10*1024*1024)] */
	int64_t *values;/* [size_is(value_count),unique] */
};

struct CLAIM_UINT64 {
	uint32_t value_count;/* [range(1,10*1024*1024)] */
	uint64_t *values;/* [size_is(value_count),unique] */
};

struct CLAIM_STRING {
	uint32_t value_count;/* [range(1,10*1024*1024)] */
	const char **values;/* [charset(UTF16),size_is(value_count),unique] */
};

union CLAIM_ENTRY_VALUES {
	struct CLAIM_INT64 claim_int64;/* [case(CLAIM_TYPE_INT64)] */
	struct CLAIM_UINT64 claim_uint64;/* [case(CLAIM_TYPE_UINT64)] */
	struct CLAIM_STRING claim_string;/* [case(CLAIM_TYPE_STRING)] */
	struct CLAIM_UINT64 claim_boolean;/* [case(CLAIM_TYPE_BOOLEAN)] */
}/* [flag(LIBNDR_FLAG_ALIGN8),switch_type(CLAIM_TYPE)] */;

struct CLAIM_ENTRY {
	const char *id;/* [charset(UTF16),unique] */
	enum CLAIM_TYPE type;
	union CLAIM_ENTRY_VALUES values;/* [switch_is(type)] */
};

struct CLAIMS_ARRAY {
	enum CLAIMS_SOURCE_TYPE claims_source_type;
	uint32_t claims_count;
	struct CLAIM_ENTRY *claim_entries;/* [size_is(claims_count),unique] */
};

struct CLAIMS_SET_METADATA_CTR {
	struct CLAIMS_SET_METADATA *metadata;/* [unique] */
};

struct CLAIMS_SET_CTR {
	struct CLAIMS_SET *claims;/* [unique] */
};

struct CLAIMS_SET {
	uint32_t claims_array_count;
	struct CLAIMS_ARRAY *claims_arrays;/* [size_is(claims_array_count),unique] */
	uint16_t reserved_type;
	uint32_t reserved_field_size;
	uint8_t *reserved_field;/* [size_is(reserved_field_size),unique] */
}/* [public] */;

struct CLAIMS_SET_NDR {
	struct CLAIMS_SET_CTR claims;/* [subcontext(0xFFFFFC01)] */
}/* [gensize,public] */;

struct CLAIMS_SET_METADATA_NDR {
	struct CLAIMS_SET_METADATA_CTR claims;/* [subcontext(0xFFFFFC01)] */
}/* [public] */;

struct CLAIMS_SET_METADATA {
	uint32_t claims_set_size;/* [value(ndr_claims_compressed_size(claims_set,r->compression_format,ndr->flags))] */
	struct CLAIMS_SET_NDR *claims_set;/* [compression(ndr_claims_compression_alg(compression_format),claims_set_size,uncompressed_claims_set_size),subcontext(4),unique] */
	enum CLAIMS_COMPRESSION_FORMAT compression_format;/* [value(ndr_claims_actual_wire_compression_alg(r->compression_format,ndr_size_CLAIMS_SET_NDR(claims_set,ndr->flags)))] */
	uint32_t uncompressed_claims_set_size;/* [value(ndr_size_CLAIMS_SET_NDR(claims_set,ndr->flags))] */
	uint16_t reserved_type;
	uint32_t reserved_field_size;
	uint8_t *reserved_field;/* [size_is(reserved_field_size),unique] */
}/* [public] */;

#endif /* _HEADER_claims */
#endif /* _PIDL_HEADER_claims */
