/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;

public class DuplicateRelation
extends Test {
    protected static final int DUPLICATE_RELATION = 1901;
    protected static final int SAME_RELATION = 1902;
    private MultiMap<RelationPair, OsmPrimitive> relations;
    private MultiMap<List<RelationMember>, OsmPrimitive> relationsNoKeys;
    private final Set<String> ignoreKeys = new HashSet<String>(AbstractPrimitive.getUninterestingKeys());

    public DuplicateRelation() {
        super(I18n.tr("Duplicated relations", new Object[0]), I18n.tr("This test checks that there are no relations with same tags and same members with same roles.", new Object[0]));
    }

    @Override
    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        this.relations = new MultiMap(1000);
        this.relationsNoKeys = new MultiMap(1000);
    }

    @Override
    public void endTest() {
        TestError testError;
        super.endTest();
        for (Set<OsmPrimitive> duplicated : this.relations.values()) {
            if (duplicated.size() <= 1) continue;
            testError = TestError.builder(this, Severity.ERROR, 1901).message(I18n.tr("Duplicated relations", new Object[0])).primitives(duplicated).build();
            this.errors.add(testError);
        }
        this.relations = null;
        for (Set<OsmPrimitive> duplicated : this.relationsNoKeys.values()) {
            if (duplicated.size() <= 1) continue;
            testError = TestError.builder(this, Severity.WARNING, 1902).message(I18n.tr("Relations with same members", new Object[0])).primitives(duplicated).build();
            this.errors.add(testError);
        }
        this.relationsNoKeys = null;
    }

    @Override
    public void visit(Relation r) {
        if (!r.isUsable() || r.hasIncompleteMembers() || "tmc".equals(r.get("type")) || "TMC".equals(r.get("type"))) {
            return;
        }
        List<RelationMember> rMembers = r.getMembers();
        TagMap rkeys = r.getKeys();
        for (String key : this.ignoreKeys) {
            rkeys.remove(key);
        }
        RelationPair rKey = new RelationPair(rMembers, rkeys);
        this.relations.put(rKey, r);
        this.relationsNoKeys.put(rMembers, r);
    }

    @Override
    public Command fixError(TestError testError) {
        if (testError.getCode() == 1902) {
            return null;
        }
        Collection<? extends OsmPrimitive> sel = testError.getPrimitives();
        HashSet<Relation> relFix = new HashSet<Relation>();
        for (OsmPrimitive osmPrimitive : sel) {
            if (!(osmPrimitive instanceof Relation) || osmPrimitive.isDeleted()) continue;
            relFix.add((Relation)osmPrimitive);
        }
        if (relFix.size() < 2) {
            return null;
        }
        long idToKeep = 0L;
        Relation relationToKeep = (Relation)relFix.iterator().next();
        Relation relationWithRelations = null;
        Collection relRef = null;
        for (Relation w : relFix) {
            Object rel = w.referrers(Relation.class).collect(Collectors.toList());
            if (!rel.isEmpty()) {
                if (relationWithRelations != null) {
                    throw new AssertionError((Object)"Cannot fix duplicate relations: More than one relation is member of another relation.");
                }
                relationWithRelations = w;
                relRef = rel;
            }
            if (w.isNew() || idToKeep != 0L && w.getId() >= idToKeep) continue;
            idToKeep = w.getId();
            relationToKeep = w;
        }
        LinkedList<Command> commands = new LinkedList<Command>();
        if (relationWithRelations != null && relRef != null && relationToKeep != relationWithRelations) {
            for (Object rel : relRef) {
                Relation newRel = new Relation((Relation)rel);
                for (int i = 0; i < newRel.getMembers().size(); ++i) {
                    RelationMember m = newRel.getMember(i);
                    if (!relationWithRelations.equals(m.getMember())) continue;
                    newRel.setMember(i, new RelationMember(m.getRole(), relationToKeep));
                }
                commands.add(new ChangeCommand((OsmPrimitive)rel, newRel));
            }
        }
        relFix.remove(relationToKeep);
        commands.add(new DeleteCommand(relFix));
        return new SequenceCommand(I18n.tr("Delete duplicate relations", new Object[0]), commands);
    }

    @Override
    public boolean isFixable(TestError testError) {
        if (!(testError.getTester() instanceof DuplicateRelation) || testError.getCode() == 1902) {
            return false;
        }
        Collection<? extends OsmPrimitive> sel = testError.getPrimitives();
        HashSet<Relation> rels = new HashSet<Relation>();
        for (OsmPrimitive osmPrimitive : sel) {
            if (!(osmPrimitive instanceof Relation)) continue;
            rels.add((Relation)osmPrimitive);
        }
        if (rels.size() < 2) {
            return false;
        }
        return rels.stream().filter(x -> x.referrers(Relation.class).anyMatch(y -> true)).limit(2L).count() <= 1L;
    }

    private static class RelationPair {
        private final RelationMembers members;
        private final Map<String, String> keys;

        RelationPair(List<RelationMember> members, Map<String, String> keys) {
            this.members = new RelationMembers(members);
            this.keys = keys;
        }

        public int hashCode() {
            return Objects.hash(this.members, this.keys);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            RelationPair that = (RelationPair)obj;
            return Objects.equals(this.members, that.members) && Objects.equals(this.keys, that.keys);
        }
    }

    private static class RelationMembers {
        private final List<RelMember> members;

        RelationMembers(List<RelationMember> members) {
            this.members = new ArrayList<RelMember>(members.size());
            for (RelationMember member : members) {
                this.members.add(new RelMember(member));
            }
        }

        public int hashCode() {
            return Objects.hash(this.members);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            RelationMembers that = (RelationMembers)obj;
            return Objects.equals(this.members, that.members);
        }
    }

    public static class RelMember {
        private final String role;
        private final OsmPrimitiveType type;
        private Map<String, String> tags;
        private List<LatLon> coor;
        private long relId;

        public int hashCode() {
            return Objects.hash(new Object[]{this.role, this.type, this.tags, this.coor, this.relId});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            RelMember relMember = (RelMember)obj;
            return this.relId == relMember.relId && this.type == relMember.type && Objects.equals(this.role, relMember.role) && Objects.equals(this.tags, relMember.tags) && Objects.equals(this.coor, relMember.coor);
        }

        public RelMember(RelationMember src) {
            OsmPrimitive r;
            this.role = src.getRole();
            this.type = src.getType();
            this.relId = 0L;
            this.coor = new ArrayList<LatLon>();
            if (src.isNode()) {
                r = src.getNode();
                this.tags = r.getKeys();
                this.coor = new ArrayList<LatLon>(1);
                this.coor.add(((Node)r).getCoor());
            }
            if (src.isWay()) {
                r = src.getWay();
                this.tags = r.getKeys();
                List<Node> wNodes = ((Way)r).getNodes();
                this.coor = new ArrayList<LatLon>(wNodes.size());
                for (Node wNode : wNodes) {
                    this.coor.add(wNode.getCoor());
                }
            }
            if (src.isRelation()) {
                r = src.getRelation();
                this.tags = r.getKeys();
                this.relId = r.getId();
                this.coor = new ArrayList<LatLon>();
            }
        }
    }
}

