"use strict";

var _events = require("events");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/* eslint-disable */
// transpiled typescript->javascript from
// https://github.com/aurelia/pal-nodejs/blob/master/src/polyfills/mutation-observer.ts

/*
 * Based on Shim for MutationObserver interface
 * Author: Graeme Yeates (github.com/megawac)
 * Repository: https://github.com/megawac/MutationObserver.js
 */
var __extends = void 0 && (void 0).__extends || function () {
  var extendStatics = Object.setPrototypeOf || {
    __proto__: []
  } instanceof Array && function (d, b) {
    d.__proto__ = b;
  } || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
  };

  return function (d, b) {
    extendStatics(d, b);

    function __() {
      this.constructor = d;
    }

    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
}();

module.exports = {};
Object.defineProperty(module.exports, '__esModule', {
  value: true
});

var Util =
/** @class */
function () {
  function Util() {}

  Util.clone = function ($target, config) {
    var recurse = true; // set true so childList we'll always check the first level

    return function copy($target) {
      var elestruct = {
        /** @type {Node} */
        node: $target,
        charData: null,
        attr: null,
        kids: null
      }; // Store current character data of target text or comment node if the config requests
      // those properties to be observed.

      if (config.charData && ($target.nodeType === 3 || $target.nodeType === 8)) {
        elestruct.charData = $target.nodeValue;
      } else {
        // Add attr only if subtree is specified or top level and avoid if
        // attributes is a document object (#13).
        if (config.attr && recurse && $target.nodeType === 1) {
          /**
           * clone live attribute list to an object structure {name: val}
           * @type {Object.<string, string>}
           */
          elestruct.attr = Util.reduce($target.attributes, function (memo, attr) {
            if (!config.afilter || config.afilter[attr.name]) {
              memo[attr.name] = attr.value;
            }

            return memo;
          }, {});
        } // whether we should iterate the children of $target node


        if (recurse && (config.kids || config.charData || config.attr && config.descendents)) {
          /** @type {Array.<!Object>} : Array of custom clone */
          elestruct.kids = Util.map($target.childNodes, copy);
        }

        recurse = config.descendents;
      }

      return elestruct;
    }($target);
  };
  /**
   * indexOf an element in a collection of custom nodes
   *
   * @param {NodeList} set
   * @param {!Object} $node : A custom cloned nodeg333
   * @param {number} idx : index to start the loop
   * @return {number}
   */


  Util.indexOfCustomNode = function (set, $node, idx) {
    var JSCompiler_renameProperty = function (a) {
      return a;
    };

    return this.indexOf(set, $node, idx, JSCompiler_renameProperty('node'));
  };
  /**
   * Attempt to uniquely id an element for hashing. We could optimize this for legacy browsers but it hopefully wont be called enough to be a concern
   *
   * @param {Node} $ele
   * @return {(string|number)}
   */


  Util.getElementId = function ($ele) {
    try {
      return $ele.id || ($ele[this.expando] = $ele[this.expando] || this.counter++);
    } catch (e) {
      // ie <8 will throw if you set an unknown property on a text node
      try {
        return $ele.nodeValue; // naive
      } catch (shitie) {
        // when text node is removed: https://gist.github.com/megawac/8355978 :(
        return this.counter++;
      }
    }
  };
  /**
   * **map** Apply a mapping function to each item of a set
   * @param {Array|NodeList} set
   * @param {Function} iterator
   */


  Util.map = function (set, iterator) {
    var results = [];

    for (var index = 0; index < set.length; index++) {
      results[index] = iterator(set[index], index, set);
    }

    return results;
  };
  /**
   * **Reduce** builds up a single result from a list of values
   * @param {Array|NodeList|NamedNodeMap} set
   * @param {Function} iterator
   * @param {*} [memo] Initial value of the memo.
   */


  Util.reduce = function (set, iterator, memo) {
    for (var index = 0; index < set.length; index++) {
      memo = iterator(memo, set[index], index, set);
    }

    return memo;
  };
  /**
   * **indexOf** find index of item in collection.
   * @param {Array|NodeList} set
   * @param {Object} item
   * @param {number} idx
   * @param {string} [prop] Property on set item to compare to item
   */


  Util.indexOf = function (set, item, idx, prop) {
    for (;
    /*idx = ~~idx*/
    idx < set.length; idx++) {
      // start idx is always given as this is internal
      if ((prop ? set[idx][prop] : set[idx]) === item) return idx;
    }

    return -1;
  };
  /**
   * @param {Object} obj
   * @param {(string|number)} prop
   * @return {boolean}
   */


  Util.has = function (obj, prop) {
    return obj[prop] !== undefined; // will be nicely inlined by gcc
  };

  Util.counter = 1;
  Util.expando = 'mo_id';
  return Util;
}();

module.exports.Util = Util;

var MutationObserver =
/** @class */
function () {
  function MutationObserver(listener) {
    var _this = this;

    this._watched = [];
    this._listener = null;
    this._period = 30;
    this._timeout = null;
    this._disposed = false;
    this._notifyListener = null;
    this._watched = [];
    this._listener = listener;
    this._period = 30;

    this._notifyListener = function () {
      _this.scheduleMutationCheck(_this);
    };
  }

  MutationObserver.prototype.observe = function ($target, config) {
    var settings = {
      attr: !!(config.attributes || config.attributeFilter || config.attributeOldValue),
      // some browsers enforce that subtree must be set with childList, attributes or characterData.
      // We don't care as spec doesn't specify this rule.
      kids: !!config.childList,
      descendents: !!config.subtree,
      charData: !!(config.characterData || config.characterDataOldValue),
      afilter: null
    };
    MutationNotifier.getInstance().on('changed', this._notifyListener);
    var watched = this._watched; // remove already observed target element from pool

    for (var i = 0; i < watched.length; i++) {
      if (watched[i].tar === $target) watched.splice(i, 1);
    }

    if (config.attributeFilter) {
      /**
       * converts to a {key: true} dict for faster lookup
       * @type {Object.<String,Boolean>}
       */
      settings.afilter = Util.reduce(config.attributeFilter, function (a, b) {
        a[b] = true;
        return a;
      }, {});
    }

    watched.push({
      tar: $target,
      fn: this.createMutationSearcher($target, settings)
    });
  };

  MutationObserver.prototype.takeRecords = function () {
    var mutations = [];
    var watched = this._watched;

    for (var i = 0; i < watched.length; i++) {
      watched[i].fn(mutations);
    }

    return mutations;
  };

  MutationObserver.prototype.disconnect = function () {
    this._watched = []; // clear the stuff being observed

    MutationNotifier.getInstance().removeListener('changed', this._notifyListener);
    this._disposed = true;
    clearTimeout(this._timeout); // ready for garbage collection

    this._timeout = null;
  };

  MutationObserver.prototype.createMutationSearcher = function ($target, config) {
    var _this = this;
    /** type {Elestuct} */


    var $oldstate = Util.clone($target, config); // create the cloned datastructure

    /**
     * consumes array of mutations we can push to
     *
     * @param {Array.<MutationRecord>} mutations
     */

    return function (mutations) {
      var olen = mutations.length;
      var dirty;

      if (config.charData && $target.nodeType === 3 && $target.nodeValue !== $oldstate.charData) {
        mutations.push(new MutationRecord({
          type: 'characterData',
          target: $target,
          oldValue: $oldstate.charData
        }));
      } // Alright we check base level changes in attributes... easy


      if (config.attr && $oldstate.attr) {
        _this.findAttributeMutations(mutations, $target, $oldstate.attr, config.afilter);
      } // check childlist or subtree for mutations


      if (config.kids || config.descendents) {
        dirty = _this.searchSubtree(mutations, $target, $oldstate, config);
      } // reclone data structure if theres changes


      if (dirty || mutations.length !== olen) {
        /** type {Elestuct} */
        $oldstate = Util.clone($target, config);
      }
    };
  };

  MutationObserver.prototype.scheduleMutationCheck = function (observer) {
    var _this = this; // Only schedule if there isn't already a timer.


    if (!observer._timeout) {
      observer._timeout = setTimeout(function () {
        return _this.mutationChecker(observer);
      }, this._period);
    }
  };

  MutationObserver.prototype.mutationChecker = function (observer) {
    // allow scheduling a new timer.
    observer._timeout = null;
    var mutations = observer.takeRecords();

    if (mutations.length) {
      // fire away
      // calling the listener with context is not spec but currently consistent with FF and WebKit
      observer._listener(mutations, observer);
    }
  };

  MutationObserver.prototype.searchSubtree = function (mutations, $target, $oldstate, config) {
    var _this = this; // Track if the tree is dirty and has to be recomputed (#14).


    var dirty;
    /*
     * Helper to identify node rearrangment and stuff...
     * There is no gaurentee that the same node will be identified for both added and removed nodes
     * if the positions have been shuffled.
     * conflicts array will be emptied by end of operation
     */

    var _resolveConflicts = function (conflicts, node, $kids, $oldkids, numAddedNodes) {
      // the distance between the first conflicting node and the last
      var distance = conflicts.length - 1; // prevents same conflict being resolved twice consider when two nodes switch places.
      // only one should be given a mutation event (note -~ is used as a math.ceil shorthand)

      var counter = -~((distance - numAddedNodes) / 2);
      var $cur;
      var oldstruct;
      var conflict;

      while (conflict = conflicts.pop()) {
        $cur = $kids[conflict.i];
        oldstruct = $oldkids[conflict.j]; // attempt to determine if there was node rearrangement... won't gaurentee all matches
        // also handles case where added/removed nodes cause nodes to be identified as conflicts

        if (config.kids && counter && Math.abs(conflict.i - conflict.j) >= distance) {
          mutations.push(new MutationRecord({
            type: 'childList',
            target: node,
            addedNodes: [$cur],
            removedNodes: [$cur],
            // haha don't rely on this please
            nextSibling: $cur.nextSibling,
            previousSibling: $cur.previousSibling
          }));
          counter--; // found conflict
        } // Alright we found the resorted nodes now check for other types of mutations


        if (config.attr && oldstruct.attr) _this.findAttributeMutations(mutations, $cur, oldstruct.attr, config.afilter);

        if (config.charData && $cur.nodeType === 3 && $cur.nodeValue !== oldstruct.charData) {
          mutations.push(new MutationRecord({
            type: 'characterData',
            target: $cur,
            oldValue: oldstruct.charData
          }));
        } // now look @ subtree


        if (config.descendents) _findMutations($cur, oldstruct);
      }
    };
    /**
     * Main worker. Finds and adds mutations if there are any
     * @param {Node} node
     * @param {!Object} old : A cloned data structure using internal clone
     */


    var _findMutations = function (node, old) {
      var $kids = node.childNodes;
      var $oldkids = old.kids;
      var klen = $kids.length; // $oldkids will be undefined for text and comment nodes

      var olen = $oldkids ? $oldkids.length : 0; // if (!olen && !klen) return; // both empty; clearly no changes
      // we delay the intialization of these for marginal performance in the expected case (actually quite signficant on large subtrees when these would be otherwise unused)
      // map of checked element of ids to prevent registering the same conflict twice

      var map; // array of potential conflicts (ie nodes that may have been re arranged)

      var conflicts;
      var id; // element id from getElementId helper

      var idx; // index of a moved or inserted element

      var oldstruct; // current and old nodes

      var $cur;
      var $old; // track the number of added nodes so we can resolve conflicts more accurately

      var numAddedNodes = 0; // iterate over both old and current child nodes at the same time

      var i = 0;
      var j = 0; // while there is still anything left in $kids or $oldkids (same as i < $kids.length || j < $oldkids.length;)

      while (i < klen || j < olen) {
        // current and old nodes at the indexs
        $cur = $kids[i];
        oldstruct = $oldkids[j];
        $old = oldstruct && oldstruct.node;

        if ($cur === $old) {
          // expected case - optimized for this case
          // check attributes as specified by config
          if (config.attr && oldstruct.attr) {
            /* oldstruct.attr instead of textnode check */
            _this.findAttributeMutations(mutations, $cur, oldstruct.attr, config.afilter);
          } // check character data if node is a comment or textNode and it's being observed


          if (config.charData && oldstruct.charData !== undefined && $cur.nodeValue !== oldstruct.charData) {
            mutations.push(new MutationRecord({
              type: 'characterData',
              target: $cur
            }));
          } // resolve conflicts; it will be undefined if there are no conflicts - otherwise an array


          if (conflicts) _resolveConflicts(conflicts, node, $kids, $oldkids, numAddedNodes); // recurse on next level of children. Avoids the recursive call when there are no children left to iterate

          if (config.descendents && ($cur.childNodes.length || oldstruct.kids && oldstruct.kids.length)) _findMutations($cur, oldstruct);
          i++;
          j++;
        } else {
          // (uncommon case) lookahead until they are the same again or the end of children
          dirty = true;

          if (!map) {
            // delayed initalization (big perf benefit)
            map = {};
            conflicts = [];
          }

          if ($cur) {
            // check id is in the location map otherwise do a indexOf search
            if (!map[id = Util.getElementId($cur)]) {
              // to prevent double checking
              // mark id as found
              map[id] = true; // custom indexOf using comparitor checking oldkids[i].node === $cur

              if ((idx = Util.indexOfCustomNode($oldkids, $cur, j)) === -1) {
                if (config.kids) {
                  mutations.push(new MutationRecord({
                    type: 'childList',
                    target: node,
                    addedNodes: [$cur],
                    nextSibling: $cur.nextSibling,
                    previousSibling: $cur.previousSibling
                  }));
                  numAddedNodes++;
                }
              } else {
                conflicts.push({
                  i: i,
                  j: idx
                });
              }
            }

            i++;
          }

          if ($old && // special case: the changes may have been resolved: i and j appear congurent so we can continue using the expected case
          $old !== $kids[i]) {
            if (!map[id = Util.getElementId($old)]) {
              map[id] = true;

              if ((idx = Util.indexOf($kids, $old, i)) === -1) {
                if (config.kids) {
                  mutations.push(new MutationRecord({
                    type: 'childList',
                    target: old.node,
                    removedNodes: [$old],
                    nextSibling: $oldkids[j + 1],
                    previousSibling: $oldkids[j - 1]
                  }));
                  numAddedNodes--;
                }
              } else {
                conflicts.push({
                  i: idx,
                  j: j
                });
              }
            }

            j++;
          }
        } // end uncommon case

      } // end loop
      // resolve any remaining conflicts


      if (conflicts) _resolveConflicts(conflicts, node, $kids, $oldkids, numAddedNodes);
    };

    _findMutations($target, $oldstate);

    return dirty;
  };

  MutationObserver.prototype.findAttributeMutations = function (mutations, $target, $oldstate, filter) {
    var checked = {};
    var attributes = $target.attributes;
    var attr;
    var name;
    var i = attributes.length;

    while (i--) {
      attr = attributes[i];
      name = attr.name;

      if (!filter || Util.has(filter, name)) {
        if (attr.value !== $oldstate[name]) {
          // The pushing is redundant but gzips very nicely
          mutations.push(new MutationRecord({
            type: 'attributes',
            target: $target,
            attributeName: name,
            oldValue: $oldstate[name],
            attributeNamespace: attr.namespaceURI // in ie<8 it incorrectly will return undefined

          }));
        }

        checked[name] = true;
      }
    }

    for (name in $oldstate) {
      if (!checked[name]) {
        mutations.push(new MutationRecord({
          target: $target,
          type: 'attributes',
          attributeName: name,
          oldValue: $oldstate[name]
        }));
      }
    }
  };

  return MutationObserver;
}();

module.exports.MutationObserver = MutationObserver;

var MutationRecord =
/** @class */
function () {
  function MutationRecord(data) {
    var settings = {
      type: null,
      target: null,
      addedNodes: [],
      removedNodes: [],
      previousSibling: null,
      nextSibling: null,
      attributeName: null,
      attributeNamespace: null,
      oldValue: null
    };

    for (var prop in data) {
      if (Util.has(settings, prop) && data[prop] !== undefined) settings[prop] = data[prop];
    }

    return settings;
  }

  return MutationRecord;
}();

module.exports.MutationRecord = MutationRecord;

var MutationNotifier =
/** @class */
function (_super) {
  __extends(MutationNotifier, _super);

  function MutationNotifier() {
    var _this = _super.call(this) || this;

    _this.setMaxListeners(100);

    return _this;
  }

  MutationNotifier.getInstance = function () {
    if (!MutationNotifier._instance) {
      MutationNotifier._instance = new MutationNotifier();
    }

    return MutationNotifier._instance;
  };

  MutationNotifier.prototype.destruct = function () {
    this.removeAllListeners('changed');
  };

  MutationNotifier.prototype.notifyChanged = function (node) {
    this.emit('changed', node);
  };

  MutationNotifier._instance = null;
  return MutationNotifier;
}(_events.EventEmitter);

module.exports.MutationNotifier = MutationNotifier;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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