"use strict";
// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.NodeCachingMaterialsManager = void 0;
const cache_material_1 = require("@aws-crypto/cache-material");
const material_management_node_1 = require("@aws-crypto/material-management-node");
const sha512_1 = require("./sha512");
const crypto_1 = require("crypto");
const fromUtf8 = (input) => Buffer.from(input, 'utf8');
const toUtf8 = (input) => Buffer.from(input).toString('utf8');
const cacheKeyHelpers = (0, cache_material_1.buildCryptographicMaterialsCacheKeyHelpers)(fromUtf8, toUtf8, sha512_1.sha512);
class NodeCachingMaterialsManager {
    constructor(input) {
        const backingMaterialsManager = input.backingMaterials instanceof material_management_node_1.KeyringNode
            ? new material_management_node_1.NodeDefaultCryptographicMaterialsManager(input.backingMaterials)
            : input.backingMaterials;
        /* Precondition: A partition value must exist for NodeCachingMaterialsManager.
         * The maximum hash function at this time is 512.
         * So I create 64 bytes of random data.
         */
        const { partition = (0, crypto_1.randomBytes)(64).toString('base64') } = input;
        (0, cache_material_1.decorateProperties)(this, {
            ...input,
            backingMaterialsManager,
            partition,
        });
    }
    getEncryptionMaterials = (0, cache_material_1.getEncryptionMaterials)(cacheKeyHelpers);
    decryptMaterials = (0, cache_material_1.decryptMaterials)(cacheKeyHelpers);
    _cacheEntryHasExceededLimits = (0, cache_material_1.cacheEntryHasExceededLimits)();
}
exports.NodeCachingMaterialsManager = NodeCachingMaterialsManager;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2FjaGluZ19tYXRlcmlhbHNfbWFuYWdlcl9ub2RlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2NhY2hpbmdfbWF0ZXJpYWxzX21hbmFnZXJfbm9kZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsb0VBQW9FO0FBQ3BFLHNDQUFzQzs7O0FBRXRDLCtEQVNtQztBQUNuQyxtRkFPNkM7QUFDN0MscUNBQWlDO0FBQ2pDLG1DQUFvQztBQUVwQyxNQUFNLFFBQVEsR0FBRyxDQUFDLEtBQWEsRUFBRSxFQUFFLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsTUFBTSxDQUFDLENBQUE7QUFDOUQsTUFBTSxNQUFNLEdBQUcsQ0FBQyxLQUFpQixFQUFFLEVBQUUsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLFFBQVEsQ0FBQyxNQUFNLENBQUMsQ0FBQTtBQUV6RSxNQUFNLGVBQWUsR0FBRyxJQUFBLDJEQUEwQyxFQUNoRSxRQUFRLEVBQ1IsTUFBTSxFQUNOLGVBQU0sQ0FDUCxDQUFBO0FBRUQsTUFBYSwyQkFBMkI7SUFVdEMsWUFBWSxLQUF1RDtRQUNqRSxNQUFNLHVCQUF1QixHQUMzQixLQUFLLENBQUMsZ0JBQWdCLFlBQVksc0NBQVc7WUFDM0MsQ0FBQyxDQUFDLElBQUksbUVBQXdDLENBQUMsS0FBSyxDQUFDLGdCQUFnQixDQUFDO1lBQ3RFLENBQUMsQ0FBRSxLQUFLLENBQUMsZ0JBQTZELENBQUE7UUFFMUU7OztXQUdHO1FBQ0gsTUFBTSxFQUFFLFNBQVMsR0FBRyxJQUFBLG9CQUFXLEVBQUMsRUFBRSxDQUFDLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxFQUFFLEdBQUcsS0FBSyxDQUFBO1FBRWhFLElBQUEsbUNBQWtCLEVBQUMsSUFBSSxFQUFFO1lBQ3ZCLEdBQUcsS0FBSztZQUNSLHVCQUF1QjtZQUN2QixTQUFTO1NBQ1YsQ0FBQyxDQUFBO0lBQ0osQ0FBQztJQUVELHNCQUFzQixHQUNwQixJQUFBLHVDQUFzQixFQUFxQixlQUFlLENBQUMsQ0FBQTtJQUM3RCxnQkFBZ0IsR0FDZCxJQUFBLGlDQUFnQixFQUFxQixlQUFlLENBQUMsQ0FBQTtJQUN2RCw0QkFBNEIsR0FDMUIsSUFBQSw0Q0FBMkIsR0FBc0IsQ0FBQTtDQUNwRDtBQW5DRCxrRUFtQ0MifQ==