/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.codegen;

import jadx.api.ICodeInfo;
import jadx.api.JadxArgs;
import jadx.core.codegen.ClassGen;
import jadx.core.codegen.CodeWriter;
import jadx.core.codegen.json.JsonCodeGen;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.concurrent.Callable;

public class CodeGen {
    public static ICodeInfo generate(ClassNode cls) {
        if (cls.contains(AFlag.DONT_GENERATE)) {
            return CodeWriter.EMPTY;
        }
        JadxArgs args = cls.root().getArgs();
        switch (args.getOutputFormat()) {
            case JAVA: {
                return CodeGen.generateJavaCode(cls, args);
            }
            case JSON: {
                return CodeGen.generateJson(cls);
            }
        }
        throw new JadxRuntimeException("Unknown output format");
    }

    private static ICodeInfo generateJavaCode(ClassNode cls, JadxArgs args) {
        ClassGen clsGen = new ClassGen(cls, args);
        return CodeGen.wrapCodeGen(cls, clsGen::makeClass);
    }

    private static ICodeInfo generateJson(ClassNode cls) {
        JsonCodeGen codeGen = new JsonCodeGen(cls);
        String clsJson = CodeGen.wrapCodeGen(cls, codeGen::process);
        return new CodeWriter(clsJson);
    }

    private static <R> R wrapCodeGen(ClassNode cls, Callable<R> codeGenFunc) {
        try {
            return codeGenFunc.call();
        }
        catch (Exception e) {
            if (cls.contains(AFlag.RESTART_CODEGEN)) {
                cls.remove(AFlag.RESTART_CODEGEN);
                try {
                    return codeGenFunc.call();
                }
                catch (Exception ex) {
                    throw new JadxRuntimeException("Code generation error after restart", ex);
                }
            }
            throw new JadxRuntimeException("Code generation error", e);
        }
    }

    private CodeGen() {
    }
}

