/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.vertx.http.runtime.filters.Filter;
import io.quarkus.vertx.http.runtime.filters.Filters;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;

public final class FilterBuildItem
extends MultiBuildItem {
    public static final int CORS = 300;
    public static final int AUTHENTICATION = 200;
    public static final int AUTHORIZATION = 100;
    private static final int AUTH_FAILURE_HANDLER = -2147483647;
    private final Handler<RoutingContext> handler;
    private final int priority;
    private final boolean isFailureHandler;

    public FilterBuildItem(Handler<RoutingContext> handler, int priority) {
        this.handler = handler;
        this.checkPriority(priority);
        this.priority = priority;
        this.isFailureHandler = false;
    }

    private FilterBuildItem(Handler<RoutingContext> handler, int priority, boolean checkPriority, boolean isFailureHandler) {
        this.handler = handler;
        if (checkPriority) {
            this.checkPriority(priority);
        }
        this.priority = priority;
        this.isFailureHandler = isFailureHandler;
    }

    private FilterBuildItem(Handler<RoutingContext> authFailureHandler) {
        this.handler = authFailureHandler;
        this.isFailureHandler = true;
        this.priority = -2147483647;
    }

    public static FilterBuildItem ofAuthenticationFailureHandler(Handler<RoutingContext> authFailureHandler) {
        return new FilterBuildItem(authFailureHandler);
    }

    public static FilterBuildItem ofPreAuthenticationFailureHandler(Handler<RoutingContext> authFailureHandler) {
        return new FilterBuildItem(authFailureHandler, -2147483646, false, true);
    }

    private void checkPriority(int priority) {
        if (priority < 0) {
            throw new IllegalArgumentException("`priority` must be positive");
        }
    }

    public Handler<RoutingContext> getHandler() {
        return this.handler;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isFailureHandler() {
        return this.isFailureHandler;
    }

    public Filter toFilter() {
        if (this.isFailureHandler && this.priority == -2147483647) {
            Filters.SimpleFilter filter = new Filters.SimpleFilter();
            filter.setPriority(-2147483647);
            filter.setFailureHandler(true);
            filter.setHandler(this.handler);
            return filter;
        }
        return new Filters.SimpleFilter(this.handler, this.priority, this.isFailureHandler);
    }
}

