/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.validate;

import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiFunction;

public class ValidationError
implements Serializable {
    private static final long serialVersionUID = 4950708316675951914L;
    public static final String MESSAGE_INVALID_VALUE = "error-invalid-value";
    private static final Object[] EMPTY_PARAMETERS = new Object[0];
    private final String validatorId;
    private final String inputHint;
    private final String message;
    private final Object[] messageParameters;
    private Response.Status statusCode = Response.Status.BAD_REQUEST;

    public ValidationError(String validatorId, String inputHint, String message) {
        this(validatorId, inputHint, message, EMPTY_PARAMETERS);
    }

    public ValidationError(String validatorId, String inputHint, String message, Object ... messageParameters) {
        this.validatorId = validatorId;
        this.inputHint = inputHint;
        this.message = message;
        this.messageParameters = messageParameters == null ? EMPTY_PARAMETERS : (Object[])messageParameters.clone();
    }

    public String getValidatorId() {
        return this.validatorId;
    }

    public String getInputHint() {
        return this.inputHint;
    }

    public String getMessage() {
        return this.message;
    }

    public Object[] getMessageParameters() {
        return this.messageParameters;
    }

    public String formatMessage(BiFunction<String, Object[], String> formatter) {
        Objects.requireNonNull(formatter, "formatter must not be null");
        return formatter.apply(this.message, this.getInputHintWithMessageParameters());
    }

    public Object[] getInputHintWithMessageParameters() {
        Object[] args = new Object[this.messageParameters.length + 1];
        args[0] = this.getInputHint();
        System.arraycopy(this.messageParameters, 0, args, 1, this.messageParameters.length);
        return args;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValidationError)) {
            return false;
        }
        ValidationError that = (ValidationError)o;
        return Objects.equals(this.validatorId, that.validatorId) && Objects.equals(this.inputHint, that.inputHint) && Objects.equals(this.message, that.message) && Arrays.equals(this.messageParameters, that.messageParameters);
    }

    public int hashCode() {
        int result = Objects.hash(this.validatorId, this.inputHint, this.message);
        result = 31 * result + Arrays.hashCode(this.messageParameters);
        return result;
    }

    public String toString() {
        return "ValidationError{validatorId='" + this.validatorId + '\'' + ", inputHint='" + this.inputHint + '\'' + ", message='" + this.message + '\'' + ", messageParameters=" + Arrays.toString(this.messageParameters) + '}';
    }

    public ValidationError setStatusCode(Response.Status statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public Response.Status getStatusCode() {
        return this.statusCode;
    }
}

