/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.policy;

import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.hash.PasswordHashProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.PasswordCredentialModel;
import org.keycloak.policy.HistoryPasswordPolicyProviderFactory;
import org.keycloak.policy.PasswordPolicyProvider;
import org.keycloak.policy.PolicyError;

public class HistoryPasswordPolicyProvider
implements PasswordPolicyProvider {
    private static final Logger logger = Logger.getLogger(HistoryPasswordPolicyProvider.class);
    private static final String ERROR_MESSAGE = "invalidPasswordHistoryMessage";
    private KeycloakSession session;

    public HistoryPasswordPolicyProvider(KeycloakSession session) {
        this.session = session;
    }

    public PolicyError validate(String username, String password) {
        return null;
    }

    public PolicyError validate(RealmModel realm, UserModel user, String password) {
        PasswordPolicy policy = this.session.getContext().getRealm().getPasswordPolicy();
        int passwordHistoryPolicyValue = (Integer)policy.getPolicyConfig("passwordHistory");
        if (passwordHistoryPolicyValue != -1) {
            if (user.credentialManager().getStoredCredentialsByTypeStream("password").map(PasswordCredentialModel::createFromCredentialModel).anyMatch(passwordCredential -> {
                PasswordHashProvider hash = (PasswordHashProvider)this.session.getProvider(PasswordHashProvider.class, passwordCredential.getPasswordCredentialData().getAlgorithm());
                return hash != null && hash.verify(password, passwordCredential);
            })) {
                return new PolicyError(ERROR_MESSAGE, new Object[]{passwordHistoryPolicyValue});
            }
            if (passwordHistoryPolicyValue > 0 && this.getRecent(user.credentialManager().getStoredCredentialsByTypeStream("password-history"), passwordHistoryPolicyValue - 1).map(PasswordCredentialModel::createFromCredentialModel).anyMatch(passwordCredential -> {
                PasswordHashProvider hash = (PasswordHashProvider)this.session.getProvider(PasswordHashProvider.class, passwordCredential.getPasswordCredentialData().getAlgorithm());
                return hash.verify(password, passwordCredential);
            })) {
                return new PolicyError(ERROR_MESSAGE, new Object[]{passwordHistoryPolicyValue});
            }
        }
        return null;
    }

    private Stream<CredentialModel> getRecent(Stream<CredentialModel> passwordHistory, int limit) {
        return passwordHistory.sorted(CredentialModel.comparingByStartDateDesc()).limit(limit);
    }

    public Object parseConfig(String value) {
        return this.parseInteger(value, HistoryPasswordPolicyProviderFactory.DEFAULT_VALUE);
    }

    public void close() {
    }
}

